/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Starwave
extends JPanel
implements KeyListener {
    private static Random r = new Random();
    private static final String title = "StarWave";
    private static final String url = "http://ssjx.co.uk";
    private static final String version = "v0.1 (21/06/20)";
    private static final int swidth = 480;
    private static final int sheight = 480;
    private static final int fps = 30;
    private static int fpsdelay = 33;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean fire = false;
    int firedelay = 0;
    boolean firedown = false;
    int fc = 0;
    GenXY player = new GenXY();
    GenXY[] enemy = new GenXY[6];
    GenXY[] stars = new GenXY[30];
    GenXY[] shot = new GenXY[50];
    GenXY bonus = new GenXY();
    int advweapon = 0;
    String message = "";
    int tmr = 0;
    int stage = 0;
    int wave = 0;
    int stage_enemy = 0;
    int gamecounter = 0;
    int hiscore = 0;
    int xshuffle = 0;
    int xshuffle_dir = 0;
    int[] wave_order = new int[]{0, 1, 2, 3, 4, 5};
    final int[] over_text = new int[]{2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 2, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 2};
    final int[] title_text = new int[]{1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1};
    final int[] welldone_text = new int[]{1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1};
    String[] title_line = new String[11];
    State gamestate = State.WELCOME;
    static Image ship_img;
    static Image ship_shield_img;
    static Image enemy_img;
    static Image saucer_img;
    static Image crab_img;
    static Image shot_img;
    static Image star_img;
    static Image dot_img;
    static Image bonus_img;
    static Image supershot_img;
    Point dest = new Point(0, 0);
    Point src = new Point(0, 0);
    Explosion exp = new Explosion();
    Color[] redfade = new Color[8];
    FontMetrics fmetric;
    private final Font smlFont = new Font("Arial", 0, 16);
    private final Font medFont = new Font("Arial", 0, 18);
    private final Font bigFont = new Font("Arial", 0, 20);

    public Starwave() {
        int n;
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(480, 480));
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Starwave.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
        for (n = 0; n < this.enemy.length; ++n) {
            this.enemy[n] = new GenXY();
        }
        for (n = 0; n < this.stars.length; ++n) {
            this.stars[n] = new GenXY();
        }
        for (n = 0; n < this.shot.length; ++n) {
            this.shot[n] = new GenXY();
        }
        for (n = 0; n < this.redfade.length; ++n) {
            this.redfade[n] = new Color(n * 32, 0, 0);
        }
        try {
            URL uRL = Starwave.class.getClassLoader().getResource("ship.png");
            ship_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("ship_shields.png");
            ship_shield_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("enemy.png");
            enemy_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("saucer.png");
            saucer_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("crab.png");
            crab_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("shot.png");
            shot_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("star.png");
            star_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("block.png");
            dot_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("bonus.png");
            bonus_img = ImageIO.read(uRL);
            uRL = Starwave.class.getClassLoader().getResource("super_shot.png");
            supershot_img = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the sprites");
        }
        this.title_line[0] = "Use the arrows and space key to";
        this.title_line[1] = "defeat the many waves of invaders";
        this.title_line[2] = "over multiple stages!";
        this.title_line[3] = "";
        this.title_line[4] = "High Score";
        this.title_line[5] = "0";
        this.title_line[6] = "";
        this.title_line[7] = "Recent Score";
        this.title_line[8] = "0";
        this.title_line[9] = "";
        this.title_line[10] = "Press Space to Start";
        this.setstate(this.gamestate);
        this.stars_reset();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Starwave());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void jumble() {
        for (int i = 0; i < 50; ++i) {
            int n = r.nextInt(this.wave_order.length);
            int n2 = r.nextInt(this.wave_order.length);
            int n3 = this.wave_order[n];
            this.wave_order[n] = this.wave_order[n2];
            this.wave_order[n2] = n3;
        }
    }

    void stars_reset() {
        for (int i = 0; i < this.stars.length; ++i) {
            this.stars[i].x = r.nextInt(480);
            this.stars[i].y = r.nextInt(480);
        }
    }

    void stars_draw(Graphics graphics) {
        for (int i = 0; i < this.stars.length; ++i) {
            graphics.drawImage(star_img, this.stars[i].x, this.stars[i].y, null);
            if (this.gamestate != State.GAME) continue;
            ++this.stars[i].y;
            if (this.stars[i].y < 480) continue;
            this.stars[i].x = r.nextInt(480);
            this.stars[i].y = 0;
        }
    }

    void message_set(String string) {
        this.message = string;
        this.tmr = 50;
    }

    void message_draw(Graphics graphics) {
        if (this.tmr > 0) {
            graphics.setFont(this.bigFont);
            this.fmetric = graphics.getFontMetrics(this.bigFont);
            int n = this.fmetric.stringWidth(this.message);
            int n2 = 480 - n >> 1;
            if (this.tmr > 7) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(this.redfade[this.tmr]);
            }
            graphics.drawString(this.message, n2, 48);
            --this.tmr;
        }
    }

    void reset() {
        this.player.x = 224;
        this.player.y = 360;
        this.player.damage = 0;
        this.player.score = 0;
        this.player.shield = 0;
        this.player.triple = 0;
        this.stars_reset();
        this.exp.reset();
        this.shot_reset();
        this.left = false;
        this.right = false;
        this.up = false;
        this.down = false;
        this.fire = false;
        this.firedelay = 0;
        this.firedown = false;
        this.fc = 0;
        this.wave = 0;
        this.stage = 0;
        this.stage_enemy = 0;
        this.gamecounter = 0;
        this.bonus.active = 0;
        this.advweapon = 0;
    }

    void setwave(int n) {
        int n2;
        int n3 = 1 + this.stage;
        for (n2 = 0; n2 < this.enemy.length; ++n2) {
            this.enemy[n2].active = 1;
            this.enemy[n2].ydir = 2;
            this.enemy[n2].xdir = 0;
            this.enemy[n2].alt = 0;
            this.enemy[n2].damage = n3;
        }
        this.xshuffle_dir = 1;
        this.xshuffle = 0;
        n2 = this.enemy.length;
        int n4 = 480 / (n2 + 1);
        int n5 = this.wave_order[n];
        switch (n5) {
            case 0: {
                for (int i = 0; i < n2; ++i) {
                    this.enemy[i].x = n4 + n4 * i - 16;
                    this.enemy[i].y = -32;
                }
                break;
            }
            case 1: {
                int n6 = n2;
                for (int i = 0; i < n2; ++i) {
                    this.enemy[i].x = n4 + n4 * i - 16;
                    this.enemy[i].y = -32 * n6;
                    --n6;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    this.enemy[i].x = n4 + n4 * i - 16;
                    this.enemy[i].y = -32 - i * 32;
                }
                break;
            }
            case 3: {
                int n7 = 0;
                for (int i = 0; i < n2; ++i) {
                    this.enemy[i].x = 224;
                    this.enemy[i].y = -32 - i * 32;
                    this.enemy[i].xdir = n7 == 1 ? -2 : 2;
                    n7 = 1 - n7;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n2; ++i) {
                    this.enemy[i].x = n4 + n4 * i - 16;
                }
                this.enemy[0].y = -96;
                this.enemy[1].y = -64;
                this.enemy[2].y = -32;
                this.enemy[3].y = -32;
                this.enemy[4].y = -64;
                this.enemy[5].y = -96;
                break;
            }
            case 5: {
                for (int i = 0; i < n2; ++i) {
                    this.enemy[i].y = -32;
                    this.enemy[i].x = n4 + n4 * i - 16;
                    this.enemy[i].xdir = 2;
                }
                break;
            }
        }
    }

    void setstate(State state) {
        switch (state) {
            case WELCOME: {
                fpsdelay = 100;
                this.title_line[5] = String.valueOf(this.hiscore);
                this.title_line[8] = String.valueOf(this.player.score);
                break;
            }
            case GAME: {
                fpsdelay = 33;
                this.reset();
                this.message_set("Stage " + (this.stage + 1) + " Good Luck!");
                this.jumble();
                this.setwave(this.wave);
            }
        }
        this.gamestate = state;
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_bg(graphics);
                this.stars_draw(graphics);
                this.draw_title(graphics);
                break;
            }
            case GAME: {
                this.draw_bg(graphics);
                this.stars_draw(graphics);
                this.shots_hit();
                this.shots_draw(graphics);
                this.shots_update();
                this.enemy_draw(graphics);
                this.enemy_update();
                this.player_draw(graphics);
                this.draw_game(graphics);
                this.exp.draw(graphics);
                if (this.bonus.active > 0) {
                    this.player_hit_bonus();
                }
                this.message_draw(graphics);
                this.draw_hud(graphics);
                ++this.gamecounter;
                if (this.gamecounter == 360) {
                    ++this.wave;
                    if (this.wave > 5) {
                        ++this.stage;
                        if (this.stage < 6) {
                            this.wave = 0;
                            this.message_set("Stage " + (this.stage + 1) + " Good Luck!");
                            this.jumble();
                            ++this.stage_enemy;
                            if (this.stage_enemy == 3) {
                                this.stage_enemy = 0;
                            }
                        } else {
                            this.setstate(State.COMPLETE);
                        }
                    }
                    this.setwave(this.wave);
                    this.gamecounter = 0;
                }
                if (this.player.damage < 4) break;
                this.player.damage = 4;
                this.exp.add(this.player.x, this.player.y);
                this.setstate(State.OVER);
                break;
            }
            case OVER: {
                this.draw_bg(graphics);
                this.stars_draw(graphics);
                this.shots_draw(graphics);
                this.enemy_draw(graphics);
                this.player_draw(graphics);
                this.exp.draw(graphics);
                this.draw_hud(graphics);
                this.draw_gameover(graphics);
                break;
            }
            case COMPLETE: {
                this.draw_bg(graphics);
                this.stars_draw(graphics);
                this.shots_draw(graphics);
                this.enemy_draw(graphics);
                this.player_draw(graphics);
                this.exp.draw(graphics);
                this.draw_hud(graphics);
                this.draw_welldone(graphics);
            }
        }
    }

    void draw_hud(Graphics graphics) {
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.white);
        graphics.drawString("Score: " + this.player.score, 2, 14);
        graphics.drawString("Damage: " + this.player.damage * 25 + "%", 370, 14);
    }

    void draw_bg(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 480, 480);
    }

    void draw_footer(Graphics graphics) {
        graphics.setFont(this.smlFont);
        this.fmetric = graphics.getFontMetrics(this.smlFont);
        int n = this.fmetric.stringWidth(version);
        int n2 = 480 - n;
        int n3 = 476;
        graphics.setColor(Color.white);
        graphics.drawString(version, n2, n3 - 1);
        graphics.drawString(url, 2, n3);
    }

    void draw_title(Graphics graphics) {
        int n;
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            for (n = 0; n < 35; ++n) {
                if (this.title_text[n2] == 1) {
                    graphics.drawImage(dot_img, 30 + n * 12, 48 + i * 12, null);
                }
                ++n2;
                graphics.drawImage(dot_img, 30 + n * 12, 24, null);
                graphics.drawImage(dot_img, 30 + n * 12, 120, null);
            }
        }
        graphics.setFont(this.medFont);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        int n3 = 172;
        n = 0;
        for (String string : this.title_line) {
            if (string.length() > 0) {
                Color color;
                switch (n) {
                    case 4: 
                    case 7: {
                        color = Color.orange;
                        break;
                    }
                    case 10: {
                        color = Color.yellow;
                        break;
                    }
                    default: {
                        color = Color.white;
                    }
                }
                int n4 = this.fmetric.stringWidth(string);
                int n5 = 480 - n4 >> 1;
                graphics.setColor(color);
                graphics.drawString(string, n5, n3);
            }
            n3 += 20;
            ++n;
        }
        this.draw_footer(graphics);
    }

    void draw_game(Graphics graphics) {
        if (this.bonus.active == 0) {
            if (r.nextInt(100) == 1) {
                this.bonus.active = 1 + r.nextInt(4);
                this.bonus.y = -32;
                this.bonus.x = 20 + r.nextInt(440);
            }
        } else {
            this.src.x = (this.bonus.active - 1) * 16;
            this.src.y = 0;
            this.dest.x = this.bonus.x;
            this.dest.y = this.bonus.y++;
            graphics.drawImage(bonus_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
            if (this.bonus.y > 480) {
                this.bonus.active = 0;
            }
        }
        if (this.advweapon > 0) {
            --this.advweapon;
            if (this.advweapon <= 0) {
                this.player.triple = 0;
                this.player.shield = 0;
                this.player.sshot = 0;
            }
        }
        if (this.up && this.player.y > 240) {
            this.player.y -= 4;
        }
        if (this.down && this.player.y + 4 <= 448) {
            this.player.y += 4;
        }
        if (this.left && this.player.x >= 4) {
            this.player.x -= 4;
        }
        if (this.right && this.player.x <= 444) {
            this.player.x += 4;
        }
        if (this.firedown) {
            if (this.firedelay == 0) {
                this.fire = true;
            }
            if (this.fire) {
                this.fire = false;
                this.firedelay = 6;
                this.shot_add(this.player.x + 12, this.player.y - 4, 0);
            }
        }
        if (this.firedelay > 0) {
            --this.firedelay;
        }
        ++this.fc;
        if (this.fc > 10) {
            this.fc = 0;
        }
    }

    void player_draw(Graphics graphics) {
        if (this.player.shield == 0) {
            graphics.drawImage(ship_img, this.player.x, this.player.y, null);
        } else {
            graphics.drawImage(ship_shield_img, this.player.x, this.player.y, null);
        }
    }

    void draw_gameover(Graphics graphics) {
        int n = 0;
        for (int i = 0; i < 11; ++i) {
            for (int j = 0; j < 20; ++j) {
                if (this.over_text[n] > 0) {
                    graphics.drawImage(dot_img, 120 + j * 12, 174 + i * 12, null);
                }
                ++n;
            }
        }
        int n2 = 330;
        graphics.setFont(this.medFont);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        int n3 = this.fmetric.stringWidth("YOUR SHIP HAS BEEN DESTROYED!");
        int n4 = (480 - n3) / 2;
        graphics.setColor(Color.red);
        graphics.drawString("YOUR SHIP HAS BEEN DESTROYED!", n4, n2);
        if (this.player.score > this.hiscore) {
            n2 = 354;
            this.fmetric = graphics.getFontMetrics(this.medFont);
            n3 = this.fmetric.stringWidth("You have a new high score!");
            n4 = (480 - n3) / 2;
            graphics.setColor(Color.yellow);
            graphics.drawString("You have a new high score!", n4, n2);
        }
    }

    void draw_welldone(Graphics graphics) {
        int n;
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            for (n = 0; n < 35; ++n) {
                if (this.welldone_text[n2] > 0) {
                    graphics.drawImage(dot_img, 30 + n * 12, 210 + i * 12, null);
                }
                ++n2;
                graphics.drawImage(dot_img, 30 + n * 12, 186, null);
                graphics.drawImage(dot_img, 30 + n * 12, 282, null);
            }
        }
        n = 318;
        graphics.setFont(this.medFont);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        int n3 = this.fmetric.stringWidth("YOU SURVIVED THE ENEMY INVADERS!");
        int n4 = (480 - n3) / 2;
        graphics.setColor(Color.green);
        graphics.drawString("YOU SURVIVED THE ENEMY INVADERS!", n4, n);
        if (this.player.score > this.hiscore) {
            n = 342;
            this.fmetric = graphics.getFontMetrics(this.medFont);
            n3 = this.fmetric.stringWidth("You have a new high score!");
            n4 = (480 - n3) / 2;
            graphics.setColor(Color.yellow);
            graphics.drawString("You have a new high score!", n4, n);
        }
    }

    void enemy_update() {
        this.xshuffle += this.xshuffle_dir;
        if (this.xshuffle == -31 || this.xshuffle == 31) {
            this.xshuffle_dir *= -1;
        }
        for (int i = 0; i < this.enemy.length; ++i) {
            if (this.enemy[i].active != 1 || this.player_hit_enemy(i)) continue;
            if (r.nextInt(200) == 1) {
                this.shot_add(this.enemy[i].x + 12, this.enemy[i].y + 28, 1);
            }
            this.enemy[i].x = this.enemy[i].xdir != 0 ? (this.enemy[i].x += this.enemy[i].xdir) : (this.enemy[i].x += this.xshuffle_dir);
            this.enemy[i].y += this.enemy[i].ydir;
            if (this.enemy[i].x <= 0 || this.enemy[i].x + 32 >= 480) {
                this.enemy[i].xdir *= -1;
            }
            if (this.fc != 5) continue;
            ++this.enemy[i].alt;
            if (this.enemy[i].alt <= 3) continue;
            this.enemy[i].alt = 0;
        }
    }

    void enemy_draw(Graphics graphics) {
        int n = 0;
        this.src.y = 0;
        block5: for (int i = 0; i < this.enemy.length; ++i) {
            if (this.enemy[i].active != 1) continue;
            this.src.x = n = this.enemy[i].alt << 5;
            if (this.enemy[i].y >= 480) continue;
            this.dest.x = this.enemy[i].x;
            this.dest.y = this.enemy[i].y;
            switch (this.stage_enemy) {
                case 0: {
                    graphics.drawImage(enemy_img, this.dest.x, this.dest.y, this.dest.x + 32, this.dest.y + 32, this.src.x, this.src.y, this.src.x + 32, this.src.y + 32, null);
                    continue block5;
                }
                case 1: {
                    graphics.drawImage(saucer_img, this.dest.x, this.dest.y, this.dest.x + 32, this.dest.y + 32, this.src.x, this.src.y, this.src.x + 32, this.src.y + 32, null);
                    continue block5;
                }
                case 2: {
                    graphics.drawImage(crab_img, this.dest.x, this.dest.y, this.dest.x + 32, this.dest.y + 32, this.src.x, this.src.y, this.src.x + 32, this.src.y + 32, null);
                }
            }
        }
    }

    void shot_reset() {
        for (int i = 0; i < this.shot.length; ++i) {
            this.shot[i].active = 0;
        }
    }

    int shot_free() {
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].active != 0) continue;
            return i;
        }
        return -1;
    }

    void shot_add(int n, int n2, int n3) {
        int n4 = -1;
        n4 = this.shot_free();
        if (n4 >= 0) {
            this.shot[n4].active = 1;
            this.shot[n4].x = n;
            this.shot[n4].y = n2;
            this.shot[n4].t = n3;
            switch (n3) {
                case 0: {
                    this.shot[n4].xdir = 0;
                    this.shot[n4].ydir = -8;
                    if (this.player.triple != 1) break;
                    n4 = this.shot_free();
                    if (n4 >= 0) {
                        this.shot[n4].active = 1;
                        this.shot[n4].x = n;
                        this.shot[n4].y = n2;
                        this.shot[n4].t = n3;
                        this.shot[n4].xdir = -1;
                        this.shot[n4].ydir = -8;
                    }
                    if ((n4 = this.shot_free()) < 0) break;
                    this.shot[n4].active = 1;
                    this.shot[n4].x = n;
                    this.shot[n4].y = n2;
                    this.shot[n4].t = n3;
                    this.shot[n4].xdir = 1;
                    this.shot[n4].ydir = -8;
                    break;
                }
                case 1: {
                    if (this.stage_enemy == 0) {
                        this.shot[n4].xdir = 0;
                        this.shot[n4].ydir = 8;
                        break;
                    }
                    if (this.stage_enemy != 1 && this.stage_enemy != 2) break;
                    this.shot[n4].xdir = 1;
                    this.shot[n4].ydir = 8;
                    n4 = this.shot_free();
                    if (n4 < 0) break;
                    this.shot[n4].active = 1;
                    this.shot[n4].x = n;
                    this.shot[n4].y = n2;
                    this.shot[n4].t = n3;
                    this.shot[n4].xdir = -1;
                    this.shot[n4].ydir = 8;
                }
            }
        }
    }

    void shots_update() {
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].active != 1) continue;
            this.shot[i].y += this.shot[i].ydir;
            this.shot[i].x += this.shot[i].xdir;
            if (this.shot[i].x < 0 || this.shot[i].x > 480) {
                this.shot[i].active = 0;
            }
            if (this.shot[i].y >= 0 && this.shot[i].y <= 480) continue;
            this.shot[i].active = 0;
        }
    }

    void shots_draw(Graphics graphics) {
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].active != 1) continue;
            if (this.shot[i].t == 0) {
                if (this.player.sshot == 1) {
                    graphics.drawImage(supershot_img, this.shot[i].x, this.shot[i].y, null);
                    continue;
                }
                graphics.drawImage(shot_img, this.shot[i].x, this.shot[i].y, null);
                continue;
            }
            graphics.drawImage(shot_img, this.shot[i].x, this.shot[i].y, null);
        }
    }

    boolean wave_defeated() {
        for (GenXY genXY : this.enemy) {
            if (genXY.active != 1) continue;
            return false;
        }
        return true;
    }

    void shots_hit() {
        int n = 0;
        int n2 = 0;
        int n3 = this.shot.length;
        int n4 = this.enemy.length;
        block4: for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].active != 1) continue;
            n = this.shot[i].x + 4;
            n2 = this.shot[i].y + 4;
            switch (this.shot[i].t) {
                case 0: {
                    for (int j = 0; j < n4; ++j) {
                        if (this.enemy[j].active != 1 || n < this.enemy[j].x || n > this.enemy[j].x + 32 || n2 < this.enemy[j].y || n2 > this.enemy[j].y + 32) continue;
                        this.shot[i].active = 0;
                        this.exp.add(this.enemy[j].x, this.enemy[j].y);
                        --this.enemy[j].damage;
                        if (this.player.sshot == 1) {
                            --this.enemy[j].damage;
                        }
                        if (this.enemy[j].damage <= 0) {
                            this.enemy[j].active = 0;
                        }
                        this.player.score += 10;
                        if (!this.wave_defeated()) continue block4;
                        this.player.score += 100;
                        this.message_set("Wave Defeated : 100 Bonus Points!");
                        continue block4;
                    }
                    continue block4;
                }
                case 1: {
                    if (n < this.player.x || n > this.player.x + 32 || n2 < this.player.y || n2 > this.player.y + 32) continue block4;
                    this.shot[i].active = 0;
                    if (this.player.shield == 0) {
                        this.exp.add(this.player.x, this.player.y);
                        ++this.player.damage;
                        continue block4;
                    }
                    this.message_set("Shields Holding!");
                }
            }
        }
    }

    void player_hit_bonus() {
        int n = this.bonus.x + 8;
        int n2 = this.bonus.y + 8;
        if (n > this.player.x && n < this.player.x + 32 && n2 > this.player.y && n2 < this.player.y + 32) {
            switch (this.bonus.active) {
                case 1: {
                    this.player.triple = 1;
                    this.message_set("Triple Fire Activated!");
                    this.advweapon += 300;
                    break;
                }
                case 2: {
                    if (this.player.damage > 0) {
                        --this.player.damage;
                        this.message_set("Ship Partially Repaired!");
                        break;
                    }
                    this.message_set("100 Bonus Points!");
                    this.player.score += 100;
                    break;
                }
                case 3: {
                    this.player.shield = 1;
                    this.message_set("Energy Shield Activated!");
                    this.advweapon += 300;
                    break;
                }
                case 4: {
                    this.player.sshot = 1;
                    this.message_set("Super Shot Activated!");
                    this.advweapon += 300;
                }
            }
            this.bonus.active = 0;
        }
    }

    boolean player_hit_enemy(int n) {
        int n2 = this.player.x + 6;
        int n3 = this.player.y;
        for (int i = 0; i < 2; ++i) {
            if (n2 > this.enemy[n].x && n2 < this.enemy[n].x + 32 && n3 > this.enemy[n].y && n3 < this.enemy[n].y + 32) {
                --this.enemy[n].damage;
                if (this.enemy[n].damage <= 0) {
                    this.enemy[n].active = 0;
                }
                this.exp.add(this.enemy[n].x, this.enemy[n].y);
                if (this.player.shield == 0) {
                    ++this.player.damage;
                } else {
                    this.message_set("Shields Holding!");
                }
                return true;
            }
            if (n2 + 17 > this.enemy[n].x && n2 + 17 < this.enemy[n].x + 32 && n3 > this.enemy[n].y && n3 < this.enemy[n].y + 32) {
                --this.enemy[n].damage;
                if (this.enemy[n].damage <= 0) {
                    this.enemy[n].active = 0;
                }
                this.exp.add(this.enemy[n].x, this.enemy[n].y);
                if (this.player.shield == 0) {
                    ++this.player.damage;
                } else {
                    this.message_set("Shields Holding!");
                }
                return true;
            }
            n3 += 31;
        }
        return false;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = false;
                    break;
                }
                case 40: {
                    this.down = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                    break;
                }
                case 32: {
                    this.firedown = false;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 32: {
                    this.firedown = true;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c == 'q') {
                    this.setstate(State.OVER);
                }
                if (c != 'a') break;
                this.setstate(State.COMPLETE);
                break;
            }
            case OVER: {
                if (this.player.score > this.hiscore) {
                    this.hiscore = this.player.score;
                }
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
                break;
            }
            case COMPLETE: {
                if (this.player.score > this.hiscore) {
                    this.hiscore = this.player.score;
                }
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    public static enum State {
        WELCOME,
        GAME,
        OVER,
        COMPLETE;

    }
}

