/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class Explosion {
    private int[] dist = new int[20];
    private int[] x = new int[20];
    private int[] y = new int[20];
    private static Image sprite;
    private static boolean loaded;

    public Explosion() {
        if (!loaded) {
            try {
                URL uRL = Starwave.class.getClassLoader().getResource("explosion.png");
                sprite = ImageIO.read(uRL);
                loaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the explosion sprite ");
            }
        }
        this.reset();
    }

    public void reset() {
        Arrays.fill(this.dist, 0);
    }

    public void add(int n, int n2) {
        for (int i = 0; i < this.dist.length; ++i) {
            if (this.dist[i] != 0) continue;
            this.dist[i] = 30;
            this.x[i] = n + 8;
            this.y[i] = n2 + 8;
            break;
        }
    }

    public void draw(Graphics graphics) {
        for (int i = 0; i < this.dist.length; ++i) {
            if (this.dist[i] <= 0) continue;
            int n = this.x[i];
            int n2 = this.y[i];
            int n3 = 30 - this.dist[i];
            graphics.drawImage(sprite, n + n3, n2, null);
            graphics.drawImage(sprite, n - n3, n2, null);
            graphics.drawImage(sprite, n, n2 + n3, null);
            graphics.drawImage(sprite, n, n2 - n3, null);
            int n4 = i;
            this.dist[n4] = this.dist[n4] - 1;
        }
    }

    static {
        loaded = false;
    }
}

