/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;

public class Titles {
    private final int swidth = 640;
    private final int sheight = 480;
    private final int maxlevels = 5;
    private final int mapw = 20;
    private final int maph = 15;
    private final String title = "Spring Forward!";
    private final String website = "http://ssjx.co.uk";
    private final String version = "v0.4 (15/02/2021)";
    Image[] sprite = new Image[31];
    Image banner_bmp;
    Image darkring_bmp;
    BufferedImage levels_bmp;
    int[] base = new int[1024];
    private Point pnt = new Point(0, 0);
    private XText mytext = new XText();

    public Titles() {
        this.load_gfx();
    }

    private void load_gfx() {
        try {
            URL uRL = Titles.class.getClassLoader().getResource("gfx/title/banner.gif");
            this.banner_bmp = ImageIO.read(uRL);
            uRL = Titles.class.getClassLoader().getResource("gfx/title/darkring.gif");
            this.darkring_bmp = ImageIO.read(uRL);
            uRL = Titles.class.getClassLoader().getResource("gfx/levels.gif");
            this.levels_bmp = ImageIO.read(uRL);
            this.load_preview_gfx();
        }
        catch (Exception exception) {
            System.out.println("Player: Exception loading Player UI sprites");
            System.out.println(exception);
        }
    }

    private void bg(Graphics graphics) {
        this.pnt.y = 0;
        for (int i = 0; i < 15; ++i) {
            this.pnt.x = 0;
            for (int j = 0; j < 20; ++j) {
                graphics.drawImage(this.darkring_bmp, this.pnt.x, this.pnt.y, null);
                this.pnt.x += 32;
            }
            this.pnt.y += 32;
        }
    }

    private void bar(Graphics graphics) {
        this.pnt.y = 192;
        for (int i = 0; i < 3; ++i) {
            this.pnt.x = 0;
            for (int j = 0; j < 20; ++j) {
                graphics.drawImage(this.darkring_bmp, this.pnt.x, this.pnt.y, null);
                this.pnt.x += 32;
            }
            this.pnt.y += 32;
        }
    }

    public void welcome(Graphics graphics) {
        this.bg(graphics);
        this.pnt.x = 170;
        this.pnt.y = 5;
        graphics.drawImage(this.banner_bmp, this.pnt.x, this.pnt.y, null);
        this.mytext.center(graphics, "Collect all of the rings and", 8);
        this.mytext.center(graphics, "get to the exit on each level!", 9);
        this.mytext.center(graphics, "Use your season jump device", 11);
        this.mytext.center(graphics, "to help you do this!", 12);
        this.mytext.center(graphics, "Seeds planted in spring grow in", 14);
        this.mytext.center(graphics, "summer, water freezes in winter..", 15);
        this.mytext.center(graphics, "Controls", 18);
        this.mytext.center(graphics, "-----------", 19);
        this.mytext.draw(graphics, "Arrows - Move", 15, 20);
        this.mytext.draw(graphics, "Space - Pickup / Plant", 15, 21);
        this.mytext.draw(graphics, "1,2,3,4 - Change Season", 15, 22);
        this.mytext.draw(graphics, "<> - Select Item", 15, 23);
        this.mytext.draw(graphics, "R - Restart Level", 15, 24);
        this.mytext.center(graphics, "Click / Space to Start", 27);
        this.mytext.draw(graphics, "v0.4 (15/02/2021)", 0, 29);
        this.mytext.draw(graphics, "http://ssjx.co.uk", 32, 29);
    }

    public void ready(Graphics graphics, int n) {
        String string;
        this.bg(graphics);
        this.pnt.x = 170;
        this.pnt.y = 5;
        graphics.drawImage(this.banner_bmp, this.pnt.x, this.pnt.y, null);
        this.load_preview_map(n);
        this.draw_preview_map(graphics);
        this.mytext.center(graphics, "Level " + n, 24);
        switch (n) {
            case 0: {
                string = "Test Level..";
                break;
            }
            case 1: {
                string = "Move the seed!";
                break;
            }
            case 2: {
                string = "Some blocks fall in autumn";
                break;
            }
            case 3: {
                string = "Red seeds have long roots...";
                break;
            }
            case 4: {
                string = "Use the bucket to collect water to put out fire!";
                break;
            }
            default: {
                string = "No idea, sorry!";
            }
        }
        this.mytext.center(graphics, string, 26);
        this.mytext.center(graphics, "Click / Space to Start", 28);
    }

    public void nojump(Graphics graphics) {
        this.bar(graphics);
        this.mytext.center(graphics, "Your Jump Device is out of power..", 13);
        this.mytext.center(graphics, "Click / Space to Continue", 16);
    }

    public void complete(Graphics graphics) {
        this.bar(graphics);
        this.mytext.center(graphics, "Well Done!", 13);
        this.mytext.center(graphics, "You have completed this short demo!", 14);
        this.mytext.center(graphics, "Click / Space to Continue", 16);
    }

    public void over(Graphics graphics) {
        this.bar(graphics);
        this.mytext.center(graphics, "GAME OVER!", 13);
        this.mytext.center(graphics, "Click / Space to Continue", 16);
    }

    private void load_preview_gfx() {
        try {
            URL uRL = Titles.class.getClassLoader().getResource("gfx/title/spring_sml.gif");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            this.sprite[0] = new BufferedImage(16, 16, 1);
            int n = 1;
            this.pnt.x = 0;
            this.pnt.y = 0;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 10; ++j) {
                    this.sprite[n] = bufferedImage.getSubimage(j * 16, i * 16, 16, 16);
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Title: Exception loading preview sprites");
            System.out.println(exception);
        }
    }

    private void load_preview_map(int n) {
        int n2;
        int n3;
        BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
        int n4 = 0;
        boolean bl = false;
        this.pnt.x = 0;
        this.pnt.y = 0;
        for (n3 = 0; n3 < 2; ++n3) {
            for (n2 = 0; n2 < 10; ++n2) {
                if (n4 == n) {
                    bufferedImage = this.levels_bmp.getSubimage(n2 * 32, n3 * 32, 32, 32);
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (bl) break;
        }
        n3 = 0;
        n2 = 0;
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                n3 = bufferedImage.getRGB(j, i) & 0xFFFFFF;
                n2 = i * 32 + j;
                this.base[n2] = 0;
                if (n3 == 0) {
                    this.base[n2] = 1;
                }
                if (n3 == 65280) {
                    this.base[n2] = 2;
                }
                if (n3 == 0xFF8000) {
                    this.base[n2] = 3;
                }
                if (n3 == 0xFFFF80) {
                    this.base[n2] = 8;
                }
                if (n3 == 0xFFFF00) {
                    this.base[n2] = 11;
                }
                if (n3 == 0xFF0000) {
                    this.base[n2] = 12;
                }
                if (n3 == 0x808080) {
                    this.base[n2] = 14;
                }
                if (n3 == 0x804040) {
                    this.base[n2] = 17;
                }
                if (n3 == 65535) {
                    this.base[n2] = 20;
                }
                if (n3 == 0xFFFFFF) {
                    this.base[n2] = 22;
                }
                if (n3 != 0x804000) continue;
                this.base[n2] = 24;
            }
        }
    }

    private void draw_preview_map(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        this.pnt.y = 120;
        for (int i = 0; i < 15; ++i) {
            n = i << 5;
            this.pnt.x = 160;
            for (int j = 0; j < 20; ++j) {
                n2 = this.base[n + j];
                graphics.drawImage(this.sprite[n2], this.pnt.x, this.pnt.y, null);
                this.pnt.x += 16;
            }
            this.pnt.y += 16;
        }
    }
}

