/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Spring
extends JPanel
implements KeyListener,
MouseListener {
    private final int GAME_TITLE = 0;
    private final int GAME_READY = 1;
    private final int GAME_MAIN = 2;
    private final int GAME_OVER = 3;
    private final int GAME_SELECT = 4;
    private final int GAME_COMPLETE = 5;
    private final int GAME_NOJUMP = 6;
    private final int swidth = 640;
    private final int sheight = 480;
    private final int maxlevels = 6;
    private final int mapw = 20;
    private final int maph = 15;
    private static final String title = "Spring Forward!";
    private final String website = "http://ssjx.co.uk";
    private final String version = "v0.4";
    static final int fps = 30;
    static int fpsdelay = 33;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    private boolean cheat = false;
    private int highscore;
    private int jump;
    private int level;
    private int shift;
    private Player myplayer = new Player();
    private Map mymap = new Map();
    private Snow mysnow = new Snow();
    private Inventory myinventory = new Inventory();
    private Titles mytitle = new Titles();
    private int cur_season = 0;
    private int nxt_season = -1;
    private int res_health = 0;
    private int state = 0;

    public Spring() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        this.addMouseListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Spring.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Spring());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        this.controls();
        switch (this.state) {
            case 0: {
                this.mytitle.welcome(graphics);
                break;
            }
            case 1: {
                this.mytitle.ready(graphics, this.level);
                break;
            }
            case 2: {
                this.mymap.draw(graphics);
                this.myplayer.draw_ui(graphics, this.cur_season);
                this.myinventory.draw(graphics);
                this.myplayer.draw(graphics);
                this.mysnow.draw(graphics);
                break;
            }
            case 3: {
                this.mymap.draw(graphics);
                this.myplayer.draw_ui(graphics, this.cur_season);
                this.myinventory.draw(graphics);
                this.myplayer.draw(graphics);
                this.mytitle.over(graphics);
                break;
            }
            case 6: {
                this.mymap.draw(graphics);
                this.myplayer.draw_ui(graphics, this.cur_season);
                this.myinventory.draw(graphics);
                this.myplayer.draw(graphics);
                this.mytitle.nojump(graphics);
                break;
            }
            case 5: {
                this.mymap.draw(graphics);
                this.myplayer.draw_ui(graphics, this.cur_season);
                this.myinventory.draw(graphics);
                this.myplayer.draw(graphics);
                this.mytitle.complete(graphics);
            }
        }
    }

    public void setstate() {
        switch (this.state) {
            case 0: {
                this.level = 1;
                this.state = 1;
                this.myplayer.health = 5;
                break;
            }
            case 1: {
                this.myinventory.clr();
                this.mymap.load(this.level);
                this.cur_season = 0;
                this.mymap.season(this.cur_season);
                this.mysnow.set(this.cur_season);
                this.myplayer.set(this.mymap.startx, this.mymap.starty);
                this.jump = 0;
                this.myplayer.jumps = 5;
                this.state = 2;
                this.res_health = this.myplayer.health;
                break;
            }
            case 6: {
                this.state = 2;
                break;
            }
            case 5: {
                this.state = 0;
                break;
            }
            case 3: {
                this.state = 0;
            }
        }
    }

    public void controls() {
        boolean bl = false;
        switch (this.state) {
            case 2: {
                if (this.jump > 0) {
                    if (!this.mymap.hit(this.myplayer.getBounds(0, -2), 1)) {
                        this.myplayer.move(0, -2);
                        bl = true;
                        --this.jump;
                    } else {
                        this.jump = 0;
                    }
                } else if (!this.mymap.hit(this.myplayer.getBounds(0, 0), 2) && !this.mymap.hit(this.myplayer.getBounds(0, 2), 1)) {
                    this.myplayer.move(0, 2);
                    bl = true;
                }
                if (this.right && !this.mymap.hit(this.myplayer.getBounds(2, 0), 1)) {
                    this.myplayer.move(2, 0);
                    bl = true;
                    this.myplayer.xdir = 1;
                    this.myplayer.ydir = 0;
                }
                if (this.left && !this.mymap.hit(this.myplayer.getBounds(-2, 0), 1)) {
                    this.myplayer.move(-2, 0);
                    bl = true;
                    this.myplayer.xdir = -1;
                    this.myplayer.ydir = 0;
                }
                if (this.up) {
                    if (this.mymap.hit(this.myplayer.getBounds(0, 0), 2)) {
                        if (!this.mymap.hit(this.myplayer.getBounds(0, -2), 1)) {
                            this.myplayer.move(0, -2);
                            this.myplayer.ydir = 1;
                        }
                    } else if (this.mymap.hit(this.myplayer.getBounds(0, 1), 1) && this.jump == 0) {
                        this.jump = 24;
                    }
                }
                if (!this.down || !this.mymap.hit(this.myplayer.getBounds(0, 0), 2) || this.mymap.hit(this.myplayer.getBounds(0, 2), 1)) break;
                this.myplayer.move(0, 2);
                this.myplayer.ydir = 1;
            }
        }
        if (bl) {
            if (this.mymap.collect(this.myplayer.getBounds(0, 0), 11)) {
                --this.mymap.rings;
            }
            if (this.mymap.over(this.myplayer.getBounds(0, 0), 12) && this.mymap.rings == 0) {
                ++this.level;
                this.state = this.level > 6 ? 5 : 1;
            }
            if (this.mymap.collect(this.myplayer.getBounds(0, 0), 22)) {
                this.myinventory.add(2);
            }
            if (this.mymap.over(this.myplayer.getBounds(0, 0), 5) && this.myinventory.count(2) > 0) {
                this.myinventory.remove(2);
                this.myinventory.add(3);
            }
        }
        if (this.myplayer.invincible == 0) {
            if (this.mymap.over(this.myplayer.getBounds(0, 0), 14)) {
                --this.myplayer.health;
                if (this.myplayer.health == 0) {
                    this.state = 3;
                } else {
                    this.myplayer.invincible = 60;
                }
            }
            if (this.mymap.over(this.myplayer.getBounds(0, 0), 20)) {
                if (this.myinventory.count(3) <= 0) {
                    this.myplayer.health -= 3;
                    if (this.myplayer.health <= 0) {
                        this.state = 3;
                    } else {
                        this.myplayer.invincible = 60;
                    }
                } else {
                    this.mymap.collect(this.myplayer.getBounds(0, 0), 20);
                    this.myinventory.remove(3);
                    this.myinventory.add(2);
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (!this.up) break;
                this.up = false;
                break;
            }
            case 40: {
                if (!this.down) break;
                this.down = false;
                break;
            }
            case 37: {
                if (!this.left) break;
                this.left = false;
                break;
            }
            case 39: {
                if (!this.right) break;
                this.right = false;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.up = true;
                break;
            }
            case 40: {
                this.down = true;
                break;
            }
            case 37: {
                this.left = true;
                break;
            }
            case 39: {
                this.right = true;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.state) {
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                if (c != ' ') break;
                this.setstate();
                break;
            }
            case 2: {
                if (c == 'R' || c == 'r') {
                    this.myplayer.health = this.res_health;
                    this.state = 1;
                }
                if (c == '\u001b') {
                    this.state = 3;
                }
                if (c == ',') {
                    this.myinventory.prv();
                }
                if (c == '.') {
                    this.myinventory.nxt();
                }
                if (c == ' ') {
                    this.shift = this.myplayer.ox > 16 ? 1 : 0;
                    switch (this.mymap.get(this.myplayer.x + this.shift, this.myplayer.y + 1)) {
                        case 2: {
                            if (this.myinventory.current() == 0 && this.myinventory.count(0) > 0) {
                                this.mymap.plant(this.myplayer.x + this.shift, this.myplayer.y + 1, 8);
                                this.myinventory.remove(0);
                            }
                            if (this.myinventory.current() != 1 || this.myinventory.count(1) <= 0) break;
                            this.mymap.plant(this.myplayer.x + this.shift, this.myplayer.y + 1, 17);
                            this.myinventory.remove(1);
                            break;
                        }
                        case 8: {
                            this.mymap.plant(this.myplayer.x + this.shift, this.myplayer.y + 1, 2);
                            this.myinventory.add(0);
                            break;
                        }
                        case 17: {
                            this.mymap.plant(this.myplayer.x + this.shift, this.myplayer.y + 1, 2);
                            this.myinventory.add(1);
                        }
                    }
                }
                this.nxt_season = -1;
                if (c == '1') {
                    this.nxt_season = 0;
                }
                if (c == '2') {
                    this.nxt_season = 1;
                }
                if (c == '3') {
                    this.nxt_season = 2;
                }
                if (c == '4') {
                    this.nxt_season = 3;
                }
                if (this.nxt_season == -1 || this.nxt_season == this.cur_season) break;
                if (this.myplayer.jumps > 0) {
                    this.cur_season = this.nxt_season;
                    this.mymap.season(this.cur_season);
                    this.mysnow.set(this.cur_season);
                    --this.myplayer.jumps;
                    break;
                }
                this.state = 6;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this.state) {
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                this.setstate();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

