/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class Snow {
    private final int swidth = 640;
    private final int sheight = 480;
    private final int maxlevels = 5;
    private final int mapw = 20;
    private final int maph = 15;
    private int season = 0;
    private Point[] pos = new Point[30];
    private Image[] sprite = new Image[4];
    private Random rand = new Random();

    public Snow() {
        for (int i = 0; i < this.pos.length; ++i) {
            this.pos[i] = new Point();
        }
        this.load();
        this.reset();
    }

    private void load() {
        String[] stringArray = new String[]{"", "", "rain", "flake"};
        int n = 0;
        for (String string : stringArray) {
            try {
                if (!string.equals("")) {
                    URL uRL = Map.class.getClassLoader().getResource("gfx/snow/" + string + ".gif");
                    this.sprite[n] = ImageIO.read(uRL);
                }
            }
            catch (Exception exception) {
                System.out.println("Snow: Exception loading " + string);
                System.out.println(exception);
            }
            ++n;
        }
    }

    private void reset() {
        for (int i = 0; i < this.pos.length; ++i) {
            this.pos[i].x = this.rand.nextInt(640);
            this.pos[i].y = this.rand.nextInt(480);
        }
    }

    public void set(int n) {
        this.season = n;
    }

    public void draw(Graphics graphics) {
        if (this.season < 2) {
            return;
        }
        for (int i = 0; i < this.pos.length; ++i) {
            graphics.drawImage(this.sprite[this.season], this.pos[i].x, this.pos[i].y, null);
            this.pos[i].y += 2;
            if (this.season == 2) {
                this.pos[i].x -= 2;
            }
            if (this.pos[i].y > 490) {
                this.pos[i].y = 0;
                this.pos[i].x = this.rand.nextInt(640);
            }
            if (this.pos[i].x >= 8) continue;
            this.pos[i].x = 640;
        }
    }
}

