/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;

public class Player {
    private final int swidth = 640;
    private final int sheight = 480;
    private final int maxlevels = 5;
    private final int mapw = 20;
    private final int maph = 15;
    public int x = 8;
    public int y = 10;
    public int ox = 0;
    public int oy = 0;
    public int health = 5;
    public int jumps = 5;
    public int invincible = 0;
    public int xdir = -1;
    public int ydir = 0;
    private int alt = 0;
    private int spr = 0;
    private int sx = 0;
    private int sy = 0;
    private final int width = 32;
    private final int height = 32;
    private Point actual = new Point(0, 0);
    private Image[] sprite = new Image[6];
    private Image[] ui_sprite = new Image[4];
    private Point ui_pnt = new Point(0, 0);
    Rectangle player_rect = new Rectangle(0, 0, 16, 32);
    private final Font smlFont = new Font("Arial", 1, 14);

    public Player() {
        this.load();
        this.load_ui();
        this.reset();
    }

    private void load() {
        try {
            URL uRL = Player.class.getClassLoader().getResource("gfx/player.gif");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            int n = 0;
            for (int i = 0; i < this.sprite.length; ++i) {
                this.sprite[i] = bufferedImage.getSubimage(i * 32, 0, 32, 32);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Player: Exception loading Player");
            System.out.println(exception);
        }
    }

    private void load_ui() {
        try {
            URL uRL = Player.class.getClassLoader().getResource("gfx/ui.gif");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            int n = 0;
            for (int i = 0; i < this.ui_sprite.length; ++i) {
                this.ui_sprite[i] = bufferedImage.getSubimage(i * 16, 0, 16, 16);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Player: Exception loading Player UI sprites");
            System.out.println(exception);
        }
    }

    public void set(int n, int n2) {
        this.sx = n;
        this.sy = n2;
        this.reset();
    }

    public void reset() {
        this.x = this.sx;
        this.y = this.sy;
        this.ox = 0;
        this.oy = 0;
        this.actual.x = (this.x << 5) + this.ox;
        this.actual.y = (this.y << 5) + this.oy;
    }

    public void move(int n, int n2) {
        if (this.actual.x + n > -8 && this.actual.x + n + 24 < 640) {
            this.ox += n;
            this.alt = 1 - this.alt;
        }
        this.oy += n2;
        if (this.ox == 32) {
            ++this.x;
            this.ox = 0;
        }
        if (this.oy == 32) {
            ++this.y;
            this.oy = 0;
        }
        if (this.ox < 0) {
            --this.x;
            this.ox = 30;
        }
        if (this.oy < 0) {
            --this.y;
            this.oy = 30;
        }
        this.actual.x = (this.x << 5) + this.ox;
        this.actual.y = (this.y << 5) + this.oy;
    }

    public void draw(Graphics graphics) {
        if (this.xdir == -1) {
            this.spr = 0;
        }
        if (this.xdir == 1) {
            this.spr = 2;
        }
        if (this.ydir != 0) {
            this.spr = 4;
        }
        if (this.invincible > 0) {
            --this.invincible;
        }
        if (this.invincible % 2 == 0) {
            graphics.drawImage(this.sprite[this.spr + this.alt], this.actual.x, this.actual.y, null);
        }
    }

    public void draw_ui(Graphics graphics, int n) {
        int n2;
        int n3;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 32);
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.yellow);
        graphics.drawString("Health:", 0, 13);
        graphics.drawString("Jumps:", 0, 29);
        this.ui_pnt.x = 56;
        this.ui_pnt.y = 0;
        for (n3 = 1; n3 < 6; ++n3) {
            n2 = n3 > this.health ? 0 : 1;
            graphics.drawImage(this.ui_sprite[n2], this.ui_pnt.x, this.ui_pnt.y, null);
            this.ui_pnt.x += 16;
        }
        this.ui_pnt.x = 56;
        this.ui_pnt.y = 16;
        for (n3 = 1; n3 < 6; ++n3) {
            n2 = n3 > this.jumps ? 2 : 3;
            graphics.drawImage(this.ui_sprite[n2], this.ui_pnt.x, this.ui_pnt.y, null);
            this.ui_pnt.x += 16;
        }
        if (this.jumps > 0) {
            if (n == 0) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.drawString("1. Spring", 224, 13);
            if (n == 1) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.drawString("2. Summer", 352, 13);
            if (n == 2) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.drawString("3. Autumn", 224, 29);
            if (n == 3) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.yellow);
            }
            graphics.drawString("4. Winter", 352, 29);
        } else {
            if (n == 0) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString("1. Spring", 224, 13);
            if (n == 1) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString("2. Summer", 352, 13);
            if (n == 2) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString("3. Autumn", 224, 29);
            if (n == 3) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.gray);
            }
            graphics.drawString("4. Winter", 352, 29);
        }
    }

    public Rectangle getBounds(int n, int n2) {
        int n3 = (this.x << 5) + this.ox + n + 8;
        int n4 = (this.y << 5) + this.oy + n2;
        this.player_rect.x = n3;
        this.player_rect.y = n4;
        return this.player_rect;
    }
}

