/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class Map {
    private final int swidth = 640;
    private final int sheight = 480;
    private final int maxlevels = 5;
    private final int mapw = 20;
    private final int maph = 15;
    int startx;
    int starty;
    int rings;
    private boolean flood = false;
    private int currentseason = 0;
    private int framecount = 0;
    private int alt = 0;
    private BufferedImage levels_bmp;
    private Image[] sprite = new Image[128];
    private Image[] bgbmp = new Image[4];
    private Point pt = new Point(0, 0);
    private int[] base = new int[1024];
    private int[] mapdata = new int[4096];
    private int[] solid = new int[1024];
    private Rectangle block = new Rectangle(0, 0, 32, 32);

    public Map() {
        String[] stringArray;
        try {
            stringArray = Map.class.getClassLoader().getResource("gfx/levels.gif");
            this.levels_bmp = ImageIO.read((URL)stringArray);
        }
        catch (Exception exception) {
            System.out.println("Map: Exception loading levels");
            System.out.println(exception);
        }
        stringArray = new String[]{"spring", "summer", "autumn", "winter"};
        int n = 0;
        for (String string : stringArray) {
            try {
                URL uRL = Map.class.getClassLoader().getResource("gfx/backgrounds/" + string + ".png");
                this.bgbmp[n] = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Map: Exception loading background " + string);
                System.out.println(exception);
            }
            ++n;
        }
        this.loadgfx();
        this.clear();
    }

    private void clear() {
        Arrays.fill(this.mapdata, 0);
    }

    public int get(int n, int n2) {
        int n3 = this.currentseason * 1024 + n2 * 32 + n;
        return this.mapdata[n3];
    }

    public void set(int n, int n2, int n3) {
        int n4 = this.currentseason * 1024 + n2 * 32 + n;
        this.mapdata[n4] = n3;
    }

    private void loadgfx() {
        int n;
        BufferedImage[] bufferedImageArray = new BufferedImage[4];
        String[] stringArray = new String[]{"spring", "summer", "autumn", "winter"};
        int n2 = 0;
        String[] stringArray2 = stringArray;
        int n3 = stringArray2.length;
        for (n = 0; n < n3; ++n) {
            String string = stringArray2[n];
            try {
                URL uRL = Map.class.getClassLoader().getResource("gfx/" + string + ".gif");
                bufferedImageArray[n2] = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Map: Exception loading " + string);
                System.out.println(exception);
            }
            ++n2;
        }
        this.sprite[0] = new BufferedImage(32, 32, 1);
        int n4 = 1;
        for (n3 = 0; n3 < bufferedImageArray.length; ++n3) {
            n4 = 1;
            for (n = 0; n < 3; ++n) {
                for (n2 = 0; n2 < 10; ++n2) {
                    this.sprite[n4 + n3 * 30] = bufferedImageArray[n3].getSubimage(n2 * 32, n * 32, 32, 32);
                    ++n4;
                }
            }
        }
    }

    public void load(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        this.clear();
        BufferedImage bufferedImage = new BufferedImage(32, 32, 2);
        int n6 = 0;
        boolean bl = false;
        for (n5 = 0; n5 < 2; ++n5) {
            for (n4 = 0; n4 < 10; ++n4) {
                if (n6 == n) {
                    bufferedImage = this.levels_bmp.getSubimage(n4 * 32, n5 * 32, 32, 32);
                    bl = true;
                    break;
                }
                ++n6;
            }
            if (bl) break;
        }
        n5 = 0;
        n4 = 0;
        for (n3 = 0; n3 < 32; ++n3) {
            for (n2 = 0; n2 < 32; ++n2) {
                n4 = bufferedImage.getRGB(n2, n3) & 0xFFFFFF;
                n5 = n3 * 32 + n2;
                this.base[n5] = 0;
                if (n4 == 0) {
                    this.base[n5] = 1;
                }
                if (n4 == 65280) {
                    this.base[n5] = 2;
                }
                if (n4 == 0xFF8000) {
                    this.base[n5] = 3;
                }
                if (n4 == 0xFFFF80) {
                    this.base[n5] = 8;
                }
                if (n4 == 0xFFFF00) {
                    this.base[n5] = 11;
                }
                if (n4 == 0xFF0000) {
                    this.base[n5] = 12;
                }
                if (n4 == 0x808080) {
                    this.base[n5] = 14;
                }
                if (n4 == 0x804040) {
                    this.base[n5] = 17;
                }
                if (n4 == 65535) {
                    this.base[n5] = 20;
                }
                if (n4 == 0xFFFFFF) {
                    this.base[n5] = 22;
                }
                if (n4 == 0x804000) {
                    this.base[n5] = 24;
                }
                if (n4 != 0x8000FF) continue;
                this.startx = n2;
                this.starty = n3;
            }
        }
        for (n3 = 0; n3 < 4; ++n3) {
            n5 = n3 * 1024;
            for (n2 = 0; n2 < 1024; ++n2) {
                this.mapdata[n5 + n2] = this.base[n2];
            }
        }
        this.flood = true;
        if (this.base[992] == 1) {
            this.flood = false;
        }
        this.rings = this.count(11);
    }

    public boolean hit(Rectangle rectangle, int n) {
        int n2 = 0;
        for (int i = 0; i < 15; ++i) {
            n2 = i * 32;
            for (int j = 0; j < 20; ++j) {
                if (this.solid[n2 + j] != n) continue;
                this.block.x = j << 5;
                this.block.y = i << 5;
                if (!rectangle.intersects(this.block)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean over(Rectangle rectangle, int n) {
        int n2 = this.currentseason * 1024;
        for (int i = 0; i < 15; ++i) {
            int n3 = i * 32;
            for (int j = 0; j < 20; ++j) {
                if (this.mapdata[n2 + n3 + j] != n) continue;
                this.block.x = j << 5;
                this.block.y = i << 5;
                if (!rectangle.intersects(this.block)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collect(Rectangle rectangle, int n) {
        int n2 = this.currentseason * 1024;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 20; ++j) {
                int n3 = (i << 5) + j;
                if (this.mapdata[n2 + n3] != n) continue;
                this.block.x = j * 32;
                this.block.y = i * 32;
                if (!rectangle.intersects(this.block)) continue;
                if (n == 20) {
                    this.remove_current(n3);
                } else {
                    this.remove(n3);
                }
                return true;
            }
        }
        return false;
    }

    private void remove_current(int n) {
        for (int i = this.currentseason; i < 4; ++i) {
            int n2 = 1024 * i;
            this.mapdata[n2 + n] = 0;
        }
    }

    private void remove(int n) {
        for (int i = 0; i < 4; ++i) {
            int n2 = 1024 * i;
            this.mapdata[n2 + n] = 0;
        }
    }

    public void season(int n) {
        this.currentseason = n;
        int n2 = this.currentseason * 1024;
        this.replace(6, 0);
        this.replace(7, 0);
        this.replace(9, 0);
        this.replace(19, 0);
        if (this.currentseason > 0) {
            this.replace(5, 0);
        }
        this.fillsolid();
        switch (this.currentseason) {
            case 0: {
                break;
            }
            case 1: {
                for (int i = 0; i < 1024; ++i) {
                    int n3;
                    if (this.mapdata[n2 + i - 1024] == 8) {
                        int n4 = 0;
                        for (n3 = 1; n3 < 5 && this.mapdata[n2 + i - n3 * 32] == 0; ++n3) {
                            this.mapdata[n2 + i - n3 * 32] = 6;
                            ++n4;
                        }
                        if (n4 > 0) {
                            this.mapdata[n2 + i - n4 * 32] = 7;
                        }
                    }
                    if (this.mapdata[n2 + i - 1024] != 17) continue;
                    for (n3 = 1; n3 < 5 && this.mapdata[n2 + i + n3 * 32] == 0; ++n3) {
                        this.mapdata[n2 + i + n3 * 32] = 19;
                    }
                }
                break;
            }
            case 2: {
                this.replace(20, 0);
                this.rockfall();
                for (int i = 0; i < 1024; ++i) {
                    int n5;
                    if (this.mapdata[n2 + i - 1024] == 8) {
                        for (n5 = 1; n5 < 10 && this.mapdata[n2 + i - n5 * 32] == 0; ++n5) {
                            this.mapdata[n2 + i - n5 * 32] = 6;
                        }
                    }
                    if (this.mapdata[n2 + i - 1024] != 17) continue;
                    for (n5 = 1; n5 < 10 && this.mapdata[n2 + i + n5 * 32] == 0; ++n5) {
                        this.mapdata[n2 + i + n5 * 32] = 19;
                    }
                }
                if (!this.flood) break;
                this.addwater();
                break;
            }
            case 3: {
                this.replace(8, 2);
                this.replace(17, 2);
                this.replace(20, 0);
                this.rockfall();
                if (!this.flood) break;
                this.addwater();
                this.replace(5, 9);
            }
        }
        this.fillsolid();
    }

    private void fillsolid() {
        int n = this.currentseason * 1024;
        for (int i = 0; i < 1024; ++i) {
            this.solid[i] = 0;
            if (this.mapdata[n + i] == 1) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 2) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 8) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 9) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 10) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 13) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 17) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 24) {
                this.solid[i] = 1;
            }
            if (this.mapdata[n + i] == 3) {
                this.solid[i] = 2;
            }
            if (this.mapdata[n + i] == 6) {
                this.solid[i] = 2;
            }
            if (this.mapdata[n + i] == 7) {
                this.solid[i] = 2;
            }
            if (this.mapdata[n + i] != 19) continue;
            this.solid[i] = 2;
        }
    }

    private int issolid(int n, int n2) {
        return this.solid[n2 * 32 + n];
    }

    private int count(int n) {
        int n2 = 0;
        for (int n3 : this.base) {
            if (n3 != n) continue;
            ++n2;
        }
        return n2;
    }

    public void plant(int n, int n2, int n3) {
        for (int i = this.currentseason; i < 4; ++i) {
            int n4 = i * 1024 + n2 * 32 + n;
            this.mapdata[n4] = n3;
        }
    }

    private void replace(int n, int n2) {
        int n3 = this.currentseason * 1024;
        for (int i = 0; i < 1024; ++i) {
            if (this.mapdata[n3 + i] != n) continue;
            this.mapdata[n3 + i] = n2;
        }
    }

    public void draw(Graphics graphics) {
        int n = this.currentseason * 1024;
        int n2 = this.currentseason * 30;
        graphics.drawImage(this.bgbmp[this.currentseason], 0, 0, null);
        this.pt.y = 0;
        for (int i = 0; i < 15; ++i) {
            int n3 = (i << 5) + n;
            this.pt.x = 0;
            for (int j = 0; j < 20; ++j) {
                int n4 = this.mapdata[n3 + j];
                if (n4 == 14) {
                    n4 += this.alt;
                }
                if (n4 == 20) {
                    n4 += this.alt;
                }
                if (n4 > 0) {
                    graphics.drawImage(this.sprite[n2 + n4], this.pt.x, this.pt.y, null);
                }
                this.pt.x += 32;
            }
            this.pt.y += 32;
        }
        ++this.framecount;
        if (this.framecount > 30) {
            this.alt = 1 - this.alt;
            this.framecount = 0;
        }
    }

    private void addwater() {
        int n = 0;
        boolean bl = false;
        int n2 = 19;
        int n3 = 0;
        for (int i = 0; i < 200; ++i) {
            if (this.issolid(n2, n3 + 1) == 0 && this.get(n2, n3 + 1) != 5) {
                ++n3;
            } else if (this.issolid(n2 - 1, n3) == 0 && this.get(n2 - 1, n3) != 3) {
                --n2;
            } else {
                ++n;
                if (!bl) {
                    for (int j = n2; j < 25 && this.issolid(j, n3) != 1 && this.get(j, n3) != 14; ++j) {
                        this.set(j, n3, 5);
                    }
                }
                n2 = 19;
                n3 = 0;
            }
            if (n == 2 || bl) break;
        }
    }

    private void rockfall() {
        int n;
        int n2 = this.currentseason * 1024;
        this.replace(24, 0);
        for (n = 0; n < 1024; ++n) {
            if (this.base[n] != 24) continue;
            this.mapdata[n2 + n] = 24;
        }
        for (n = 18; n > 0; --n) {
            block2: for (int i = 0; i < 20; ++i) {
                if (this.get(i, n) != 24) continue;
                this.set(i, n, 0);
                for (int j = n; j < 18; ++j) {
                    if (this.get(i, j + 1) == 0) continue;
                    this.set(i, j, 24);
                    continue block2;
                }
            }
        }
    }
}

