/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class Inventory {
    private final int swidth = 640;
    private final int sheight = 480;
    private final int maxlevels = 5;
    private final int mapw = 20;
    private final int maph = 15;
    private final String title = "Spring Forward!";
    private final String website = "http://ssjx.co.uk";
    private final String version = "v0.4";
    private int selected = 0;
    private Image[] sprite = new Image[6];
    private Point pnt = new Point(0, 0);
    private int[] itm = new int[4];
    private int[] qty = new int[4];

    public Inventory() {
        this.load_gfx();
        this.clr();
    }

    private void load_gfx() {
        try {
            URL uRL = Map.class.getClassLoader().getResource("gfx/inventory.gif");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            int n = 0;
            for (int i = 0; i < this.sprite.length; ++i) {
                this.sprite[i] = bufferedImage.getSubimage(i * 32, 0, 32, 32);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Map: Exception loading inventory");
            System.out.println(exception);
        }
    }

    public void draw(Graphics graphics) {
        this.pnt.y = 0;
        this.pnt.x = 512;
        for (int i = 0; i < this.itm.length; ++i) {
            if (this.itm[i] == -1) {
                graphics.drawImage(this.sprite[4], this.pnt.x, this.pnt.y, null);
            } else {
                graphics.drawImage(this.sprite[this.itm[i]], this.pnt.x, this.pnt.y, null);
            }
            if (i == this.selected) {
                graphics.drawImage(this.sprite[5], this.pnt.x, this.pnt.y, null);
            }
            this.pnt.x += 32;
        }
    }

    public void add(int n) {
        int n2;
        for (n2 = 0; n2 < this.itm.length; ++n2) {
            if (this.itm[n2] != n) continue;
            int n3 = n2;
            this.qty[n3] = this.qty[n3] + 1;
            return;
        }
        for (n2 = 0; n2 < this.itm.length; ++n2) {
            if (this.itm[n2] != -1) continue;
            this.itm[n2] = n;
            this.qty[n2] = 1;
            return;
        }
    }

    public void remove(int n) {
        for (int i = 0; i < this.itm.length; ++i) {
            if (this.itm[i] != n) continue;
            int n2 = i;
            this.qty[n2] = this.qty[n2] - 1;
            if (this.qty[i] == 0) {
                this.itm[i] = -1;
            }
            return;
        }
    }

    public int count(int n) {
        for (int i = 0; i < this.itm.length; ++i) {
            if (this.itm[i] != n) continue;
            return this.qty[i];
        }
        return -1;
    }

    public void clr() {
        Arrays.fill(this.itm, -1);
        Arrays.fill(this.qty, 0);
    }

    public void nxt() {
        ++this.selected;
        if (this.selected > this.itm.length - 1) {
            this.selected = 0;
        }
    }

    public void prv() {
        --this.selected;
        if (this.selected < 0) {
            this.selected = this.itm.length - 1;
        }
    }

    public int current() {
        return this.itm[this.selected];
    }
}

