/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Trek
extends JPanel
implements MouseListener,
KeyListener {
    final int swidth = 640;
    final int sheight = 480;
    final int debug = 0;
    public static final String title = "Space Search";
    final String version = "Version 0.2 (19/01/20)";
    public static final int fps = 30;
    public static int fpsdelay = 33;
    String[] line = new String[30];
    int time = 0;
    States gamestate = States.WELCOME;
    int updatemap;
    Map mymap = new Map();
    Probe myprobe = new Probe();
    XHelp myhelp = new XHelp();
    static Player myplayer = new Player(0);
    static Torpedo[] mytorpedo = new Torpedo[5];
    static Explosion[] explo = new Explosion[10];
    static XGauge gauge_damage = new XGauge();
    static XGauge gauge_energy = new XGauge();
    static XGauge gauge_shield = new XGauge();
    static XGauge gauge_torpedos = new XGauge();
    FontMetrics fmetric;
    final Font fs = new Font("Arial", 1, 14);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 1, 22);
    final Font f = new Font("Arial", 0, 16);
    int counter;
    int timer;
    int kcount;
    int move;
    int release;
    int page = 0;
    boolean drawnow = true;
    Random rand = new Random();
    Image offscreen;

    @Override
    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Trek() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addMouseListener(this);
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Trek.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        int n;
        for (n = 0; n < mytorpedo.length; ++n) {
            Trek.mytorpedo[n] = new Torpedo();
        }
        for (n = 0; n < explo.length; ++n) {
            Trek.explo[n] = new Explosion();
        }
        gauge_damage.init(368, 196);
        gauge_shield.init(368, 228);
        gauge_energy.init(368, 260);
        gauge_torpedos.init(368, 292);
        Trek.myplayer.torpedos = mytorpedo.length;
        Trek.gauge_torpedos.max = mytorpedo.length;
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Trek());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void startgame() {
        myplayer.reset();
        Trek.myplayer.active = true;
        Trek.myplayer.sx = this.rand.nextInt(8);
        Trek.myplayer.sy = this.rand.nextInt(8);
        Trek.myplayer.x = this.rand.nextInt(8);
        Trek.myplayer.y = this.rand.nextInt(8);
        Trek.myplayer.torpedos = mytorpedo.length;
        myplayer.move();
        this.mymap.reset();
        this.mymap.warp(Trek.myplayer.sx, Trek.myplayer.sy);
        this.mymap.pos_x = Trek.myplayer.x;
        this.mymap.pos_y = Trek.myplayer.y;
        this.myprobe.active = 0;
        this.counter = 0;
        this.timer = 999;
        this.kcount = this.mymap.klingon_total();
    }

    public void setstate(States states) {
        switch (states) {
            case WELCOME: {
                break;
            }
            case GAME: {
                gauge_damage.start(0);
                gauge_energy.start(100);
                gauge_shield.start(100);
                gauge_torpedos.start(mytorpedo.length);
                this.startgame();
            }
        }
        this.gamestate = states;
    }

    public void controls() {
        switch (this.gamestate) {
            case GAME: {
                if (!myplayer.can_move()) break;
                int n = -1;
                int n2 = 0;
                int n3 = 0;
                if (this.move == 1) {
                    n = 0;
                    n3 = -1;
                }
                if (this.move == 2) {
                    n = 1;
                    n3 = 1;
                }
                if (this.move == 3) {
                    n = 2;
                    n2 = -1;
                }
                if (this.move == 4) {
                    n = 3;
                    n2 = 1;
                }
                if (n < 0 || n > 3) break;
                if (Trek.myplayer.direction == n) {
                    if (this.mymap.get(Trek.myplayer.x + n2, Trek.myplayer.y + n3) == 0) {
                        boolean bl = false;
                        switch (n) {
                            case 0: {
                                if (Trek.myplayer.y > 0) {
                                    myplayer.set_dir(n);
                                    break;
                                }
                                if (Trek.myplayer.y != 0 || Trek.myplayer.sy <= 0) break;
                                Trek.myplayer.y = 7;
                                --Trek.myplayer.sy;
                                bl = true;
                                break;
                            }
                            case 1: {
                                if (Trek.myplayer.y < 7) {
                                    myplayer.set_dir(n);
                                    break;
                                }
                                if (Trek.myplayer.y != 7 || Trek.myplayer.sy >= 7) break;
                                Trek.myplayer.y = 0;
                                ++Trek.myplayer.sy;
                                bl = true;
                                break;
                            }
                            case 2: {
                                if (Trek.myplayer.x > 0) {
                                    myplayer.set_dir(n);
                                    break;
                                }
                                if (Trek.myplayer.x != 0 || Trek.myplayer.sx <= 0) break;
                                Trek.myplayer.x = 7;
                                --Trek.myplayer.sx;
                                bl = true;
                                break;
                            }
                            case 3: {
                                if (Trek.myplayer.x < 7) {
                                    myplayer.set_dir(n);
                                    break;
                                }
                                if (Trek.myplayer.x != 7 || Trek.myplayer.sx >= 7) break;
                                Trek.myplayer.x = 0;
                                ++Trek.myplayer.sx;
                                bl = true;
                            }
                        }
                        if (bl) {
                            Trek.myplayer.sector = Trek.myplayer.sy * 8 + Trek.myplayer.sx;
                            this.mymap.warp(Trek.myplayer.sx, Trek.myplayer.sy);
                        }
                    }
                } else {
                    Trek.myplayer.direction = n;
                }
                this.mymap.pos_x = Trek.myplayer.x;
                this.mymap.pos_y = Trek.myplayer.y;
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        super.paintComponent(graphics);
        for (n = 0; n < this.line.length; ++n) {
            this.line[n] = "";
        }
        switch (this.gamestate) {
            case WELCOME: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                this.mymap.draw_stars(graphics);
                this.line[0] = title;
                this.line[1] = "Find and destroy the enemy ships";
                this.line[2] = "scattered throughout this system!";
                this.line[3] = "";
                this.line[4] = "You must do this before the time";
                this.line[5] = "runs out! Good Luck!";
                this.line[6] = "";
                this.line[7] = "Controls";
                this.line[8] = "Arrow Keys - Move";
                this.line[9] = "1 - Hyper Jump";
                this.line[10] = "2 - Laser";
                this.line[11] = "3 - Torpedo";
                this.line[12] = "4 - Probe";
                this.line[13] = "W,S,A,D - Torpedo";
                this.line[14] = "+/- : Transfer Power";
                this.line[15] = "";
                this.line[16] = "About Your Ship";
                this.line[17] = "You ship is fitted with many ";
                this.line[18] = "advanced features. It is worth";
                this.line[19] = "reading the user manual:";
                this.line[20] = "";
                this.line[21] = "< Click here or press H for help >";
                this.line[22] = "";
                this.line[23] = "< Click here to press SPACE start >";
                int n2 = 32;
                n = 0;
                for (String string : this.line) {
                    switch (n) {
                        case 0: {
                            graphics.setFont(this.fm);
                            this.fmetric = graphics.getFontMetrics(this.fm);
                            graphics.setColor(Color.green);
                            break;
                        }
                        case 7: 
                        case 16: {
                            graphics.setFont(this.fb);
                            this.fmetric = graphics.getFontMetrics(this.fb);
                            graphics.setColor(Color.yellow);
                            break;
                        }
                        case 21: 
                        case 23: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.cyan);
                            break;
                        }
                        default: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.white);
                        }
                    }
                    graphics.drawString(string, (640 - this.fmetric.stringWidth(string)) / 2, n2);
                    n2 += 18;
                    ++n;
                }
                graphics.setColor(Color.yellow);
                graphics.drawString("http://ssjx.co.uk", 520, 475);
                graphics.drawString("Version 0.2 (19/01/20)", 2, 475);
                break;
            }
            case HELP: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                this.mymap.draw_stars(graphics);
                this.myhelp.draw(graphics);
                break;
            }
            case GAME: {
                int n3;
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                this.mymap.draw_galaxy(graphics);
                this.mymap.draw_sector(graphics);
                if (this.myprobe.active > 0 && this.myprobe.sector == this.mymap.sector) {
                    this.myprobe.draw(graphics);
                    if (this.myprobe.hit(Trek.myplayer.x, Trek.myplayer.y) && myplayer.stopped()) {
                        this.myprobe.active = 0;
                        this.mymap.probe_sector = -1;
                    }
                }
                Torpedo[] torpedoArray = mytorpedo;
                int n4 = torpedoArray.length;
                for (int i = 0; i < n4; ++i) {
                    Torpedo torpedo = torpedoArray[i];
                    if (!torpedo.active || torpedo.sector != this.mymap.sector) continue;
                    torpedo.draw(graphics);
                }
                myplayer.draw(graphics);
                graphics.setColor(Color.white);
                graphics.drawString("Damage: " + Integer.toString(Trek.myplayer.damage) + "%", 368, 192);
                graphics.drawString("Shield: " + Integer.toString(Trek.myplayer.shield) + "%", 368, 224);
                graphics.drawString("Energy: " + Integer.toString(Trek.myplayer.energy) + "%", 368, 256);
                graphics.drawString("Torpedos: " + Integer.toString(Trek.myplayer.torpedos), 368, 288);
                gauge_damage.draw(graphics);
                gauge_shield.draw(graphics);
                gauge_energy.draw(graphics);
                gauge_torpedos.draw(graphics);
                graphics.drawString("Time: " + Integer.toString(this.timer), 368, 352);
                graphics.drawString("Enemies: " + Integer.toString(this.kcount), 368, 384);
                graphics.setColor(Color.yellow);
                graphics.drawRect(352, 160, 256, 256);
                if (this.mymap.alert == 1) {
                    graphics.setColor(Color.red);
                    graphics.fillRect(0, 448, 640, 16);
                    this.fmetric = graphics.getFontMetrics(this.f);
                    graphics.setColor(Color.white);
                    graphics.drawString("Red alert! - Enemy Nearby!", (640 - this.fmetric.stringWidth("Red alert! - Enemy Nearby!")) / 2, 462);
                }
                if (Trek.myplayer.docked) {
                    this.fmetric = graphics.getFontMetrics(this.f);
                    graphics.setColor(Color.green);
                    graphics.drawString("Docked - Repairs / Re-arming In Progress", (640 - this.fmetric.stringWidth("Docked - Repairs / Re-arming In Progress")) / 2, 478);
                } else {
                    graphics.setColor(Color.yellow);
                    if (Trek.myplayer.energy > 50) {
                        graphics.drawString("1:Hyper Jump", 16, 479);
                    }
                    graphics.drawString("2:Laser", 176, 479);
                    if (Trek.myplayer.torpedos > 0) {
                        graphics.drawString("3:Torpedo", 336, 479);
                    }
                    if (this.myprobe.active == 0) {
                        graphics.drawString("4:Probe", 496, 479);
                    }
                    graphics.setColor(Color.gray);
                    if (Trek.myplayer.energy <= 50) {
                        graphics.drawString("1:Hyper Jump", 16, 479);
                    }
                    if (Trek.myplayer.torpedos == 0) {
                        graphics.drawString("3:Torpedo", 336, 479);
                    }
                    if (this.myprobe.active != 0) {
                        graphics.drawString("4:Probe", 496, 479);
                    }
                }
                graphics.setColor(Color.yellow);
                graphics.drawLine(0, 448, 640, 448);
                for (n = 0; n < explo.length; ++n) {
                    explo[n].update(this.mymap.sector);
                    explo[n].draw(graphics);
                }
                myplayer.move();
                for (n3 = 0; n3 < mytorpedo.length; ++n3) {
                    if (!Trek.mytorpedo[n3].active) continue;
                    mytorpedo[n3].move();
                    if (this.mymap.hit_star(Trek.mytorpedo[n3].x, Trek.mytorpedo[n3].y)) {
                        Trek.mytorpedo[n3].active = false;
                    }
                    for (n4 = 0; n4 < this.mymap.klingons.length; ++n4) {
                        if (!this.mymap.klingons[n4].active || this.mymap.klingons[n4].sector != Trek.mytorpedo[n3].sector || !mytorpedo[n3].hit(this.mymap.klingons[n4].x, this.mymap.klingons[n4].y)) continue;
                        Trek.mytorpedo[n3].active = false;
                        this.mymap.klingons[n4].active = false;
                        this.addexplosion(this.mymap.klingons[n4].x * 32, this.mymap.klingons[n4].y * 32, this.mymap.sector);
                    }
                }
                if (this.myprobe.active > 0 && this.myprobe.active == 1) {
                    if (this.mymap.hit_probestar(this.myprobe.x + this.myprobe.xdir, this.myprobe.y + this.myprobe.ydir, this.myprobe.sx, this.myprobe.sy)) {
                        this.myprobe.active = 2;
                        this.myprobe.stop();
                    } else if (this.myprobe.move() == 1) {
                        this.mymap.mapvis[this.myprobe.sector] = 1;
                        this.mymap.probe_sector = this.myprobe.sector;
                    }
                }
                ++this.counter;
                if (this.counter == 30) {
                    --this.timer;
                    if (this.timer == 0) {
                        this.setstate(States.TIMEUP);
                    }
                    for (n3 = 0; n3 < this.mymap.klingons.length; ++n3) {
                        for (n4 = 0; n4 < 4; ++n4) {
                            this.mymap.klingons[n3].charge();
                        }
                    }
                    this.counter = 0;
                    myplayer.charge();
                    this.kcount = this.mymap.klingon_total();
                    Trek.myplayer.docked = this.mymap.docked(Trek.myplayer.x, Trek.myplayer.y);
                    if (Trek.myplayer.docked) {
                        myplayer.charge();
                        if (Trek.myplayer.damage > 0) {
                            Trek.myplayer.damage -= 5;
                            if (Trek.myplayer.damage < 0) {
                                Trek.myplayer.damage = 0;
                            }
                            gauge_damage.update(Trek.myplayer.damage);
                        }
                        if (Trek.myplayer.torpedos < mytorpedo.length) {
                            ++Trek.myplayer.torpedos;
                            gauge_torpedos.update(Trek.myplayer.torpedos);
                        }
                    }
                    gauge_shield.update(Trek.myplayer.shield);
                    gauge_energy.update(Trek.myplayer.energy);
                }
                if (!Trek.myplayer.docked) {
                    if (this.counter % 2 == 0) {
                        this.mymap.klingons_update();
                    }
                    n3 = 0;
                    n3 = this.mymap.klingons_attack(Trek.myplayer.actx, Trek.myplayer.acty);
                    if (n3 > 0) {
                        myplayer.hit(3 * n3);
                        gauge_damage.update(Trek.myplayer.damage);
                        gauge_energy.update(Trek.myplayer.energy);
                        gauge_shield.update(Trek.myplayer.shield);
                    }
                }
                this.controls();
                if (!Trek.myplayer.active) {
                    this.setstate(States.OVER);
                }
                if (this.kcount != 0) break;
                this.setstate(States.DONE);
                break;
            }
            case OVER: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                this.mymap.draw_stars(graphics);
                this.line[0] = "Mission Failed!";
                this.line[1] = "Your ship was destroyed!";
                this.line[2] = "Better luck next time!";
                this.line[3] = "";
                this.line[4] = "< Click to continue >";
                graphics.setFont(this.f);
                this.fmetric = graphics.getFontMetrics(this.f);
                graphics.setColor(Color.white);
                for (int i = 0; i < 5; ++i) {
                    switch (i) {
                        case 0: {
                            graphics.setFont(this.fb);
                            this.fmetric = graphics.getFontMetrics(this.fb);
                            graphics.setColor(Color.red);
                            break;
                        }
                        case 4: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.cyan);
                            break;
                        }
                        default: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.white);
                        }
                    }
                    graphics.drawString(this.line[i], (640 - this.fmetric.stringWidth(this.line[i])) / 2, (i + 12) * 16);
                }
                break;
            }
            case DONE: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                this.mymap.draw_stars(graphics);
                this.line[0] = "Well Done!";
                this.line[1] = "You found and defeated";
                this.line[2] = "all of the enemy ships!";
                this.line[3] = "";
                this.line[4] = "< Click to continue >";
                graphics.setFont(this.f);
                this.fmetric = graphics.getFontMetrics(this.f);
                graphics.setColor(Color.white);
                for (int i = 0; i < 5; ++i) {
                    switch (i) {
                        case 0: {
                            graphics.setFont(this.fb);
                            this.fmetric = graphics.getFontMetrics(this.fb);
                            graphics.setColor(Color.yellow);
                            break;
                        }
                        case 4: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.cyan);
                            break;
                        }
                        default: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.yellow);
                        }
                    }
                    graphics.drawString(this.line[i], (640 - this.fmetric.stringWidth(this.line[i])) / 2, (i + 12) * 16);
                }
                break;
            }
            case TIMEUP: {
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                this.mymap.draw_stars(graphics);
                this.line[0] = "Time Up!";
                this.line[1] = "You ran out of time!";
                this.line[2] = "Better luck next time!";
                this.line[3] = "";
                this.line[4] = "< Click to continue >";
                graphics.setFont(this.f);
                this.fmetric = graphics.getFontMetrics(this.f);
                graphics.setColor(Color.white);
                for (int i = 0; i < 5; ++i) {
                    switch (i) {
                        case 0: {
                            graphics.setFont(this.fb);
                            this.fmetric = graphics.getFontMetrics(this.fb);
                            graphics.setColor(Color.red);
                            break;
                        }
                        case 4: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.cyan);
                            break;
                        }
                        default: {
                            graphics.setFont(this.f);
                            this.fmetric = graphics.getFontMetrics(this.f);
                            graphics.setColor(Color.white);
                        }
                    }
                    graphics.drawString(this.line[i], (640 - this.fmetric.stringWidth(this.line[i])) / 2, (i + 12) * 16);
                }
                break;
            }
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
        graphics.dispose();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.gamestate == States.WELCOME) {
            this.setstate(States.GAME);
        }
        if (this.gamestate == States.DONE) {
            this.setstate(States.WELCOME);
        }
        if (this.gamestate == States.OVER) {
            this.setstate(States.WELCOME);
        }
        if (this.gamestate == States.TIMEUP) {
            this.setstate(States.WELCOME);
        }
        if (this.gamestate == States.HELP) {
            this.setstate(States.WELCOME);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (this.release != 0) break;
                this.move = 1;
                break;
            }
            case 40: {
                if (this.release != 0) break;
                this.move = 2;
                break;
            }
            case 37: {
                if (this.release == 0) {
                    this.move = 3;
                }
                if (this.gamestate != States.HELP) break;
                --this.page;
                if (this.page < 0) {
                    this.page = 2;
                }
                this.myhelp.ship_help(this.page);
                break;
            }
            case 39: {
                if (this.release == 0) {
                    this.move = 4;
                }
                if (this.gamestate != States.HELP) break;
                ++this.page;
                if (this.page > 2) {
                    this.page = 0;
                }
                this.myhelp.ship_help(this.page);
                break;
            }
            case 32: {
                if (this.gamestate == States.WELCOME) {
                    this.setstate(States.GAME);
                }
                if (this.gamestate == States.DONE) {
                    this.setstate(States.WELCOME);
                }
                if (this.gamestate == States.OVER) {
                    this.setstate(States.WELCOME);
                }
                if (this.gamestate == States.TIMEUP) {
                    this.setstate(States.WELCOME);
                }
                if (this.gamestate != States.HELP) break;
                this.setstate(States.WELCOME);
                break;
            }
            case 49: {
                this.warp_jump();
                break;
            }
            case 50: {
                this.fire_laser();
                break;
            }
            case 51: {
                this.launch_torpedo(Trek.myplayer.direction);
                break;
            }
            case 52: {
                this.launch_probe();
                break;
            }
            case 87: {
                this.launch_torpedo(0);
                break;
            }
            case 83: {
                this.launch_torpedo(1);
                break;
            }
            case 65: {
                this.launch_torpedo(2);
                break;
            }
            case 68: {
                this.launch_torpedo(3);
                break;
            }
            case 72: {
                if (this.gamestate != States.WELCOME) break;
                this.setstate(States.HELP);
                break;
            }
            case 61: {
                myplayer.transfer_to_shield();
                gauge_energy.update(Trek.myplayer.energy);
                gauge_shield.update(Trek.myplayer.shield);
                break;
            }
            case 45: {
                myplayer.transfer_from_shield();
                gauge_energy.update(Trek.myplayer.energy);
                gauge_shield.update(Trek.myplayer.shield);
                break;
            }
            case 80: {
                break;
            }
            case 81: {
                if (this.gamestate == States.GAME) {
                    this.setstate(States.WELCOME);
                }
                if (this.gamestate != States.HELP) break;
                this.setstate(States.WELCOME);
                break;
            }
            case 90: {
                this.setstate(States.OVER);
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.move = 0;
                this.release = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void warp_jump() {
        if (Trek.myplayer.docked) {
            return;
        }
        if (Trek.myplayer.energy > 50) {
            Trek.myplayer.energy -= 50;
            gauge_energy.update(Trek.myplayer.energy);
            Trek.myplayer.sx = this.rand.nextInt(8);
            Trek.myplayer.sy = this.rand.nextInt(8);
            this.mymap.warp(Trek.myplayer.sx, Trek.myplayer.sy);
        }
    }

    private void launch_torpedo(int n) {
        if (Trek.myplayer.docked) {
            return;
        }
        if (Trek.myplayer.torpedos > 0) {
            for (int i = 0; i < mytorpedo.length; ++i) {
                if (Trek.mytorpedo[i].active) continue;
                --Trek.myplayer.torpedos;
                gauge_torpedos.update(Trek.myplayer.torpedos);
                mytorpedo[i].set(this.mymap.pos_x, this.mymap.pos_y, this.mymap.sector, n);
                break;
            }
        }
    }

    private void launch_probe() {
        if (Trek.myplayer.docked) {
            return;
        }
        if (this.myprobe.active == 0) {
            int n = Trek.myplayer.x;
            int n2 = Trek.myplayer.y;
            int n3 = Trek.myplayer.direction;
            if (n3 == 0) {
                --n2;
            }
            if (n3 == 1) {
                ++n2;
            }
            if (n3 == 2) {
                --n;
            }
            if (n3 == 3) {
                ++n;
            }
            if (!this.mymap.hit_probestar(n, n2, this.mymap.sec_x, this.mymap.sec_y)) {
                this.myprobe.set(this.mymap.pos_x, this.mymap.pos_y, this.mymap.sec_x, this.mymap.sec_y, Trek.myplayer.direction);
                if (this.myprobe.sector != Trek.myplayer.sector) {
                    this.mymap.mapvis[this.myprobe.sector] = 1;
                }
            }
        }
    }

    private void fire_laser() {
        int n;
        if (Trek.myplayer.docked) {
            return;
        }
        if (Trek.myplayer.energy > 0 && (n = this.mymap.klingons_target()) > -1 && myplayer.set_target(this.mymap.klingons[n].actx, this.mymap.klingons[n].acty)) {
            gauge_energy.update(Trek.myplayer.energy);
            this.mymap.klingons[n].hit(20);
            if (!this.mymap.klingons[n].active) {
                this.addexplosion(this.mymap.klingons[n].x * 32, this.mymap.klingons[n].y * 32, this.mymap.sector);
            }
        }
    }

    public void addexplosion(int n, int n2, int n3) {
        for (int i = 0; i < explo.length; ++i) {
            if (Trek.explo[i].active) continue;
            explo[i].set(n + 12, n2 + 12, n3);
            break;
        }
    }

    public static enum States {
        WELCOME,
        GAME,
        OVER,
        DONE,
        TIMEUP,
        HELP;

    }
}

