/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;

public class Player {
    public int shield;
    public int damage;
    public int energy;
    public boolean active;
    public boolean docked;
    public int direction;
    public int torpedos;
    public int sector;
    public int x = 1;
    public int y = 1;
    public int sx = 1;
    public int sy = 1;
    public int actx;
    public int acty;
    public int firedelay;
    private int ox;
    private int oy;
    private int ship;
    private int palt;
    private boolean fire;
    private boolean canfire;
    Point tgt = new Point(0, 0);
    int[] phaser_colour = new int[]{39168, 0x990000};
    static Image[] sprite = new Image[2];
    static boolean loaded = false;

    public Player(int n) {
        if (!loaded) {
            String[] stringArray = new String[]{"ship4.gif", "klingon4.gif"};
            int n2 = 0;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            for (String string : stringArray) {
                try {
                    Player.sprite[n2] = graphicsConfiguration.createCompatibleImage(128, 32, 2);
                    URL uRL = Trek.class.getClassLoader().getResource("gfx/" + string);
                    Player.sprite[n2] = ImageIO.read(uRL);
                }
                catch (Exception exception) {
                    System.out.println("Problem loading the sprite " + string);
                }
                ++n2;
            }
            loaded = true;
        }
        this.ship = n;
        this.reset();
    }

    public void set_dir(int n) {
        if (this.ox == 0 && this.oy == 0) {
            switch (n) {
                case 0: {
                    if (this.y <= 0) break;
                    --this.y;
                    this.oy = 30;
                    break;
                }
                case 1: {
                    if (this.y >= 7) break;
                    ++this.y;
                    this.oy = -30;
                    break;
                }
                case 2: {
                    if (this.x <= 0) break;
                    --this.x;
                    this.ox = 30;
                    break;
                }
                case 3: {
                    if (this.x >= 7) break;
                    ++this.x;
                    this.ox = -30;
                }
            }
            this.direction = n;
        }
    }

    public boolean stopped() {
        return this.ox == 0 && this.oy == 0;
    }

    public boolean can_move() {
        return this.ox == 0 && this.oy == 0;
    }

    public void set_offset(int n, int n2) {
        this.ox = n;
        this.oy = n2;
    }

    public void move() {
        if (this.ox != 0) {
            this.ox = this.ox < 0 ? (this.ox += 2) : (this.ox -= 2);
        }
        if (this.oy != 0) {
            this.oy = this.oy < 0 ? (this.oy += 2) : (this.oy -= 2);
        }
        this.actx = this.x * 32 + this.ox;
        this.acty = this.y * 32 + this.oy;
    }

    public void set(int n, int n2, int n3) {
        this.ox = 0;
        this.oy = 0;
        this.x = n;
        this.y = n2;
        this.actx = this.x * 32 + this.ox;
        this.acty = this.y * 32 + this.oy;
        this.sector = n3;
    }

    public boolean set_target(int n, int n2) {
        if (this.firedelay == 0) {
            if (this.energy - 5 >= 0) {
                this.tgt.x = 32 + n;
                this.tgt.y = 160 + n2;
                this.fire = true;
                this.energy -= 5;
                return true;
            }
            if (this.ship == 1) {
                this.firedelay = 20;
            }
        }
        return false;
    }

    public void reset() {
        this.ox = 0;
        this.oy = 0;
        this.direction = 0;
        this.damage = 0;
        this.energy = 100;
        this.shield = 100;
        this.firedelay = 0;
        this.fire = false;
        this.palt = -1;
        this.active = false;
        this.docked = false;
        this.canfire = true;
    }

    public void hit(int n) {
        if (this.shield > 0) {
            this.shield -= n;
            if (this.shield < 0) {
                this.damage -= this.shield;
                this.shield = 0;
            }
        } else {
            this.damage += n;
        }
        if (this.damage >= 100) {
            this.damage = 100;
            this.active = false;
        }
    }

    public void charge() {
        if (this.active) {
            if (this.shield < 100) {
                ++this.shield;
            }
            if (this.energy < 100) {
                ++this.energy;
            }
            if (this.firedelay > 0) {
                --this.firedelay;
            }
        }
    }

    public void transfer_to_shield() {
        if (this.energy > 0 && this.shield < 100) {
            ++this.shield;
            --this.energy;
        }
    }

    public void transfer_from_shield() {
        if (this.shield > 0 && this.energy < 100) {
            --this.shield;
            ++this.energy;
        }
    }

    public void draw(Graphics graphics) {
        int n = 32 + this.x * 32 + this.ox;
        int n2 = 160 + this.y * 32 + this.oy;
        if (this.fire) {
            graphics.drawLine(n + 16 + this.palt, n2 + 16 + this.palt, this.tgt.x + 16, this.tgt.y + 16);
            this.fire = false;
            ++this.palt;
            if (this.palt > 1) {
                this.palt = -1;
            }
        }
        graphics.drawImage(sprite[this.ship], n, n2, n + 32, n2 + 32, 0 + this.direction * 32, 0, 32 + this.direction * 32, 32, null);
    }
}

