/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class Map {
    public int sector;
    public int sec_x;
    public int sec_y;
    public int pos_x;
    public int pos_y;
    public int act_x;
    public int act_y;
    public int alert;
    public int probe_sector;
    final int width = 32;
    final int height = 32;
    final int mapw = 64;
    final int maph = 64;
    static Image[] sprite = new Image[6];
    int[] mapdata = new int[4096];
    int[] mapvis = new int[64];
    Player[] klingons = new Player[50];
    final Font fm = new Font("Arial", 0, 16);
    private Random rand = new Random();

    public Map() {
        int n;
        for (n = 0; n < this.klingons.length; ++n) {
            this.klingons[n] = new Player(1);
            this.klingons[n].sector = -1;
        }
        String[] stringArray = new String[]{"space.gif", "star.gif", "klingon.gif", "station.gif", "ship.gif", "space_dim.gif"};
        n = 0;
        for (String string : stringArray) {
            try {
                URL uRL = Trek.class.getClassLoader().getResource("gfx/" + string);
                Map.sprite[n] = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Problem loading the sprite " + string);
            }
            ++n;
        }
        this.reset();
    }

    public void reset() {
        int n;
        int n2 = 0;
        int n3 = -1;
        for (n = 0; n < this.mapvis.length; ++n) {
            this.mapvis[n] = 0;
        }
        for (n = 0; n < this.klingons.length; ++n) {
            this.klingons[n].sector = -1;
            this.klingons[n].reset();
        }
        int n4 = 0;
        for (int i = 0; i < 8; ++i) {
            for (n = 0; n < 8; ++n) {
                for (int j = 0; j < 8; ++j) {
                    for (int k = 0; k < 8; ++k) {
                        int n5 = (i * 8 + j) * 64 + n * 8 + k;
                        this.mapdata[n5] = 0;
                        int n6 = this.rand.nextInt(24);
                        int n7 = this.rand.nextInt(384);
                        int n8 = this.rand.nextInt(256);
                        if (n6 == 5) {
                            this.mapdata[n5] = 1;
                        }
                        if (n7 == 1 && n2 < this.klingons.length) {
                            this.klingons[n2].set(k, j, n4);
                            this.klingons[n2].active = true;
                            ++n2;
                        }
                        if (n8 != 5) continue;
                        this.mapdata[n5] = 3;
                    }
                }
                ++n4;
            }
        }
    }

    public void draw_galaxy(Graphics graphics) {
        graphics.setFont(this.fm);
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Object object;
                if (this.mapvis[n] == 1) {
                    graphics.setColor(Color.white);
                    int n2 = this.sector_count(j, i, 1);
                    int n3 = this.klingon_count(n);
                    int n4 = this.sector_count(j, i, 3);
                    object = n == this.sector ? "[" + Integer.toString(n2) + Integer.toString(n3) + Integer.toString(n4) + "]" : (this.probe_sector == n ? "<" + Integer.toString(n2) + Integer.toString(n3) + Integer.toString(n4) + ">" : " " + Integer.toString(n2) + Integer.toString(n3) + Integer.toString(n4) + " ");
                    if (n3 != 0) {
                        graphics.setColor(Color.red);
                    }
                } else {
                    graphics.setColor(Color.gray);
                    object = " ??? ";
                }
                graphics.drawString((String)object, 16 + j * 80, 8 + i * 17 + 17);
                ++n;
            }
        }
        graphics.setColor(Color.yellow);
        graphics.drawRect(8, 8, 624, 144);
    }

    private int sector_count(int n, int n2, int n3) {
        int n4 = n * 8;
        int n5 = n2 * 8 * 64;
        int n6 = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (this.mapdata[n5 + n4 + j] != n3) continue;
                ++n6;
            }
            n5 += 64;
        }
        return n6;
    }

    private int klingon_count(int n) {
        int n2 = 0;
        for (Player player : this.klingons) {
            if (!player.active || player.sector != n) continue;
            ++n2;
        }
        return n2;
    }

    public int klingon_total() {
        int n = 0;
        for (Player player : this.klingons) {
            if (!player.active) continue;
            ++n;
        }
        return n;
    }

    public int get(int n, int n2) {
        int n3 = this.sec_x * 8 + n;
        int n4 = (this.sec_y * 8 + n2) * 64;
        for (Player player : this.klingons) {
            if (!player.active || player.sector != this.sector || player.x != n || player.y != n2) continue;
            return 2;
        }
        int n5 = n3 + n4;
        if (n5 >= 0 && n5 < this.mapdata.length) {
            return this.mapdata[n4 + n3];
        }
        return 1;
    }

    public void klingons_update() {
        for (int i = 0; i < this.klingons.length; ++i) {
            if (!this.klingons[i].active || this.klingons[i].sector != this.sector || this.klingons[i].shield <= 50) continue;
            int n = Math.abs(this.pos_x - this.klingons[i].x);
            int n2 = Math.abs(this.pos_y - this.klingons[i].y);
            if (n > 2) {
                if (this.klingons[i].x < this.pos_x && this.get(this.klingons[i].x + 1, this.klingons[i].y) == 0) {
                    this.klingons[i].set_dir(3);
                }
                if (this.klingons[i].x > this.pos_x && this.get(this.klingons[i].x - 1, this.klingons[i].y) == 0) {
                    this.klingons[i].set_dir(2);
                }
            }
            if (n2 > 2) {
                if (this.klingons[i].y < this.pos_y && this.get(this.klingons[i].x, this.klingons[i].y + 1) == 0) {
                    this.klingons[i].set_dir(1);
                }
                if (this.klingons[i].y > this.pos_y && this.get(this.klingons[i].x, this.klingons[i].y - 1) == 0) {
                    this.klingons[i].set_dir(0);
                }
            }
            this.klingons[i].move();
        }
    }

    public int klingons_attack(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.klingons.length; ++i) {
            if (!this.klingons[i].active || this.klingons[i].sector != this.sector) continue;
            int n4 = Math.abs(n - this.klingons[i].actx);
            int n5 = Math.abs(n2 - this.klingons[i].acty);
            if (n4 > 64 || n5 > 64 || !this.klingons[i].set_target(n, n2)) continue;
            ++n3;
        }
        return n3;
    }

    public void warp(int n, int n2) {
        this.sec_x = n;
        this.sec_y = n2;
        this.sector = this.sec_y * 8 + this.sec_x;
        this.mapvis[this.sector] = 1;
    }

    public boolean docked(int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.get(n - 1 + j, n2 - 1 + i) != 3) continue;
                return true;
            }
        }
        return false;
    }

    public int klingons_target() {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.klingons.length; ++i) {
            int n3;
            if (!this.klingons[i].active || this.klingons[i].sector != this.sector) continue;
            int n4 = Math.abs(this.pos_x - this.klingons[i].x);
            int n5 = Math.abs(this.pos_y - this.klingons[i].y);
            if (n4 >= 3 || n5 >= 3 || (n3 = (n4 ^ 2) + (n5 ^ 2)) >= n && n != -1) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    public boolean hit_star(int n, int n2) {
        int n3 = this.sec_x * 8 + n;
        int n4 = (this.sec_y * 8 + n2) * 64;
        if (n3 + n4 >= this.mapdata.length) {
            return true;
        }
        if (n3 + n4 < 0) {
            return true;
        }
        return this.mapdata[n3 + n4] == 1;
    }

    public boolean hit_probestar(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n > 7) {
            n = 0;
            ++n3;
        }
        if (n < 0) {
            n = 7;
            --n3;
        }
        if (n2 > 7) {
            n2 = 0;
            ++n4;
        }
        if (n2 < 0) {
            n2 = 7;
            --n4;
        }
        if ((n6 = n3 * 8 + n) + (n5 = (n4 * 8 + n2) * 64) >= this.mapdata.length) {
            return true;
        }
        if (n6 + n5 < 0) {
            return true;
        }
        if (this.mapdata[n6 + n5] == 1) {
            return true;
        }
        return this.mapdata[n6 + n5] == 3;
    }

    public void draw_stars(Graphics graphics) {
        for (int i = 0; i < 480; i += 32) {
            for (int j = 0; j < 640; j += 32) {
                graphics.drawImage(sprite[5], j, i, null);
            }
        }
    }

    public void draw_sector(Graphics graphics) {
        int n;
        int n2 = this.sec_x * 8;
        int n3 = this.sec_y * 8 * 64;
        Point point = new Point(32, 160);
        for (int i = 0; i < 8; ++i) {
            point.x = 32;
            for (n = 0; n < 8; ++n) {
                int n4 = this.mapdata[n2 + n3 + n];
                if (n4 >= 0 && n4 <= 4) {
                    graphics.drawImage(sprite[n4], point.x, point.y, null);
                }
                point.x += 32;
            }
            n3 += 64;
            point.y += 32;
        }
        int n5 = 0;
        for (n = 0; n < this.klingons.length; ++n) {
            if (!this.klingons[n].active || this.klingons[n].sector != this.sector) continue;
            this.klingons[n].draw(graphics);
            ++n5;
        }
        this.alert = 0;
        if (n5 > 0) {
            this.alert = 1;
        }
        graphics.setColor(Color.yellow);
        if (this.alert == 1) {
            graphics.setColor(Color.red);
        }
        graphics.drawRect(32, 160, 256, 256);
    }
}

