/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Sense
extends JPanel
implements MouseListener,
KeyListener {
    final int swidth = 640;
    final int sheight = 480;
    final int debug = 0;
    final String title = "Sensitive 2020";
    final String version = "Version 3.1 (19/01/20)";
    final int levels = 5;
    public int fps = 5;
    public int fpsdelay = 1000 / this.fps;
    public int count;
    static String[] line = new String[30];
    int px;
    int py;
    int ofx;
    int ofy;
    int xdir;
    int ydir;
    boolean moving;
    int ox;
    int oy;
    int time = 0;
    int level = 1;
    int lives = 3;
    int move = 0;
    States gamestate = States.WELCOME;
    int score;
    int hiscore;
    int prevscore;
    int updatemap;
    static Image player;
    static Image background;
    static Explosion[] explo;
    String txt;
    int xpos;
    static Map mymap;
    FontMetrics fmetric;
    final Font fs = new Font("Arial", 1, 14);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 1, 30);

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Sense() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addMouseListener(this);
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Sense.this.repaint();
                    try {
                        Thread.sleep(Sense.this.fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        for (int i = 0; i < explo.length; ++i) {
            Sense.explo[i] = new Explosion();
        }
        try {
            serializable = Sense.class.getClassLoader().getResource("gfx/player.gif");
            player = ImageIO.read((URL)serializable);
            serializable = Sense.class.getClassLoader().getResource("gfx/shadow.gif");
            background = ImageIO.read((URL)serializable);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map sprites...");
        }
        serializable = new JFrame("Sensitive");
        ((Frame)serializable).setResizable(false);
        ((JFrame)serializable).setDefaultCloseOperation(3);
        ((JFrame)serializable).setContentPane(new Sense());
        ((Window)serializable).pack();
        ((Window)serializable).setVisible(true);
    }

    public void startgame() {
        mymap.load(this.level);
        this.px = Sense.mymap.startx;
        this.py = Sense.mymap.starty;
        this.count = 0;
        this.time = 60;
        this.xdir = 0;
        this.ydir = 0;
        this.moving = false;
        this.ofx = 0;
        this.ofy = 0;
        for (int i = 0; i < explo.length; ++i) {
            Sense.explo[i].active = false;
        }
    }

    public void setstate(States states) {
        switch (states) {
            case WELCOME: {
                this.score = 0;
                this.lives = 3;
                this.fpsdelay = 200;
                break;
            }
            case OVER: {
                this.fpsdelay = 200;
                break;
            }
            case DONE: {
                this.fpsdelay = 200;
                break;
            }
            case READY: {
                this.startgame();
                this.fpsdelay = 200;
                break;
            }
            case GAME: {
                this.fpsdelay = 33;
            }
        }
        this.gamestate = states;
    }

    public void nextstate(States states) {
        switch (states) {
            case WELCOME: {
                this.level = 1;
                this.setstate(States.READY);
                break;
            }
            case OVER: {
                if (this.score > this.hiscore) {
                    this.prevscore = this.hiscore;
                    this.hiscore = this.score;
                }
                this.setstate(States.WELCOME);
                break;
            }
            case DONE: {
                if (this.score > this.hiscore) {
                    this.prevscore = this.hiscore;
                    this.hiscore = this.score;
                }
                this.setstate(States.WELCOME);
                break;
            }
            case READY: {
                this.setstate(States.GAME);
            }
        }
    }

    public void draw_bg(Graphics graphics) {
        for (int i = 0; i < 480; i += 32) {
            for (int j = 0; j < 672; j += 32) {
                graphics.drawImage(background, j, i, null);
            }
        }
    }

    public void addexplosion(int n, int n2) {
        for (int i = 0; i < explo.length; ++i) {
            if (Sense.explo[i].active) continue;
            explo[i].set(n + 12, n2 + 12);
            break;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        for (n = 0; n < line.length; ++n) {
            Sense.line[n] = "";
        }
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_bg(graphics);
                graphics.setFont(this.fs);
                graphics.setColor(Color.yellow);
                graphics.drawString("http://ssjx.co.uk", 520, 475);
                graphics.drawString("Version 3.1 (19/01/20)", 2, 475);
                Sense.line[0] = "Sensitive 2020";
                Sense.line[2] = "High Score";
                Sense.line[3] = Integer.toString(this.hiscore);
                Sense.line[4] = "Previous High Score";
                Sense.line[5] = Integer.toString(this.prevscore);
                Sense.line[7] = "The aim of the game is to remove all";
                Sense.line[8] = "of the tiles and reach the exit. Green";
                Sense.line[9] = "tiles need to be passed over twice.";
                Sense.line[11] = "Click to play!!";
                Sense.line[13] = "Based on the C64 PD game Sensitive by Oliver Kirwa";
                for (n = 0; n < line.length; ++n) {
                    switch (n) {
                        case 0: 
                        case 11: {
                            graphics.setFont(this.fm);
                            this.fmetric = graphics.getFontMetrics(this.fm);
                            break;
                        }
                        case 13: {
                            graphics.setFont(this.fb);
                            this.fmetric = graphics.getFontMetrics(this.fb);
                            break;
                        }
                        default: {
                            graphics.setFont(this.fb);
                            this.fmetric = graphics.getFontMetrics(this.fb);
                        }
                    }
                    graphics.setColor(Color.black);
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 50 + n * 30);
                    switch (n) {
                        case 0: 
                        case 11: {
                            graphics.setColor(Color.yellow);
                            break;
                        }
                        case 13: {
                            graphics.setColor(Color.white);
                            break;
                        }
                        default: {
                            graphics.setColor(Color.cyan);
                        }
                    }
                    graphics.drawString(line[n], (642 - this.fmetric.stringWidth(line[n])) / 2, 52 + n * 30);
                }
                break;
            }
            case OVER: {
                mymap.draw(graphics);
                graphics.drawImage(player, this.px * 32, this.py * 32, null);
                Sense.line[0] = "Game Over";
                Sense.line[1] = "Final Score : " + this.score;
                if (this.score > this.hiscore) {
                    Sense.line[3] = "A New High Score!";
                }
                Sense.line[4] = "";
                Sense.line[5] = "Space / Click to Continue!";
                graphics.setFont(this.fm);
                this.fmetric = graphics.getFontMetrics(this.fm);
                for (n = 0; n < 6; ++n) {
                    graphics.setColor(Color.black);
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2 + 2, 200 + n * 30 + 2);
                    graphics.setColor(Color.red);
                    if (n == 5) {
                        graphics.setColor(Color.cyan);
                    }
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 200 + n * 30);
                }
                break;
            }
            case DONE: {
                mymap.draw(graphics);
                graphics.drawImage(player, this.px * 32, this.py * 32, null);
                Sense.line[0] = "All Levels Completed!";
                Sense.line[1] = "Final Score : " + this.score;
                if (this.score > this.hiscore) {
                    Sense.line[3] = "A New High Score!";
                }
                Sense.line[4] = "";
                Sense.line[5] = "Space / Click to Continue";
                graphics.setFont(this.fm);
                this.fmetric = graphics.getFontMetrics(this.fm);
                for (n = 0; n < 4; ++n) {
                    graphics.setColor(Color.black);
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2 + 2, 200 + n * 30 + 2);
                    graphics.setColor(Color.green);
                    if (n == 5) {
                        graphics.setColor(Color.cyan);
                    }
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 200 + n * 30);
                }
                break;
            }
            case READY: {
                mymap.draw(graphics);
                graphics.drawImage(player, this.px * 32, this.py * 32, null);
                Sense.line[0] = "Level " + this.level;
                Sense.line[1] = "Get Ready!";
                Sense.line[2] = "";
                Sense.line[3] = "Space / Click to Start!";
                graphics.setFont(this.fm);
                this.fmetric = graphics.getFontMetrics(this.fm);
                for (n = 0; n < 4; ++n) {
                    graphics.setColor(Color.black);
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2 + 2, 200 + n * 30 + 2);
                    graphics.setColor(Color.yellow);
                    if (n == 3) {
                        graphics.setColor(Color.cyan);
                    }
                    graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 200 + n * 30);
                }
                break;
            }
            case GAME: {
                this.updatemap = 0;
                this.ox = this.px;
                this.oy = this.py;
                if (!this.moving) {
                    switch (this.move) {
                        case 6: {
                            this.xdir = 1;
                            break;
                        }
                        case 4: {
                            this.xdir = -1;
                            break;
                        }
                        case 8: {
                            this.ydir = -1;
                            break;
                        }
                        case 2: {
                            this.ydir = 1;
                        }
                    }
                }
                this.moving = false;
                if (this.xdir != 0 || this.ydir != 0) {
                    this.ofx += this.xdir * 4;
                    this.ofy += this.ydir * 4;
                    if (Math.abs(this.ofx) == 32) {
                        this.ofx = 0;
                        this.px += this.xdir;
                        this.xdir = 0;
                        this.updatemap = 1;
                    }
                    if (Math.abs(this.ofy) == 32) {
                        this.ofy = 0;
                        this.py += this.ydir;
                        this.ydir = 0;
                        this.updatemap = 1;
                    }
                    this.moving = true;
                }
                if (this.updatemap == 1) {
                    if (Sense.mymap.data[this.ox][this.oy] == 2) {
                        Sense.mymap.data[this.ox][this.oy] = 0;
                        this.addexplosion(this.ox * 32, this.oy * 32);
                    }
                    if (Sense.mymap.data[this.ox][this.oy] == 5) {
                        Sense.mymap.data[this.ox][this.oy] = 2;
                    }
                    if (Sense.mymap.data[this.px][this.py] == 0) {
                        --this.lives;
                        if (this.lives > 0) {
                            this.startgame();
                            this.setstate(States.READY);
                        } else {
                            this.setstate(States.OVER);
                        }
                    }
                    if (Sense.mymap.data[this.px][this.py] == 4 && mymap.cleared()) {
                        this.score += this.time;
                        if (this.level == 5) {
                            this.setstate(States.DONE);
                        } else {
                            ++this.level;
                            this.startgame();
                            this.setstate(States.READY);
                        }
                    }
                }
                mymap.draw(graphics);
                graphics.drawImage(player, this.px * 32 + this.ofx, this.py * 32 + this.ofy, null);
                for (n = 0; n < explo.length; ++n) {
                    explo[n].update();
                    explo[n].draw(graphics);
                }
                graphics.setColor(Color.yellow);
                graphics.setFont(this.fb);
                this.fmetric = graphics.getFontMetrics(this.fb);
                this.txt = "Level";
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, this.xpos, 15);
                this.txt = "Score";
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, 160 + this.xpos, 15);
                this.txt = "Time";
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, 320 + this.xpos, 15);
                this.txt = "Lives";
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, 480 + this.xpos, 15);
                graphics.setColor(Color.cyan);
                this.txt = Integer.toString(this.level);
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, this.xpos, 30);
                this.txt = Integer.toString(this.score);
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, 160 + this.xpos, 30);
                this.txt = Integer.toString(this.time);
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, 320 + this.xpos, 30);
                this.txt = Integer.toString(this.lives);
                this.xpos = (160 - this.fmetric.stringWidth(this.txt)) / 2;
                graphics.drawString(this.txt, 480 + this.xpos, 30);
                ++this.count;
                if (this.count != 30) break;
                --this.time;
                this.count = 0;
                if (this.time > 0) break;
                this.setstate(States.OVER);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.nextstate(this.gamestate);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.move = 6;
                break;
            }
            case 37: {
                this.move = 4;
                break;
            }
            case 38: {
                this.move = 8;
                break;
            }
            case 40: {
                this.move = 2;
                break;
            }
            case 32: {
                this.nextstate(this.gamestate);
                break;
            }
            case 80: {
                break;
            }
            case 27: 
            case 81: {
                if (this.gamestate == States.GAME) {
                    this.setstate(States.OVER);
                }
                if (this.gamestate != States.WELCOME) break;
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.move = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    static {
        explo = new Explosion[10];
        mymap = new Map();
    }

    public static enum States {
        WELCOME,
        READY,
        GAME,
        OVER,
        DONE;

    }
}

