/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Map {
    byte[][] data = new byte[40][40];
    int width;
    int height;
    int startx;
    int starty;
    private int bgx;
    private BufferedImage[] block = new BufferedImage[7];

    public Map() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        String[] stringArray = new String[]{"gfx/background.gif", "gfx/shadow.gif", "gfx/tile.gif", "gfx/solid.gif", "gfx/exit.gif", "gfx/tile2.gif"};
        try {
            int n = 0;
            for (String string : stringArray) {
                this.block[n] = graphicsConfiguration.createCompatibleImage(32, 32, 2);
                URL uRL = this.getClass().getResource(string);
                this.block[n] = ImageIO.read(uRL);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map sprites...");
        }
    }

    private void clear() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.data[j][i] = 0;
            }
        }
    }

    public boolean cleared() {
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < 20; ++j) {
                if (this.data[j][i] != 2 && this.data[j][i] != 5) continue;
                return false;
            }
        }
        return true;
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        for (n2 = 0; n2 < 480; n2 += 32) {
            for (n = 0; n < 672; n += 32) {
                graphics.drawImage(this.block[0], n - this.bgx, n2, null);
            }
        }
        ++this.bgx;
        if (this.bgx >= 32) {
            this.bgx = 0;
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                if (this.data[n][n2] <= 0) continue;
                graphics.drawImage(this.block[1], n * 32 + 16, n2 * 32 + 16, null);
            }
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                if (this.data[n][n2] <= 1) continue;
                graphics.drawImage(this.block[this.data[n][n2]], n * 32, n2 * 32, null);
            }
        }
    }

    public void load(int n) {
        this.clear();
        try {
            URL uRL = this.getClass().getResource("maps/level" + n + ".bmp");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n2 = bufferedImage.getRGB(j, i);
                    int n3 = n2 & 0xFF;
                    int n4 = (n2 & 0xFF00) >> 8;
                    int n5 = (n2 & 0xFF0000) >> 16;
                    if (n5 < 0) {
                        n5 += 256;
                    }
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    if (n5 == 0 && n4 == 255 && n3 == 0) {
                        this.data[j][i] = 2;
                    }
                    if (n5 == 0 && n4 == 0 && n3 == 255) {
                        this.data[j][i] = 3;
                    }
                    if (n5 == 255 && n4 == 0 && n3 == 0) {
                        this.data[j][i] = 4;
                    }
                    if (n5 == 255 && n4 == 128 && n3 == 0) {
                        this.data[j][i] = 5;
                    }
                    if (n5 != 255 || n4 != 0 || n3 != 255) continue;
                    this.data[j][i] = 3;
                    this.startx = j;
                    this.starty = i;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Load Map file error caught...");
        }
    }
}

