/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;

public class World {
    static String[] com = new String[]{"Land", "Sea", "Nuclear", "Moon", "Diplomat"};
    Country[] mycountry = new Country[15];
    Link mylink = new Link();
    private int highlight;
    Risk parent;

    public World(Risk risk) {
        for (int i = 0; i < this.mycountry.length; ++i) {
            this.mycountry[i] = new Country();
        }
        this.parent = risk;
    }

    public void clear() {
        for (int i = 0; i < this.mycountry.length; ++i) {
            this.mycountry[i].troops = 0;
            this.mycountry[i].owner = -1;
            this.mycountry[i].nuked = false;
        }
        this.mycountry[0].set("Yllow", 160, 90, 0, 0);
        this.mycountry[1].set("Amber", 100, 180, 0, 0);
        this.mycountry[2].set("Sande", 200, 180, 0, 0);
        this.mycountry[3].set("Gren", 320, 80, 1, 0);
        this.mycountry[4].set("Vert", 380, 135, 1, 0);
        this.mycountry[5].set("Gras", 340, 190, 1, 0);
        this.mycountry[6].set("Elub", 500, 80, 2, 0);
        this.mycountry[7].set("Yvan", 650, 70, 2, 0);
        this.mycountry[8].set("Syan", 500, 170, 2, 0);
        this.mycountry[9].set("Blue", 650, 170, 2, 0);
        this.mycountry[10].set("Magen", 300, 360, 3, 0);
        this.mycountry[11].set("Urple", 380, 360, 3, 0);
        this.mycountry[12].set("Cee", 620, 270, 4, 1);
        this.mycountry[13].set("Aquon", 560, 310, 4, 1);
        this.mycountry[14].set("Raiin", 480, 340, 4, 1);
        this.mylink.clear();
        this.mylink.add(12, 13);
        this.mylink.add(13, 14);
        this.mylink.add(9, 12);
        this.mylink.add(11, 14);
        this.mylink.add(0, 1);
        this.mylink.add(0, 2);
        this.mylink.add(1, 2);
        this.mylink.add(3, 4);
        this.mylink.add(3, 5);
        this.mylink.add(4, 5);
        this.mylink.add(0, 3);
        this.mylink.add(2, 5);
        this.mylink.add(5, 10);
        this.mylink.add(5, 11);
        this.mylink.add(6, 4);
        this.mylink.add(6, 7);
        this.mylink.add(6, 8);
        this.mylink.add(7, 9);
        this.mylink.add(8, 9);
        this.mylink.add(8, 5);
        this.mylink.add(8, 4);
        this.mylink.add(10, 11);
        this.mylink.add(8, 13);
        this.mylink.add(8, 14);
        this.nuke();
    }

    public void nuke() {
        for (int i = 0; i < 1; ++i) {
            int n = (int)(Math.random() * (double)this.mycountry.length);
            this.mycountry[n].nuked = true;
            this.mylink.remove(n);
        }
    }

    public void draw(Graphics graphics) {
        graphics.setColor(Color.yellow);
        for (int i = 0; i < this.mylink.size && this.mylink.a[i] != -1; ++i) {
            graphics.setColor(Color.yellow);
            if (this.mylink.a[i] == this.highlight || this.mylink.b[i] == this.highlight) {
                graphics.setColor(Color.cyan);
            }
            int n = this.mycountry[this.mylink.a[i]].x;
            int n2 = this.mycountry[this.mylink.a[i]].y;
            int n3 = this.mycountry[this.mylink.b[i]].x;
            int n4 = this.mycountry[this.mylink.b[i]].y;
            graphics.drawLine(n + 16, n2 + 16, n3 + 16, n4 + 16);
            graphics.setColor(Color.black);
            graphics.drawLine(1 + n + 16, 1 + n2 + 16, 1 + n3 + 16, 1 + n4 + 16);
        }
        if (this.highlight > -1) {
            graphics.setColor(Color.yellow);
            Country cfr_ignored_0 = this.mycountry[this.highlight];
            Country cfr_ignored_1 = this.mycountry[this.highlight];
            graphics.drawRect(this.mycountry[this.highlight].x - 2, this.mycountry[this.highlight].y - 2, 32 + 4, 32 + 4);
        }
        for (Country country : this.mycountry) {
            country.draw(graphics);
        }
    }

    public int mouse(int n, int n2) {
        this.highlight = -1;
        for (int i = 0; i < this.mycountry.length && this.mycountry[i].active != -1; ++i) {
            if (n <= this.mycountry[i].x) continue;
            Country cfr_ignored_0 = this.mycountry[i];
            if (n >= this.mycountry[i].x + 32 || n2 <= this.mycountry[i].y) continue;
            Country cfr_ignored_1 = this.mycountry[i];
            if (n2 >= this.mycountry[i].y + 32) continue;
            this.highlight = i;
        }
        return this.highlight;
    }

    public int owner() {
        int n = -1;
        if (this.highlight != -1) {
            n = this.mycountry[this.highlight].owner;
        }
        return n;
    }

    public boolean islinked(int n, int n2) {
        return this.mylink.islinked(n, n2);
    }

    public int addtroop(int n) {
        int n2 = 0;
        if (this.highlight != -1 && this.mycountry[this.highlight].owner == -1 && !this.mycountry[this.highlight].nuked) {
            ++this.mycountry[this.highlight].troops;
            this.mycountry[this.highlight].owner = n;
            n2 = 1;
            this.parent.gamelog_add("Army added to " + this.mycountry[this.highlight].name, n);
        }
        return n2;
    }

    public int moretroop(int n, int n2) {
        int n3 = 0;
        if (this.highlight != -1) {
            if (this.mycountry[this.highlight].owner == n) {
                this.mycountry[this.highlight].troops += n2;
                n3 = 1;
                this.parent.gamelog_add(n2 + " armies added to " + this.mycountry[this.highlight].name, n);
            }
            if (this.mycountry[this.highlight].owner == -1 && !this.mycountry[this.highlight].nuked) {
                boolean bl = false;
                for (int i = 0; i < this.mycountry.length; ++i) {
                    if (this.mycountry[i].owner != n || !this.mylink.islinked(this.highlight, i)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.mycountry[this.highlight].troops += n2;
                    this.mycountry[this.highlight].owner = n;
                    n3 = 1;
                    this.parent.gamelog_add(n2 + " armies added to " + this.mycountry[this.highlight].name + " [EN]", n);
                }
            }
        }
        return n3;
    }

    public int cpu_addtroop(int n) {
        int n2;
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < this.mycountry.length; ++n2) {
            if (this.mycountry[n2].nuked || this.mycountry[n2].troops != 0 || this.mycountry[n2].owner != -1) continue;
            arrayList.add(n2);
            ++n3;
        }
        n2 = 0;
        if (n3 > 0) {
            int n4 = (Integer)arrayList.get((int)(Math.random() * (double)n3));
            ++this.mycountry[n4].troops;
            this.mycountry[n4].owner = n;
            n2 = 1;
            this.parent.gamelog_add("[com] Army added to " + this.mycountry[n4].name, n);
        }
        return n2;
    }

    public int cpu_smarttroop(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            n4 = this.weakest(n);
            if (n4 != -1) {
                ++this.mycountry[n4].troops;
                this.mycountry[n4].owner = n;
                n3 = 1;
                this.parent.gamelog_add("[com] Army added to " + this.mycountry[n4].name + " (smart)", n);
                continue;
            }
            this.parent.gamelog_add("[com] Failed to add Army (smart error)", n);
        }
        return n3;
    }

    public int cpu_moretroop(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        Country[] objectArray = this.mycountry;
        int n5 = objectArray.length;
        for (int i = 0; i < n5; ++i) {
            Country country = objectArray[i];
            if (country.owner != n) continue;
            ++n4;
        }
        if (n4 > 0) {
            int[] nArray = new int[n4];
            n4 = 0;
            for (n5 = 0; n5 < this.mycountry.length; ++n5) {
                if (this.mycountry[n5].owner != n) continue;
                nArray[n4] = n5;
                ++n4;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                int n6 = nArray[(int)(Math.random() * (double)n4)];
                ++this.mycountry[n6].troops;
                this.parent.gamelog_add("[com] 1 troop added to " + this.mycountry[n6].name + " (more)", n);
            }
        }
        n3 = 1;
        return n3;
    }

    public int cpu_fixedtroop(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < this.mycountry.length; ++i) {
            if (this.mycountry[i].owner != n) continue;
            ++n5;
        }
        int[] nArray = new int[n5];
        n5 = 0;
        for (n3 = 0; n3 < this.mycountry.length; ++n3) {
            if (this.mycountry[n3].owner != n) continue;
            nArray[n5] = n3;
            ++n5;
        }
        n3 = nArray[(int)(Math.random() * (double)n5)];
        this.mycountry[n3].troops += n2;
        this.parent.gamelog_add("[com] " + n2 + " armies added to " + this.mycountry[n3].name + " (fixed)", n);
        n4 = 1;
        return n4;
    }

    public int cpu_attack(int n) {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = new int[this.mycountry.length];
        for (int i = 0; i < this.mycountry.length; ++i) {
            if (this.mycountry[i].owner != n || this.mycountry[i].troops <= 1) continue;
            for (int j = 0; j < this.mycountry.length; ++j) {
                if (this.mycountry[j].owner == n || this.mycountry[j].troops <= 0 || !this.islinked(i, j)) continue;
                int n2 = 0;
                do {
                    if (this.mycountry[i].troops >= this.mycountry[j].troops) {
                        if (this.mycountry[i].troops < 4) {
                            this.attack(i, j, this.mycountry[i].troops - 1);
                        } else {
                            this.attack(i, j, this.mycountry[i].troops);
                        }
                        if (this.mycountry[j].troops == 0) {
                            this.mycountry[j].owner = -1;
                            int n3 = this.mycountry[i].troops / 2;
                            if (n3 > 0) {
                                this.mycountry[i].troops -= n3;
                                this.mycountry[j].troops += n3;
                                this.mycountry[j].owner = n;
                                this.parent.gamelog_add("Com: " + n3 + " moved to conquered " + this.mycountry[j].name + " from " + this.mycountry[i].name, n);
                            } else {
                                this.parent.gamelog_add("Com: unable to moved to conquered " + this.mycountry[j].name + " from " + this.mycountry[i].name, n);
                            }
                            bl2 = true;
                        }
                    } else {
                        bl2 = true;
                    }
                    if (++n2 < 10) continue;
                    this.parent.gamelog_add("Com: Got stuck in attack loop!", n);
                    bl2 = true;
                } while (!bl2);
            }
        }
        return 0;
    }

    public int attack(int n, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray = new int[3];
        int[] nArray2 = new int[2];
        if (n3 > 3) {
            n3 = 3;
        }
        for (n5 = 0; n5 < nArray.length; ++n5) {
            nArray[n5] = 1 + (int)(Math.random() * 6.0);
        }
        Arrays.sort(nArray);
        n5 = nArray[0];
        nArray[0] = nArray[2];
        nArray[2] = n5;
        this.parent.gamelog_add(this.mycountry[n].name + " [" + this.mycountry[n].troops + "] attacking " + this.mycountry[n2].name + " [" + this.mycountry[n2].troops + "] with " + n3 + " troops", this.mycountry[n].owner);
        for (n4 = 0; n4 < nArray2.length; ++n4) {
            nArray2[n4] = 1 + (int)(Math.random() * 6.0);
        }
        if (nArray2[0] < nArray2[1]) {
            n5 = nArray2[0];
            nArray2[0] = nArray2[1];
            nArray2[1] = n5;
        }
        this.parent.gamelog_add("Dice A:" + nArray[0] + "-" + nArray[1] + "-" + nArray[2] + " D:" + nArray2[0] + "-" + nArray2[1], this.mycountry[n].owner);
        n4 = this.mycountry[n2].troops;
        if (n4 > 2) {
            n4 = 2;
        }
        if (n3 < n4) {
            n4 = n3;
        }
        for (int i = 0; i < n4; ++i) {
            if (nArray[i] > nArray2[i]) {
                --this.mycountry[n2].troops;
                this.parent.gamelog_add("Attacker wins! " + nArray[i] + ">" + nArray2[i], this.mycountry[n].owner);
                continue;
            }
            --this.mycountry[n].troops;
            this.parent.gamelog_add("Attacker loses! " + nArray[i] + "<=" + nArray2[i], this.mycountry[n].owner);
        }
        this.update();
        return 0;
    }

    public int empty() {
        int n = 0;
        for (int i = 0; i < this.mycountry.length; ++i) {
            if (this.mycountry[i].nuked || this.mycountry[i].troops != 0) continue;
            ++n;
        }
        return n;
    }

    public int target(int n) {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < this.mycountry.length; ++i) {
            if (this.mycountry[i].owner == n || this.mycountry[i].owner == -1) continue;
            for (int j = 0; j < this.mycountry.length; ++j) {
                if (this.mycountry[j].owner != n || !this.islinked(i, j)) continue;
                n2 += this.mycountry[j].troops;
                if (this.mycountry[j].troops - this.mycountry[i].troops <= 3) continue;
                n2 += 5;
            }
            if (n2 > n4) {
                n4 = n2;
                n3 = i;
            }
            n2 = 0;
        }
        return n3;
    }

    public int weakest(int n) {
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        for (int i = 0; i < this.mycountry.length; ++i) {
            if (this.mycountry[i].owner != n) continue;
            for (int j = 0; j < this.mycountry.length; ++j) {
                if (this.mycountry[j].owner == n || this.mycountry[j].owner == -1 || !this.islinked(i, j)) continue;
                n2 += this.mycountry[j].troops;
                if (this.mycountry[i].troops >= 3) continue;
                n2 += 10;
            }
            if (n2 > n4) {
                n4 = n2;
                n3 = i;
            }
            n2 = 0;
        }
        return n3;
    }

    public void update() {
        for (int i = 0; i < this.mycountry.length; ++i) {
            if (this.mycountry[i].nuked || this.mycountry[i].troops > 0) continue;
            this.mycountry[i].troops = 0;
            this.mycountry[i].owner = -1;
        }
    }

    public int count(int n) {
        int n2 = 0;
        for (Country country : this.mycountry) {
            if (country.owner != n) continue;
            ++n2;
        }
        return n2;
    }

    public int ccount(int n) {
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < 5; ++i) {
            bl = true;
            for (int j = 0; j < this.mycountry.length; ++j) {
                if (this.mycountry[j].nuked || this.mycountry[j].cont != i || this.mycountry[j].owner == n) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            ++n2;
        }
        return n2;
    }

    public int score(int n) {
        int n2 = 0;
        n2 += this.count(n);
        return n2 += this.ccount(n) * 2;
    }

    public int allocation(int n) {
        int n2 = 3;
        int n3 = this.score(n);
        if (n3 > 5) {
            n2 = 4;
        }
        if (n3 > 8) {
            n2 = 5;
        }
        if (n3 == 0) {
            n2 = 0;
        }
        return n2;
    }

    public int energy(int n) {
        int n2 = 3;
        int n3 = this.score(n);
        if (n3 > 7) {
            n2 = 4;
        }
        return n2;
    }
}

