/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class Risk
extends JFrame
implements ActionListener,
MouseListener,
MouseMotionListener {
    final int swidth = 800;
    final int sheight = 480;
    final boolean debug = false;
    static final String prog_name = "Planet Rysk";
    static final String prog_author = "ssjx";
    static final String prog_version = "v2.0a (06/04/2023)";
    static final String prog_url = "http://ssjx.co.uk";
    final int fps = 5;
    final int fpsdelay = 200;
    final int yearlimit = 3;
    String[] line = new String[15];
    int mx;
    int my;
    int players = 3;
    int year = 0;
    int player = 0;
    int stage;
    int turn = 0;
    int attacker;
    int defender;
    State gamestate = State.WELCOME;
    World myworld = new World(this);
    Player[] myplayer = new Player[4];
    Image background;
    Image titlebg;
    FontMetrics fmetric;
    final String[] stagename = new String[]{"0 > Mark countries in turn ", "1 > Add additional armies (x3) ", "2 > Game: Add armies ", "3 > Game: Attack ", "4 > Game: Redeploy armies "};
    final Font fs = new Font("Arial", 1, 14);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 1, 30);
    final Font font_title_big = new Font("Arial", 1, 30);
    final Font font_title_med = new Font("Arial", 1, 25);
    final Font infofont = new Font("Verdana", 0, 12);
    JMenuItem[] item = new JMenuItem[15];
    JPanel gridpanel = new JPanel();
    BufferedImage bimage;
    JLabel blabel;
    JLabel info_label;
    ImageIcon bicon;
    JButton done_button;
    JList<String> list;
    JScrollPane listScroller;
    DefaultListModel<String> data_log = new DefaultListModel();
    ArrayList<Integer> data_log_owner = new ArrayList();
    boolean nameset = false;
    String player_name = "Human";
    int logcounter = 0;

    /*
     * WARNING - void declaration
     */
    public Risk() {
        super(prog_name);
        String[] stringArray;
        void object3;
        this.setSize(800, 480);
        this.setDefaultCloseOperation(3);
        try {
            URL uRL = this.getClass().getResource("gfx/bg1-480.png");
            this.background = ImageIO.read(uRL);
            uRL = this.getClass().getResource("gfx/bg1bw-480.png");
            this.titlebg = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the background map...");
        }
        this.myworld.clear();
        for (int i = 0; i < this.myplayer.length; ++i) {
            this.myplayer[i] = new Player(i);
        }
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        String[] stringArray2 = new String[]{"New Game", "Abort Game", "", "Exit"};
        int n = 0;
        Object jMenu2 = stringArray2;
        int n2 = ((String[])jMenu2).length;
        boolean bl = false;
        while (object3 < n2) {
            String jPanel = jMenu2[object3];
            if (jPanel.equals("")) {
                jMenu.addSeparator();
            } else {
                this.item[n] = new JMenuItem(jPanel);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(jPanel);
                jMenu.add(this.item[n]);
                if (jPanel.equals("New Game")) {
                    this.item[n].setMnemonic(78);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(78, 2));
                }
                if (jPanel.equals("Exit")) {
                    this.item[n].setMnemonic(88);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(27, 0));
                }
                ++n;
            }
            ++object3;
        }
        jMenu2 = new JMenu("Help");
        ((AbstractButton)jMenu2).setMnemonic(72);
        for (String string : stringArray = new String[]{"Instructions", "Change Name", "", "About"}) {
            if (string.equals("")) {
                ((JMenu)jMenu2).addSeparator();
                continue;
            }
            this.item[n] = new JMenuItem(string);
            this.item[n].addActionListener(this);
            this.item[n].setActionCommand(string);
            ((JMenu)jMenu2).add(this.item[n]);
            if (string.equals("Instructions")) {
                this.item[n].setMnemonic(73);
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(73, 2));
            }
            if (string.equals("About")) {
                this.item[n].setMnemonic(88);
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(112, 0));
            }
            ++n;
        }
        jMenuBar.add(jMenu);
        jMenuBar.add((JMenu)jMenu2);
        this.setJMenuBar(jMenuBar);
        this.gridpanel = new JPanel();
        this.bimage = new BufferedImage(800, 480, 1);
        this.bicon = new ImageIcon(this.bimage);
        this.blabel = new JLabel(this.bicon);
        this.blabel.addMouseListener(this);
        this.gridpanel.add(this.blabel);
        this.add((Component)this.gridpanel, "Center");
        FlowLayout flowLayout = new FlowLayout(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        jPanel.setBackground(Color.WHITE);
        this.info_label = new JLabel("Welcome to Planet Rysk! Click on the help menu for instructions!");
        this.info_label.setFont(this.infofont);
        jPanel.add(this.info_label);
        this.done_button = new JButton("Done");
        this.done_button.addActionListener(this);
        this.done_button.setActionCommand("done");
        this.done_button.setEnabled(false);
        jPanel.add(this.done_button);
        this.add((Component)jPanel, "First");
        this.gamelog_add("Welcome", 0);
        this.list = new JList<String>(this.data_log);
        this.list.setSelectionMode(1);
        this.list.setVisibleRowCount(8);
        this.list.setBackground(Color.BLACK);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                try {
                    int n2 = Risk.this.data_log_owner.get(n);
                    if (n2 > -1) {
                        this.setForeground(Risk.this.myplayer[n2].col);
                    }
                }
                catch (Exception exception) {
                    System.out.println("Something went wrong in JList.");
                    System.out.println(exception);
                }
                return component;
            }
        });
        this.listScroller = new JScrollPane(this.list);
        this.add((Component)this.listScroller, "Last");
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Risk.this.update();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
        this.pack();
        this.setTitle("Planet Rysk v2.0a (06/04/2023) by ssjx (http://ssjx.co.uk)");
        this.setVisible(true);
        Intro intro = new Intro(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        switch (string = actionEvent.getActionCommand()) {
            case "New Game": {
                int n = JOptionPane.showConfirmDialog(this, "Are you sure?", "New Game", 0);
                if (n != 0) break;
                this.reset();
                this.gamestate = State.GAME;
                break;
            }
            case "Abort Game": {
                int n = JOptionPane.showConfirmDialog(this, "Are you sure?", "Abort Game", 0);
                if (n != 0) break;
                this.gamestate = State.WELCOME;
                break;
            }
            case "done": {
                if (!this.myplayer[this.turn].human || this.stage != 3) break;
                this.nextplayer();
                this.stage = 2;
                this.done_button.setEnabled(false);
                break;
            }
            case "Change Name": {
                String string2 = (String)JOptionPane.showInputDialog(this, "Please enter your name", "Player Name", 3, null, null, this.player_name);
                if (string2 == null || string2.length() <= 0) break;
                this.player_name = string2;
                this.nameset = true;
                break;
            }
            case "Instructions": {
                Help help = new Help(this);
                break;
            }
            case "About": {
                Intro intro = new Intro(this);
            }
        }
    }

    public void reset() {
        this.myworld.clear();
        for (int i = 0; i < this.myplayer.length; ++i) {
            this.myplayer[i].reset(i);
        }
        this.myplayer[0].human = true;
        this.myplayer[0].name = this.player_name;
        this.year = 0;
        this.stage = 0;
        this.logcounter = 0;
        this.data_log.clear();
        this.data_log_owner.clear();
    }

    public void setstate(State state) {
        switch (state) {
            case WELCOME: {
                if (!this.nameset) {
                    String string = (String)JOptionPane.showInputDialog(this, "Please enter your name", "Player Name", 3, null, null, this.player_name);
                    if (string != null && string.length() > 0) {
                        this.player_name = string;
                    }
                    this.nameset = true;
                }
                this.gamestate = State.GAME;
                this.reset();
                break;
            }
            case OVER: {
                this.gamestate = State.WELCOME;
                break;
            }
            case COMPLETED: {
                this.gamestate = State.WELCOME;
            }
        }
    }

    public void nextplayer() {
        ++this.turn;
        if (this.turn == this.players) {
            this.turn = 0;
            if (this.stage == 3) {
                if (this.year + 1 > 3) {
                    this.gamestate = State.COMPLETED;
                } else {
                    ++this.year;
                }
            }
        }
        this.myplayer[this.turn].troops = this.myworld.allocation(this.turn);
        if (this.stage == 3) {
            this.myplayer[this.turn].energy += this.myworld.energy(this.turn);
        }
    }

    public void update() {
        int n;
        BufferedImage bufferedImage = new BufferedImage(800, 480, 1);
        Graphics graphics = bufferedImage.getGraphics();
        if (this.gamestate == State.COMPLETED || this.gamestate == State.OVER) {
            graphics.drawImage(this.titlebg, 0, 0, null);
            this.info_label.setText("Year end");
            for (n = 0; n < this.players; ++n) {
                graphics.setColor(this.myplayer[n].col);
                graphics.setFont(this.fb);
                graphics.drawString(this.myplayer[n].name, 5 + n * 100, 16);
                graphics.setFont(this.fs);
                if (this.myworld.score(n) > 0) {
                    graphics.drawString("Energy: " + this.myplayer[n].energy, 5 + n * 100, 35);
                    graphics.drawString("Score: " + this.myworld.score(n), 5 + n * 100, 50);
                    continue;
                }
                if (this.stage <= 0) continue;
                graphics.drawString("Not in play.", 5 + n * 100, 35);
            }
            this.myworld.draw(graphics);
        }
        if (this.gamestate == State.GAME) {
            int n2;
            graphics.drawImage(this.background, 0, 0, null);
            if (!this.myplayer[this.turn].human) {
                switch (this.stage) {
                    case 0: {
                        this.myworld.cpu_addtroop(this.turn);
                        this.nextplayer();
                        break;
                    }
                    case 1: {
                        this.myworld.cpu_fixedtroop(this.turn, 3);
                        --this.myplayer[this.turn].stageone;
                        this.nextplayer();
                        break;
                    }
                    case 2: {
                        if (this.myplayer[this.turn].troops != 0) {
                            this.myworld.cpu_smarttroop(this.turn, this.myplayer[this.turn].troops);
                            this.myplayer[this.turn].troops = 0;
                            this.stage = 3;
                            break;
                        }
                        this.gamelog_add("[com] No longer in play..", this.turn);
                        break;
                    }
                    case 3: {
                        this.myworld.cpu_attack(this.turn);
                        if (this.myworld.score(0) == 0) {
                            this.gamestate = State.OVER;
                            break;
                        }
                        this.nextplayer();
                        this.stage = 2;
                        break;
                    }
                }
            }
            if (this.stage == 0 && this.myworld.empty() == 0) {
                this.stage = 1;
            }
            if (this.stage == 1) {
                n = 0;
                for (n2 = 0; n2 < this.players; ++n2) {
                    n += this.myplayer[n2].stageone;
                }
                if (n == 0) {
                    this.gamelog_add("*Stage 1 complete [" + n + "]", this.turn);
                    this.turn = 0;
                    this.myplayer[0].troops = this.myworld.allocation(0);
                    this.myplayer[0].energy += this.myworld.energy(0);
                    this.stage = 2;
                    this.year = 1;
                }
            }
            Object object = "";
            switch (this.stage) {
                case 1: {
                    object = "Stage " + this.stagename[this.stage] + " " + this.myplayer[this.turn].stageone;
                    break;
                }
                case 2: {
                    object = "Stage " + this.stagename[this.stage] + " - " + this.myplayer[this.turn].troops;
                    break;
                }
                case 3: {
                    object = "Stage " + this.stagename[this.stage];
                    if (this.attacker != -1) {
                        object = "Stage " + this.stagename[this.stage] + " Attacker : " + this.myworld.mycountry[this.attacker].name;
                    }
                    if (this.defender == -1) break;
                    object = "Stage " + this.stagename[this.stage] + " Defender : " + this.myworld.mycountry[this.defender].name;
                    break;
                }
                default: {
                    object = "Stage " + this.stagename[this.stage];
                }
            }
            this.info_label.setText("Year " + this.year + " > " + this.myplayer[this.turn].name + " > " + (String)object);
            for (n2 = 0; n2 < this.players; ++n2) {
                graphics.setColor(this.myplayer[n2].col);
                graphics.setFont(this.fb);
                if (this.turn == n2) {
                    graphics.drawString(">" + this.myplayer[n2].name + "<", 5 + n2 * 100, 16);
                } else {
                    graphics.drawString(this.myplayer[n2].name, 5 + n2 * 100, 16);
                }
                graphics.setFont(this.fs);
                if (this.myworld.score(n2) > 0) {
                    graphics.drawString("Energy: " + this.myplayer[n2].energy, 5 + n2 * 100, 35);
                    graphics.drawString("Score: " + this.myworld.score(n2), 5 + n2 * 100, 50);
                    continue;
                }
                if (this.stage <= 0) continue;
                graphics.drawString("Not in play.", 5 + n2 * 100, 35);
            }
            this.myworld.mouse(this.mx, this.my);
            this.myworld.draw(graphics);
        }
        if (this.gamestate != State.GAME) {
            Arrays.fill(this.line, "");
            switch (this.gamestate) {
                case WELCOME: {
                    graphics.setColor(Color.black);
                    graphics.drawImage(this.titlebg, 0, 0, null);
                    for (n = 0; n < this.myworld.mycountry.length; ++n) {
                        this.myworld.mycountry[n].label(graphics);
                    }
                    this.line[0] = prog_name;
                    this.line[2] = "Take control of one of Planet Rysk's armies and";
                    this.line[3] = "try to conquer the world!";
                    this.line[5] = "The game is 1 player against 2 computer";
                    this.line[6] = "opponents over 3 years";
                    this.line[8] = "Click to play!!";
                    for (n = 0; n < this.line.length; ++n) {
                        if (n == 0 || n == 8) {
                            graphics.setFont(this.font_title_big);
                            this.fmetric = graphics.getFontMetrics(this.font_title_big);
                            graphics.setColor(Color.black);
                            graphics.drawString(this.line[n], (802 - this.fmetric.stringWidth(this.line[n])) / 2, 122 + n * 30);
                            graphics.setColor(Color.red);
                        } else {
                            graphics.setFont(this.font_title_med);
                            this.fmetric = graphics.getFontMetrics(this.font_title_med);
                            graphics.setColor(Color.black);
                            graphics.drawString(this.line[n], (802 - this.fmetric.stringWidth(this.line[n])) / 2, 122 + n * 30);
                            graphics.setColor(Color.yellow);
                        }
                        graphics.drawString(this.line[n], (800 - this.fmetric.stringWidth(this.line[n])) / 2, 120 + n * 30);
                    }
                    break;
                }
                case OVER: {
                    this.line[0] = "Game Over - You have been defeated...";
                    graphics.setFont(this.font_title_med);
                    this.fmetric = graphics.getFontMetrics(this.font_title_med);
                    graphics.setColor(Color.black);
                    graphics.drawString(this.line[0], (800 - this.fmetric.stringWidth(this.line[0])) / 2 + 2, 462);
                    graphics.setColor(Color.RED);
                    graphics.drawString(this.line[0], (800 - this.fmetric.stringWidth(this.line[0])) / 2, 460);
                    break;
                }
                case COMPLETED: {
                    int n3;
                    this.line[0] = "Final Score";
                    n = 0;
                    Object object = "";
                    for (n3 = 0; n3 < this.players; ++n3) {
                        if (this.myworld.score(n3) <= n) continue;
                        n = this.myworld.score(n3);
                    }
                    n3 = 0;
                    for (int i = 0; i < this.players; ++i) {
                        if (this.myworld.score(i) != n) continue;
                        object = ++n3 == 1 ? (String)object + this.myplayer[i].name : (String)object + ", " + this.myplayer[i].name;
                    }
                    this.line[0] = n3 == 1 ? "The winner is " + (String)object + " with " + n + " points!" : "No clear winner! Draw between " + (String)object + " with " + n + " points";
                    graphics.setFont(this.font_title_med);
                    this.fmetric = graphics.getFontMetrics(this.font_title_med);
                    graphics.setColor(Color.black);
                    graphics.drawString(this.line[0], (800 - this.fmetric.stringWidth(this.line[0])) / 2 + 2, 462);
                    graphics.setColor(Color.GREEN);
                    if (n3 > 1) {
                        graphics.setColor(Color.YELLOW);
                    }
                    graphics.drawString(this.line[0], (800 - this.fmetric.stringWidth(this.line[0])) / 2, 460);
                }
            }
        }
        this.blabel.setIcon(new ImageIcon(bufferedImage));
        this.blabel.repaint();
        this.listScroller.repaint();
    }

    public void gamelog_add(String string, int n) {
        String string2 = this.logcounter + ". " + this.myplayer[n].name + ": " + string;
        this.data_log_owner.add(0, n);
        this.data_log.add(0, string2);
        ++this.logcounter;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setstate(this.gamestate);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.blabel) {
            this.mx = mouseEvent.getX();
            this.my = mouseEvent.getY();
        }
        if (this.gamestate == State.GAME) {
            int n = this.myworld.mouse(this.mx, this.my);
            switch (this.stage) {
                case 0: {
                    if (this.myworld.addtroop(this.turn) <= 0) break;
                    this.nextplayer();
                    break;
                }
                case 1: {
                    if (this.myworld.moretroop(this.turn, 3) <= 0) break;
                    --this.myplayer[this.turn].stageone;
                    this.nextplayer();
                    break;
                }
                case 2: {
                    if (this.myplayer[this.turn].troops <= 0 || this.myworld.moretroop(this.turn, 1) <= 0) break;
                    --this.myplayer[this.turn].troops;
                    if (this.myplayer[this.turn].troops != 0) break;
                    this.attacker = -1;
                    this.defender = -1;
                    this.stage = 3;
                    this.done_button.setEnabled(true);
                    break;
                }
                case 3: {
                    if (this.myworld.owner() == this.turn && this.myworld.mycountry[n].troops > 1) {
                        this.attacker = n;
                    }
                    if (this.myworld.owner() != this.turn && this.myworld.islinked(this.attacker, n)) {
                        this.defender = n;
                    }
                    if (this.attacker == -1 || this.defender == -1) break;
                    Object[] objectArray = new Object[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
                    int n2 = this.myworld.mycountry[this.attacker].troops;
                    if (n2 <= 3) {
                        --n2;
                    }
                    if (n2 > 3) {
                        n2 = 3;
                    }
                    Object[] objectArray2 = new Object[n2];
                    String string = (String)JOptionPane.showInputDialog(null, "How many armies do you want to attack with?", "Attacking", -1, null, objectArray2 = Arrays.copyOf(objectArray, objectArray2.length), "1");
                    if (string != null) {
                        this.myworld.attack(this.attacker, this.defender, Integer.parseInt(string));
                        if (this.myworld.mycountry[this.defender].troops == 0 && this.myworld.mycountry[this.attacker].troops > 1) {
                            this.gamelog_add(this.myworld.mycountry[this.defender].name + " is now empty", this.turn);
                            n2 = this.myworld.mycountry[this.attacker].troops - 1;
                            if (n2 > 10) {
                                n2 = 10;
                            }
                            Object[] objectArray3 = new Object[n2];
                            string = (String)JOptionPane.showInputDialog(null, "The area is now unoccupied!\nHow many armies do you want to move in?", "Moving", -1, null, objectArray3 = Arrays.copyOf(objectArray, objectArray3.length), "1");
                            if (string != null) {
                                this.myworld.mycountry[this.attacker].troops -= Integer.parseInt(string);
                                this.myworld.mycountry[this.defender].troops += Integer.parseInt(string);
                                this.myworld.mycountry[this.defender].owner = this.turn;
                                this.gamelog_add(Integer.parseInt(string) + " moved to conquered " + this.myworld.mycountry[this.defender].name + " from " + this.myworld.mycountry[this.attacker].name, this.player);
                            } else if (this.myworld.mycountry[this.attacker].troops > 1) {
                                this.gamelog_add("1 moved to conquered " + this.myworld.mycountry[this.defender].name + " from " + this.myworld.mycountry[this.attacker].name, this.player);
                                --this.myworld.mycountry[this.attacker].troops;
                                ++this.myworld.mycountry[this.defender].troops;
                                this.myworld.mycountry[this.defender].owner = this.turn;
                            }
                        }
                        string = null;
                    }
                    this.attacker = -1;
                    this.defender = -1;
                    break;
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static void main(String[] stringArray) {
        Risk risk = new Risk();
    }

    static enum State {
        WELCOME,
        OVER,
        COMPLETED,
        GAME;

    }
}

