/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;

public class Country {
    int owner;
    int station;
    int troops;
    int[] command = new int[6];
    boolean nuked;
    int cont;
    private int type;
    int active = -1;
    String name;
    int x;
    int y;
    static final int width = 32;
    static final int height = 32;
    static Color[] ccol = new Color[6];
    static final Font fs = new Font("Verdana", 1, 12);
    private static Image[] ownersprite = new Image[10];
    private static Image[] comsprite = new Image[10];
    private static boolean gfxloaded = false;

    public Country() {
        if (!gfxloaded) {
            gfxloaded = true;
            Country.ccol[0] = new Color(255, 0, 0);
            Country.ccol[1] = new Color(0, 255, 0);
            Country.ccol[2] = new Color(0, 0, 255);
            Country.ccol[3] = new Color(255, 0, 255);
            Country.ccol[4] = new Color(255, 255, 0);
            Country.ccol[5] = new Color(0, 255, 255);
            try {
                URL uRL = this.getClass().getResource("gfx/black.png");
                Country.ownersprite[0] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/blue.png");
                Country.ownersprite[1] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/green.png");
                Country.ownersprite[2] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/red.png");
                Country.ownersprite[3] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/nuke.png");
                Country.ownersprite[4] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/c_land.png");
                Country.comsprite[0] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/c_sea.png");
                Country.comsprite[1] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/c_nuclear.png");
                Country.comsprite[2] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/c_moon.png");
                Country.comsprite[3] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/c_diplomat.png");
                Country.comsprite[4] = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Country sprites...");
                System.out.println(exception);
            }
        }
    }

    public void set(String string, int n, int n2, int n3, int n4) {
        if (!string.equals("")) {
            this.name = string;
        }
        this.x = n;
        this.y = n2;
        this.cont = n3;
        this.type = n4;
        this.active = 1;
    }

    public void draw(Graphics graphics) {
        graphics.setFont(fs);
        FontMetrics fontMetrics = graphics.getFontMetrics(fs);
        switch (this.type) {
            case 0: {
                graphics.setColor(ccol[this.cont]);
                graphics.fillRect(this.x - 2, this.y - 2, 37, 37);
                graphics.setColor(Color.black);
                graphics.fillRect(this.x, this.y, 32, 32);
                graphics.setColor(Color.gray);
                graphics.drawRect(this.x, this.y, 32, 32);
                break;
            }
            case 1: {
                graphics.setColor(ccol[this.cont]);
                graphics.fillOval(this.x - 2, this.y - 2, 37, 37);
                graphics.setColor(Color.black);
                graphics.fillOval(this.x, this.y, 32, 32);
                graphics.setColor(Color.gray);
                graphics.drawOval(this.x, this.y, 32, 32);
            }
        }
        int n = this.x + 16 - fontMetrics.stringWidth(this.name) / 2;
        this.label(graphics);
        if (!this.nuked) {
            graphics.setColor(Color.white);
            if (this.owner > -1) {
                graphics.drawImage(ownersprite[this.owner], 8 + this.x, 8 + this.y, null);
                String string = "Armies:" + this.troops;
                int n2 = this.x + 16 - fontMetrics.stringWidth(string) / 2;
                int n3 = this.y + 44;
                graphics.setColor(Color.black);
                graphics.drawString(string, n2 - 1, n3);
                graphics.drawString(string, n2 + 1, n3);
                graphics.drawString(string, n2, n3 - 1);
                graphics.drawString(string, n2, n3 + 1);
                graphics.setColor(Color.white);
                graphics.drawString(string, n2, n3);
            } else {
                int n4 = this.x + 16 - fontMetrics.stringWidth("Empty") / 2;
                graphics.drawString("Empty", n4, this.y + 20);
            }
        } else {
            String string = "Wasteland";
            int n5 = this.x + 16 - fontMetrics.stringWidth(string) / 2;
            int n6 = this.y + 44;
            graphics.setColor(Color.red);
            graphics.drawString(string, n5 - 1, n6);
            graphics.drawString(string, n5 + 1, n6);
            graphics.drawString(string, n5, n6 - 1);
            graphics.drawString(string, n5, n6 + 1);
            graphics.setColor(Color.yellow);
            graphics.drawString(string, n5, n6);
            graphics.drawImage(ownersprite[4], this.x + 8, this.y + 8, null);
        }
    }

    public void label(Graphics graphics) {
        graphics.setFont(fs);
        FontMetrics fontMetrics = graphics.getFontMetrics(fs);
        int n = this.x + (32 - fontMetrics.stringWidth(this.name)) / 2;
        graphics.setColor(Color.gray);
        graphics.fillRect(n - 1, this.y + 5 - 11, fontMetrics.stringWidth(this.name) + 2, 12);
        graphics.setColor(Color.white);
        graphics.drawString(this.name, n, this.y + 5);
    }
}

