/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Tower
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final int swidth = 800;
    private static final int sheight = 600;
    private static final int fps = 30;
    private static int fpsdelay = 33;
    State gamestate = State.WELCOME;
    final int enemy_max = 8;
    int enemy_count = 1;
    int enemy_timer = 0;
    int current_map;
    final int mapw = 25;
    final int maph = 19;
    int[] map = new int[475];
    int[] basemap = new int[475];
    int mx;
    int my;
    Player player = new Player();
    int bonus;
    int hit = -1;
    int hitx = 0;
    int hity = 0;
    Enemy[] enemy = new Enemy[8];
    Weapon[] weapon = new Weapon[10];
    Rocket[] rocket = new Rocket[475];
    Turret[] turret = new Turret[475];
    Explosion explo = new Explosion();
    static Titles mytitles = new Titles();
    int fc = 0;
    int level = 0;
    ImageNumbers images = new ImageNumbers();
    Image[] sprite = new Image[20];
    final Color darkgreen = new Color(0, 100, 0);

    public Tower() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(800, 600));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        String[] stringArray = new String[]{"path", "grass", "tree", "flower", "highlight", "beam1", "beam2", "beam3", "slow1", "slow2", "slow3", "rocket1", "rocket2", "rocket3", "tank", "rocket", "life1"};
        int n = 0;
        for (String string : stringArray) {
            try {
                URL uRL = Tower.class.getClassLoader().getResource(string + ".gif");
                this.sprite[n] = ImageIO.read(uRL);
                ++n;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the sprite " + string);
                System.out.println(exception);
            }
        }
        int n2 = 0;
        for (n2 = 0; n2 < this.enemy.length; ++n2) {
            this.enemy[n2] = new Enemy();
        }
        for (n2 = 0; n2 < this.rocket.length; ++n2) {
            this.rocket[n2] = new Rocket();
        }
        for (n2 = 0; n2 < this.turret.length; ++n2) {
            this.turret[n2] = new Turret();
        }
        this.load_map_from_file(1);
        this.load_map(1);
        this.setstate(this.gamestate);
        this.weapon[0] = new Weapon("Beam Laser", 10, 4, 1, 5);
        this.weapon[1] = new Weapon("Slow Beam", 10, 4, 0, 8);
        this.weapon[2] = new Weapon("Homing Rocket", 20, 10, 50, 11);
        this.weapon[3] = new Weapon("Super Beam Laser", 50, 4, 5, 6);
        this.weapon[4] = new Weapon("Super Slow Beam", 50, 4, 5, 9);
        this.weapon[5] = new Weapon("Super Homing Rocket", 100, 10, 100, 12);
        this.weapon[6] = new Weapon("Mega Beam Laser", 100, 4, 20, 7);
        this.weapon[7] = new Weapon("Mega Slow Beam", 100, 4, 20, 10);
        this.weapon[8] = new Weapon("Mega Homing Rocket", 200, 10, 200, 13);
        this.weapon[9] = new Weapon("Extra Life", 10, 0, 0, 16);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Tower.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Robo Tanks Tower Defense II");
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Tower());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void reset() {
        this.player.money = 20;
        this.player.score = 0;
        this.player.lives = this.enemy.length;
        this.bonus = 0;
        this.level = 0;
        this.load_map(1);
        this.level_set();
        for (int i = 0; i < this.turret.length; ++i) {
            this.turret[i].a = -1;
        }
    }

    void level_set() {
        ++this.level;
        if (this.level > 1 && this.level < 6) {
            this.add_trees(5);
        }
        this.player.money += 10;
        this.player.score += this.bonus;
        this.fc = 0;
        this.bonus = 200;
        this.enemy_count = 0;
        this.enemy_start();
        this.weapon_reset();
        this.explo.reset();
    }

    void weapon_reset() {
        int n;
        for (n = 0; n < this.rocket.length; ++n) {
            this.rocket[n].a = 0;
        }
        for (n = 0; n < this.turret.length; ++n) {
            this.turret[n].target = -1;
        }
    }

    void setstate(State state) {
        switch (state) {
            case WELCOME: {
                if (Tower.mytitles.recent <= Tower.mytitles.highscore) break;
                Tower.mytitles.highscore = Tower.mytitles.recent;
                break;
            }
            case GAME: {
                this.reset();
                break;
            }
            case OVER: {
                Tower.mytitles.recent = this.player.score;
            }
        }
        this.gamestate = state;
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_map(graphics);
                mytitles.welcome(graphics);
                break;
            }
            case GAME: {
                this.enemy_update();
                this.tower_fire();
                this.draw_map(graphics);
                this.draw_enemy(graphics);
                this.draw_fire(graphics);
                this.draw_rocket(graphics);
                this.draw_menu(graphics);
                this.explo.draw(graphics);
                ++this.fc;
                if (this.fc <= 30) break;
                this.fc = 0;
                if (this.bonus <= 0) break;
                --this.bonus;
                break;
            }
            case OVER: {
                this.draw_map(graphics);
                this.draw_enemy(graphics);
                this.draw_fire(graphics);
                this.draw_rocket(graphics);
                this.draw_menu(graphics);
                mytitles.over(graphics);
            }
        }
    }

    public boolean load_map_from_file(int n) {
        boolean bl = false;
        Arrays.fill(this.basemap, 1);
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("maps/" + n + "a.bmp");
            byte[] byArray = inputStream.readAllBytes();
            inputStream.close();
            int n2 = byArray[10] + (byArray[11] << 8);
            int n3 = byArray[18] + (byArray[19] << 8);
            int n4 = byArray[22] + (byArray[23] << 8);
            int n5 = byArray[28] + (byArray[29] << 8);
            System.out.println("Level " + n3 + " x " + n4 + " x " + n5);
            if (n3 * n4 <= 475) {
                if (n5 == 8) {
                    int n6 = 0;
                    for (int i = n4 - 1; i > -1; --i) {
                        for (int j = 0; j < n3; ++j) {
                            this.basemap[i * n3 + j] = byArray[n2 + n6];
                            ++n6;
                        }
                        n6 += 3;
                    }
                    bl = true;
                } else {
                    System.out.println("Depth should be 8 not " + n5);
                }
            } else {
                System.out.println("Level is too big for map buffer!");
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map...");
        }
        return bl;
    }

    void load_map(int n) {
        Arrays.fill(this.map, 1);
        this.map = Arrays.copyOf(this.basemap, this.basemap.length);
        this.add_trees(10);
    }

    void add_trees(int n) {
        int n2 = 0;
        int n3 = 0;
        do {
            if (this.map[n2 = (int)Math.floor(Math.random() * 425.0)] != 1) continue;
            this.map[n2] = 4;
            ++n3;
        } while (n3 != n);
    }

    void enemy_start() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < 4; ++i) {
            n4 = 0;
            for (n2 = 0; n2 < 19; ++n2) {
                for (n = 0; n < 25; ++n) {
                    if (this.map[n4++] != 2) continue;
                    this.enemy[n3].a = 0;
                    this.enemy[n3].stx = n;
                    this.enemy[n3].sty = n2;
                    this.enemy[n3].x = n;
                    this.enemy[n3].y = n2;
                    this.enemy[n3].ofx = 0;
                    this.enemy[n3].ofy = 0;
                    this.enemy[n3].freeze = 0;
                    this.enemy[n3].maxpower = 100 + (this.level - 1) * 200;
                    this.enemy[n3].power = 100 + (this.level - 1) * 200;
                    this.enemy[n3].speed = 1;
                    if (this.enemy[n3].y == 0) {
                        this.enemy[n3].dir = 3;
                    }
                    if (this.enemy[n3].y == 14) {
                        this.enemy[n3].dir = 1;
                    }
                    if (this.enemy[n3].x == 0) {
                        this.enemy[n3].dir = 2;
                    }
                    if (this.enemy[n3].x == 19) {
                        this.enemy[n3].dir = 3;
                    }
                    ++n3;
                }
            }
            if (n3 > 8) break;
        }
    }

    int enemy_active() {
        int n = 0;
        for (Enemy enemy : this.enemy) {
            if (enemy.a != 1) continue;
            ++n;
        }
        return n;
    }

    void tower_fire() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        block0: for (n = 0; n < this.turret.length; ++n) {
            if (this.turret[n].charge > 0) {
                --this.turret[n].charge;
            }
            if (this.turret[n].a == -1 || this.turret[n].charge != 0) continue;
            n4 = this.weapon[this.turret[n].a].range * this.weapon[this.turret[n].a].range;
            if (this.turret[n].target == -1) {
                for (n2 = 0; n2 < this.enemy.length; ++n2) {
                    if (this.enemy[n2].a != 1 || (n3 = (n5 = this.enemy[n2].x - this.turret[n].x) * n5 + (n6 = this.enemy[n2].y - this.turret[n].y) * n6) >= n4) continue;
                    this.turret[n].target = n2;
                    if (this.turret[n].a != 2 && this.turret[n].a != 5 && this.turret[n].a != 8) continue block0;
                    this.rocket[n].a = 1;
                    this.rocket[n].x = (this.turret[n].x << 5) + 16;
                    this.rocket[n].y = (this.turret[n].y << 5) + 16;
                    this.rocket[n].dist = this.weapon[this.turret[n].a].range << 5;
                    continue block0;
                }
                continue;
            }
            n2 = this.turret[n].target;
            n5 = this.enemy[n2].x - this.turret[n].x;
            n6 = this.enemy[n2].y - this.turret[n].y;
            n3 = n5 * n5 + n6 * n6;
            if (n3 <= n4) continue;
            this.turret[n].target = -1;
            this.rocket[n].a = 0;
        }
    }

    void draw_rocket(Graphics graphics) {
        for (Rocket rocket : this.rocket) {
            if (rocket.a != 1) continue;
            graphics.drawImage(this.sprite[this.images.missile], rocket.x, rocket.y, null);
        }
    }

    void draw_fire(Graphics graphics) {
        block11: for (int i = 0; i < this.turret.length; ++i) {
            if (this.turret[i].a == -1 || this.turret[i].target == -1) continue;
            int n = (this.enemy[this.turret[i].target].x << 5) + this.enemy[this.turret[i].target].ofx + 16;
            int n2 = (this.enemy[this.turret[i].target].y << 5) + this.enemy[this.turret[i].target].ofy + 16;
            switch (this.turret[i].a) {
                case 0: {
                    graphics.setColor(Color.magenta);
                    graphics.drawLine((this.turret[i].x << 5) + 16, (this.turret[i].y << 5) + 16, n, n2);
                    this.enemy_damage(i);
                    continue block11;
                }
                case 1: {
                    graphics.setColor(Color.cyan);
                    graphics.drawLine((this.turret[i].x << 5) + 16, (this.turret[i].y << 5) + 16, n, n2);
                    this.enemy_damage(i);
                    this.enemy[this.turret[i].target].freeze = 50;
                    this.turret[i].charge = 100;
                    this.turret[i].target = -1;
                    continue block11;
                }
                case 2: {
                    if (this.rocket[i].a != 1) continue block11;
                    if (this.rocket[i].x < n) {
                        this.rocket[i].x += 3;
                    }
                    if (this.rocket[i].x > n) {
                        this.rocket[i].x -= 3;
                    }
                    if (this.rocket[i].y < n2) {
                        this.rocket[i].y += 3;
                    }
                    if (this.rocket[i].y > n2) {
                        this.rocket[i].y -= 3;
                    }
                    if (this.rocket[i].x <= n - 16 || this.rocket[i].x >= n + 16 || this.rocket[i].y <= n2 - 16 || this.rocket[i].y >= n2 + 16) continue block11;
                    this.rocket[i].a = 0;
                    this.enemy_damage(i);
                    this.turret[i].target = -1;
                    continue block11;
                }
                case 3: {
                    graphics.setColor(Color.magenta);
                    graphics.drawLine((this.turret[i].x << 5) + 16 + 4, (this.turret[i].y << 5) + 16, n, n2);
                    graphics.drawLine((this.turret[i].x << 5) + 16 - 4, (this.turret[i].y << 5) + 16, n, n2);
                    this.enemy_damage(i);
                    continue block11;
                }
                case 4: {
                    graphics.setColor(Color.cyan);
                    graphics.drawLine((this.turret[i].x << 5) + 16 - 4, (this.turret[i].y << 5) + 16, n, n2);
                    graphics.setColor(Color.magenta);
                    graphics.drawLine((this.turret[i].x << 5) + 16 + 4, (this.turret[i].y << 5) + 16, n, n2);
                    this.enemy[this.turret[i].target].freeze = 50;
                    this.enemy_damage(i);
                    this.turret[i].charge = 100;
                    this.turret[i].target = -1;
                    continue block11;
                }
                case 5: {
                    if (this.rocket[i].a != 1) continue block11;
                    if (this.rocket[i].x < n) {
                        this.rocket[i].x += 3;
                    }
                    if (this.rocket[i].x > n) {
                        this.rocket[i].x -= 3;
                    }
                    if (this.rocket[i].y < n2) {
                        this.rocket[i].y += 3;
                    }
                    if (this.rocket[i].y > n2) {
                        this.rocket[i].y -= 3;
                    }
                    if (this.rocket[i].x <= n - 16 || this.rocket[i].x >= n + 16 || this.rocket[i].y <= n2 - 16 || this.rocket[i].y >= n2 + 16) continue block11;
                    this.rocket[i].a = 0;
                    this.enemy_damage(i);
                    this.turret[i].target = -1;
                    continue block11;
                }
                case 6: {
                    graphics.setColor(Color.green);
                    graphics.drawLine((this.turret[i].x << 5) + 16 + 4, (this.turret[i].y << 5) + 16, n, n2);
                    graphics.drawLine((this.turret[i].x << 5) + 16 - 4, (this.turret[i].y << 5) + 16, n, n2);
                    graphics.drawLine((this.turret[i].x << 5) + 16, (this.turret[i].y << 5) + 16 + 4, n, n2);
                    graphics.drawLine((this.turret[i].x << 5) + 16, (this.turret[i].y << 5) + 16 - 4, n, n2);
                    this.enemy_damage(i);
                    continue block11;
                }
                case 7: {
                    graphics.setColor(Color.cyan);
                    graphics.drawLine((this.turret[i].x << 5) + 16, (this.turret[i].y << 5) + 16, n, n2);
                    this.enemy[this.turret[i].target].freeze = 50;
                    this.turret[i].charge = 100;
                    this.turret[i].target = -1;
                    continue block11;
                }
                case 8: {
                    if (this.rocket[i].a != 1) continue block11;
                    if (this.rocket[i].x < n) {
                        this.rocket[i].x += 3;
                    }
                    if (this.rocket[i].x > n) {
                        this.rocket[i].x -= 3;
                    }
                    if (this.rocket[i].y < n2) {
                        this.rocket[i].y += 3;
                    }
                    if (this.rocket[i].y > n2) {
                        this.rocket[i].y -= 3;
                    }
                    if (this.rocket[i].x <= n - 16 || this.rocket[i].x >= n + 16 || this.rocket[i].y <= n2 - 16 || this.rocket[i].y >= n2 + 16) continue block11;
                    this.rocket[i].a = 0;
                    this.enemy_damage(i);
                    this.turret[i].target = -1;
                }
            }
        }
    }

    void enemy_damage(int n) {
        this.enemy[this.turret[n].target].power -= this.weapon[this.turret[n].a].power;
        if (this.enemy[this.turret[n].target].power <= 0) {
            this.enemy[this.turret[n].target].a = 0;
            int n2 = (this.enemy[this.turret[n].target].x << 5) + this.enemy[this.turret[n].target].ofx;
            int n3 = (this.enemy[this.turret[n].target].y << 5) + this.enemy[this.turret[n].target].ofy;
            this.explo.add(n2, n3);
            this.enemy_remove(this.turret[n].target);
            this.player.money += 5;
            if (this.enemy_active() == 0) {
                this.level_set();
            }
        }
    }

    void enemy_remove(int n) {
        for (int i = 0; i < this.turret.length; ++i) {
            if (this.turret[i].target != n) continue;
            this.turret[i].target = -1;
        }
    }

    void draw_map(Graphics graphics) {
        int n = 0;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 800, 600);
        for (int i = 0; i < 19; ++i) {
            int n2 = i << 5;
            for (int j = 0; j < 25; ++j) {
                switch (this.map[n]) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 8: 
                    case 9: {
                        graphics.drawImage(this.sprite[this.images.path], j << 5, n2, null);
                        break;
                    }
                    case 1: {
                        graphics.drawImage(this.sprite[this.images.block], j << 5, n2, null);
                        break;
                    }
                    case 4: {
                        graphics.drawImage(this.sprite[this.images.tree], j << 5, n2, null);
                        break;
                    }
                    case 10: {
                        graphics.drawImage(this.sprite[this.images.beam], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 11: {
                        graphics.drawImage(this.sprite[this.images.slow], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 12: {
                        graphics.drawImage(this.sprite[this.images.rocket], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 13: {
                        graphics.drawImage(this.sprite[this.images.beam2], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 14: {
                        graphics.drawImage(this.sprite[this.images.slow2], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 15: {
                        graphics.drawImage(this.sprite[this.images.rocket2], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 16: {
                        graphics.drawImage(this.sprite[this.images.beam3], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 17: {
                        graphics.drawImage(this.sprite[this.images.slow3], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                        break;
                    }
                    case 18: {
                        graphics.drawImage(this.sprite[this.images.rocket3], j << 5, n2, (j << 5) + 32, n2 + 32, 0, 0, 32, 32, null);
                    }
                }
                if (this.hit == n) {
                    graphics.drawImage(this.sprite[this.images.highlight], j << 5, n2, null);
                }
                ++n;
            }
        }
    }

    void draw_enemy(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        graphics.setColor(Color.red);
        for (Enemy enemy : this.enemy) {
            if (enemy.a != 1) continue;
            n = (enemy.x << 5) + enemy.ofx;
            n2 = (enemy.y << 5) + enemy.ofy;
            graphics.drawImage(this.sprite[this.images.tank], n, n2, n + 32, n2 + 32, (enemy.dir << 5) - 32, 0, (enemy.dir << 5) - 32 + 32, 32, null);
            n3 = enemy.power * 32 / enemy.maxpower;
            graphics.drawLine(n, n2 + 32 - 1, n + n3, n2 + 32 - 1);
        }
    }

    void enemy_update() {
        if (this.enemy_count < 8) {
            ++this.enemy_timer;
            if (this.enemy_timer == 16) {
                this.enemy[this.enemy_count].a = 1;
                ++this.enemy_count;
                this.enemy_timer = 0;
            }
        }
        for (int i = 0; i < this.enemy_count; ++i) {
            if (this.enemy[i].a != 1) continue;
            if (this.enemy[i].freeze == 0) {
                switch (this.enemy[i].dir) {
                    case 1: {
                        this.enemy[i].ofy -= 2;
                        if (this.enemy[i].ofy != -32) break;
                        --this.enemy[i].y;
                        this.enemy[i].ofy = 0;
                        break;
                    }
                    case 2: {
                        this.enemy[i].ofx += 2;
                        if (this.enemy[i].ofx != 32) break;
                        ++this.enemy[i].x;
                        this.enemy[i].ofx = 0;
                        break;
                    }
                    case 3: {
                        this.enemy[i].ofy += 2;
                        if (this.enemy[i].ofy != 32) break;
                        ++this.enemy[i].y;
                        this.enemy[i].ofy = 0;
                        break;
                    }
                    case 4: {
                        this.enemy[i].ofx -= 2;
                        if (this.enemy[i].ofx != -32) break;
                        --this.enemy[i].x;
                        this.enemy[i].ofx = 0;
                    }
                }
                if (this.enemy[i].ofx != 0 || this.enemy[i].ofy != 0) continue;
                int n = this.enemy[i].y * 25 + this.enemy[i].x;
                if (this.map[n] == 8) {
                    --this.enemy[i].dir;
                }
                if (this.map[n] == 9) {
                    ++this.enemy[i].dir;
                }
                if (this.map[n] != 3) continue;
                this.enemy[i].a = 0;
                --this.player.lives;
                if (this.player.lives == 0) {
                    this.setstate(State.OVER);
                    continue;
                }
                if (this.enemy_active() != 0) continue;
                this.level_set();
                continue;
            }
            --this.enemy[i].freeze;
        }
    }

    void draw_menu(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 536, 800, 64);
        graphics.setColor(this.darkgreen);
        graphics.fillRect(0, 536, 800, 16);
        graphics.setColor(Color.yellow);
        graphics.drawString("Level: " + this.level, 8, 550);
        graphics.drawString("Credits: " + this.player.money, 100, 550);
        graphics.drawString("Lives: " + this.player.lives, 200, 550);
        graphics.drawString("Score: " + this.player.score, 300, 550);
        graphics.drawString("Bonus: " + this.bonus, 400, 550);
        graphics.drawString("Weapon: " + this.weapon[this.player.weapon].name, 8, 566);
        graphics.drawString("Cost: " + this.weapon[this.player.weapon].cost, 200, 566);
        graphics.drawString("Range: " + this.weapon[this.player.weapon].range, 300, 566);
        for (int i = 0; i < this.weapon.length; ++i) {
            if (this.player.money >= this.weapon[i].cost) {
                graphics.drawImage(this.sprite[this.weapon[i].gfx], i * 32, 568, i * 32 + 32, 600, 0, 0, 32, 32, null);
                if (this.player.weapon != i) continue;
                graphics.drawImage(this.sprite[this.images.highlight], i * 32, 568, null);
                continue;
            }
            graphics.drawImage(this.sprite[this.weapon[i].gfx], i * 32, 568, i * 32 + 32, 600, 32, 0, 64, 32, null);
        }
    }

    int over_block(int n, int n2) {
        if (this.mx > n && this.mx < n + 32 && this.my > n2 && this.my < n2 + 32) {
            return 1;
        }
        return -1;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        switch (this.gamestate) {
            case WELCOME: {
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (this.my < 536) {
                    if (this.hit == -1) break;
                    if (this.map[this.hit] == 1) {
                        if (this.player.money < this.weapon[this.player.weapon].cost) break;
                        this.map[this.hit] = this.player.weapon + 10;
                        this.player.money -= this.weapon[this.player.weapon].cost;
                        this.turret[this.hit].a = this.player.weapon;
                        this.turret[this.hit].x = this.hitx;
                        this.turret[this.hit].y = this.hity;
                        break;
                    }
                    if (this.map[this.hit] < 10) break;
                    this.player.money += this.weapon[this.turret[this.hit].a].cost / 2;
                    this.turret[this.hit].a = -1;
                    this.rocket[this.hit].a = -1;
                    this.map[this.hit] = 1;
                    break;
                }
                for (int i = 0; i < this.weapon.length; ++i) {
                    if (this.over_block(i * 32, 568) != 1) continue;
                    if (i == 9) {
                        if (this.player.money < this.weapon[i].cost) continue;
                        ++this.player.lives;
                        this.player.money -= this.weapon[this.player.weapon].cost;
                        continue;
                    }
                    this.player.weapon = i;
                }
                break;
            }
            case OVER: {
                this.setstate(State.WELCOME);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.mx = mouseEvent.getX();
        this.my = mouseEvent.getY();
        switch (this.gamestate) {
            case GAME: {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                this.hit = -1;
                for (int i = 0; i < 19; ++i) {
                    n2 = i * 32;
                    for (int j = 0; j < 25; ++j) {
                        n = j * 32;
                        if (this.mx > n && this.mx < n + 32 && this.my > n2 && this.my < n2 + 32 && this.map[n3] != 0) {
                            this.hit = n3;
                            this.hitx = j;
                            this.hity = i;
                        }
                        ++n3;
                    }
                }
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case READY: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != 'q') break;
                this.setstate(State.OVER);
                break;
            }
            case OVER: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
                break;
            }
            case COMPLETE: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    private static enum State {
        WELCOME,
        READY,
        GAME,
        OVER,
        COMPLETE;

    }
}

