/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

class Titles {
    static final String title = "Robo Tanks Tower Defense II";
    private static final String url = "http://ssjx.co.uk";
    private static final String version = "v0.2 (05/12/20)";
    private final int swidth = 800;
    private final int sheight = 600;
    private final Font smlFont = new Font("Arial", 0, 14);
    private final Font medFont = new Font("Arial", 0, 16);
    private final Font bigFont = new Font("Arial", 0, 20);
    private FontMetrics fmetric;
    int recent = 0;
    int highscore = 5;
    private final String[] welcome_words = new String[]{"Robo Tanks Tower Defense II", "", "Stop the robot tanks from invading!", "Place the weapons towers to stop them!", "", "Select a tower from the bottom of the screen.", "Sell towers on the map by clicking on them.", "", "Click to Start!"};

    public void welcome(Graphics graphics) {
        this.dim_screen(graphics);
        graphics.setColor(Color.black);
        graphics.fillRect(120, 120, 560, 360);
        graphics.setColor(Color.red);
        graphics.drawRect(120, 120, 560, 360);
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        int n = 0;
        int n2 = 0;
        int n3 = 600 - (this.welcome_words.length - 1) * 32 >> 1;
        for (String string : this.welcome_words) {
            n = 800 - this.fmetric.stringWidth(string) >> 1;
            if (n2 == 8 || n2 == 0) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.drawString(string, n, n3 + n2 * 32);
            ++n2;
        }
        String string = "High Score";
        n = 100 - this.fmetric.stringWidth(string) >> 1;
        graphics.setColor(Color.yellow);
        graphics.drawString(string, n, 22);
        String string2 = Integer.toString(this.highscore);
        n = 100 - this.fmetric.stringWidth(string2) >> 1;
        graphics.setColor(Color.white);
        graphics.drawString(string2, n, 44);
        this.footer(graphics);
    }

    private void footer(Graphics graphics) {
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.yellow);
        graphics.drawString(url, 690, 598);
        graphics.drawString(version, 2, 598);
    }

    private void dim_screen(Graphics graphics) {
        graphics.setColor(new Color(0, 0, 0, 150));
        graphics.fillRect(0, 0, 800, 600);
    }

    private void bar(Graphics graphics, int n) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 252, 800, 96);
        switch (n) {
            case 0: {
                graphics.setColor(Color.yellow);
                break;
            }
            case 1: {
                graphics.setColor(Color.red);
                break;
            }
            case 2: {
                graphics.setColor(Color.cyan);
                break;
            }
            case 3: {
                graphics.setColor(Color.green);
            }
        }
        graphics.drawLine(0, 252, 800, 252);
        graphics.drawLine(0, 348, 800, 348);
    }

    public void over(Graphics graphics) {
        this.dim_screen(graphics);
        this.bar(graphics, 1);
        graphics.setColor(Color.red);
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        Object object = "Too many tanks got through...";
        graphics.drawString((String)object, (800 - this.fmetric.stringWidth((String)object)) / 2, 284);
        if (this.recent > this.highscore) {
            graphics.setColor(Color.orange);
            object = "New High Score : " + String.valueOf(this.recent);
        } else {
            object = "Final Score : " + String.valueOf(this.recent);
        }
        graphics.drawString((String)object, (800 - this.fmetric.stringWidth((String)object)) / 2, 332);
    }
}

