/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Rescue
extends JPanel
implements KeyListener {
    private static final String title = "Invaders : Drone Rescue";
    private static final String url = "http://ssjx.co.uk";
    private static final String version = "v0.1 (21/11/20)";
    private static final int swidth = 640;
    private static final int sheight = 480;
    private static final int fps = 30;
    private static int fpsdelay = 33;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    static Image[] images = new Image[20];
    Random rand = new Random();
    State gamestate = State.WELCOME;
    XY[] drone = new XY[12];
    XY[] shot = new XY[30];
    XY[] fireball = new XY[30];
    XY[] explo = new XY[30];
    Rectangle drone_rect = new Rectangle(16, 16);
    Rectangle player_rect = new Rectangle(32, 16);
    Rectangle shot_rect = new Rectangle(2, 12);
    Rectangle fireball_rect = new Rectangle(16, 16);
    int dronecount = 0;
    int level = 0;
    int bonus = 0;
    boolean tower = false;
    int mindrone = 0;
    int totaldrone = 0;
    String levelname = "No Name..";
    XY player = new XY();
    XY pshot = new XY();
    XY warp = new XY();
    XY paddle = new XY();
    int fc = 0;
    int recent = 0;
    int hiscore = 10;
    Clip[] clip = new Clip[3];
    AudioInputStream[] ais = new AudioInputStream[3];
    private final Font medFont = new Font("Arial", 0, 18);
    private final Font bigFont = new Font("Arial", 0, 20);
    private FontMetrics fmetric;

    public Rescue() {
        int n;
        URL uRL;
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        try {
            String[] stringArray = new String[]{"background2", "saucer", "drone", "shot2", "paddle", "warp", "streamer", "tower", "square", "explosion"};
            int n2 = 0;
            for (String string : stringArray) {
                uRL = Rescue.class.getClassLoader().getResource(string + ".gif");
                Rescue.images[n2] = ImageIO.read(uRL);
                ++n2;
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the sprites");
            System.out.println(exception);
        }
        try {
            for (int i = 0; i < this.clip.length; ++i) {
                uRL = Rescue.class.getClassLoader().getResource("wav/" + String.valueOf(i) + ".wav");
                this.ais[i] = AudioSystem.getAudioInputStream(uRL);
                this.clip[i] = AudioSystem.getClip();
                this.clip[i].open(this.ais[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the sounds");
            System.out.println(exception);
        }
        for (n = 0; n < this.drone.length; ++n) {
            this.drone[n] = new XY();
        }
        for (n = 0; n < this.shot.length; ++n) {
            this.shot[n] = new XY();
        }
        for (n = 0; n < this.fireball.length; ++n) {
            this.fireball[n] = new XY();
        }
        for (n = 0; n < this.explo.length; ++n) {
            this.explo[n] = new XY();
        }
        this.reset();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Rescue.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Rescue());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void reset() {
        this.level = 1;
        this.player.lives = 5;
        this.player.score = 0;
    }

    void setstate(State state) {
        switch (state) {
            case WELCOME: {
                if (this.player.score > this.hiscore) {
                    this.hiscore = this.player.score;
                }
                this.recent = this.player.score;
                break;
            }
            case READY: {
                if (this.gamestate == State.WELCOME) {
                    this.reset();
                }
                this.level_set(this.level);
                break;
            }
            case DONE: {
                this.player.score += this.bonus;
            }
        }
        this.gamestate = state;
    }

    void nextstate() {
        switch (this.gamestate) {
            case WELCOME: {
                this.setstate(State.READY);
                break;
            }
            case READY: {
                this.setstate(State.GAME);
                break;
            }
            case DONE: {
                ++this.level;
                if (this.level <= 5) {
                    this.setstate(State.READY);
                    break;
                }
                this.setstate(State.COMPLETE);
                break;
            }
            case OVER: 
            case COMPLETE: {
                this.setstate(State.WELCOME);
            }
        }
    }

    void level_set(int n) {
        this.levelname = "No name..";
        this.tower = false;
        this.bonus = 100;
        this.player.x = 304;
        this.player.y = 232;
        this.player.saved = 0;
        this.player.carry = -1;
        this.player.speed = 2;
        this.warp.x = 50 + this.rand.nextInt(540);
        this.warp.y = 50 + this.rand.nextInt(200);
        this.paddle.active = false;
        this.paddle.x = 304;
        this.paddle.y = 392;
        this.paddle.xdir = 4;
        this.left = false;
        this.right = false;
        this.up = false;
        this.down = false;
        int n2 = 0;
        for (n2 = 0; n2 < this.drone.length; ++n2) {
            this.drone[n2].active = false;
        }
        for (n2 = 0; n2 < this.shot.length; ++n2) {
            this.shot[n2].active = false;
        }
        for (n2 = 0; n2 < this.fireball.length; ++n2) {
            this.fireball[n2].active = false;
        }
        for (n2 = 0; n2 < this.explo.length; ++n2) {
            this.explo[n2].active = false;
        }
        int n3 = 0;
        switch (n) {
            case 1: {
                this.paddle.active = true;
                this.mindrone = 4;
                this.totaldrone = 5;
                n3 = (640 - 16 * this.totaldrone - 16 * (this.totaldrone - 1)) / 2;
                for (n2 = 0; n2 < this.totaldrone; ++n2) {
                    this.drone[n2].active = true;
                    this.drone[n2].x = n3 + n2 * 32;
                    this.drone[n2].y = 424;
                }
                this.levelname = "A Simple Recovery";
                break;
            }
            case 2: {
                this.mindrone = 6;
                this.totaldrone = 8;
                this.tower = true;
                n3 = 100;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.drone[n2].active = true;
                    this.drone[n2].x = n3 + n2 * 32;
                    this.drone[n2].y = 424;
                }
                n3 = 428;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.drone[n2 + 4].active = true;
                    this.drone[n2 + 4].x = n3 + n2 * 32;
                    this.drone[n2 + 4].y = 424;
                }
                this.levelname = "Earth's New Weapon!";
                break;
            }
            case 3: {
                this.mindrone = 8;
                this.totaldrone = 10;
                this.tower = true;
                this.paddle.active = true;
                n3 = 100;
                for (n2 = 0; n2 < 5; ++n2) {
                    this.drone[n2].active = true;
                    this.drone[n2].x = n3 + n2 * 32;
                    this.drone[n2].y = 424;
                }
                n3 = 396;
                for (n2 = 0; n2 < 5; ++n2) {
                    this.drone[n2 + 5].active = true;
                    this.drone[n2 + 5].x = n3 + n2 * 32;
                    this.drone[n2 + 5].y = 424;
                }
                this.levelname = "Double Trouble!";
                break;
            }
            case 4: {
                this.mindrone = 8;
                this.totaldrone = 10;
                this.tower = true;
                this.paddle.active = true;
                n3 = 100;
                for (n2 = 0; n2 < 5; ++n2) {
                    this.drone[n2].active = true;
                    this.drone[n2].x = n3 + n2 * 32;
                    this.drone[n2].y = 424;
                }
                n3 = 396;
                for (n2 = 0; n2 < 5; ++n2) {
                    this.drone[n2 + 5].active = true;
                    this.drone[n2 + 5].x = n3 + n2 * 32;
                    this.drone[n2 + 5].y = 424;
                }
                this.levelname = "Engine Malfunction!";
                break;
            }
            case 5: {
                this.mindrone = 12;
                this.totaldrone = 12;
                this.tower = true;
                this.paddle.active = true;
                n3 = 100;
                for (n2 = 0; n2 < 6; ++n2) {
                    this.drone[n2].active = true;
                    this.drone[n2].x = n3 + n2 * 32;
                    this.drone[n2].y = 424;
                }
                n3 = 364;
                for (n2 = 0; n2 < 6; ++n2) {
                    this.drone[n2 + 6].active = true;
                    this.drone[n2 + 6].x = n3 + n2 * 32;
                    this.drone[n2 + 6].y = 424;
                }
                this.levelname = "Save Everything!";
            }
        }
        for (n2 = 0; n2 < this.drone.length; ++n2) {
            if (!this.drone[n2].active) continue;
            this.drone[n2].sx = this.drone[n2].x;
            this.drone[n2].sy = this.drone[n2].y;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_bg(graphics);
                this.draw_title(graphics);
                this.draw_footer(graphics);
                break;
            }
            case READY: {
                this.draw_bg(graphics);
                this.draw_ready(graphics);
                break;
            }
            case GAME: {
                this.draw_bg(graphics);
                this.draw_game(graphics);
                this.drone_update();
                this.explo_update();
                ++this.fc;
                if (this.fc > 25) {
                    this.fc = 0;
                    ++this.warp.alt;
                    if (this.warp.alt == 4) {
                        this.warp.alt = 0;
                    }
                    if (this.bonus > 0) {
                        --this.bonus;
                    }
                }
                if (this.paddle.active) {
                    this.shots_draw(graphics);
                    this.shots_update();
                    this.paddle.x += this.paddle.xdir;
                    if (this.paddle.x <= 0 || this.paddle.x >= 608) {
                        this.paddle.xdir *= -1;
                    }
                    if (this.rand.nextInt(100) > 92) {
                        this.shot_add(this.paddle.x, this.paddle.y);
                    }
                }
                if (this.tower) {
                    this.fireball_draw(graphics);
                    this.fireball_move();
                    if (this.rand.nextInt(100) > 93) {
                        this.fireball_add(this.player.x, this.player.y);
                    }
                }
                this.explo_draw(graphics);
                break;
            }
            case DONE: {
                this.draw_bg(graphics);
                this.draw_done(graphics);
                break;
            }
            case OVER: {
                this.draw_bg(graphics);
                this.draw_over(graphics);
                break;
            }
            case COMPLETE: {
                this.draw_bg(graphics);
                this.draw_completed(graphics);
            }
        }
    }

    void explo_add(int n, int n2) {
        for (int i = 0; i < this.explo.length; ++i) {
            if (this.explo[i].active) continue;
            this.explo[i].active = true;
            this.explo[i].x = n;
            this.explo[i].y = n2;
            this.explo[i].dist = 0;
            try {
                this.clip[2].setFramePosition(0);
                this.clip[2].start();
            }
            catch (Exception exception) {
                System.out.println("Problem playing the sound 2");
                System.out.println(exception);
            }
            return;
        }
    }

    void explo_update() {
        for (int i = 0; i < this.explo.length; ++i) {
            if (!this.explo[i].active) continue;
            this.explo[i].dist += 2;
            if (this.explo[i].dist < 30) continue;
            this.explo[i].active = false;
        }
    }

    void explo_draw(Graphics graphics) {
        for (int i = 0; i < this.explo.length; ++i) {
            if (!this.explo[i].active) continue;
            graphics.drawImage(images[9], this.explo[i].x + this.explo[i].dist, this.explo[i].y, null);
            graphics.drawImage(images[9], this.explo[i].x - this.explo[i].dist, this.explo[i].y, null);
            graphics.drawImage(images[9], this.explo[i].x, this.explo[i].y + this.explo[i].dist, null);
            graphics.drawImage(images[9], this.explo[i].x, this.explo[i].y - this.explo[i].dist, null);
            graphics.drawImage(images[9], this.explo[i].x + this.explo[i].dist, this.explo[i].y + this.explo[i].dist, null);
            graphics.drawImage(images[9], this.explo[i].x - this.explo[i].dist, this.explo[i].y - this.explo[i].dist, null);
            graphics.drawImage(images[9], this.explo[i].x + this.explo[i].dist, this.explo[i].y - this.explo[i].dist, null);
            graphics.drawImage(images[9], this.explo[i].x - this.explo[i].dist, this.explo[i].y + this.explo[i].dist, null);
        }
    }

    void fireball_add(int n, int n2) {
        n += 8;
        for (int i = 0; i < this.fireball.length; ++i) {
            if (this.fireball[i].active) continue;
            this.fireball[i].active = true;
            this.fireball[i].angle = Math.atan2(n2 - 408, n - 312);
            this.fireball[i].x = 312;
            this.fireball[i].y = 408;
            this.fireball[i].sx = 312;
            this.fireball[i].sy = 408;
            this.fireball[i].dist = 0;
            return;
        }
    }

    void fireball_move() {
        for (int i = 0; i < this.fireball.length; ++i) {
            if (!this.fireball[i].active) continue;
            this.fireball[i].dist += 3;
            this.fireball[i].x = this.fireball[i].sx + (int)(Math.cos(this.fireball[i].angle) * (double)this.fireball[i].dist);
            this.fireball[i].y = this.fireball[i].sy + (int)(Math.sin(this.fireball[i].angle) * (double)this.fireball[i].dist);
            if (this.fireball[i].y < 0 || this.fireball[i].y > 480) {
                this.fireball[i].active = false;
                continue;
            }
            if (this.fireball[i].x < 0 || this.fireball[i].x > 640) {
                this.fireball[i].active = false;
                continue;
            }
            for (int j = 0; j < this.drone.length; ++j) {
                if (!this.drone[j].active) continue;
                this.fireball_rect.setLocation(this.fireball[i].x, this.fireball[i].y);
                this.drone_rect.setLocation(this.drone[j].x, this.drone[j].y);
                if (!this.fireball_rect.intersects(this.drone_rect)) continue;
                this.drone[j].active = false;
                this.fireball[i].active = false;
                this.explo_add(this.drone[j].x, this.drone[j].y);
                if (this.player.carry == j) {
                    this.player.carry = -1;
                }
                --this.totaldrone;
                if (this.totaldrone - this.player.saved < this.mindrone) {
                    this.setstate(State.OVER);
                    break;
                }
                this.drones_allsaved();
                break;
            }
            if (!this.fireball[i].active) continue;
            this.player_rect.setLocation(this.player.x, this.player.y);
            if (!this.fireball_rect.intersects(this.player_rect)) continue;
            this.fireball[i].active = false;
            this.explo_add(this.fireball[i].x + 8, this.fireball[i].y + 8);
            --this.player.lives;
            if (this.player.lives != 0) continue;
            this.setstate(State.OVER);
        }
    }

    void fireball_draw(Graphics graphics) {
        for (int i = 0; i < this.fireball.length; ++i) {
            if (!this.fireball[i].active) continue;
            graphics.drawImage(images[6], this.fireball[i].x, this.fireball[i].y, null);
        }
    }

    void shot_add(int n, int n2) {
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].active) continue;
            this.shot[i].active = true;
            this.shot[i].x = n + 15;
            this.shot[i].y = n2;
            return;
        }
    }

    void shots_update() {
        int n = 0;
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].active) {
                this.shot[i].y -= 8;
                if (this.shot[i].y < 0) {
                    this.shot[i].active = false;
                    continue;
                }
                this.shot_rect.setLocation(this.shot[i].x, this.shot[i].y);
                for (n = 0; n < this.drone.length; ++n) {
                    if (!this.drone[n].active) continue;
                    this.drone_rect.setLocation(this.drone[n].x, this.drone[n].y);
                    if (!this.shot_rect.intersects(this.drone_rect)) continue;
                    this.drone[n].active = false;
                    this.shot[i].active = false;
                    this.explo_add(this.drone[n].x + 8, this.drone[n].y + 8);
                    if (this.player.carry == n) {
                        this.player.carry = -1;
                    }
                    --this.totaldrone;
                    if (this.totaldrone - this.player.saved < this.mindrone) {
                        this.setstate(State.OVER);
                        break;
                    }
                    this.drones_allsaved();
                    break;
                }
            }
            if (!this.shot[i].active) continue;
            this.player_rect.setLocation(this.player.x, this.player.y);
            if (!this.shot_rect.intersects(this.player_rect)) continue;
            this.explo_add(this.shot[i].x + 8, this.shot[i].y + 8);
            this.shot[i].active = false;
            --this.player.lives;
            if (this.player.lives != 0) continue;
            this.setstate(State.OVER);
        }
    }

    void shots_draw(Graphics graphics) {
        for (XY xY : this.shot) {
            if (!xY.active) continue;
            graphics.drawImage(images[3], xY.x, xY.y, null);
        }
    }

    void draw_bg(Graphics graphics) {
        graphics.drawImage(images[0], 0, 0, null);
    }

    void draw_footer(Graphics graphics) {
        graphics.setFont(this.medFont);
        graphics.setColor(Color.white);
        graphics.drawString(url, 510, 475);
        graphics.drawString(version, 2, 475);
    }

    void draw_ready(Graphics graphics) {
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        graphics.setColor(Color.red);
        Object object = "Level " + String.valueOf(this.level);
        int n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 150);
        graphics.setFont(this.medFont);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        graphics.setColor(Color.orange);
        object = "- " + this.levelname + " -";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 210);
        object = "Rescue at least " + String.valueOf(this.mindrone) + " drones!";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 270);
        graphics.setColor(Color.cyan);
        object = " Click / Space to Continue! ";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 330);
    }

    void draw_done(Graphics graphics) {
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        graphics.setColor(Color.green);
        Object object = "Level " + String.valueOf(this.level) + " Complete!";
        int n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 165);
        String[] stringArray = new String[]{"txt1", "txt2", "txt3", "txt4"};
        stringArray[0] = "Drones Rescued : " + String.valueOf(this.player.saved);
        stringArray[1] = "Time Bonus : " + String.valueOf(this.bonus);
        stringArray[2] = "";
        stringArray[3] = "Score " + String.valueOf(this.player.score);
        graphics.setFont(this.medFont);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        graphics.setColor(Color.orange);
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            n = (640 - this.fmetric.stringWidth((String)object)) / 2;
            graphics.drawString((String)object, n, 195 + i * 30);
        }
        graphics.setColor(Color.cyan);
        object = " Click / Space to Continue! ";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 315);
    }

    void draw_over(Graphics graphics) {
        graphics.setFont(this.bigFont);
        graphics.setColor(Color.red);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        Object object = "Game Over";
        int n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 150);
        graphics.setFont(this.medFont);
        graphics.setColor(Color.orange);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        object = this.player.lives == 0 ? "Your ship has been destroyed by the humans" : "You did not save enough drones";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 210);
        object = "Final Score : " + String.valueOf(this.player.score);
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 270);
        graphics.setColor(Color.cyan);
        object = " Click / Space to Continue! ";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 330);
    }

    void draw_completed(Graphics graphics) {
        graphics.setFont(this.bigFont);
        graphics.setColor(Color.green);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        Object object = "Mission Completed!";
        int n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 150);
        graphics.setFont(this.medFont);
        graphics.setColor(Color.orange);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        object = "Thanks to your efforts, the invasion can resume!";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 210);
        object = "Final Score : " + String.valueOf(this.player.score);
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 270);
        graphics.setColor(Color.cyan);
        object = "Click / Space to Continue!";
        n = (640 - this.fmetric.stringWidth((String)object)) / 2;
        graphics.drawString((String)object, n, 330);
    }

    void draw_title(Graphics graphics) {
        String[] stringArray = new String[]{"by ssjx", "", "Rescue the Invader drone ships captured by the", "humans and return them home via the warp gate!", "", "Controls:", "Arrows : Move your ship", "Space : Drop a carried drone", "", "Click / Space to Start!"};
        graphics.setFont(this.bigFont);
        graphics.setColor(Color.yellow);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        int n = (640 - this.fmetric.stringWidth(title)) / 2;
        graphics.drawString(title, n, 64);
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == 2 || i == 3 || i == 6 || i == 7) {
                graphics.setFont(this.medFont);
                graphics.setColor(Color.orange);
                this.fmetric = graphics.getFontMetrics(this.medFont);
            } else {
                graphics.setFont(this.bigFont);
                graphics.setColor(Color.red);
                this.fmetric = graphics.getFontMetrics(this.bigFont);
                if (i == 9) {
                    graphics.setColor(Color.cyan);
                }
            }
            string = stringArray[i];
            n = (640 - this.fmetric.stringWidth(string)) / 2;
            graphics.drawString(string, n, 96 + i * 30);
        }
        graphics.setFont(this.medFont);
        graphics.setColor(Color.white);
        graphics.drawString("High Score : " + String.valueOf(this.hiscore), 10, 16);
    }

    void draw_game(Graphics graphics) {
        int n;
        int n2 = 0;
        for (n = 0; n < 5; ++n) {
            n2 = this.player.lives - 1 < n ? 1 : 0;
            graphics.drawImage(images[8], 520 + n * 24, 2, 520 + n * 24 + 16, 16, n2 * 16, 0, n2 * 16 + 16, 16, null);
        }
        graphics.drawImage(images[5], this.warp.x, this.warp.y, this.warp.x + 32, this.warp.y + 32, this.warp.alt * 32, 0, this.warp.alt * 32 + 32, 32, null);
        graphics.drawImage(images[1], this.player.x, this.player.y, null);
        n = 0;
        for (XY xY : this.drone) {
            if (xY.active) {
                if (this.player.carry == n) {
                    graphics.drawImage(images[2], xY.x, xY.y, xY.x + 16, xY.y + 16, 0, 0, 16, 16, null);
                } else {
                    graphics.drawImage(images[2], xY.x, xY.y, xY.x + 16, xY.y + 16, 16, 0, 32, 16, null);
                }
            }
            ++n;
        }
        if (this.paddle.active) {
            graphics.drawImage(images[4], this.paddle.x, this.paddle.y, null);
        }
        if (this.tower) {
            graphics.drawImage(images[7], 304, 408, null);
        }
        graphics.setFont(this.medFont);
        graphics.setColor(Color.white);
        graphics.drawString("Score : " + String.valueOf(this.player.score), 10, 16);
        graphics.drawString("Saved : " + String.valueOf(this.player.saved) + " / " + String.valueOf(this.totaldrone) + " (" + String.valueOf(this.mindrone) + ")", 150, 16);
        graphics.drawString("Bonus : " + String.valueOf(this.bonus), 350, 16);
        this.player.speed = 2;
        if (this.player.carry != -1) {
            this.player.speed = 1;
        }
        if (this.level == 4) {
            this.player.speed = 1;
        }
        if (this.left) {
            for (int i = 0; i < this.player.speed; ++i) {
                if (this.player.x - 4 < 0) continue;
                this.player.x -= 4;
            }
        }
        if (this.right) {
            for (int i = 0; i < this.player.speed; ++i) {
                if (this.player.x + 32 + 4 > 640) continue;
                this.player.x += 4;
            }
        }
        if (this.up) {
            for (int i = 0; i < this.player.speed; ++i) {
                if (this.player.y - 4 < 16) continue;
                this.player.y -= 4;
            }
        }
        if (this.down) {
            for (int i = 0; i < this.player.speed; ++i) {
                if (this.player.y + 4 > 408) continue;
                this.player.y += 4;
            }
        }
        if (this.player.carry == -1) {
            this.player.carry = this.drone_hook(this.player.x + 16, this.player.y + 24);
        }
    }

    boolean drones_allsaved() {
        boolean bl = true;
        for (XY xY : this.drone) {
            if (!xY.active) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.setstate(State.DONE);
        }
        return bl;
    }

    void drone_update() {
        for (int i = 0; i < this.drone.length; ++i) {
            if (!this.drone[i].active) continue;
            if (this.player.carry == i) {
                this.drone[i].x = this.player.x + 8;
                this.drone[i].y = this.player.y + 16;
            } else {
                if (this.drone[i].x < this.drone[i].sx) {
                    this.drone[i].x += 2;
                }
                if (this.drone[i].x > this.drone[i].sx) {
                    this.drone[i].x -= 2;
                }
                if (this.drone[i].y < this.drone[i].sy) {
                    this.drone[i].y += 2;
                }
                if (this.drone[i].y > this.drone[i].sy) {
                    this.drone[i].y -= 2;
                }
            }
            if (this.drone[i].x + 8 <= this.warp.x || this.drone[i].x + 8 >= this.warp.x + 32 || this.drone[i].y + 8 <= this.warp.y || this.drone[i].y + 8 >= this.warp.y + 32) continue;
            this.drone[i].active = false;
            ++this.player.saved;
            this.player.score += 10;
            if (this.player.carry == i) {
                this.player.carry = -1;
            }
            try {
                this.clip[0].setFramePosition(0);
                this.clip[0].start();
            }
            catch (Exception exception) {
                System.out.println("Problem playing the sound");
                System.out.println(exception);
            }
            this.drones_allsaved();
        }
    }

    int drone_hook(int n, int n2) {
        int n3 = 0;
        for (XY xY : this.drone) {
            if (xY.active && xY.x == xY.sx && xY.y == xY.sy && n > xY.x && n < xY.x + 32 && n2 > xY.y && n2 < xY.y + 32) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = false;
                    break;
                }
                case 40: {
                    this.down = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == ' ') {
            this.nextstate();
        }
        switch (this.gamestate) {
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c == 'q') {
                    this.setstate(State.OVER);
                }
                if (c != ' ') break;
                this.player.carry = -1;
            }
        }
    }

    private static enum State {
        WELCOME,
        READY,
        GAME,
        OVER,
        DONE,
        COMPLETE;

    }
}

