/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Pushover
extends JPanel
implements KeyListener {
    private static final String title = "Pushover";
    private static final int swidth = 640;
    private static final int sheight = 480;
    private static final int fps = 60;
    private static int fpsdelay = 16;
    static Map mymap = new Map();
    static Title mytitle = new Title();
    int xd = 0;
    int yd = 0;
    int currentlevel = 1;
    int tick;
    int tc = 0;
    GameState state = GameState.TITLE;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean fire = false;
    boolean spacedown = false;
    boolean escapedown = false;
    FontMetrics fmetric;
    final Font smlFont = new Font("Arial", 0, 18);
    final Font bigFont = new Font("Arial", 0, 20);
    String lbl_help = "";
    final Color bgcol = new Color(0, 128, 192);
    final String[] hud_text = new String[]{"Score", "Time", "Lives"};
    String[] hud_value = new String[]{"0", "1", "2"};

    public Pushover() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Pushover.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
        this.setstate(GameState.TITLE);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Pushover());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void setstate(GameState gameState) {
        switch (gameState) {
            case TITLE: 
            case FAIL: 
            case OVER: 
            case LEVELDONE: 
            case COMPLETED: {
                fpsdelay = 100;
                break;
            }
            case READY: {
                this.lbl_help = "";
                if (this.currentlevel == 2) {
                    this.lbl_help = "Dominoes can be pushed off the edge but you cannot fall holding one!";
                }
                if (this.currentlevel == 4) {
                    this.lbl_help = "Yellow dominoes bounce off Red ones!";
                }
                fpsdelay = 100;
                break;
            }
            default: {
                fpsdelay = 16;
            }
        }
        this.state = gameState;
    }

    void show_hud(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics.setFont(this.smlFont);
        this.fmetric = graphics.getFontMetrics(this.smlFont);
        graphics.setColor(Color.blue);
        for (n3 = 0; n3 < 3; ++n3) {
            n2 = this.fmetric.stringWidth(this.hud_text[n3]);
            n = 213 - n2 >> 1;
            graphics.drawString(this.hud_text[n3], n3 * 213 + n, 16);
        }
        graphics.setColor(Color.yellow);
        for (n3 = 0; n3 < 3; ++n3) {
            n2 = this.fmetric.stringWidth(this.hud_value[n3]);
            n = 213 - n2 >> 1;
            graphics.drawString(this.hud_value[n3], n3 * 213 + n, 32);
        }
        if (this.lbl_help != "") {
            graphics.setColor(Color.green);
            n2 = this.fmetric.stringWidth(this.lbl_help);
            n = 640 - n2 >> 1;
            graphics.drawString(this.lbl_help, n, 60);
        }
    }

    public void update_hud() {
        this.hud_value[0] = String.valueOf(Pushover.mymap.myplayer.score);
        this.hud_value[1] = String.valueOf(Pushover.mymap.bonus);
        this.hud_value[2] = String.valueOf(Pushover.mymap.myplayer.lives);
    }

    public void reset_hud() {
        this.hud_value[0] = "-";
        this.hud_value[1] = "-";
        this.hud_value[2] = "-";
    }

    void draw_bg(Graphics graphics) {
        graphics.setColor(this.bgcol);
        graphics.fillRect(0, 0, 640, 480);
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.state) {
            case TITLE: {
                this.draw_bg(graphics);
                mytitle.welcome(graphics, Pushover.mymap.highscore);
                break;
            }
            case READY: {
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                mytitle.ready(graphics, this.currentlevel);
                break;
            }
            case PLAY: {
                this.xd = 0;
                this.yd = 0;
                if (this.left) {
                    this.xd = -1;
                }
                if (this.right) {
                    this.xd = 1;
                }
                if (this.up) {
                    this.yd = -1;
                }
                if (this.down) {
                    this.yd = 1;
                }
                mymap.move(this.xd, this.yd, this.fire);
                this.fire = false;
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                this.update_hud();
                int n = mymap.check();
                if (n == 1) {
                    this.setstate(GameState.FAIL);
                }
                if (n == 2) {
                    this.setstate(GameState.OVER);
                }
                if (Pushover.mymap.push) {
                    mymap.startpush();
                    this.setstate(GameState.PUSH);
                    this.tick = 10;
                }
                ++this.tc;
                if (this.tc != 50) break;
                this.tc = 0;
                if (Pushover.mymap.bonus >= 90) break;
                this.lbl_help = "";
                break;
            }
            case PUSH: {
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                if (Pushover.mymap.push_start) {
                    ++this.tick;
                    if (this.tick < 5) break;
                    this.tick = 0;
                    mymap.updatepush();
                    break;
                }
                if (Pushover.mymap.down == Pushover.mymap.up) {
                    this.setstate(GameState.LEVELDONE);
                    mymap.add_bonus();
                    break;
                }
                int n = mymap.check_domino(Pushover.mymap.up, Pushover.mymap.down);
                if (n == 1) {
                    this.setstate(GameState.FAIL);
                }
                if (n != 2) break;
                this.setstate(GameState.OVER);
                break;
            }
            case FAIL: {
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                mytitle.fail(graphics);
                break;
            }
            case OVER: {
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                mytitle.gameover(graphics, this.hud_value[0]);
                break;
            }
            case LEVELDONE: {
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                mytitle.leveldone(graphics);
                break;
            }
            case COMPLETED: {
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                mytitle.gamedone(graphics, this.hud_value[0]);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.state) {
            case TITLE: {
                if (c != ' ') break;
                this.currentlevel = 1;
                this.tc = 0;
                mymap.load(this.currentlevel);
                this.reset_hud();
                this.setstate(GameState.READY);
                break;
            }
            case OVER: {
                if (c != ' ' && c != '\u001b') break;
                this.setstate(GameState.TITLE);
                break;
            }
            case FAIL: {
                if (c != ' ') break;
                mymap.reset();
                this.update_hud();
                this.setstate(GameState.READY);
                break;
            }
            case READY: {
                if (c != ' ') break;
                mymap.reset();
                this.setstate(GameState.PLAY);
                this.up = false;
                this.down = false;
                this.left = false;
                this.right = false;
                this.fire = false;
                break;
            }
            case LEVELDONE: {
                if (c != ' ') break;
                this.update_hud();
                if (this.currentlevel < 6) {
                    ++this.currentlevel;
                    mymap.load(this.currentlevel);
                    this.setstate(GameState.READY);
                } else {
                    mymap.is_highscore();
                    this.setstate(GameState.COMPLETED);
                }
                this.tc = 0;
                break;
            }
            case COMPLETED: {
                if (c != ' ') break;
                this.setstate(GameState.TITLE);
                break;
            }
            case PLAY: {
                if (c == '\u001b') {
                    mymap.is_highscore();
                    this.setstate(GameState.OVER);
                }
                if (c == 'c') {
                    mymap.cheat();
                    this.setstate(GameState.LEVELDONE);
                }
                if (c != 't') break;
                Pushover.mymap.bonus = 3;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.state == GameState.PLAY) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = false;
                    break;
                }
                case 40: {
                    this.down = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                    break;
                }
                case 32: {
                    this.fire = false;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.state == GameState.PLAY) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 32: {
                    this.fire = true;
                }
            }
        }
    }

    public static enum GameState {
        TITLE,
        PLAY,
        PUSH,
        FAIL,
        OVER,
        LEVELDONE,
        COMPLETED,
        READY;

    }
}

