/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

public class Player {
    private final int width = 20;
    private final int height = 15;
    int score = 0;
    int lives;
    int fall;
    private static Image img;
    private static boolean gfxloaded;
    int x;
    int y;
    int ox;
    int oy;
    int facing;
    private int fc;
    private int frame;
    private int xdir;
    private int ydir;
    private int sprite;
    private int turned;
    int carry = -1;
    boolean push = false;
    Rectangle dest = new Rectangle(0, 0, 32, 32);
    Rectangle src = new Rectangle(0, 0, 32, 32);
    boolean moving = false;

    public Player() {
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/players2.gif");
                img = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the PLAYER sprites");
            }
        }
        this.reset();
    }

    public void set(int n, int n2) {
        this.reset();
        this.x = n;
        this.y = n2;
        this.dest.x = this.x * 32;
        this.dest.y = this.y * 32;
        this.src.x = (this.sprite + this.frame) * 32;
        this.push = false;
    }

    public void reset() {
        this.x = 0;
        this.y = 0;
        this.ox = 0;
        this.oy = 0;
        this.fc = 0;
        this.frame = 0;
        this.xdir = 0;
        this.ydir = 0;
        this.sprite = 0;
        this.carry = -1;
    }

    public void update(int[] nArray, int n, int n2, boolean bl) {
        if (!this.moving) {
            if (nArray[(this.y + 1) * 20 + this.x] == 0) {
                if (nArray[this.y * 20 + this.x] != 2) {
                    n2 = 1;
                    n = 0;
                    ++this.fall;
                }
            } else {
                this.fall = 0;
            }
            if (n == 0) {
                this.ydir = n2;
                if (this.y == 0 && n2 == -1) {
                    this.ydir = 0;
                }
                if (nArray[(this.y + this.ydir) * 20 + this.x] == 1) {
                    this.ydir = 0;
                }
                if (this.ydir != 0) {
                    this.sprite = 4;
                }
            } else {
                if (this.facing == n) {
                    this.xdir = n;
                    if (nArray[this.y * 20 + this.x + this.xdir] == 1) {
                        this.xdir = 0;
                    }
                    if (this.x == 0 && n == -1) {
                        this.xdir = 0;
                    }
                    if (this.x == 19 && n == 1) {
                        this.xdir = 0;
                    }
                } else {
                    this.facing = n;
                    this.turned = 3;
                }
                if (this.facing == 1) {
                    this.sprite = 2;
                }
                if (this.facing == -1) {
                    this.sprite = 0;
                }
            }
            if (bl) {
                int n3 = this.y * 20 + this.x;
                if (this.carry == -1) {
                    if (nArray[n3] == 3 || nArray[n3] == 7) {
                        this.carry = nArray[n3];
                        nArray[n3] = 0;
                    } else if (nArray[n3] == 0 && nArray[n3 + this.facing] == 3) {
                        this.push = true;
                    }
                } else if (nArray[n3] == 0) {
                    nArray[n3] = (byte)this.carry;
                    this.carry = -1;
                }
            }
        }
    }

    public void draw(Graphics graphics) {
        if (!this.push) {
            this.moving = false;
            if (this.xdir != 0 || this.ydir != 0) {
                this.ox += this.xdir * 4;
                this.oy += this.ydir * 4;
                if (this.ox == 32 || this.ox == -32) {
                    this.ox = 0;
                    this.x += this.xdir;
                    this.xdir = 0;
                }
                if (this.oy == 32 || this.oy == -32) {
                    this.oy = 0;
                    this.y += this.ydir;
                    this.ydir = 0;
                }
                this.moving = true;
                ++this.fc;
                if (this.fc >= 5) {
                    this.frame = 1 - this.frame;
                    this.fc = 0;
                }
                this.dest.x = this.x * 32 + this.ox;
                this.dest.y = this.y * 32 + this.oy;
            } else if (this.turned > 0) {
                --this.turned;
                this.moving = true;
            }
        } else {
            if (this.facing == 1) {
                this.sprite = 7;
                this.frame = 0;
            }
            if (this.facing == -1) {
                this.sprite = 6;
                this.frame = 0;
            }
        }
        this.src.x = (this.sprite + this.frame) * 32;
        graphics.drawImage(img, this.dest.x, this.dest.y, this.dest.x + 32, this.dest.y + 32, this.src.x, this.src.y, this.src.x + 32, this.src.y + 32, null);
    }

    static {
        gfxloaded = false;
    }
}

