/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

class Map {
    public int highscore = 0;
    public boolean push = false;
    private int width;
    private int height;
    private int depth;
    int fc;
    int bonus;
    private static Image[] sprite = new Image[11];
    private static boolean gfxloaded = false;
    int[] map = new int[300];
    int[] map_copy = new int[300];
    Player myplayer = new Player();
    private static Rectangle dest = new Rectangle(0, 0, 32, 32);
    private static Rectangle src = new Rectangle(0, 0, 32, 32);
    int push_x;
    int push_y;
    int push_xdir;
    int stage;
    public int up;
    public int down;
    public boolean push_start = false;

    public Map() {
        if (!gfxloaded) {
            try {
                String[] stringArray = new String[]{"block.gif", "block.gif", "ladder.gif", "domino1.gif", "domino2.gif", "domino-final.gif", "domino-final2.gif", "domino-red.gif", "domino3.gif", "domino-final3.gif", "broken.gif"};
                int n = 0;
                for (String string : stringArray) {
                    URL uRL = this.getClass().getResource("gfx/" + string);
                    Map.sprite[n] = ImageIO.read(uRL);
                    ++n;
                }
            }
            catch (Exception exception) {
                System.out.println("Problem loading the MAP sprites");
            }
        }
    }

    public boolean load(int n) {
        boolean bl = false;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("map/level" + n + ".bmp");
            byte[] byArray = inputStream.readAllBytes();
            inputStream.close();
            int n2 = byArray[10] + (byArray[11] << 8);
            this.width = byArray[18] + (byArray[19] << 8);
            this.height = byArray[22] + (byArray[23] << 8);
            this.depth = byArray[28] + (byArray[29] << 8);
            if (this.width * this.height <= this.map.length) {
                if (this.depth == 8) {
                    int n3 = 0;
                    for (int i = this.height - 1; i > -1; --i) {
                        for (int j = 0; j < this.width; ++j) {
                            this.map[n3] = byArray[n2 + i * this.width + j];
                            this.map_copy[n3] = this.map[n3];
                            ++n3;
                        }
                    }
                    this.reset();
                    if (n == 1) {
                        this.myplayer.score = 0;
                        this.myplayer.lives = 3;
                    }
                    bl = true;
                } else {
                    System.out.println("Depth should be 8 not " + this.depth);
                }
            } else {
                System.out.println("Level is too big for map buffer! " + byArray.length + " > " + this.map.length);
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map...");
        }
        return bl;
    }

    public void reset() {
        int n = 0;
        this.up = 0;
        int[] nArray = this.map_copy;
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3;
            this.map[n] = n3 = nArray[i];
            ++n;
            if (n3 != 3 && n3 != 5) continue;
            ++this.up;
        }
        for (int i = 0; i < this.height; ++i) {
            for (n = 0; n < this.width; ++n) {
                switch (this.get(n, i)) {
                    case 15: {
                        this.myplayer.set(n, i);
                        this.set(n, i, 0);
                    }
                }
            }
        }
        this.bonus = 100;
        this.push = false;
        this.fc = 0;
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                int n3 = this.get(n, n2);
                if (n3 <= 0 || n3 >= sprite.length) continue;
                graphics.drawImage(sprite[n3], n * 32, n2 * 32, null);
            }
        }
        this.myplayer.draw(graphics);
        if (this.myplayer.carry != -1) {
            n2 = this.myplayer.x * 32 + this.myplayer.ox;
            n = this.myplayer.y * 32 + this.myplayer.oy - 16;
            if (this.myplayer.carry == 10) {
                n += 16;
            }
            graphics.drawImage(sprite[this.myplayer.carry], n2, n, null);
        }
        ++this.fc;
        if (this.fc == 60) {
            this.fc = 0;
            --this.bonus;
        }
    }

    public void move(int n, int n2, boolean bl) {
        this.myplayer.update(this.map, n, n2, bl);
        if (this.myplayer.push) {
            this.push = true;
        }
    }

    public int check() {
        boolean bl = false;
        if (this.myplayer.y == 16) {
            bl = true;
        }
        if (this.myplayer.fall > 1 && this.get(this.myplayer.x, this.myplayer.y + 1) == 1 && this.myplayer.carry != -1) {
            this.myplayer.carry = 10;
            bl = true;
        }
        if (this.bonus <= 0) {
            if (this.myplayer.score > this.highscore) {
                this.highscore = this.myplayer.score;
            }
            bl = true;
        }
        if (bl) {
            --this.myplayer.lives;
            if (this.myplayer.lives > 0) {
                return 1;
            }
            if (this.myplayer.score > this.highscore) {
                this.highscore = this.myplayer.score;
            }
            return 2;
        }
        return 0;
    }

    public int check_domino(int n, int n2) {
        if (n2 != n) {
            --this.myplayer.lives;
            if (this.myplayer.lives > 0) {
                return 1;
            }
            if (this.myplayer.score > this.highscore) {
                this.highscore = this.myplayer.score;
            }
            return 2;
        }
        return 0;
    }

    public boolean is_highscore() {
        if (this.myplayer.score > this.highscore) {
            this.highscore = this.myplayer.score;
            return true;
        }
        return false;
    }

    int get(int n, int n2) {
        return this.map[n2 * this.width + n];
    }

    void set(int n, int n2, int n3) {
        this.map[n2 * this.width + n] = n3;
    }

    public void set_bonus(int n) {
        this.bonus = n;
    }

    public void add_bonus() {
        this.myplayer.score += this.bonus;
    }

    public void cheat() {
        this.myplayer.score += 7;
        this.down = this.up;
    }

    public void startpush() {
        this.push_x = this.myplayer.x;
        this.push_y = this.myplayer.y;
        this.push_xdir = this.myplayer.facing;
        this.push_x += this.push_xdir;
        this.push_start = true;
        this.down = 0;
    }

    public void updatepush() {
        if (this.get(this.push_x, this.push_y) == 3) {
            if (this.get(this.push_x, this.push_y + 1) == 0) {
                this.set(this.push_x, this.push_y, 0);
                this.set(this.push_x, this.push_y + 1, 3);
                ++this.push_y;
                return;
            }
            if (this.get(this.push_x, this.push_y + 1) == 3) {
                this.set(this.push_x, this.push_y, 0);
                this.set(this.push_x, this.push_y + 1, 10);
                this.push_start = false;
                return;
            }
            if (this.get(this.push_x + this.push_xdir, this.push_y + 1) == 0) {
                this.set(this.push_x, this.push_y, 0);
                this.set(this.push_x + this.push_xdir, this.push_y + 1, 3);
                this.push_x += this.push_xdir;
                ++this.push_y;
                return;
            }
            if (this.get(this.push_x + this.push_xdir, this.push_y) == 3 || this.get(this.push_x + this.push_xdir, this.push_y) == 5) {
                if (this.push_xdir == 1) {
                    this.set(this.push_x, this.push_y, 4);
                } else {
                    this.set(this.push_x, this.push_y, 8);
                }
                ++this.down;
                this.push_x += this.push_xdir;
                return;
            }
            if (this.get(this.push_x + this.push_xdir, this.push_y) == 7) {
                if (this.push_xdir == 1) {
                    this.set(this.push_x, this.push_y, 4);
                } else {
                    this.set(this.push_x, this.push_y, 8);
                }
            }
            if (this.get(this.push_x + this.push_xdir, this.push_y) == 0) {
                if (this.get(this.push_x, this.push_y) == 3) {
                    if (this.push_xdir == 1) {
                        this.set(this.push_x, this.push_y, 4);
                    } else {
                        this.set(this.push_x, this.push_y, 8);
                    }
                    ++this.down;
                }
                if (this.get(this.push_x, this.push_y) == 5) {
                    this.set(this.push_x, this.push_y, 6);
                    ++this.down;
                }
            }
        }
        if ((this.get(this.push_x, this.push_y) == 4 || this.get(this.push_x, this.push_y) == 8) && this.get(this.push_x + this.push_xdir, this.push_y) == 7) {
            switch (this.stage) {
                case 0: {
                    if (this.push_xdir == 1) {
                        this.set(this.push_x, this.push_y, 4);
                    } else {
                        this.set(this.push_x, this.push_y, 8);
                    }
                    ++this.stage;
                    break;
                }
                case 1: {
                    this.set(this.push_x, this.push_y, 3);
                    this.push_xdir *= -1;
                    this.stage = 0;
                }
            }
            return;
        }
        boolean bl = false;
        if (this.get(this.push_x, this.push_y) == 5) {
            if (this.push_xdir == 1) {
                this.set(this.push_x, this.push_y, 6);
            } else {
                this.set(this.push_x, this.push_y, 9);
            }
            ++this.down;
            bl = true;
        }
        this.push_start = false;
        if (!this.push_start && !bl) {
            this.set(this.push_x, this.push_y, 10);
        }
    }
}

