/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class Npc {
    private static final int MODE_RPG = 10;
    public int active = 0;
    public int x = 0;
    public int y = 0;
    public int ox = 0;
    public int oy = 0;
    private int state = 0;
    private int xdir = 0;
    private int ydir = 0;
    private int path = 0;
    private int frame = 0;
    private int startx = 0;
    private int starty = 0;
    private static Image[] sprite = new Image[10];
    private static boolean gfxloaded = false;
    private int[] order = new int[]{0, 1, 2, 3};
    private Random rand = new Random();

    public Npc() {
        if (!gfxloaded) {
            gfxloaded = true;
            String[] stringArray = new String[]{"up", "up_1", "down", "down_1", "left", "left_1", "right", "right_1"};
            int n = 0;
            for (String string : stringArray) {
                try {
                    URL uRL = Npc.class.getResource("gfx/npc/" + string + ".gif");
                    Npc.sprite[n] = ImageIO.read(uRL);
                    ++n;
                }
                catch (Exception exception) {
                    System.out.println("Problem loading the NPC sprite " + string);
                    System.out.println(exception);
                }
            }
        }
    }

    private void jumble() {
        for (int i = 0; i < 10; ++i) {
            int n = this.rand.nextInt(4);
            int n2 = this.rand.nextInt(4);
            int n3 = this.order[n];
            this.order[n] = this.order[n2];
            this.order[n2] = n3;
        }
    }

    public void set(int n, int n2, int n3, int n4) {
        this.startx = n;
        this.starty = n2;
        this.reset();
        this.active = 1;
        this.path = n3;
        this.state = n4;
    }

    public void reset() {
        this.x = this.startx;
        this.y = this.starty;
        this.ox = 0;
        this.oy = 0;
        this.xdir = 0;
        this.ydir = 0;
    }

    public void move(int[] nArray) {
        int n;
        if (this.active == 0) {
            return;
        }
        if (Math.abs(this.ox) == 32 || Math.abs(this.oy) == 32) {
            this.x += this.xdir;
            this.y += this.ydir;
            this.ox = 0;
            this.oy = 0;
            n = (this.y + this.ydir) * 40 + this.x + this.xdir;
            if (nArray[n] != this.path) {
                this.xdir = 0;
                this.ydir = 0;
            }
            if (this.xdir != 0 && (nArray[(this.y - 1) * 40 + this.x] == this.path || nArray[(this.y + 1) * 40 + this.x] == this.path)) {
                this.xdir = 0;
                this.ydir = 0;
            }
            if (this.ydir != 0 && (nArray[this.y * 40 + this.x + 1] == this.path || nArray[this.y * 40 + this.x + 1] == this.path)) {
                this.xdir = 0;
                this.ydir = 0;
            }
        }
        if (this.xdir == 0 && this.ydir == 0) {
            this.jumble();
            for (int n2 : this.order) {
                switch (n2) {
                    case 0: {
                        n = this.y * 40 + this.x + 1;
                        if (nArray[n] != this.path) break;
                        this.xdir = 1;
                        this.ydir = 0;
                        break;
                    }
                    case 1: {
                        n = this.y * 40 + this.x - 1;
                        if (nArray[n] != this.path) break;
                        this.xdir = -1;
                        this.ydir = 0;
                        break;
                    }
                    case 2: {
                        n = (this.y + 1) * 40 + this.x;
                        if (nArray[n] != this.path) break;
                        this.xdir = 0;
                        this.ydir = 1;
                        break;
                    }
                    case 3: {
                        n = (this.y - 1) * 40 + this.x;
                        if (nArray[n] != this.path) break;
                        this.xdir = 0;
                        this.ydir = -1;
                    }
                }
                if (this.xdir != 0 || this.ydir != 0) break;
            }
        }
        this.ox += this.xdir * 2;
        this.oy += this.ydir * 2;
    }

    public void draw(int n, int n2, Graphics graphics) {
        if (this.active == 0) {
            return;
        }
        Point point = new Point((this.x - n) * 32 + this.ox, (this.y - n2) * 32 + this.oy);
        switch (this.state) {
            case 10: {
                int n3;
                if (this.ydir == 0 && ((n3 = Math.abs(this.ox)) == 0 || n3 == 8 || n3 == 16 || n3 == 24)) {
                    this.frame = 1 - this.frame;
                }
                if (this.xdir == 0 && ((n3 = Math.abs(this.oy)) == 0 || n3 == 8 || n3 == 16 || n3 == 24)) {
                    this.frame = 1 - this.frame;
                }
                if (this.ydir == -1) {
                    graphics.drawImage(sprite[0 + this.frame], point.x, point.y, null);
                }
                if (this.ydir == 1) {
                    graphics.drawImage(sprite[2 + this.frame], point.x, point.y, null);
                }
                if (this.xdir == -1) {
                    graphics.drawImage(sprite[4 + this.frame], point.x, point.y, null);
                }
                if (this.xdir != 1) break;
                graphics.drawImage(sprite[6 + this.frame], point.x, point.y, null);
            }
        }
    }
}

