/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;

class Shot {
    boolean[] active = new boolean[20];
    int[] x = new int[20];
    int[] y = new int[20];
    private final int owner;
    private int[] xdir = new int[20];
    private int[] ydir = new int[20];
    private Image sprite;

    public Shot(int n) {
        this.owner = n;
        try {
            URL uRL = Menastar.class.getClassLoader().getResource("shot.png");
            this.sprite = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the Shot sprite ");
        }
    }

    public void reset() {
        for (int i = 0; i < this.active.length; ++i) {
            this.active[i] = false;
        }
    }

    public void add(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.active.length; ++i) {
            if (this.active[i]) continue;
            this.active[i] = true;
            this.x[i] = n;
            this.y[i] = n2;
            this.xdir[i] = n3;
            this.ydir[i] = n4;
            break;
        }
    }

    public void update() {
        for (int i = 0; i < this.active.length; ++i) {
            if (!this.active[i]) continue;
            int n = i;
            this.x[n] = this.x[n] + this.xdir[i] * 2;
            int n2 = i;
            this.y[n2] = this.y[n2] + this.ydir[i] * 2;
            if (this.x[i] < 0 || this.x[i] > 1280) {
                this.active[i] = false;
            }
            if (this.y[i] >= 0 && this.y[i] <= 960) continue;
            this.active[i] = false;
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        for (int i = 0; i < this.active.length; ++i) {
            if (!this.active[i]) continue;
            int n3 = this.x[i] - n;
            int n4 = this.y[i] - n2;
            graphics.drawImage(this.sprite, n3, n4, n3 + 16, n4 + 16, 0 + this.owner * 16, 0, 16 + this.owner * 16, 16, null);
        }
    }
}

