/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Menastar
extends JPanel
implements KeyListener {
    FontMetrics fmetric;
    Random rand;
    static final String title = "Menastar";
    static final String url = "http://ssjx.co.uk";
    static final String version = "v0.1 (##/05/20)";
    static final int swidth = 640;
    static final int sheight = 480;
    static final int fps = 60;
    static int fpsdelay = 16;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    static State gamestate = State.WELCOME;
    Titles mytitle = new Titles();
    Deathstar mydeathstar = new Deathstar();
    Player myplayer = new Player();
    Explosion myexplosion = new Explosion();
    int sct;
    int hiscore = 0;
    int reason;
    int fc = 0;
    String txt = "";
    int tx = 0;
    boolean drawnow = true;
    static Point[] star = new Point[40];
    static Point[] diamond = new Point[20];
    final int[] shot_point = new int[]{-4, 4, 4, 4, -4, -4, 4, -4};
    static URL imageurl;
    static Image bg_img;
    static Image txt_img;
    static Image[] sprite;
    final Font smlFont = new Font("Arial", 0, 16);
    final Font medFont = new Font("Arial", 0, 18);
    final String[] hud_text = new String[]{"Shields", "Score", "Diamonds"};
    String[] hud_value = new String[]{"0", "0", "0"};
    final String dia_txt = "COLLECT THE DIAMONDS TO MAKE MORE TORPEDOES!";

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Menastar() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        this.rand = new Random();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Menastar.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        int n;
        String[] stringArray2 = new String[]{"barrier", "diamond", "fire", "star", "pips", "explosion"};
        int n2 = 0;
        String[] stringArray3 = stringArray2;
        int n3 = stringArray3.length;
        for (n = 0; n < n3; ++n) {
            String string = stringArray3[n];
            try {
                imageurl = Menastar.class.getClassLoader().getResource(string + ".png");
                Menastar.sprite[n2] = new ImageIcon(imageurl).getImage();
            }
            catch (Exception exception) {
                System.out.println("Main: Exception loading " + string);
            }
            ++n2;
        }
        for (n = 0; n < star.length; ++n) {
            int n4 = (int)Math.floor(Math.random() * 640.0);
            n3 = (int)Math.floor(Math.random() * 480.0);
            Menastar.star[n] = new Point(n4, n3);
        }
        for (n = 0; n < diamond.length; ++n) {
            Menastar.diamond[n] = new Point(-1, -1);
        }
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Menastar());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        switch (gamestate) {
            case WELCOME: {
                this.draw_bg(graphics);
                this.mytitle.welcome(graphics, this.hiscore);
                break;
            }
            case GAME: {
                int n;
                int n2;
                this.draw_bg(graphics);
                graphics.setColor(Color.cyan);
                for (n2 = 0; n2 < diamond.length; ++n2) {
                    if (Menastar.diamond[n2].x == -1) continue;
                    graphics.drawImage(sprite[1], Menastar.diamond[n2].x - this.myplayer.mx, Menastar.diamond[n2].y - this.myplayer.my, null);
                    if (!this.myplayer.got_diamond(Menastar.diamond[n2].x + 8, Menastar.diamond[n2].y + 8)) continue;
                    Menastar.diamond[n2].x = -1;
                }
                this.myplayer.draw(graphics);
                this.mydeathstar.draw(graphics, this.myplayer.mx, this.myplayer.my);
                this.myexplosion.draw(graphics, this.myplayer.mx, this.myplayer.my);
                this.draw_hud(graphics);
                ++this.fc;
                if (this.myplayer.speed >= this.fc) {
                    this.myplayer.move();
                }
                if (this.mydeathstar.complete) {
                    for (n = 0; n < 20; ++n) {
                        if (!this.myplayer.shots.active[n] || (n2 = this.mydeathstar.hit_segment(this.myplayer.shots.x[n] + 8, this.myplayer.shots.y[n] + 8)) <= -1) continue;
                        this.myplayer.shots.active[n] = false;
                        this.myexplosion.add(this.mydeathstar.hit_x, this.mydeathstar.hit_y);
                    }
                }
                for (int i = 0; i < 20; ++i) {
                    if (!this.mydeathstar.shots.active[i] || (n = (int)(this.myplayer.hit_segment(this.mydeathstar.shots.x[i] + 8, this.mydeathstar.shots.y[i] + 8) ? 1 : 0)) != 1) continue;
                    this.mydeathstar.shots.active[i] = false;
                    --this.myplayer.lives;
                    if (this.myplayer.lives == 0) {
                        this.myexplosion.add(304 + 0 + this.myplayer.mx, 224 + 0 + this.myplayer.my);
                        this.myexplosion.add(304 + 16 + this.myplayer.mx, 224 + 0 + this.myplayer.my);
                        this.myexplosion.add(304 + 0 + this.myplayer.mx, 224 + 16 + this.myplayer.my);
                        this.myexplosion.add(304 + 16 + this.myplayer.mx, 224 + 16 + this.myplayer.my);
                        continue;
                    }
                    this.myexplosion.add(304 + 8 + this.myplayer.mx, 224 + 8 + this.myplayer.my);
                }
                if (this.mydeathstar.is_destroyed()) {
                    this.setstate(State.COMPLETE);
                    return;
                }
                if (this.myplayer.lives == 0) {
                    this.reason = 1;
                    this.setstate(State.OVER);
                    return;
                }
                if (this.fc >= 2) {
                    this.panic_diamonds();
                    this.mydeathstar.assemble(this.myplayer.mx + 304, this.myplayer.my + 224);
                    this.fc = 0;
                }
                ++this.sct;
                if (this.sct <= 60) break;
                this.sct = 0;
                if (this.myplayer.score > 0) {
                    --this.myplayer.score;
                }
                if (this.myplayer.score > 0) break;
                this.reason = 0;
                this.setstate(State.OVER);
                return;
            }
            case OVER: {
                this.draw_bg(graphics);
                if (this.reason == 0) {
                    this.myplayer.draw(graphics);
                }
                this.mydeathstar.draw(graphics, this.myplayer.mx, this.myplayer.my);
                this.myexplosion.draw(graphics, this.myplayer.mx, this.myplayer.my);
                this.mytitle.over(graphics, this.reason);
                break;
            }
            case COMPLETE: {
                this.draw_bg(graphics);
                this.myplayer.draw(graphics);
                this.mydeathstar.draw(graphics, this.myplayer.mx, this.myplayer.my);
                this.mytitle.welldone(graphics);
            }
        }
    }

    void draw_hud(Graphics graphics) {
        graphics.setFont(this.smlFont);
        this.fmetric = graphics.getFontMetrics(this.smlFont);
        graphics.setColor(Color.cyan);
        int n = (200 - this.fmetric.stringWidth(this.hud_text[0])) / 2;
        graphics.drawString(this.hud_text[0], n, 18);
        n = (640 - this.fmetric.stringWidth(this.hud_text[1])) / 2;
        graphics.drawString(this.hud_text[1], n, 18);
        n = (200 - this.fmetric.stringWidth(this.hud_text[2])) / 2;
        graphics.drawString(this.hud_text[2], 440 + n, 18);
        this.hud_value[1] = String.valueOf(this.myplayer.score);
        this.hud_value[2] = String.valueOf(this.myplayer.diamonds);
        graphics.setColor(Color.yellow);
        n = (640 - this.fmetric.stringWidth(this.hud_value[1])) / 2;
        graphics.drawString(this.hud_value[1], n, 36);
        n = (200 - this.fmetric.stringWidth(this.hud_value[2])) / 2;
        graphics.drawString(this.hud_value[2], 440 + n, 36);
        if (this.myplayer.diamonds == 0) {
            graphics.setColor(Color.red);
            n = 640 - this.fmetric.stringWidth("COLLECT THE DIAMONDS TO MAKE MORE TORPEDOES!") >> 1;
            graphics.drawString("COLLECT THE DIAMONDS TO MAKE MORE TORPEDOES!", n, 54);
        }
        for (int i = 0; i < 3; ++i) {
            if (this.myplayer.lives >= i + 1) {
                graphics.drawImage(sprite[4], 76 + i * 16, 21, 76 + i * 16 + 16, 37, 16, 0, 32, 16, null);
                continue;
            }
            graphics.drawImage(sprite[4], 76 + i * 16, 21, 76 + i * 16 + 16, 37, 0, 0, 16, 16, null);
        }
    }

    void draw_bg(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 480);
        for (Point point : star) {
            graphics.drawImage(sprite[3], point.x, point.y, null);
        }
        if (gamestate != State.WELCOME) {
            int n;
            if (this.myplayer.speed > 0) {
                for (n = 0; n < star.length; ++n) {
                    Menastar.star[n].x -= this.myplayer.xd * this.myplayer.speed;
                    if (Menastar.star[n].x < 0) {
                        Menastar.star[n].x = 639;
                    }
                    if (Menastar.star[n].x > 639) {
                        Menastar.star[n].x = 0;
                    }
                    Menastar.star[n].y -= this.myplayer.yd * this.myplayer.speed;
                    if (Menastar.star[n].y < 0) {
                        Menastar.star[n].y = 479;
                    }
                    if (Menastar.star[n].y <= 479) continue;
                    Menastar.star[n].y = 0;
                }
            }
            if (this.myplayer.my < 32) {
                int n2 = 0 - this.myplayer.my;
                for (n = 0; n < 672; n += 16) {
                    graphics.drawImage(sprite[0], n - this.myplayer.bx, n2, null);
                }
            }
            if (this.myplayer.my > 416) {
                int n3 = 960 - this.myplayer.my;
                for (n = 0; n < 672; n += 16) {
                    graphics.drawImage(sprite[0], n - this.myplayer.bx, n3, null);
                }
            }
            if (this.myplayer.mx < 32) {
                int n4 = 0 - this.myplayer.mx;
                for (n = 0; n < 512; n += 16) {
                    graphics.drawImage(sprite[0], n4, n - this.myplayer.by, null);
                }
            }
            if (this.myplayer.mx > 576) {
                int n5 = 1280 - this.myplayer.mx;
                for (n = 0; n < 512; n += 16) {
                    graphics.drawImage(sprite[0], n5, n - this.myplayer.by, null);
                }
            }
        }
    }

    void panic_diamonds() {
        int n = 0;
        for (Point point : diamond) {
            if (point.x != -1) continue;
            ++n;
        }
        if (this.myplayer.diamonds == 0 && n == diamond.length) {
            for (int i = 0; i < 5; ++i) {
                Menastar.diamond[i].x = 32 + (int)Math.floor(Math.random() * 1216.0);
                Menastar.diamond[i].y = 32 + (int)Math.floor(Math.random() * 896.0);
            }
        }
    }

    void setstate(State state) {
        switch (state) {
            case GAME: {
                this.mydeathstar.reset();
                this.myplayer.reset();
                this.up = false;
                this.down = false;
                for (int i = 0; i < diamond.length; ++i) {
                    Menastar.diamond[i].x = 32 + (int)Math.floor(Math.random() * 1216.0);
                    Menastar.diamond[i].y = 32 + (int)Math.floor(Math.random() * 896.0);
                }
                break;
            }
            case WELCOME: 
            case OVER: 
            case COMPLETE: {
                this.mytitle.hiscore = false;
                if (this.myplayer.score > this.hiscore) {
                    this.mytitle.hiscore = true;
                    this.hiscore = this.myplayer.score;
                }
                this.myplayer.xd = 0;
                this.myplayer.yd = 0;
            }
        }
        gamestate = state;
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    if (!this.up) break;
                    this.up = false;
                    if (this.myplayer.speed >= 2) break;
                    ++this.myplayer.speed;
                    break;
                }
                case 40: {
                    if (!this.down) break;
                    this.down = false;
                    if (this.myplayer.speed <= 0) break;
                    --this.myplayer.speed;
                    break;
                }
                case 37: {
                    if (!this.left) break;
                    this.left = false;
                    --this.myplayer.direction;
                    if (this.myplayer.direction < 0) {
                        this.myplayer.direction = 7;
                    }
                    this.myplayer.set_dir();
                    break;
                }
                case 39: {
                    if (!this.right) break;
                    this.right = false;
                    ++this.myplayer.direction;
                    if (this.myplayer.direction > 7) {
                        this.myplayer.direction = 0;
                    }
                    this.myplayer.set_dir();
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c == 'q') {
                    this.setstate(State.OVER);
                }
                if (c == ' ') {
                    this.myplayer.fire();
                }
                if (c == 'c') {
                    this.mydeathstar.cheat();
                }
                if (c != 'd') break;
                this.myplayer.score = 5;
                break;
            }
            case OVER: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
                break;
            }
            case COMPLETE: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    static {
        sprite = new Image[10];
    }

    public static enum State {
        WELCOME,
        GAME,
        OVER,
        COMPLETE;

    }
}

