/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Memory
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final String title = "Memory Challenge";
    private static final String version = "Version 2.0 (15/11/20)";
    private static final int swidth = 640;
    private static final int sheight = 480;
    private static int px;
    private static int py;
    private static int find;
    private static int range;
    private static int gx;
    private static int gy;
    private static int check;
    private static int lives;
    private static int level;
    private static int[] order;
    private static boolean reset;
    private static boolean gameover;
    private static boolean hide;
    static Zone[] mybutton;
    final Color darkgreen = new Color(0, 200, 0);
    final Color bgblue = new Color(153, 204, 255);
    Font fs = new Font("Arial", 1, 14);
    Font fb = new Font("Arial", 1, 18);
    Font fm = new Font("Arial", 1, 30);
    Font fl = new Font("Arial", 1, 40);

    public Memory() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < mybutton.length; ++i) {
            Memory.mybutton[i] = new Zone();
            Memory.mybutton[i].text = "-";
        }
        level = 0;
        reset = true;
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Memory());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (reset) {
            reset = false;
            this.setup();
        }
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 640, 480);
        graphics.setColor(this.bgblue);
        for (n2 = 0; n2 < 640; n2 += 20) {
            graphics.drawLine(n2, 0, n2, 480);
        }
        for (n2 = 0; n2 < 480; n2 += 20) {
            graphics.drawLine(0, n2, 640, n2);
        }
        graphics.setFont(this.fs);
        graphics.setColor(Color.black);
        graphics.drawString("(c)2020 SSJX", 540, 460);
        graphics.setColor(Color.blue);
        graphics.drawString("http://ssjx.co.uk", 520, 475);
        graphics.setColor(Color.gray);
        graphics.drawString(title, 2, 460);
        graphics.drawString(version, 2, 475);
        graphics.setFont(this.fb);
        graphics.setColor(Color.blue);
        graphics.drawString("Searching for " + find + " of " + range, 10, 20);
        graphics.drawString("Level: " + level, 290, 20);
        graphics.drawString("Lives: " + lives, 550, 20);
        graphics.setFont(this.fl);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.fl);
        for (int i = 0; i < gx * gy; ++i) {
            switch (Memory.mybutton[i].status) {
                case 0: {
                    graphics.setColor(Color.cyan);
                    break;
                }
                case 1: {
                    graphics.setColor(Color.yellow);
                    break;
                }
                case 2: {
                    graphics.setColor(Color.green);
                    break;
                }
                case 3: {
                    graphics.setColor(Color.red);
                }
            }
            graphics.fillRect(Memory.mybutton[i].x, Memory.mybutton[i].y, Memory.mybutton[i].w, Memory.mybutton[i].h);
            graphics.setColor(Color.red);
            graphics.drawRect(Memory.mybutton[i].x, Memory.mybutton[i].y, Memory.mybutton[i].w, Memory.mybutton[i].h);
            if (hide || Memory.mybutton[i].text.equals("-1")) continue;
            n = fontMetrics.stringWidth(Memory.mybutton[i].text);
            int n3 = (Memory.mybutton[i].w - n) / 2;
            graphics.drawString(Memory.mybutton[i].text, Memory.mybutton[i].x + n3, Memory.mybutton[i].y + 45);
        }
        if (gameover) {
            String[] stringArray = new String[]{"You did not find all of the numbers", "Click the mouse to try again!"};
            graphics.setFont(this.fm);
            fontMetrics = graphics.getFontMetrics(this.fm);
            int n4 = 0;
            for (String string : stringArray) {
                n = fontMetrics.stringWidth(string);
                graphics.setColor(Color.black);
                graphics.drawString(string, (640 - n) / 2 + 2, 372 + n4);
                graphics.setColor(this.darkgreen);
                graphics.drawString(string, (640 - n) / 2, 370 + n4);
                n4 += 30;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (gameover) {
            gameover = false;
            level = 0;
            this.setup();
        } else {
            px = mouseEvent.getX();
            py = mouseEvent.getY();
            for (int i = 0; i < gx * gy; ++i) {
                mybutton[i].check(px, py);
                if (Memory.mybutton[i].status != 1) continue;
                hide = true;
                for (int j = 0; j < gx * gy; ++j) {
                    if (Memory.mybutton[j].status != 3) continue;
                    Memory.mybutton[j].status = 0;
                }
                if (Memory.mybutton[i].text.equals("" + find)) {
                    Memory.mybutton[i].status = 2;
                    if (find == range) {
                        ++range;
                        reset = true;
                    }
                    ++find;
                    continue;
                }
                if (lives > 0) {
                    --lives;
                    Memory.mybutton[i].status = 3;
                    continue;
                }
                hide = false;
                gameover = true;
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        px = mouseEvent.getX();
        py = mouseEvent.getY();
        for (int i = 0; i < gx * gy; ++i) {
            mybutton[i].check(px, py);
        }
        this.repaint();
    }

    public void setup() {
        int n;
        int n2;
        if (level == 0) {
            lives = 3;
            gx = 3;
            gy = 2;
            range = 4;
        }
        ++level;
        find = 1;
        hide = false;
        Random random = new Random();
        if (range > gx * gy) {
            if (gx < 6) {
                ++gx;
            }
            if (gy < 5) {
                ++gy;
            }
            if (range > order.length) {
                range = order.length;
            }
        }
        Arrays.fill(order, -1);
        for (n2 = 0; n2 < range; ++n2) {
            Memory.order[n2] = 1 + n2;
        }
        for (n = 0; n < 50; ++n) {
            n2 = random.nextInt(gx * gy);
            int n3 = random.nextInt(gx * gy);
            int n4 = order[n2];
            Memory.order[n2] = order[n3];
            Memory.order[n3] = n4;
        }
        n = (640 - (gx * 70 - 10)) / 2;
        int n5 = (480 - (gy * 70 - 10)) / 2;
        int n6 = 0;
        for (int i = 0; i < gy; ++i) {
            for (int j = 0; j < gx; ++j) {
                Memory.mybutton[n6].w = 60;
                Memory.mybutton[n6].h = 60;
                Memory.mybutton[n6].x = n + j * (Memory.mybutton[n6].w + 10);
                Memory.mybutton[n6].y = n5 + i * (Memory.mybutton[n6].h + 10);
                Memory.mybutton[n6].status = 0;
                Memory.mybutton[n6].text = "" + order[n6];
                ++n6;
            }
        }
    }

    static {
        check = 0;
        lives = 3;
        level = 0;
        order = new int[30];
        mybutton = new Zone[30];
    }
}

