/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Light
extends JPanel
implements MouseListener,
KeyListener {
    final int swidth = 640;
    final int sheight = 480;
    final boolean debug = false;
    final int fps = 30;
    final int fpsdelay = 33;
    static final String title = "Light Cycles";
    static final String version = "Version 0.2 (17/02/20)";
    String[] line;
    Selector arenaselect;
    Thread runner;
    int[] pleft = new int[2];
    int[] pright = new int[2];
    int[] px = new int[2];
    int[] py = new int[2];
    int[] pdir = new int[2];
    int[] pcolor = new int[2];
    boolean[] phit = new boolean[2];
    States gamestate = States.WELCOME;
    int arena = 0;
    final Color p0color = Color.white;
    final Color p1color = Color.red;
    boolean gridcls;
    FontMetrics fmetric;
    final Font fs = new Font("Arial", 1, 14);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 1, 30);
    BufferedImage offscreen;

    @Override
    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Light() {
        this.line = new String[20];
        this.arenaselect = new Selector();
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addMouseListener(this);
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Light.this.repaint();
                    try {
                        Thread.sleep(33L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Light());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void resetgame() {
        this.pcolor[0] = this.p0color.getRGB();
        this.pcolor[1] = this.p1color.getRGB();
        this.px[0] = 420;
        this.px[1] = 220;
        this.pdir[0] = 4;
        this.pdir[1] = 2;
        this.phit[0] = false;
        this.phit[1] = false;
        this.py[0] = 240;
        this.py[1] = this.py[0];
        this.gridcls = true;
        this.arena = this.arenaselect.highlight;
    }

    public void setstate(States states) {
        switch (states) {
            case WELCOME: {
                this.gamestate = States.GAME;
                this.resetgame();
                break;
            }
            case OVER: {
                this.gamestate = States.WELCOME;
                break;
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Object object;
        if (this.offscreen == null) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.offscreen = graphicsConfiguration.createCompatibleImage(this.getSize().width, this.getSize().height);
        }
        object = this.offscreen.getGraphics();
        switch (this.gamestate) {
            case WELCOME: {
                int n;
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                graphics.setColor(new Color(30, 30, 128));
                for (n = 0; n < 640; n += 32) {
                    graphics.drawLine(n, 0, n, 480);
                }
                for (n = 0; n < 480; n += 32) {
                    graphics.drawLine(0, n, 640, n);
                }
                for (n = 0; n < this.line.length; ++n) {
                    this.line[n] = "";
                }
                this.line[0] = title;
                this.line[1] = "";
                this.line[2] = "Try and survive the grid!";
                this.line[3] = "Avoid the walls and trails whilst trying to crash your opponent";
                this.line[4] = "";
                this.line[5] = "Controls";
                this.line[6] = "Player 1 : Z , X";
                this.line[7] = "Player 2 : Left, Right";
                this.line[8] = "Q - Quit";
                this.line[9] = "";
                this.line[10] = "";
                this.line[11] = "";
                this.line[12] = "";
                this.line[13] = "";
                this.line[14] = "Select an arena:";
                block22: for (n = 0; n < this.line.length; ++n) {
                    switch (n) {
                        case 0: {
                            graphics.setColor(Color.yellow);
                            this.ctext(graphics, this.fm, this.line[n], 60 + n * 18);
                            continue block22;
                        }
                        case 5: 
                        case 10: 
                        case 14: {
                            graphics.setColor(Color.cyan);
                            this.ctext(graphics, this.fb, this.line[n], 60 + n * 18);
                            continue block22;
                        }
                        default: {
                            graphics.setColor(Color.white);
                            this.ctext(graphics, this.fs, this.line[n], 60 + n * 18);
                        }
                    }
                }
                this.arenaselect.draw(graphics);
                break;
            }
            case OVER: {
                this.box(graphics);
                graphics.setColor(Color.red);
                if (this.phit[0] && !this.phit[1]) {
                    graphics.setColor(this.p0color);
                    this.ctext(graphics, this.fb, "Player 1 Destroyed!", 250);
                    graphics.setColor(this.p1color);
                    this.ctext(graphics, this.fb, "Player 2 Wins!", 220);
                }
                if (this.phit[1] && !this.phit[0]) {
                    graphics.setColor(this.p1color);
                    this.ctext(graphics, this.fb, "Player 2 Destroyed!", 250);
                    graphics.setColor(this.p0color);
                    this.ctext(graphics, this.fb, "Player 1 Wins!", 220);
                }
                if (!this.phit[1] || !this.phit[0]) break;
                graphics.setColor(Color.yellow);
                this.ctext(graphics, this.fb, "Both Players Destroyed!", 250);
                this.ctext(graphics, this.fb, "No Winner.", 220);
                break;
            }
            case GAME: {
                if (this.gridcls) {
                    int n;
                    this.gridcls = false;
                    ((Graphics)object).setColor(Color.black);
                    ((Graphics)object).fillRect(0, 0, 640, 480);
                    ((Graphics)object).setColor(new Color(30, 30, 128));
                    for (n = 0; n < 640; n += 32) {
                        ((Graphics)object).drawLine(n, 0, n, 480);
                    }
                    for (n = 0; n < 480; n += 32) {
                        ((Graphics)object).drawLine(0, n, 640, n);
                    }
                    ((Graphics)object).setColor(Color.cyan);
                    ((Graphics)object).drawRect(0, 0, 639, 459);
                    ((Graphics)object).drawRect(1, 1, 637, 457);
                    switch (this.arena) {
                        case 1: {
                            ((Graphics)object).setColor(Color.cyan);
                            ((Graphics)object).drawRect(20, 20, 120, 120);
                            ((Graphics)object).drawRect(20, 320, 120, 120);
                            ((Graphics)object).drawRect(500, 20, 120, 120);
                            ((Graphics)object).drawRect(500, 320, 120, 120);
                            break;
                        }
                        case 2: {
                            ((Graphics)object).setColor(Color.cyan);
                            ((Graphics)object).drawRect(160, 110, 320, 240);
                            ((Graphics)object).drawRect(159, 109, 322, 242);
                        }
                    }
                }
                block25: for (int i = 0; i < 2; ++i) {
                    if (this.pright[i] == 1) {
                        int n = i;
                        this.pdir[n] = this.pdir[n] + 1;
                        if (this.pdir[i] > 4) {
                            this.pdir[i] = 1;
                        }
                        this.pright[i] = 2;
                    }
                    if (this.pleft[i] == 1) {
                        int n = i;
                        this.pdir[n] = this.pdir[n] - 1;
                        if (this.pdir[i] < 1) {
                            this.pdir[i] = 4;
                        }
                        this.pleft[i] = 2;
                    }
                    switch (this.pdir[i]) {
                        case 1: {
                            int n = i;
                            this.py[n] = this.py[n] - 1;
                            continue block25;
                        }
                        case 2: {
                            int n = i;
                            this.px[n] = this.px[n] + 1;
                            continue block25;
                        }
                        case 3: {
                            int n = i;
                            this.py[n] = this.py[n] + 1;
                            continue block25;
                        }
                        case 4: {
                            int n = i;
                            this.px[n] = this.px[n] - 1;
                        }
                    }
                }
                if (this.px[0] == this.px[1] && this.py[0] == this.py[1]) {
                    this.phit[0] = true;
                    this.phit[1] = true;
                }
                if (this.offscreen.getRGB(this.px[0], this.py[0]) == this.pcolor[1]) {
                    this.phit[0] = true;
                }
                if (this.offscreen.getRGB(this.px[1], this.py[1]) == this.pcolor[0]) {
                    this.phit[1] = true;
                }
                if (this.offscreen.getRGB(this.px[0], this.py[0]) == this.pcolor[0]) {
                    this.phit[0] = true;
                }
                if (this.offscreen.getRGB(this.px[1], this.py[1]) == this.pcolor[1]) {
                    this.phit[1] = true;
                }
                if (this.offscreen.getRGB(this.px[0], this.py[0]) == Color.cyan.getRGB()) {
                    this.phit[0] = true;
                }
                if (this.offscreen.getRGB(this.px[1], this.py[1]) == Color.cyan.getRGB()) {
                    this.phit[1] = true;
                }
                ((Graphics)object).setColor(Color.white);
                ((Graphics)object).drawLine(this.px[0], this.py[0], this.px[0], this.py[0]);
                ((Graphics)object).setColor(Color.red);
                ((Graphics)object).drawLine(this.px[1], this.py[1], this.px[1], this.py[1]);
                if (this.phit[0] || this.phit[1]) {
                    this.gamestate = States.OVER;
                }
                graphics.drawImage(this.offscreen, 0, 0, null);
                ((Graphics)object).dispose();
            }
        }
        graphics.setColor(new Color(128, 0, 0));
        graphics.fillRect(0, 460, 640, 20);
        graphics.setFont(this.fs);
        graphics.setColor(Color.yellow);
        graphics.drawLine(0, 460, 640, 460);
        graphics.drawString("http://ssjx.co.uk", 528, 475);
        graphics.drawString(version, 2, 475);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.gamestate == States.WELCOME) {
            if (this.arenaselect.hit(n, n2) != -1) {
                this.gamestate = States.GAME;
                this.resetgame();
            }
        } else {
            this.setstate(this.gamestate);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                if (this.pright[0] == 0 && this.pleft[0] == 0) {
                    this.pright[0] = 1;
                }
                if (this.gamestate != States.WELCOME) break;
                this.arenaselect.next();
                break;
            }
            case 37: {
                if (this.pright[0] == 0 && this.pleft[0] == 0) {
                    this.pleft[0] = 1;
                }
                if (this.gamestate != States.WELCOME) break;
                this.arenaselect.prev();
                break;
            }
            case 88: {
                if (this.pright[1] == 0 && this.pleft[1] == 0) {
                    this.pright[1] = 1;
                }
                if (this.gamestate != States.WELCOME) break;
                this.arenaselect.next();
                break;
            }
            case 90: {
                if (this.pright[1] == 0 && this.pleft[1] == 0) {
                    this.pleft[1] = 1;
                }
                if (this.gamestate != States.WELCOME) break;
                this.arenaselect.prev();
                break;
            }
            case 32: {
                this.setstate(this.gamestate);
                break;
            }
            case 81: {
                this.gamestate = States.WELCOME;
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.pright[0] = 0;
                break;
            }
            case 37: {
                this.pleft[0] = 0;
                break;
            }
            case 88: {
                this.pright[1] = 0;
                break;
            }
            case 90: {
                this.pleft[1] = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void box(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(195, 190, 250, 100);
        graphics.setColor(Color.cyan);
        graphics.drawRect(195, 190, 250, 100);
        graphics.drawRect(197, 192, 246, 96);
    }

    public void ctext(Graphics graphics, Font font, String string, int n) {
        graphics.setFont(font);
        this.fmetric = graphics.getFontMetrics(font);
        graphics.drawString(string, (640 - this.fmetric.stringWidth(string)) / 2, n);
    }

    private static enum States {
        WELCOME,
        GAME,
        OVER;

    }
}

