/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

public class Shot {
    int x;
    int y;
    int type;
    int owner;
    int xdir;
    int ydir;
    int active;
    private static final Rectangle player = new Rectangle(26, 32);
    private final Rectangle bomb = new Rectangle(8, 16);
    private static boolean gfxloaded = false;
    private static Image[] sprite = new Image[2];

    public Shot() {
        this.clear();
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/shot.gif");
                Shot.sprite[0] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/bomb.gif");
                Shot.sprite[1] = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the shots...");
            }
        }
    }

    public void clear() {
        this.x = 0;
        this.y = 0;
        this.xdir = 0;
        this.ydir = 0;
        this.active = 0;
    }

    public void move() {
        if (this.active == 1) {
            this.x += this.xdir * 4;
            this.y += this.ydir * 4;
            if (this.y < 0 || this.y > 480) {
                this.clear();
            }
            if (this.x < 0 || this.x > 640) {
                this.clear();
            }
        }
    }

    public void draw(Graphics graphics) {
        if (this.active == 1) {
            graphics.drawImage(sprite[this.owner], this.x, this.y, null);
        }
    }

    public void fire(int n, int n2, int n3, int n4, int n5) {
        if (this.active == 0) {
            this.owner = n5;
            this.x = n3 == -1 ? n : n + 24;
            this.y = n2 + 6;
            this.xdir = n3;
            this.ydir = 0;
            this.active = 1;
        }
    }

    public void bomb(int n, int n2, int n3) {
        if (this.active == 0) {
            this.owner = n3;
            this.x = n + 12;
            this.y = n2 + 14;
            this.xdir = 0;
            this.ydir = 1;
            this.active = 1;
        }
    }

    public int playerhit(int n, int n2) {
        if (this.active == 1) {
            player.setLocation(n, n2);
            this.bomb.setLocation(this.x, this.y);
            if (player.intersects(this.bomb)) {
                return 1;
            }
        }
        return 0;
    }
}

