/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Map {
    int[][] data = new int[20][20];
    int[][] col = new int[20][20];
    int guagex;
    int width;
    int height;
    int zones;
    private int tiles;
    private static Image[] block = new Image[4];
    private static final boolean debug = false;

    public Map() {
        try {
            URL uRL = this.getClass().getResource("gfx/platform.gif");
            Map.block[1] = ImageIO.read(uRL);
            uRL = this.getClass().getResource("gfx/platform2.gif");
            Map.block[2] = ImageIO.read(uRL);
            uRL = this.getClass().getResource("gfx/dia_sml2.gif");
            Map.block[3] = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the Map sprites...");
        }
    }

    public void remove(int n) {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.data[j][i] != n) continue;
                this.data[j][i] = 0;
                this.col[j][i] = 0;
            }
        }
    }

    public void clear(int n, int n2) {
        this.data[n][n2] = 0;
        this.col[n][n2] = 0;
    }

    public int count(int n) {
        int n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                if (this.data[j][i] != n) continue;
                ++n2;
            }
        }
        return n2;
    }

    public void update(Collide[] collideArray) {
        this.zones = 0;
        this.tiles = 0;
        for (int i = 0; i < this.height; ++i) {
            block6: for (int j = 0; j < this.width; ++j) {
                if (this.data[j][i] <= 0) continue;
                ++this.tiles;
                switch (this.col[j][i]) {
                    case 0: 
                    case 21: 
                    case 22: 
                    case 23: {
                        continue block6;
                    }
                    case 3: {
                        collideArray[this.zones].mx = j;
                        collideArray[this.zones].my = i;
                        collideArray[this.zones].set(j * 32 + 8, i * 32 + 16, this.col[j][i]);
                        ++this.zones;
                        continue block6;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        collideArray[this.zones].mx = j;
                        collideArray[this.zones].my = i;
                        collideArray[this.zones].set(j * 32, i * 32, this.col[j][i]);
                        ++this.zones;
                        continue block6;
                    }
                    default: {
                        collideArray[this.zones].mx = j * 32;
                        collideArray[this.zones].my = i * 32;
                        collideArray[this.zones].set(j * 32, i * 32, this.col[j][i]);
                        ++this.zones;
                    }
                }
            }
        }
    }

    public void draw(Graphics graphics) {
        for (int i = 0; i < 20; ++i) {
            for (int j = 0; j < 15; ++j) {
                if (this.data[i][j] >= 4) continue;
                graphics.drawImage(block[this.data[i][j]], i * 32, j * 32, null);
            }
        }
    }

    public void load(int n) {
        int n2 = 0;
        try {
            if (n == 1 || n == 4 || n == 7) {
                n2 = 1;
            }
            if (n == 2 || n == 5 || n == 8) {
                n2 = 2;
            }
            if (n == 3 || n == 6 || n == 9) {
                n2 = 3;
            }
            URL uRL = this.getClass().getResource("maps/level" + n2 + ".bmp");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n5 = bufferedImage.getRGB(j, i);
                    int n6 = n5 & 0xFF;
                    int n7 = (n5 & 0xFF00) >> 8;
                    int n8 = (n5 & 0xFF0000) >> 16;
                    if (n8 < 0) {
                        n8 += 256;
                    }
                    if (n7 < 0) {
                        n7 += 256;
                    }
                    if (n6 < 0) {
                        n6 += 256;
                    }
                    this.data[j][i] = 0;
                    this.col[j][i] = 0;
                    if (n8 == 0 && n7 == 0 && n6 == 0) {
                        this.data[j][i] = 1;
                        this.col[j][i] = 1;
                    }
                    if (n8 == 0 && n7 == 0 && n6 == 255) {
                        this.data[j][i] = 2;
                        this.col[j][i] = 1;
                        this.guagex = j * 32 + 32;
                    }
                    if (n8 == 0 && n7 == 255 && n6 == 0) {
                        this.data[j][i] = 0;
                        this.col[j][i] = 11 + n3;
                        ++n3;
                    }
                    if (n8 == 128 && n7 == 0 && n6 == 255) {
                        this.col[j][i] = 21 + n4;
                        this.data[j][i] = 0;
                        ++n4;
                    }
                    if (n8 == 255 && n7 == 128 && n6 == 0) {
                        this.data[j][i] = 3;
                        this.col[j][i] = 3;
                    }
                    if (n8 == 255 && n7 == 0 && n6 == 255) {
                        this.data[j][i] = 7;
                    }
                    if (n8 != 255 || n7 != 0 || n6 != 0) continue;
                    this.data[j][i] = 0;
                    this.col[j][i] = 10;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Load Map file error caught...");
        }
    }
}

