/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

public class Item {
    private static final boolean debug = false;
    private static final Rectangle player = new Rectangle(26, 32);
    private final Rectangle block = new Rectangle(32, 32);
    private final Rectangle target = new Rectangle(32, 32);
    int x;
    int y;
    int type = -1;
    int carried;
    int home = 0;
    private static boolean gfxloaded = false;
    private static Image[] sprite = new Image[15];

    public Item() {
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/ship1.png");
                Item.sprite[0] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/ship2.png");
                Item.sprite[1] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/ship3.png");
                Item.sprite[2] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/dia_green.png");
                Item.sprite[3] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/outline1.png");
                Item.sprite[10] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/outline2.png");
                Item.sprite[11] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/outline3.png");
                Item.sprite[12] = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Item sprites...");
            }
        }
    }

    public void set(int n, int n2, int n3) {
        this.type = n3;
        if (this.type == 3) {
            this.block.width = 16;
            this.block.height = 16;
        }
        this.pos(n, n2);
        this.home = 0;
    }

    public void settarget(int n, int n2) {
        this.target.setLocation(n, n2);
    }

    public void move(Collide[] collideArray) {
        int n = 0;
        if (this.home != 0 || this.type == -1) {
            return;
        }
        for (int i = 0; i < collideArray.length && (n = this.type == 3 ? collideArray[i].diahit(this.x, this.y + 2) : collideArray[i].nmehit(this.x, this.y + 2)) == 0; ++i) {
        }
        if (n == 0) {
            this.y += 2;
            this.pos(this.x, this.y);
        }
    }

    public void pos(int n, int n2) {
        if (this.type == -1) {
            return;
        }
        this.x = n;
        this.y = n2;
        this.block.setLocation(this.x, this.y);
        if (this.type != 3 && this.block.intersects(this.target)) {
            this.x = this.target.x;
            this.y = this.target.y;
            this.home = 1;
            this.block.setLocation(this.x, this.y);
        }
    }

    public void cheat() {
        this.home = 1;
        this.x = this.target.x;
        this.y = this.target.y;
        this.block.setLocation(this.x, this.y);
    }

    public void draw(Graphics graphics) {
        if (this.type == -1) {
            return;
        }
        if (this.type == 3) {
            graphics.drawImage(sprite[3], this.x, this.y, this.x + 16, this.y + 16, 0, 0, 16, 16, null);
        } else {
            graphics.drawImage(sprite[this.type], this.x, this.y, null);
        }
        if (this.home == 0) {
            graphics.drawImage(sprite[this.type + 10], this.target.x, this.target.y, null);
        }
    }

    public int hit(int n, int n2) {
        if (this.home == 0) {
            player.setLocation(n, n2);
            if (player.intersects(this.block)) {
                return this.type;
            }
        }
        return -1;
    }
}

