/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;

public class Explosion {
    int active = 0;
    private int dist;
    private int bx;
    private int by;
    private static Image sprite;
    private static boolean gfxloaded;

    public Explosion() {
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/explosion.png");
                sprite = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the explosion sprite...");
            }
        }
    }

    public void clear() {
        this.active = 0;
        this.dist = 0;
    }

    public void set(int n, int n2) {
        this.active = 1;
        this.dist = 0;
        this.bx = n;
        this.by = n2;
    }

    public void move(Map map) {
        ++this.dist;
        if (this.dist >= 30) {
            this.clear();
        }
    }

    public void draw(Graphics graphics) {
        if (this.active == 0) {
            return;
        }
        graphics.drawImage(sprite, this.bx, this.by + this.dist, null);
        graphics.drawImage(sprite, this.bx + this.dist, this.by, null);
        graphics.drawImage(sprite, this.bx, this.by - this.dist, null);
        graphics.drawImage(sprite, this.bx - this.dist, this.by, null);
        int n = (int)((double)this.dist * 0.75);
        graphics.drawImage(sprite, this.bx + n, this.by + n, null);
        graphics.drawImage(sprite, this.bx - n, this.by - n, null);
        graphics.drawImage(sprite, this.bx + n, this.by - n, null);
        graphics.drawImage(sprite, this.bx - n, this.by + n, null);
    }

    static {
        gfxloaded = false;
    }
}

