/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class Enemy {
    private static final boolean debug = false;
    private final int width = 32;
    private int initialtype = 0;
    private static final Rectangle player = new Rectangle(26, 32);
    private final Rectangle block = new Rectangle(32, 32);
    int active = 0;
    int type = 0;
    int x;
    int y;
    private int startx;
    private int starty;
    int xdir;
    int ydir;
    private int frame = 0;
    private int fstep = 0;
    private int firecount;
    private Random rand = new Random();
    private static boolean gfxloaded = false;
    private static Image[] sprite = new Image[4];

    public Enemy() {
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("enemy/flyer1.gif");
                Enemy.sprite[0] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("enemy/flyer2.gif");
                Enemy.sprite[1] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("enemy/comet2.png");
                Enemy.sprite[2] = ImageIO.read(uRL);
                uRL = this.getClass().getResource("enemy/comet2.png");
                Enemy.sprite[3] = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the enemy sprites...");
            }
        }
    }

    public void startpos(int n, int n2) {
        this.startx = n;
        this.starty = n2;
        this.x = this.startx;
        this.y = this.starty;
        this.xdir = 0;
        if (this.active == 1) {
            this.xdir = this.randdir();
        }
        if (this.active == 2) {
            this.xdir = this.randdir();
        }
        this.ydir = 0;
        this.firecount = 50 + this.rand.nextInt(50);
        this.initialtype = this.active;
    }

    public void move(Collide[] collideArray) {
        if (this.firecount > 0) {
            --this.firecount;
        }
        switch (this.active) {
            case 1: {
                if (this.dirclear(this.xdir, 0, collideArray) == 0) {
                    this.x += this.xdir;
                } else {
                    this.xdir *= -1;
                }
                if (this.x < 0) {
                    this.xdir = 1;
                }
                if (this.x <= 608) break;
                this.xdir = -1;
                break;
            }
            case 2: {
                this.x += this.xdir;
                this.y += 2;
                if (this.x < 0) {
                    this.xdir = 1;
                }
                if (this.x > 608) {
                    this.xdir = -1;
                }
                if (this.y <= 480) break;
                this.respawn();
            }
        }
        ++this.fstep;
        if (this.fstep == 16) {
            this.frame = 1 - this.frame;
            this.fstep = 0;
        }
    }

    private int dirclear(int n, int n2, Collide[] collideArray) {
        int n3 = 0;
        int n4 = 0;
        int n5 = this.x;
        int n6 = this.y;
        n5 += n;
        n6 += n2;
        for (int i = 0; i < collideArray.length; ++i) {
            n4 = collideArray[i].nmehit(n5, n6);
            if (n4 == 0) continue;
            n3 = 1;
            break;
        }
        return n3;
    }

    public void draw(Graphics graphics) {
        if (this.active == 0) {
            return;
        }
        switch (this.active) {
            case 1: {
                graphics.drawImage(sprite[this.frame], this.x, this.y, null);
                break;
            }
            case 2: {
                graphics.drawImage(sprite[2 + this.frame], this.x, this.y, null);
            }
        }
    }

    public int hit(int n, int n2) {
        int n3 = 0;
        if (this.active != 0) {
            this.block.setLocation(this.x, this.y);
            if (this.block.contains(n, n2)) {
                n3 = 1;
                this.active = 0;
            }
        }
        return n3;
    }

    public void respawn() {
        this.active = this.initialtype;
        switch (this.active) {
            case 1: {
                this.y = this.rand.nextInt(10) * 32;
                if (this.randdir() == 1) {
                    this.x = -64;
                    this.xdir = 1;
                    break;
                }
                this.x = 672;
                this.xdir = -1;
                break;
            }
            case 2: {
                this.xdir = this.randdir();
                this.x = 20 + this.rand.nextInt(600);
                this.y = -40;
                this.y += 2;
            }
        }
    }

    public int fire() {
        if (this.active == 1 && this.firecount == 0 && this.rand.nextInt(100) == 50) {
            this.firecount = 100;
            return 1;
        }
        return 0;
    }

    public int hitplayer(int n, int n2) {
        if (this.active != 0) {
            player.setLocation(n, n2);
            this.block.setLocation(this.x, this.y);
            if (player.intersects(this.block)) {
                return 1;
            }
        }
        return 0;
    }

    private int randdir() {
        int n = 1;
        if (this.rand.nextInt(9) <= 4) {
            n = -1;
        }
        return n;
    }
}

