/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Random;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Armour
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    static final int swidth = 640;
    static final int sheight = 480;
    public static final int fps = 60;
    public static int fpsdelay = 16;
    static final int debug = 0;
    static final String title = "Armour Ranger : Jet Pac III";
    static final String version = "v0.1 (28/05/20)";
    String[] line;
    int level;
    int moveleft = 0;
    int moveright = 0;
    int movejump = 0;
    int moveup = 0;
    int movedown = 0;
    int movefire = 0;
    int firedelay;
    int lclear;
    int rclear;
    int uclear;
    int dclear;
    int onladder;
    int cclear;
    int power;
    int diamonds;
    int score;
    int hiscore;
    int prevscore;
    int reqpart;
    Image full_square;
    Image empty_square;
    Image dia_green;
    Image bg_img;
    Map mymap;
    Enemy[] myenemy;
    Player myplayer;
    Explosion[] explo;
    Collide[] zone;
    Item[] part;
    Random rand;
    Shot[] myshot;
    FontMetrics fmetric;
    final Font fs = new Font("Arial", 1, 16);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 3, 34);
    State gamestate = State.WELCOME;
    final String green_text = "* Collect Green Diamonds! *";

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Armour() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.init();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Armour.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Armour());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void init() {
        int n;
        this.rand = new Random();
        this.line = new String[30];
        this.myplayer = new Player();
        this.myenemy = new Enemy[20];
        for (n = 0; n < this.myenemy.length; ++n) {
            this.myenemy[n] = new Enemy();
        }
        this.part = new Item[5];
        for (n = 0; n < this.part.length; ++n) {
            this.part[n] = new Item();
        }
        this.zone = new Collide[80];
        for (n = 0; n < this.zone.length; ++n) {
            this.zone[n] = new Collide();
        }
        this.myshot = new Shot[40];
        for (n = 0; n < this.myshot.length; ++n) {
            this.myshot[n] = new Shot();
        }
        this.explo = new Explosion[20];
        for (n = 0; n < this.explo.length; ++n) {
            this.explo[n] = new Explosion();
        }
        this.mymap = new Map();
        try {
            URL uRL = this.getClass().getResource("gfx/square1.gif");
            this.full_square = new ImageIcon(uRL).getImage();
            uRL = this.getClass().getResource("gfx/square2.gif");
            this.empty_square = new ImageIcon(uRL).getImage();
            uRL = this.getClass().getResource("gfx/dia_green.png");
            this.dia_green = new ImageIcon(uRL).getImage();
            uRL = this.getClass().getResource("gfx/background.png");
            this.bg_img = new ImageIcon(uRL).getImage();
        }
        catch (Exception exception) {
            System.out.println("Problem loading the main sprites...");
        }
        this.hiscore = 10;
        this.prevscore = 0;
        this.setstate(State.WELCOME);
    }

    public void startgame() {
        if (this.level == 1) {
            this.power = 5;
        }
        this.diamonds = 0;
        this.firedelay = 0;
        this.setlevel(this.level);
    }

    public void setlevel(int n) {
        int n2;
        this.mymap.load(n);
        for (n2 = 0; n2 < this.myenemy.length; ++n2) {
            this.myenemy[n2].active = 0;
        }
        for (n2 = 0; n2 < this.myshot.length; ++n2) {
            this.myshot[n2].clear();
        }
        for (n2 = 0; n2 < this.explo.length; ++n2) {
            this.explo[n2].clear();
        }
        n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 1 || n == 2 || n == 3) {
            bl2 = true;
        }
        if (n == 4 || n == 5 || n == 6) {
            bl = true;
        }
        if (n == 7 || n == 8 || n == 9) {
            bl2 = true;
            bl = true;
        }
        for (int i = 0; i < this.mymap.width; ++i) {
            block9: for (int j = 0; j < this.mymap.height; ++j) {
                if (this.mymap.data[i][j] == 7) {
                    this.myplayer.x = i * 32;
                    this.myplayer.y = j * 32;
                }
                switch (this.mymap.col[i][j]) {
                    case 10: {
                        if (bl2) {
                            this.myenemy[n2].active = 2;
                            this.myenemy[n2].startpos(i * 32, j * 32 + 16);
                            ++n2;
                        }
                        if (bl) {
                            this.myenemy[n2].active = 1;
                            this.myenemy[n2].startpos(i * 32, j * 32 + 16);
                            ++n2;
                        }
                        this.mymap.col[i][j] = 0;
                        continue block9;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        this.part[n3].set(i * 32, j * 32, n3);
                        ++n3;
                        this.mymap.col[i][j] = 0;
                        this.mymap.data[i][j] = 0;
                        continue block9;
                    }
                    case 21: 
                    case 22: 
                    case 23: {
                        this.part[n4].settarget(i * 32, j * 32);
                        ++n4;
                        this.mymap.data[i][j] = 0;
                        this.mymap.col[i][j] = 0;
                    }
                }
            }
        }
        this.part[4].type = -1;
        this.mymap.update(this.zone);
        this.reqpart = 2;
    }

    public void addexplosion(int n, int n2) {
        for (int i = 0; i < this.explo.length; ++i) {
            if (this.explo[i].active != 0) continue;
            this.explo[i].set(n, n2);
            break;
        }
    }

    void draw_bg(Graphics graphics) {
        graphics.drawImage(this.bg_img, 0, 0, null);
    }

    /*
     * WARNING - void declaration
     */
    void draw_game(Graphics graphics) {
        int n;
        this.draw_bg(graphics);
        this.mymap.draw(graphics);
        for (Item object : this.part) {
            object.draw(graphics);
        }
        for (Shot shot : this.myshot) {
            shot.draw(graphics);
        }
        for (Enemy enemy : this.myenemy) {
            enemy.draw(graphics);
        }
        this.myplayer.draw(graphics);
        for (Explosion explosion : this.explo) {
            explosion.draw(graphics);
        }
        graphics.setColor(Color.yellow);
        graphics.setFont(this.fs);
        graphics.drawString(String.valueOf(this.score), 2, 16);
        for (n = 0; n < 5; ++n) {
            if (this.power <= n) {
                graphics.drawImage(this.full_square, 620 - n * 16, 4, null);
                continue;
            }
            graphics.drawImage(this.empty_square, 620 - n * 16, 4, null);
        }
        if (this.reqpart == -1) {
            void var5_14;
            this.fmetric = graphics.getFontMetrics(this.fs);
            n = 640 - this.fmetric.stringWidth("* Collect Green Diamonds! *") >> 1;
            graphics.drawString("* Collect Green Diamonds! *", n, 16);
            int n2 = this.mymap.guagex;
            boolean bl = false;
            while (var5_14 < 5) {
                int n3 = 432 - var5_14 * 16;
                if (this.diamonds <= var5_14) {
                    graphics.drawImage(this.dia_green, n2, n3, n2 + 16, n3 + 16, 16, 0, 32, 16, null);
                } else {
                    graphics.drawImage(this.dia_green, n2, n3, n2 + 16, n3 + 16, 0, 0, 16, 16, null);
                }
                ++var5_14;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.gamestate) {
            case GAME: {
                this.maingame();
                this.draw_game(graphics);
                break;
            }
            case WELCOME: {
                for (int i = 0; i < this.line.length; ++i) {
                    this.line[i] = "";
                }
                this.score = 0;
                this.draw_bg(graphics);
                graphics.setColor(Color.black);
                graphics.fillRect(50, 100, 540, 280);
                graphics.setColor(Color.green);
                graphics.drawRect(50, 100, 540, 280);
                graphics.setFont(this.fs);
                graphics.setColor(Color.white);
                graphics.drawString("http://ssjx.co.uk", 518, 475);
                graphics.drawString(version, 2, 475);
                graphics.drawString("High Score:" + String.valueOf(this.hiscore), 2, 18);
                this.line[0] = title;
                this.line[1] = "";
                this.line[2] = "A cargo ship carrying Alliance rockets was attacked!";
                this.line[3] = "Visit the planets these rockets crashed into and recover them!";
                this.line[4] = "";
                this.line[5] = "Your mission is to:";
                this.line[6] = "- Collect and assemble the rocket";
                this.line[7] = "- Collect green diamonds to power it";
                this.line[8] = "";
                this.line[9] = "Watch out as Enemy forces have been spotted in the area!";
                this.line[10] = "";
                this.line[11] = "Click / Space to Start!";
                int n = 0;
                boolean bl = false;
                for (int i = 0; i < this.line.length; ++i) {
                    Color color;
                    switch (i) {
                        case 0: {
                            graphics.setFont(this.fm);
                            this.fmetric = graphics.getFontMetrics(this.fm);
                            color = Color.yellow;
                            bl = true;
                            break;
                        }
                        case 11: {
                            graphics.setFont(this.fm);
                            this.fmetric = graphics.getFontMetrics(this.fm);
                            color = Color.cyan;
                            bl = true;
                            break;
                        }
                        default: {
                            graphics.setFont(this.fs);
                            this.fmetric = graphics.getFontMetrics(this.fs);
                            color = Color.green;
                            bl = false;
                        }
                    }
                    if (this.line[i].length() <= 0) continue;
                    n = 640 - this.fmetric.stringWidth(this.line[i]) >> 1;
                    if (bl) {
                        graphics.setColor(Color.black);
                        graphics.drawString(this.line[i], 2 + n, 74 + i * 32);
                    }
                    graphics.setColor(color);
                    graphics.drawString(this.line[i], n, 72 + i * 32);
                }
                break;
            }
            case READY: {
                for (int i = 0; i < this.line.length; ++i) {
                    this.line[i] = "";
                }
                this.draw_bg(graphics);
                this.mymap.draw(graphics);
                this.line[0] = "Level " + this.level;
                this.line[1] = "Click / Space to Continue";
                this.infobox(graphics);
                break;
            }
            case OVER: {
                this.draw_game(graphics);
                for (int i = 0; i < this.line.length; ++i) {
                    this.line[i] = "";
                }
                this.line[0] = "Mission Failed";
                if (this.score > this.hiscore) {
                    this.line[1] = "New high score!";
                }
                this.line[2] = "Click / Space to Continue";
                this.infobox(graphics);
                break;
            }
            case WELLDONE: {
                this.draw_game(graphics);
                for (int i = 0; i < this.line.length; ++i) {
                    this.line[i] = "";
                }
                this.line[0] = "Mission " + this.level + " Completed!";
                this.line[1] = "On to the next mission";
                this.line[2] = "Click / Space to Continue";
                this.infobox(graphics);
                break;
            }
            case COMPLETED: {
                this.draw_game(graphics);
                for (int i = 0; i < this.line.length; ++i) {
                    this.line[i] = "";
                }
                this.line[0] = "All Missions Completed!";
                if (this.score > this.hiscore) {
                    this.line[1] = "New high score!";
                }
                this.line[2] = "Click / Space to Continue";
                this.infobox(graphics);
            }
        }
    }

    public void maingame() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.mymap.zones; ++n2) {
            for (n = 0; n < this.myshot.length; ++n) {
                if (this.myshot[n].active != 1 || this.zone[n2].pointhit(this.myshot[n].x + 4, this.myshot[n].y + 4) <= 0) continue;
                this.addexplosion(this.myshot[n].x + 4, this.myshot[n].y + 4);
                this.myshot[n].clear();
            }
        }
        for (n2 = 0; n2 < this.part.length; ++n2) {
            this.part[n2].move(this.zone);
            if (this.part[n2].hit(this.myplayer.x, this.myplayer.y) != 3) continue;
            this.part[n2].type = -1;
            this.score += 20;
            ++this.diamonds;
            if (this.diamonds < 5) {
                this.part[4].set(20 + this.rand.nextInt(600), 0, 3);
            }
            if (this.diamonds != 5) continue;
            ++this.level;
            if (this.level < 10) {
                this.setstate(State.READY);
                continue;
            }
            this.setstate(State.COMPLETED);
        }
        if (this.moveright == 1) {
            if (this.myplayer.x + 26 < 640) {
                this.myplayer.xdir = 1;
                this.rclear = this.dirclear(2, 0);
                if (this.rclear == 0 && this.myplayer.crouch == 0) {
                    this.myplayer.x += 2;
                    this.myplayer.update();
                }
            }
        }
        if (this.moveleft == 1 && this.myplayer.x > 0) {
            this.myplayer.xdir = -1;
            this.lclear = this.dirclear(-2, 0);
            if (this.lclear == 0 && this.myplayer.crouch == 0) {
                this.myplayer.x -= 2;
                this.myplayer.update();
            }
        }
        if (this.moveup == 1 && this.myplayer.y > 0) {
            this.uclear = this.dirclear(0, -2);
            if (this.uclear == 0) {
                this.myplayer.ydir = 1;
                this.myplayer.y -= 2;
            }
        } else {
            this.myplayer.ydir = 0;
        }
        this.myplayer.crouch = 0;
        if (this.movedown == 1) {
            this.dclear = this.dirclear(0, 2);
            if (this.dclear != 0) {
                this.myplayer.crouch = 1;
            }
        }
        if (this.moveup == 0) {
            this.dclear = this.dirclear(0, 2);
            if (this.dclear == 0) {
                this.myplayer.ydir = 1;
                this.myplayer.y += 2;
            }
        }
        if (this.firedelay == 0) {
            if (this.movefire == 1) {
                for (n2 = 0; n2 < this.myshot.length; ++n2) {
                    if (this.myshot[n2].active != 0) continue;
                    if (this.myplayer.crouch == 0) {
                        this.myshot[n2].fire(this.myplayer.x, this.myplayer.y, this.myplayer.xdir, this.myplayer.ydir, 0);
                    } else {
                        this.myshot[n2].fire(this.myplayer.x, this.myplayer.y + 8, this.myplayer.xdir, this.myplayer.ydir, 0);
                    }
                    this.firedelay = 10;
                    break;
                }
            }
        } else {
            --this.firedelay;
        }
        if (this.movefire == 1 & this.myplayer.carry != -1) {
            this.part[this.myplayer.carry].carried = 0;
            this.myplayer.carry = -1;
        }
        for (n2 = 0; n2 < this.myshot.length; ++n2) {
            this.myshot[n2].move();
        }
        for (n2 = 0; n2 < this.explo.length; ++n2) {
            if (this.explo[n2].active != 1) continue;
            this.explo[n2].move(this.mymap);
        }
        if (this.myplayer.carry == -1) {
            this.dclear = this.dirclear(0, 2);
            if (this.dclear != 0) {
                for (n2 = 0; n2 < this.part.length; ++n2) {
                    if (this.reqpart == -1 || this.part[n2].hit(this.myplayer.x, this.myplayer.y) != this.reqpart) continue;
                    this.myplayer.carry = n2;
                }
            }
        }
        if (this.reqpart != -1 && this.part[this.reqpart].home == 1) {
            --this.reqpart;
            if (this.reqpart == -1) {
                this.part[4].set(0, 0, 3);
            }
        }
        if (this.myplayer.carry != -1) {
            this.part[this.myplayer.carry].pos(this.myplayer.x, this.myplayer.y);
            if (this.part[this.myplayer.carry].home == 1) {
                this.myplayer.carry = -1;
            }
        }
        for (n2 = 0; n2 < this.myenemy.length; ++n2) {
            if (this.myenemy[n2].active <= 0) continue;
            this.myenemy[n2].move(this.zone);
            if (this.myenemy[n2].fire() == 1) {
                for (n = 0; n < this.myshot.length; ++n) {
                    if (this.myshot[n].active != 0) continue;
                    this.myshot[n].bomb(this.myenemy[n2].x, this.myenemy[n2].y, 1);
                    break;
                }
            }
            for (n = 0; n < this.myshot.length; ++n) {
                if (this.myshot[n].owner != 0 || this.myshot[n].active != 1 || this.myenemy[n2].hit(this.myshot[n].x + 4, this.myshot[n].y + 4) <= 0) continue;
                this.addexplosion(this.myenemy[n2].x + 8, this.myenemy[n2].y + 8);
                this.score += 10;
                this.myshot[n].clear();
                this.myenemy[n2].respawn();
            }
            if (this.myenemy[n2].hitplayer(this.myplayer.x, this.myplayer.y) != 1) continue;
            this.addexplosion(this.myenemy[n2].x + 8, this.myenemy[n2].y + 8);
            this.addexplosion(this.myplayer.x + 13, this.myplayer.y + 16);
            this.myenemy[n2].respawn();
            --this.power;
            if (this.myplayer.carry == -1) continue;
            this.part[this.myplayer.carry].carried = 0;
            this.myplayer.carry = -1;
        }
        for (n2 = 0; n2 < this.myshot.length; ++n2) {
            if (this.myshot[n2].owner <= 0 || this.myshot[n2].playerhit(this.myplayer.x, this.myplayer.y) != 1) continue;
            this.addexplosion(this.myshot[n2].x + 4, this.myshot[n2].y + 4);
            --this.power;
            this.myshot[n2].clear();
        }
        if (this.power == 0) {
            this.setstate(State.OVER);
        }
    }

    public void setstate(State state) {
        switch (state) {
            case WELCOME: {
                if (this.score > this.hiscore) {
                    this.prevscore = this.hiscore;
                    this.hiscore = this.score;
                }
                fpsdelay = 100;
                this.level = 1;
                break;
            }
            case READY: {
                fpsdelay = 16;
                this.startgame();
                break;
            }
            case GAME: {
                break;
            }
            case OVER: 
            case WELLDONE: 
            case COMPLETED: {
                fpsdelay = 100;
            }
        }
        this.gamestate = state;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 90: {
                if (this.firedelay != 0) break;
                this.movefire = 1;
                break;
            }
            case 39: {
                this.moveright = 1;
                break;
            }
            case 37: {
                this.moveleft = 1;
                break;
            }
            case 38: {
                this.moveup = 1;
                break;
            }
            case 40: {
                this.movedown = 1;
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 90: {
                this.movefire = 0;
                break;
            }
            case 39: {
                this.moveright = 0;
                break;
            }
            case 37: {
                this.moveleft = 0;
                break;
            }
            case 32: 
            case 38: {
                this.moveup = 0;
                break;
            }
            case 40: {
                this.movedown = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                this.setstate(State.READY);
                break;
            }
            case READY: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.OVER);
                }
                if (c == 'q') {
                    this.setstate(State.OVER);
                }
                if (c != 'c') break;
                this.reqpart = -1;
                this.part[0].cheat();
                this.part[1].cheat();
                this.part[2].cheat();
                this.part[4].set(20 + this.rand.nextInt(600), 0, 3);
                this.diamonds = 4;
                break;
            }
            case OVER: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
                break;
            }
            case COMPLETED: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    private void bar(Graphics graphics, int n) {
    }

    public void infobox(Graphics graphics) {
        int n = 0;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 192, 640, 96);
        if (this.gamestate == State.READY) {
            n = 0;
        }
        if (this.gamestate == State.OVER) {
            n = 1;
        }
        if (this.gamestate == State.WELLDONE || this.gamestate == State.COMPLETED) {
            n = 3;
        }
        if (n == 0) {
            graphics.setColor(Color.yellow);
        }
        if (n == 1) {
            graphics.setColor(Color.red);
        }
        if (n == 2) {
            graphics.setColor(Color.cyan);
        }
        if (n == 3) {
            graphics.setColor(Color.green);
        }
        graphics.drawLine(0, 192, 640, 192);
        graphics.drawLine(0, 288, 640, 288);
        graphics.setFont(this.fb);
        this.fmetric = graphics.getFontMetrics(this.fb);
        graphics.setColor(Color.yellow);
        String string = "";
        for (int i = 0; i < this.line.length; ++i) {
            if (this.line[i].length() <= 0) continue;
            string = this.line[i];
            if (i == 0) {
                if (this.gamestate == State.OVER) {
                    graphics.setColor(Color.red);
                }
                if (n == 3) {
                    graphics.setColor(Color.green);
                }
            }
            if (string.charAt(0) == 'C') {
                graphics.setColor(Color.cyan);
            }
            if (string.charAt(0) == 'N') {
                graphics.setColor(Color.orange);
            }
            graphics.drawString(this.line[i], (640 - this.fmetric.stringWidth(this.line[i])) / 2, 220 + i * 25);
        }
    }

    public int dirclear(int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        n += this.myplayer.x;
        n2 += this.myplayer.y;
        for (n3 = 0; n3 < this.mymap.zones; ++n3) {
            if (this.zone[n3].collect(n, n2, 3) != 1) continue;
            this.mymap.clear(this.zone[n3].mx, this.zone[n3].my);
            if (this.power < 5) {
                ++this.power;
                continue;
            }
            this.score += 10;
        }
        for (n3 = 0; n3 < this.mymap.zones; ++n3) {
            n5 = this.zone[n3].hit(n, n2);
            if (n5 == 0) continue;
            n4 = 1;
            break;
        }
        return n4;
    }

    public static enum State {
        WELCOME,
        GAME,
        OVER,
        WELLDONE,
        COMPLETED,
        READY;

    }
}

