/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Tik
extends JPanel
implements MouseListener,
KeyListener,
MouseMotionListener {
    final int swidth = 640;
    final int sheight = 480;
    final int debug = 0;
    final int fps = 10;
    final int fpsdelay = 100;
    static final String title = "Frantik 2020";
    static final String version = "Version 0.3 (17/02/20)";
    Font fs = new Font("Arial", 1, 14);
    Font fb = new Font("Arial", 1, 18);
    Font fm = new Font("Arial", 1, 30);
    Font fl = new Font("Arial", 1, 40);
    Cheese[] mycheese;
    Zone[] mybutton;
    static Explosion[] explo;
    Color bgcolor = new Color(90, 90, 90);
    Color dark_red = new Color(128, 0, 0);
    Color dark_blue = new Color(0, 0, 150);
    String[] line;
    States gamestate = States.WELCOME;
    int px;
    int py;
    int score;
    int lives = 3;
    int time = 10;
    int maxtime;
    int pieces = 0;
    int level = 1;
    int hiscore = 0;
    int dbl;
    int freeze;
    int multi;
    int ppc = 0;
    int pause = 0;
    int rseg;
    int rcol;
    Random rand = new Random();

    public Tik() {
        int n;
        this.line = new String[16];
        this.setstate(States.WELCOME);
        explo = new Explosion[20];
        for (n = 0; n < explo.length; ++n) {
            Tik.explo[n] = new Explosion();
        }
        this.mybutton = new Zone[3];
        for (n = 0; n < this.mybutton.length; ++n) {
            this.mybutton[n] = new Zone();
            this.mybutton[n].w = 80;
            this.mybutton[n].h = 30;
        }
        this.mybutton[0].x = 280;
        this.mybutton[0].y = 40;
        this.mybutton[0].text = "Clear [C]";
        this.mybutton[1].x = 140;
        this.mybutton[1].y = 380;
        this.mybutton[1].text = "Freeze [Z]";
        this.mybutton[2].x = 420;
        this.mybutton[2].y = 380;
        this.mybutton[2].text = "Double [X]";
        this.mycheese = new Cheese[7];
        for (n = 0; n < 7; ++n) {
            this.mycheese[n] = new Cheese();
            this.mycheese[n].clr();
            this.mycheese[n].w = 100;
            this.mycheese[n].x = -(this.mycheese[n].w / 2);
        }
        this.mycheese[6].x = 270;
        this.mycheese[6].y = 200;
        this.mycheese[0].x += 320;
        this.mycheese[0].y = 80;
        this.mycheese[1].x += 220;
        this.mycheese[1].y = 140;
        this.mycheese[2].x += 420;
        this.mycheese[2].y = 140;
        this.mycheese[3].x += 220;
        this.mycheese[3].y = 270;
        this.mycheese[4].x += 420;
        this.mycheese[4].y = 270;
        this.mycheese[5].x += 320;
        this.mycheese[5].y = 320;
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Tik.this.repaint();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Tik());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void clear_lines() {
        for (int i = 0; i < this.line.length; ++i) {
            this.line[i] = "";
        }
    }

    public void draw_container(Graphics graphics) {
        graphics.setColor(this.dark_blue);
        graphics.fillOval(195, 125, 250, 250);
        graphics.setColor(this.bgcolor);
        graphics.fillOval(220, 150, 200, 200);
        for (int i = 0; i < 7; ++i) {
            if (this.mycheese[i].status == 1) {
                graphics.setColor(Color.yellow);
            } else {
                graphics.setColor(Color.blue);
            }
            graphics.fillOval(this.mycheese[i].x, this.mycheese[i].y, this.mycheese[i].w, this.mycheese[i].w);
            graphics.setColor(new Color(20, 20, 20));
            graphics.fillOval(this.mycheese[i].x + 4, this.mycheese[i].y + 4, this.mycheese[i].w - 8, this.mycheese[i].w - 8);
            for (int j = 0; j < 6; ++j) {
                if (this.mycheese[i].segment[j] <= -1) continue;
                switch (this.mycheese[i].segment[j]) {
                    case 0: {
                        graphics.setColor(Color.cyan);
                        break;
                    }
                    case 1: {
                        graphics.setColor(Color.green);
                        break;
                    }
                    case 2: {
                        graphics.setColor(Color.red);
                        break;
                    }
                    case 3: {
                        graphics.setColor(Color.orange);
                    }
                }
                double d = (double)(120 + j * 60) * 3.14 / 180.0;
                int n = (int)(Math.sin(d) * 5.0);
                int n2 = (int)(Math.cos(d) * 5.0);
                graphics.fillArc(n + this.mycheese[i].x + 10, n2 + this.mycheese[i].y + 10, this.mycheese[i].w - 20, this.mycheese[i].w - 20, j * 60, 60);
            }
        }
    }

    public void setstate(States states) {
        switch (states) {
            case WELCOME: {
                this.clear_lines();
                this.line[0] = "Welcome to Frantik";
                this.line[1] = "";
                this.line[2] = "Put the center shape into the";
                this.line[3] = "outer containers against the timer!";
                this.line[4] = "";
                this.line[5] = "Gain an extra life and bonus points if";
                this.line[6] = "you fill a container with the same colour!";
                this.line[7] = "";
                this.line[8] = "High Score";
                this.line[9] = "" + this.hiscore;
                this.line[10] = "";
                this.line[11] = "Recent Score";
                this.line[12] = "" + this.score;
                this.line[13] = "";
                this.line[15] = "Click to start";
                break;
            }
            case OVER: {
                this.clear_lines();
                this.line[0] = "Game Over";
                this.line[1] = "Final Score : " + this.score;
                if (this.score <= this.hiscore) break;
                this.line[2] = "New High Score!";
                break;
            }
            case PAUSED: {
                this.clear_lines();
                this.line[0] = "Game Paused!";
                this.line[1] = "Score : " + this.score;
                this.line[2] = "Level : " + this.level;
                this.line[3] = "";
                this.line[4] = "Press Space or click to continue!";
            }
        }
        this.gamestate = states;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        graphics.setColor(this.bgcolor);
        graphics.fillRect(0, 0, 640, 480);
        graphics.setFont(this.fs);
        graphics.setColor(Color.yellow);
        graphics.drawString("Score: " + this.score, 10, 14);
        graphics.drawString("Lives: " + this.lives, 560, 14);
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_container(graphics);
                graphics.setFont(this.fb);
                graphics.setColor(Color.cyan);
                FontMetrics fontMetrics = graphics.getFontMetrics(this.fb);
                n = 0;
                for (int i = 0; i < this.line.length; ++i) {
                    if (i == 0 || i == 15) {
                        graphics.setFont(this.fm);
                        fontMetrics = graphics.getFontMetrics(this.fm);
                        n2 = fontMetrics.stringWidth(this.line[i]);
                        graphics.setColor(Color.black);
                        graphics.drawString(this.line[i], (640 - n2) / 2 + 2, 64 + n + 2);
                        graphics.setColor(Color.green);
                    } else {
                        graphics.setFont(this.fb);
                        fontMetrics = graphics.getFontMetrics(this.fb);
                        n2 = fontMetrics.stringWidth(this.line[i]);
                        graphics.setColor(Color.black);
                        graphics.drawString(this.line[i], (640 - n2) / 2 + 2, 64 + n + 2);
                        graphics.setColor(Color.cyan);
                        if (i == 8 || i == 11) {
                            graphics.setColor(Color.green);
                        }
                    }
                    graphics.drawString(this.line[i], (640 - n2) / 2, 64 + n);
                    n += 24;
                }
                break;
            }
            case GAME: {
                int n3;
                if (this.freeze == 0) {
                    --this.time;
                    if (this.time < 0) {
                        this.time = 0;
                    }
                } else {
                    this.time = this.maxtime;
                    --this.freeze;
                    if (this.freeze == 0) {
                        this.mybutton[1].status = 0;
                    }
                }
                if (this.dbl > 0) {
                    this.multi = 2;
                    --this.dbl;
                    if (this.dbl == 0) {
                        this.mybutton[2].status = 0;
                    }
                }
                graphics.setColor(this.dark_blue);
                graphics.fillOval(195, 125, 250, 250);
                graphics.fillRect(310, 50, 20, 40);
                graphics.fillRect(195, 350, 20, 40);
                graphics.fillRect(425, 350, 20, 40);
                graphics.setColor(this.bgcolor);
                graphics.fillOval(220, 150, 200, 200);
                int n4 = 180 * this.time / this.maxtime;
                if (n4 >= 60) {
                    graphics.setColor(Color.orange);
                }
                if (n4 >= 120) {
                    graphics.setColor(Color.green);
                }
                if (n4 <= 60) {
                    graphics.setColor(Color.red);
                }
                graphics.fillArc(this.mycheese[6].x - 10, this.mycheese[6].y - 10, this.mycheese[6].w + 20, this.mycheese[6].w + 20, 180, -n4);
                if (this.time <= 0) {
                    if (this.lives > 0) {
                        --this.lives;
                        this.newpiece();
                    } else {
                        this.setstate(States.OVER);
                    }
                }
                for (n = 0; n < 3; ++n) {
                    switch (this.mybutton[n].status) {
                        case 0: {
                            graphics.setColor(Color.gray);
                            graphics.fillRect(this.mybutton[n].x, this.mybutton[n].y, this.mybutton[n].w, this.mybutton[n].h);
                            break;
                        }
                        case 1: {
                            graphics.setColor(Color.yellow);
                            graphics.fillRect(this.mybutton[n].x, this.mybutton[n].y, this.mybutton[n].w, this.mybutton[n].h);
                            break;
                        }
                        case 2: {
                            graphics.setColor(Color.gray);
                            graphics.fillRect(this.mybutton[n].x, this.mybutton[n].y, this.mybutton[n].w, this.mybutton[n].h);
                            if (n <= 0) break;
                            n3 = 0;
                            if (n == 1) {
                                n3 = this.mybutton[n].w * this.freeze / (this.maxtime * 3);
                            }
                            if (n == 2) {
                                n3 = this.mybutton[n].w * this.dbl / (this.maxtime * 3);
                            }
                            graphics.setColor(Color.green);
                            graphics.fillRect(this.mybutton[n].x, this.mybutton[n].y, n3, this.mybutton[n].h);
                        }
                    }
                    FontMetrics fontMetrics = graphics.getFontMetrics(this.fs);
                    n2 = (this.mybutton[n].w - fontMetrics.stringWidth(this.mybutton[n].text)) / 2;
                    graphics.setColor(Color.black);
                    graphics.drawString(this.mybutton[n].text, this.mybutton[n].x + n2, this.mybutton[n].y + 20);
                    graphics.setColor(Color.blue);
                    graphics.drawRect(this.mybutton[n].x, this.mybutton[n].y, this.mybutton[n].w, this.mybutton[n].h);
                }
                for (n = 0; n < 7; ++n) {
                    if (this.mycheese[n].status == 1) {
                        graphics.setColor(Color.yellow);
                    } else {
                        graphics.setColor(Color.blue);
                    }
                    graphics.fillOval(this.mycheese[n].x, this.mycheese[n].y, this.mycheese[n].w, this.mycheese[n].w);
                    graphics.setColor(new Color(20, 20, 20));
                    graphics.fillOval(this.mycheese[n].x + 4, this.mycheese[n].y + 4, this.mycheese[n].w - 8, this.mycheese[n].w - 8);
                    for (n3 = 0; n3 < 6; ++n3) {
                        if (this.mycheese[n].segment[n3] <= -1) continue;
                        switch (this.mycheese[n].segment[n3]) {
                            case 0: {
                                graphics.setColor(Color.cyan);
                                break;
                            }
                            case 1: {
                                graphics.setColor(Color.green);
                                break;
                            }
                            case 2: {
                                graphics.setColor(Color.red);
                                break;
                            }
                            case 3: {
                                graphics.setColor(Color.orange);
                            }
                        }
                        double d = (double)(120 + n3 * 60) * 3.14 / 180.0;
                        int n5 = (int)(Math.sin(d) * 5.0);
                        int n6 = (int)(Math.cos(d) * 5.0);
                        graphics.fillArc(n5 + this.mycheese[n].x + 10, n6 + this.mycheese[n].y + 10, this.mycheese[n].w - 20, this.mycheese[n].w - 20, n3 * 60, 60);
                    }
                }
                for (n = 0; n < explo.length; ++n) {
                    explo[n].update();
                    explo[n].draw(graphics);
                }
                break;
            }
            case OVER: {
                this.draw_container(graphics);
                graphics.setFont(this.fm);
                FontMetrics fontMetrics = graphics.getFontMetrics(this.fm);
                for (String string : this.line) {
                    n2 = fontMetrics.stringWidth(string);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, (640 - n2) / 2 + 2, 222 + n);
                    graphics.setColor(new Color(200, 0, 0));
                    graphics.drawString(string, (640 - n2) / 2, 220 + n);
                    n += 30;
                }
                break;
            }
            case PAUSED: {
                graphics.setFont(this.fm);
                FontMetrics fontMetrics = graphics.getFontMetrics(this.fm);
                for (String string : this.line) {
                    n2 = fontMetrics.stringWidth(string);
                    graphics.setColor(Color.black);
                    graphics.drawString(string, (640 - n2) / 2 + 2, 192 + n);
                    graphics.setColor(new Color(0, 200, 0));
                    graphics.drawString(string, (640 - n2) / 2, 190 + n - 30);
                    n += 30;
                }
                break;
            }
        }
        graphics.setColor(this.dark_red);
        graphics.fillRect(0, 460, 640, 20);
        graphics.setFont(this.fs);
        graphics.setColor(Color.yellow);
        graphics.drawLine(0, 460, 640, 460);
        graphics.drawString("http://ssjx.co.uk", 528, 475);
        graphics.drawString(version, 2, 475);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.px = mouseEvent.getX();
        this.py = mouseEvent.getY();
        switch (this.gamestate) {
            case WELCOME: {
                this.gamestate = States.GAME;
                this.reset();
                break;
            }
            case PAUSED: {
                this.gamestate = States.GAME;
                break;
            }
            case OVER: {
                this.setstate(States.WELCOME);
                if (this.score <= this.hiscore) break;
                this.hiscore = this.score;
                break;
            }
            case GAME: {
                int n;
                int n2;
                if (this.pause != 0) break;
                for (n2 = 0; n2 < 6; ++n2) {
                    this.mycheese[n2].status = 0;
                    if (this.px <= this.mycheese[n2].x || this.px >= this.mycheese[n2].x + this.mycheese[n2].w || this.py <= this.mycheese[n2].y || this.py >= this.mycheese[n2].y + this.mycheese[n2].w) continue;
                    this.mycheese[n2].status = 1;
                    if (this.mycheese[n2].segment[this.rseg] != -1) continue;
                    this.mycheese[n2].segment[this.rseg] = this.rcol;
                    ++this.score;
                    n = this.mycheese[n2].full();
                    if (n > 0) {
                        ++this.pieces;
                        if (this.pieces == 6) {
                            this.pieces = 0;
                            ++this.level;
                            this.maxtime -= 3;
                        }
                        if (n == 6) {
                            this.score += 6 * this.multi;
                            this.addexplosion(this.mycheese[n2].x + (this.mycheese[n2].w >> 1), this.mycheese[n2].y + (this.mycheese[n2].w >> 1));
                        }
                        if (n == 12) {
                            ++this.lives;
                            switch (n2) {
                                case 0: {
                                    this.mybutton[0].status = 1;
                                    break;
                                }
                                case 3: {
                                    this.mybutton[1].status = 1;
                                    break;
                                }
                                case 4: {
                                    this.mybutton[2].status = 1;
                                }
                            }
                            this.score += 12 * this.multi;
                        }
                    }
                    this.newpiece();
                }
                block17: for (n2 = 0; n2 < 3; ++n2) {
                    if (this.mybutton[n2].status != 1 || this.px <= this.mybutton[n2].x || this.px >= this.mybutton[n2].x + this.mybutton[n2].w || this.py <= this.mybutton[n2].y || this.py >= this.mybutton[n2].y + this.mybutton[n2].h) continue;
                    this.mybutton[n2].status = 2;
                    switch (n2) {
                        case 0: {
                            n = 0;
                            for (int i = 0; i < 6; ++i) {
                                n += this.mycheese[i].count();
                                this.mycheese[i].clr();
                            }
                            this.score += n * this.multi;
                            this.mybutton[n2].status = 0;
                            continue block17;
                        }
                        case 1: {
                            this.freeze = 3 * this.maxtime;
                            continue block17;
                        }
                        case 2: {
                            this.dbl = 3 * this.maxtime;
                        }
                    }
                }
                break;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.px = mouseEvent.getX();
        this.py = mouseEvent.getY();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.gamestate == States.GAME) {
            this.px = mouseEvent.getX();
            this.py = mouseEvent.getY();
            for (int i = 0; i < 6; ++i) {
                this.mycheese[i].status = 0;
                if (this.px <= this.mycheese[i].x || this.px >= this.mycheese[i].x + this.mycheese[i].w || this.py <= this.mycheese[i].y || this.py >= this.mycheese[i].y + this.mycheese[i].w) continue;
                this.mycheese[i].status = 1;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (this.gamestate == States.GAME) {
            switch (c) {
                case 'c': {
                    if (this.mybutton[0].status != 1 || this.pause != 0) break;
                    int n = 0;
                    for (int i = 0; i < 6; ++i) {
                        n += this.mycheese[i].count();
                        this.mycheese[i].clr();
                    }
                    this.score += n * this.multi;
                    this.mybutton[0].status = 0;
                    break;
                }
                case 'z': {
                    if (this.mybutton[1].status != 1 || this.pause != 0) break;
                    this.freeze = 3 * this.maxtime;
                    this.mybutton[1].status = 2;
                    break;
                }
                case 'x': {
                    if (this.mybutton[2].status != 1 || this.pause != 0) break;
                    this.dbl = 3 * this.maxtime;
                    this.mybutton[2].status = 2;
                    break;
                }
                case 'p': {
                    this.setstate(States.PAUSED);
                    break;
                }
                case 'q': {
                    this.setstate(States.OVER);
                }
            }
        } else {
            if (c == ' ') {
                switch (this.gamestate) {
                    case WELCOME: {
                        this.gamestate = States.GAME;
                        this.reset();
                        break;
                    }
                    case OVER: {
                        this.setstate(States.WELCOME);
                        if (this.score <= this.hiscore) break;
                        this.hiscore = this.score;
                        break;
                    }
                    case PAUSED: {
                        this.gamestate = States.GAME;
                    }
                }
            }
            if (this.gamestate == States.PAUSED && c == 'p') {
                this.gamestate = States.GAME;
            }
        }
        keyEvent.consume();
    }

    public void newpiece() {
        int n = this.rcol;
        int n2 = this.rseg;
        this.time = this.maxtime;
        this.rseg = this.rand.nextInt(6);
        this.rcol = this.rand.nextInt(3);
        if (this.rseg == n2) {
            ++this.rseg;
            if (this.rseg > 5) {
                this.rseg = 0;
            }
        }
        if (this.rcol == n) {
            ++this.rcol;
            if (this.rcol > 2) {
                this.rcol = 0;
            }
        }
        this.mycheese[6].clr();
        this.mycheese[6].segment[this.rseg] = this.rcol;
    }

    public void addexplosion(int n, int n2) {
        for (int i = 0; i < explo.length; ++i) {
            if (Tik.explo[i].active) continue;
            explo[i].set(n + 12, n2 + 12);
            break;
        }
    }

    public void reset() {
        int n;
        this.gamestate = States.GAME;
        this.pieces = 0;
        this.lives = 3;
        this.level = 1;
        this.score = 0;
        this.time = this.maxtime = 40;
        this.multi = 1;
        this.mybutton[0].status = 0;
        this.mybutton[1].status = 0;
        this.mybutton[2].status = 0;
        this.pause = 0;
        for (n = 0; n < 7; ++n) {
            this.mycheese[n].clr();
        }
        for (n = 0; n < explo.length; ++n) {
            Tik.explo[n].active = false;
        }
        this.clear_lines();
        this.newpiece();
    }

    public static enum States {
        WELCOME,
        GAME,
        OVER,
        PAUSED;

    }
}

