/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class Map {
    int xmap = 0;
    int ofx = 0;
    Point ball = new Point(0, 0);
    private final int width = 32;
    private final int height = 32;
    private final int mapw = 40;
    private final int maph = 13;
    private final int swidth = 480;
    private final int sheight = 320;
    private Image[] sprite = new Image[20];
    private BufferedImage[] mapbmp = new BufferedImage[5];
    private Image sky_img;
    private int[] mapdata = new int[520];
    private int boxcount = 0;
    private int firecount = 0;
    private Block bomb = new Block();
    private Block tbomb = new Block();
    private double[] mysin = new double[360];
    private double[] mycos = new double[360];
    private Block[] box = new Block[520];
    private Block[] firebox = new Block[20];
    private int frame = 0;
    private int alt = 0;
    private int waterframe = 0;

    public Map() {
        int n;
        for (n = 0; n < this.box.length; ++n) {
            this.box[n] = new Block();
        }
        for (n = 0; n < this.firebox.length; ++n) {
            this.firebox[n] = new Block();
        }
        for (n = 0; n < this.mysin.length; ++n) {
            double d = (double)n * Math.PI / 180.0;
            this.mysin[n] = Math.sin(d);
            this.mycos[n] = Math.cos(d);
        }
        String[] stringArray = new String[]{"", "grass", "wood", "fire", "fire1", "", "", "splat", "right", "wood2", "flower", "water", "water1", "water2", "water3", "outline"};
        int n2 = 0;
        for (String string : stringArray) {
            try {
                if (!string.equals("")) {
                    URL uRL = Map.class.getClassLoader().getResource("gfx/" + string + ".gif");
                    this.sprite[n2] = ImageIO.read(uRL);
                }
                ++n2;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the sprite " + string);
                System.out.println(exception);
            }
        }
        String[] stringArray2 = new String[]{"level1", "level2", "level3", "level4", "level5"};
        n2 = 0;
        for (String string : stringArray2) {
            try {
                if (!string.equals("")) {
                    URL uRL = Map.class.getClassLoader().getResource("map/" + string + ".gif");
                    this.mapbmp[n2] = ImageIO.read(uRL);
                }
                ++n2;
            }
            catch (Exception exception) {
                System.out.println("Problem loading map " + string);
                System.out.println(exception);
            }
        }
        try {
            URL uRL = Map.class.getClassLoader().getResource("gfx/sky.png");
            this.sky_img = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading sky image");
            System.out.println(exception);
        }
        this.clear();
    }

    private void clear() {
        this.boxcount = 0;
        this.firecount = 0;
        Arrays.fill(this.mapdata, 0);
        this.home();
    }

    public int count(int n) {
        int n2 = 0;
        for (int n3 : this.mapdata) {
            if (n3 != n) continue;
            ++n2;
        }
        return n2;
    }

    public void load(int n) {
        this.clear();
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < 13; ++i) {
            block9: for (int j = 0; j < 40; ++j) {
                n2 = this.mapbmp[n - 1].getRGB(j, i);
                switch (n2) {
                    case -16711936: {
                        this.set(j, i, 1);
                        this.box[this.boxcount].x = j * 32;
                        this.box[this.boxcount].y = i * 32;
                        ++this.boxcount;
                        continue block9;
                    }
                    case -16777216: {
                        this.set(j, i, 2);
                        this.box[this.boxcount].x = j * 32;
                        this.box[this.boxcount].y = i * 32;
                        ++this.boxcount;
                        continue block9;
                    }
                    case -32768: {
                        this.set(j, i, 9);
                        continue block9;
                    }
                    case -256: {
                        this.set(j, i, 10);
                        continue block9;
                    }
                    case -65536: {
                        this.set(j, i, 3);
                        this.firebox[this.firecount].x = j * 32;
                        this.firebox[this.firecount].y = i * 32;
                        this.firebox[this.firecount].mx = j;
                        this.firebox[this.firecount].my = i;
                        ++this.firecount;
                        continue block9;
                    }
                    case -65281: {
                        this.set(j, i, 0);
                        this.set(j - 1, i, 8);
                        this.bomb.x = 0;
                        this.bomb.y = 12;
                        this.bomb.mx = j;
                        this.bomb.my = i;
                        this.tbomb.x = this.bomb.x;
                        this.tbomb.y = this.bomb.y;
                        this.tbomb.mx = this.bomb.mx;
                        this.tbomb.my = this.bomb.my;
                        this.ball.x = this.tbomb.mx * 32 + this.tbomb.x;
                        this.ball.y = this.tbomb.my * 32 + this.tbomb.y;
                    }
                }
            }
        }
    }

    public void draw(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        graphics.drawImage(this.sky_img, 0, 0, null);
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < 13; ++n2) {
            n4 = -32 - this.ofx;
            n3 = 40 * n2 + this.xmap - 1;
            for (n = 0; n < 17; ++n) {
                int n6;
                if (n3 >= 0 && n3 < 520 && (n6 = this.mapdata[n3]) > 0) {
                    if (n6 == 3) {
                        n6 += this.alt;
                    }
                    graphics.drawImage(this.sprite[n6], n4, n5, null);
                }
                n4 += 32;
                ++n3;
            }
            n5 += 32;
        }
        n2 = (this.bomb.mx - this.xmap) * 32 + this.bomb.x - this.ofx;
        n = this.bomb.my * 32 + this.bomb.y;
        graphics.drawImage(this.sprite[11 + this.waterframe], n2, n, null);
        this.ball.x = this.tbomb.mx * 32 + this.tbomb.x - this.ofx;
        this.ball.y = this.tbomb.my * 32 + this.tbomb.y;
        ++this.frame;
        switch (this.frame) {
            case 12: {
                ++this.waterframe;
                if (this.waterframe <= 3) break;
                this.waterframe = 0;
                break;
            }
            case 24: {
                this.alt = 1 - this.alt;
                ++this.waterframe;
                if (this.waterframe > 3) {
                    this.waterframe = 0;
                }
                this.frame = 0;
            }
        }
    }

    public boolean draw_water(Graphics graphics, int n, int n2) {
        int n3;
        this.bomb.x = (int)((double)this.bomb.x + this.mycos[n] * 4.0);
        if (n2 > 0) {
            --n2;
            this.bomb.y = (int)((double)this.bomb.y - this.mysin[n] * 4.0);
        } else {
            this.bomb.y = (int)((double)this.bomb.y + this.mysin[n] * 4.0);
        }
        if (this.bomb.x >= 32) {
            ++this.bomb.mx;
            this.bomb.x -= 32;
        }
        if (this.bomb.y >= 32) {
            ++this.bomb.my;
            this.bomb.y -= 32;
        }
        if (this.bomb.y <= -32) {
            --this.bomb.my;
            this.bomb.y += 32;
        }
        boolean bl = false;
        int n4 = this.bomb.mx * 32 + this.bomb.x + 8;
        int n5 = this.bomb.my * 32 + this.bomb.y + 8;
        if (n5 > 320 || n4 > 1280) {
            bl = true;
            this.bomb.x = this.tbomb.x;
            this.bomb.y = this.tbomb.y;
            this.bomb.mx = this.tbomb.mx;
            this.bomb.my = this.tbomb.my;
        }
        if (n4 > 320) {
            this.move(1);
        }
        for (n3 = 0; n3 < this.boxcount; ++n3) {
            if (n4 <= this.box[n3].x || n4 > this.box[n3].x + 32 || n5 <= this.box[n3].y || n5 > this.box[n3].y + 32) continue;
            this.bomb.x = this.tbomb.x;
            this.bomb.y = this.tbomb.y;
            this.bomb.mx = this.tbomb.mx;
            this.bomb.my = this.tbomb.my;
            bl = true;
        }
        for (n3 = 0; n3 < this.firecount; ++n3) {
            if (this.firebox[n3].x <= -1 || this.firebox[n3].y <= -1 || n4 <= this.firebox[n3].x || n4 > this.firebox[n3].x + 32 || n5 <= this.firebox[n3].y + 8 || n5 > this.firebox[n3].y + 32) continue;
            this.firebox[n3].x = -1;
            this.firebox[n3].y = -1;
            this.set(this.firebox[n3].mx, this.firebox[n3].my, 7);
            this.bomb.x = this.tbomb.x;
            this.bomb.y = this.tbomb.y;
            this.bomb.mx = this.tbomb.mx;
            this.bomb.my = this.tbomb.my;
            bl = true;
        }
        return bl;
    }

    public void draw_aim(Graphics graphics, int n) {
        int n2 = (this.tbomb.mx - this.xmap) * 32 + this.tbomb.x - this.ofx;
        int n3 = this.tbomb.my * 32 + this.tbomb.y;
        for (int i = 1; i < 5; ++i) {
            int n4 = n2 + (int)(this.mycos[n] * (double)(i * 16)) + 4;
            int n5 = n3 - (int)(this.mysin[n] * (double)(i * 16)) + 4;
            graphics.drawImage(this.sprite[15], n4, n5, null);
        }
    }

    public void set(int n, int n2, int n3) {
        this.mapdata[n2 * 40 + n] = n3;
    }

    private int get(int n, int n2) {
        return this.mapdata[n2 * 40 + n];
    }

    public void move(int n) {
        if (n == -1 && (this.xmap > 0 || this.ofx > 0)) {
            this.ofx -= 4;
            if (this.ofx == -32) {
                --this.xmap;
                this.ofx = 0;
            }
        }
        if (n == 1 && this.xmap < 25) {
            this.ofx += 4;
            if (this.ofx == 32) {
                ++this.xmap;
                this.ofx = 0;
            }
        }
    }

    public void home() {
        this.xmap = 0;
        this.ofx = 0;
        this.bomb.x = this.tbomb.x;
        this.bomb.y = this.tbomb.y;
        this.bomb.mx = this.tbomb.mx;
        this.bomb.my = this.tbomb.my;
    }
}

