/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Fire
extends JPanel
implements KeyListener,
MouseListener,
MouseMotionListener {
    private final int MODE_WELCOME = 0;
    private final int MODE_READY = 1;
    private final int MODE_GAME = 2;
    private final int MODE_LAUNCH = 3;
    private final int MODE_FAIL = 7;
    private final int MODE_COMPLETED = 5;
    private final int MODE_OVER = 6;
    private final int MODE_HELP = 8;
    private final int swidth = 480;
    private final int sheight = 320;
    private final boolean DEBUG = false;
    private final int MAXLEVELS = 5;
    private static final String title = "Fire!";
    private final String website = "http://ssjx.co.uk";
    private final String version = "v0.3 (15/05/21)";
    private static final int fps = 30;
    private static int fpsdelay = 33;
    private int angle = 0;
    private double[] mysin = new double[360];
    private double[] mycos = new double[360];
    private int level;
    private int highscore;
    private int bonus;
    private int score;
    private int fires;
    private int power;
    private boolean drawnow;
    private boolean powerdown;
    private int movedir;
    private XText mytext = new XText();
    private XGauge mygauge = new XGauge();
    private Map mymap = new Map();
    private Point mymouse = new Point(0, 0);
    private int count = 0;
    private int alt = 0;
    private int state = 0;
    Color dim_black = new Color(0, 0, 0, 128);

    public Fire() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(480, 320));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        for (int i = 0; i < this.mysin.length; ++i) {
            double d = (double)i * Math.PI / 180.0;
            this.mysin[i] = Math.sin(d);
            this.mycos[i] = Math.cos(d);
        }
        this.mygauge.init(140, 6, 200, 20);
        this.setlevel(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Fire.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Fire());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.state) {
            case 0: {
                ++this.count;
                if (this.count >= 20) {
                    this.count = 0;
                    this.alt = 1 - this.alt;
                    this.drawnow = true;
                }
                if (!this.drawnow) break;
                this.mymap.draw(graphics);
                this.grey(graphics);
                this.mytext.draw(graphics, "H:" + Integer.toString(this.highscore), 0, 0);
                this.mytext.center(graphics, title, 1);
                this.mytext.center(graphics, "Solar flares have caused many", 3);
                this.mytext.center(graphics, "fires in your town!", 4);
                this.mytext.center(graphics, "Armed with Professor White's", 6);
                this.mytext.center(graphics, "water gun, put them out!", 7);
                this.mytext.center(graphics, "Controls", 9);
                this.mytext.center(graphics, "--------", 10);
                this.mytext.center(graphics, "Use the Arrow keys or mouse to aim,", 11);
                this.mytext.center(graphics, "hold down the mouse button or Space to", 12);
                this.mytext.center(graphics, "charge, release it to fire!", 13);
                if (this.alt == 1) {
                    this.mytext.center(graphics, "* Click to start *", 15);
                }
                this.mytext.draw(graphics, "v0.3 (15/05/21)", 23, 19);
                this.mytext.draw(graphics, "http://ssjx.co.uk", 0, 19);
                this.drawnow = false;
                break;
            }
            case 1: {
                if (!this.drawnow) break;
                this.mymap.draw(graphics);
                this.mytext.center(graphics, "LEVEL " + Integer.toString(this.level), 7);
                this.mytext.center(graphics, "* CLICK TO START *", 9);
                this.drawnow = false;
                break;
            }
            case 5: {
                if (!this.drawnow) break;
                this.mymap.draw(graphics);
                this.grey(graphics);
                this.mytext.center(graphics, "WELL DONE!", 5);
                this.mytext.center(graphics, "YOU HAVE COMPLETED", 7);
                this.mytext.center(graphics, "ALL OF THE LEVELS!", 8);
                this.mytext.center(graphics, "PLEASE CHECK BACK", 10);
                this.mytext.center(graphics, "FOR NEW LEVELS!", 11);
                this.mytext.center(graphics, "THANKS FOR PLAYING!", 13);
                this.drawnow = false;
                break;
            }
            case 2: {
                this.mymap.draw(graphics);
                this.mygauge.draw(graphics);
                this.mytext.draw(graphics, "S:" + Integer.toString(this.score), 0, 0);
                this.mytext.draw(graphics, "B:" + Integer.toString(this.bonus), 0, 1);
                this.mytext.draw(graphics, "#:" + Integer.toString(this.fires), 0, 2);
                this.mymap.draw_aim(graphics, this.angle);
                if (this.bonus > 0) {
                    ++this.count;
                    if (this.count >= 30) {
                        --this.bonus;
                        this.count = 0;
                    }
                }
                if (this.powerdown) {
                    if (this.power < 200) {
                        this.power += 2;
                    }
                    this.mygauge.update(this.power);
                }
                if (this.movedir == 0) break;
                this.mymap.move(this.movedir);
                break;
            }
            case 3: {
                this.mymap.draw(graphics);
                this.mymap.draw_aim(graphics, this.angle);
                this.mygauge.draw(graphics);
                this.mytext.draw(graphics, "S:" + Integer.toString(this.score), 0, 0);
                this.mytext.draw(graphics, "B:" + Integer.toString(this.bonus), 0, 1);
                this.mytext.draw(graphics, "#:" + Integer.toString(this.fires), 0, 2);
                if (this.mymap.draw_water(graphics, this.angle, this.power)) {
                    this.fires = this.mymap.count(3);
                    if (this.fires == 0) {
                        this.score += 100;
                        this.score += this.bonus;
                        ++this.level;
                        if (this.level <= 5) {
                            this.setlevel(this.level);
                            this.state = 1;
                        } else {
                            if (this.score > this.highscore) {
                                this.highscore = this.score;
                            }
                            this.state = 5;
                        }
                    } else {
                        this.state = 2;
                        this.power = 0;
                        this.mymap.home();
                    }
                }
                if (this.power > 0) {
                    --this.power;
                    this.mygauge.update(this.power);
                }
                if (this.bonus <= 0) break;
                ++this.count;
                if (this.count < 30) break;
                --this.bonus;
                this.count = 0;
                break;
            }
            case 8: {
                if (!this.drawnow) break;
                this.mymap.draw(graphics);
                this.grey(graphics);
                this.mytext.center(graphics, title, 1);
                this.mytext.draw(graphics, "Use the mouse to aim your", 1, 3);
                this.mytext.draw(graphics, "water ball. hold down the", 1, 4);
                this.mytext.draw(graphics, "mouse button to charge,", 1, 5);
                this.mytext.draw(graphics, "release to launch it!", 1, 6);
                this.mytext.draw(graphics, "Click on the edges of the", 1, 8);
                this.mytext.draw(graphics, "screen to view the area.", 1, 9);
                this.mytext.draw(graphics, "You can also use the arrow", 1, 11);
                this.mytext.draw(graphics, "keys and space bar to play.", 1, 12);
                this.mytext.center(graphics, "** Good Luck **", 16);
                this.mytext.draw(graphics, "v0.3 (15/05/21)", 0, 18);
                this.mytext.draw(graphics, "http://ssjx.co.uk", 0, 19);
                this.drawnow = false;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case ' ': {
                if (this.state == 2) break;
                this.setgamestate(this.state);
                break;
            }
            case '\u001b': {
                if (this.score > this.highscore) {
                    this.highscore = this.score;
                }
                this.state = 0;
                this.drawnow = true;
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.state == 2) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.setdir(0);
                    break;
                }
                case 40: {
                    this.setdir(1);
                    break;
                }
                case 37: {
                    this.setdir(2);
                    break;
                }
                case 39: {
                    this.setdir(3);
                    break;
                }
                case 32: {
                    this.powerdown = true;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.state == 2) {
            switch (keyEvent.getKeyCode()) {
                case 32: {
                    if (!this.powerdown) break;
                    this.mygauge.marker = this.power;
                    this.powerdown = false;
                    this.state = 3;
                }
            }
        }
    }

    private void setdir(int n) {
        switch (n) {
            case 0: {
                this.angle += 5;
                if (this.angle <= 85) break;
                this.angle = 85;
                break;
            }
            case 1: {
                this.angle -= 5;
                if (this.angle >= 5) break;
                this.angle = 5;
                break;
            }
            case 2: {
                this.mymap.move(-1);
                break;
            }
            case 3: {
                this.mymap.move(1);
                break;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.state == 2) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n2 > 32) {
                if (n < 32) {
                    this.movedir = -1;
                }
                if (n > 448) {
                    this.movedir = 1;
                }
                if (n > 32 && n < 448) {
                    this.powerdown = true;
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        switch (this.state) {
            case 2: {
                if (this.movedir != 0) {
                    this.movedir = 0;
                }
                if (!this.powerdown) break;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                this.track(n, n2);
                this.powerdown = false;
                this.mygauge.marker = this.power;
                this.mymap.home();
                this.state = 3;
                break;
            }
            default: {
                this.setgamestate(this.state);
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.state == 2) {
            int n = mouseEvent.getY();
            if (n > 32) {
                int n2 = mouseEvent.getX();
                if (n2 >= 0 && n2 < 32) {
                    this.movedir = -1;
                }
                if (n2 > 448 && n2 < 480) {
                    this.movedir = 1;
                }
                if (n2 > 32 && n2 < 448) {
                    this.movedir = 0;
                    this.track(n2, n);
                }
            } else {
                this.movedir = 0;
            }
        }
    }

    private void track(int n, int n2) {
        int n3 = this.mymap.ball.x + 8;
        int n4 = 320 - this.mymap.ball.y - 8;
        this.mymouse.x = this.mymap.xmap * 32 + this.mymap.ofx + (n - n3);
        this.mymouse.y = 320 - n2 - n4;
        double d = Math.atan2(this.mymouse.y, this.mymouse.x) * 57.29577951308232;
        this.angle = (int)d;
        if (this.angle > 85) {
            this.angle = 85;
        }
        if (this.angle < 5) {
            this.angle = 5;
        }
    }

    private void setlevel(int n) {
        this.power = 0;
        this.bonus = 180;
        this.angle = 5;
        this.count = 0;
        this.powerdown = false;
        this.mygauge.marker = 0;
        this.mygauge.update(0);
        this.mymap.load(n);
        this.fires = this.mymap.count(3);
    }

    private void restartlevel() {
    }

    private void setgamestate(int n) {
        switch (n) {
            case 0: {
                this.level = 1;
                this.score = 0;
                this.setlevel(this.level);
                this.state = 1;
                break;
            }
            case 1: {
                this.state = 2;
                break;
            }
            case 8: {
                this.state = 2;
                break;
            }
            case 5: {
                this.state = 0;
            }
        }
        this.drawnow = true;
    }

    private void grey(Graphics graphics) {
        graphics.setColor(this.dim_black);
        graphics.fillRect(0, 0, 480, 320);
    }

    private void dim(Graphics graphics, int n, int n2) {
        graphics.setColor(this.dim_black);
        graphics.fillRect(0, n, 480, n2);
    }
}

