/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class Map {
    byte[][] data = new byte[40][40];
    byte[][] col = new byte[40][40];
    int width;
    int height;
    int diamonds;
    int startx;
    int starty;
    private static Image[] block = new Image[10];

    public Map() {
        String[] stringArray = new String[]{"soil", "wall", "diamond", "boulder", "door", "key"};
        int n = 1;
        for (String string : stringArray) {
            try {
                URL uRL = Boulder.class.getClassLoader().getResource("gfx/" + string + ".gif");
                Map.block[n] = new ImageIcon(uRL).getImage();
            }
            catch (Exception exception) {
                System.out.println("Main: Exception loading map sprite " + string);
            }
            ++n;
        }
    }

    public int update(int n, int n2) {
        boolean bl;
        if (this.data[n][n2 - 1] == 0 && this.data[n][n2 - 2] == 4) {
            this.data[n][n2] = 0;
        }
        do {
            bl = false;
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    if (this.data[j][i] != 4) continue;
                    if (j == n && i == n2) {
                        return 1;
                    }
                    if (this.data[j][i + 1] == 0) {
                        this.data[j][i] = 0;
                        this.data[j][i + 1] = 4;
                        this.col[j][i] = 0;
                        this.col[j][i + 1] = 1;
                        bl = true;
                    }
                    if (this.data[j][i + 1] != 3) continue;
                    if ((j + 1 == n || j - 1 == n) && i == n2) {
                        return 0;
                    }
                    if (this.data[j + 1][i] == 0 && (this.data[j + 1][i + 1] == 0 || n == j + 1 && n2 == i + 1)) {
                        this.data[j][i] = 0;
                        this.data[j + 1][i + 1] = 4;
                        this.col[j][i] = 0;
                        this.col[j + 1][i + 1] = 1;
                        bl = true;
                    }
                    if (this.data[j - 1][i] != 0 || this.data[j - 1][i + 1] != 0 && (n != j - 1 || n2 != i + 1)) continue;
                    this.data[j][i] = 0;
                    this.data[j - 1][i + 1] = 4;
                    this.col[j][i] = 0;
                    this.col[j - 1][i + 1] = 1;
                    bl = true;
                }
            }
        } while (bl);
        return 0;
    }

    private void clear() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.data[j][i] = 0;
                this.col[j][i] = 0;
            }
        }
    }

    public void draw(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 480);
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                graphics.drawImage(block[this.data[j][i]], j * 16, i * 16, null);
            }
        }
    }

    public void load(int n) {
        this.diamonds = 0;
        this.clear();
        try {
            URL uRL = this.getClass().getResource("maps/level" + n + ".bmp");
            BufferedImage bufferedImage = ImageIO.read(uRL);
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n2 = bufferedImage.getRGB(j, i);
                    int n3 = n2 & 0xFF;
                    int n4 = (n2 & 0xFF00) >> 8;
                    int n5 = (n2 & 0xFF0000) >> 16;
                    if (n5 < 0) {
                        n5 += 256;
                    }
                    if (n4 < 0) {
                        n4 += 256;
                    }
                    if (n3 < 0) {
                        n3 += 256;
                    }
                    this.col[j][i] = 0;
                    if (n5 == 255 && n4 == 255 && n3 == 255) {
                        this.data[j][i] = 1;
                        this.col[j][i] = 0;
                    }
                    if (n5 == 0 && n4 == 0 && n3 == 0) {
                        this.data[j][i] = 2;
                        this.col[j][i] = 1;
                    }
                    if (n5 == 255 && n4 == 0 && n3 == 0) {
                        this.data[j][i] = 3;
                        this.col[j][i] = 0;
                        ++this.diamonds;
                    }
                    if (n5 == 128 && n4 == 128 && n3 == 128) {
                        this.data[j][i] = 4;
                        this.col[j][i] = 1;
                    }
                    if (n5 == 0 && n4 == 255 && n3 == 0) {
                        this.data[j][i] = 5;
                        this.col[j][i] = 1;
                    }
                    if (n5 == 0 && n4 == 255 && n3 == 255) {
                        this.data[j][i] = 6;
                        this.col[j][i] = 0;
                    }
                    if (n5 != 255 || n4 != 0 || n3 != 255) continue;
                    this.data[j][i] = 0;
                    this.startx = j;
                    this.starty = i;
                }
            }
        }
        catch (IOException iOException) {
            System.out.println("Load Map file error caught...");
        }
    }
}

