/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Boulder
extends JPanel
implements KeyListener {
    final int swidth = 640;
    final int sheight = 480;
    final int debug = 0;
    final int maxlevels = 5;
    final int startlevel = 1;
    static final String title = "Diamond Mine";
    static final String version = "Version 0.3";
    public static final int fps = 15;
    public static int fpsdelay = 66;
    Thread runner;
    static String[] line;
    int px;
    int py;
    int gamestate = 0;
    int level = 1;
    int diamonds = 0;
    int keys = 0;
    int move = 0;
    int updatemap;
    static BufferedImage player;
    static BufferedImage[] block;
    static Map mymap;
    FontMetrics fmetric;
    final Font fs = new Font("Arial", 1, 14);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 1, 30);
    BufferedImage offscreen;

    @Override
    public void invalidate() {
        super.invalidate();
        this.offscreen = null;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Boulder() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Boulder.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        line = new String[30];
        mymap = new Map();
        block = new BufferedImage[5];
        try {
            URL uRL = Boulder.class.getClassLoader().getResource("gfx/player.gif");
            player = ImageIO.read(uRL);
            uRL = Boulder.class.getClassLoader().getResource("gfx/soil.gif");
            Boulder.block[1] = ImageIO.read(uRL);
            uRL = Boulder.class.getClassLoader().getResource("gfx/wall.gif");
            Boulder.block[2] = ImageIO.read(uRL);
            uRL = Boulder.class.getClassLoader().getResource("gfx/diamond.gif");
            Boulder.block[3] = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map sprites...");
        }
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Boulder());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void startgame() {
        mymap.load(this.level);
        this.px = Boulder.mymap.startx;
        this.py = Boulder.mymap.starty;
        this.diamonds = 0;
        this.keys = 0;
    }

    public void setstate(int n) {
        switch (n) {
            case 0: {
                this.level = 1;
                mymap.load(this.level);
                this.gamestate = 3;
                this.repaint();
                break;
            }
            case 1: {
                this.gamestate = 0;
                this.repaint();
                break;
            }
            case 2: {
                this.gamestate = 0;
                this.repaint();
                break;
            }
            case 3: {
                this.startgame();
                this.gamestate = 10;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.gamestate == 10) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, 640, 480);
            mymap.draw(graphics);
            this.updatemap = 0;
            switch (this.move) {
                case 6: {
                    if (Boulder.mymap.data[this.px + 1][this.py] == 4 && Boulder.mymap.data[this.px + 2][this.py] == 0) {
                        Boulder.mymap.data[this.px + 2][this.py] = 4;
                        Boulder.mymap.data[this.px + 1][this.py] = 0;
                        Boulder.mymap.col[this.px + 2][this.py] = 1;
                        Boulder.mymap.col[this.px + 1][this.py] = 0;
                    }
                    if (Boulder.mymap.data[this.px + 1][this.py] == 5 && this.keys > 0) {
                        Boulder.mymap.col[this.px + 1][this.py] = 0;
                        --this.keys;
                    }
                    if (Boulder.mymap.col[this.px + 1][this.py] == 1) break;
                    ++this.px;
                    this.updatemap = 1;
                    break;
                }
                case 4: {
                    if (Boulder.mymap.data[this.px - 1][this.py] == 4 && Boulder.mymap.data[this.px - 2][this.py] == 0) {
                        Boulder.mymap.data[this.px - 2][this.py] = 4;
                        Boulder.mymap.data[this.px - 1][this.py] = 0;
                        Boulder.mymap.col[this.px - 2][this.py] = 1;
                        Boulder.mymap.col[this.px - 1][this.py] = 0;
                    }
                    if (Boulder.mymap.data[this.px - 1][this.py] == 5 && this.keys > 0) {
                        Boulder.mymap.col[this.px - 1][this.py] = 0;
                        --this.keys;
                    }
                    if (Boulder.mymap.col[this.px - 1][this.py] == 1) break;
                    --this.px;
                    this.updatemap = 1;
                    break;
                }
                case 8: {
                    if (Boulder.mymap.data[this.px][this.py - 1] == 5 && this.keys > 0) {
                        Boulder.mymap.col[this.px][this.py - 1] = 0;
                        --this.keys;
                    }
                    if (Boulder.mymap.col[this.px][this.py - 1] == 1) break;
                    --this.py;
                    this.updatemap = 1;
                    break;
                }
                case 2: {
                    if (Boulder.mymap.data[this.px][this.py + 1] == 5 && this.keys > 0) {
                        Boulder.mymap.col[this.px][this.py + 1] = 0;
                        --this.keys;
                    }
                    if (Boulder.mymap.col[this.px][this.py + 1] == 1) break;
                    ++this.py;
                    this.updatemap = 1;
                }
            }
            graphics.drawImage(player, this.px * 16, this.py * 16, null);
            if (this.updatemap == 1) {
                switch (Boulder.mymap.data[this.px][this.py]) {
                    case 0: {
                        mymap.update(this.px, this.py);
                        break;
                    }
                    case 1: {
                        if (mymap.update(this.px, this.py) != 0) break;
                        Boulder.mymap.data[this.px][this.py] = 0;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        ++this.diamonds;
                        if (mymap.update(this.px, this.py) != 0) break;
                        Boulder.mymap.data[this.px][this.py] = 0;
                        break;
                    }
                    case 5: {
                        if (mymap.update(this.px, this.py) != 0) break;
                        Boulder.mymap.data[this.px][this.py] = 0;
                        break;
                    }
                    case 6: {
                        ++this.keys;
                        if (mymap.update(this.px, this.py) != 0) break;
                        Boulder.mymap.data[this.px][this.py] = 0;
                    }
                }
                if (Boulder.mymap.data[this.px][this.py] == 4) {
                    this.gamestate = 3;
                }
            }
            graphics.setColor(Color.yellow);
            graphics.setFont(this.fs);
            graphics.drawString("Diamonds: " + this.diamonds + " / " + Boulder.mymap.diamonds, 5, 13);
            graphics.drawString("Keys: " + this.keys, 200, 13);
            graphics.drawString("Level : " + this.level, 400, 13);
            if (this.diamonds == Boulder.mymap.diamonds) {
                if (this.level == 5) {
                    this.gamestate = 2;
                } else {
                    ++this.level;
                    mymap.load(this.level);
                    this.gamestate = 3;
                }
            }
        }
        if (this.gamestate < 10) {
            int n;
            for (n = 0; n < line.length; ++n) {
                Boulder.line[n] = "";
            }
            switch (this.gamestate) {
                case 0: {
                    graphics.setColor(Color.black);
                    graphics.fillRect(0, 0, 640, 480);
                    for (n = 1; n < 29; ++n) {
                        for (int i = 1; i < 39; ++i) {
                            graphics.drawImage(block[1], i * 16, n * 16, null);
                        }
                    }
                    for (n = 0; n < 40; ++n) {
                        graphics.drawImage(block[2], n * 16, 0, null);
                        graphics.drawImage(block[2], n * 16, 464, null);
                    }
                    for (n = 0; n < 30; ++n) {
                        graphics.drawImage(block[2], 0, n * 16, null);
                        graphics.drawImage(block[2], 624, n * 16, null);
                    }
                    for (n = 4; n < 36; ++n) {
                        graphics.drawImage(block[3], n * 16, 64, null);
                        graphics.drawImage(block[3], n * 16, 400, null);
                    }
                    for (n = 4; n < 26; ++n) {
                        graphics.drawImage(block[3], 64, n * 16, null);
                        graphics.drawImage(block[3], 560, n * 16, null);
                    }
                    graphics.setFont(this.fs);
                    graphics.setColor(Color.yellow);
                    graphics.drawString("http://ssjx.co.uk", 520, 475);
                    graphics.drawString(version, 2, 475);
                    Boulder.line[0] = title;
                    Boulder.line[2] = "Objective:";
                    Boulder.line[3] = "Avoid the rocks and collect all of the diamonds";
                    Boulder.line[4] = "on each level. To open locked doors you must find ";
                    Boulder.line[5] = "a key. Rocks will fall off diamonds so be careful!";
                    Boulder.line[7] = "Controls:";
                    Boulder.line[8] = "Arrow keys - Move";
                    Boulder.line[9] = "R - Restart the level";
                    Boulder.line[10] = "Q - Quit the game";
                    Boulder.line[13] = "Click to play!!";
                    for (n = 0; n < line.length; ++n) {
                        if (n > 0 && n < 13) {
                            graphics.setFont(this.fb);
                            this.fmetric = graphics.getFontMetrics(this.fb);
                            graphics.setColor(Color.black);
                            graphics.drawString(line[n], (642 - this.fmetric.stringWidth(line[n])) / 2, 52 + n * 30);
                            if (n == 2 || n == 7) {
                                graphics.setColor(Color.green);
                            } else {
                                graphics.setColor(Color.cyan);
                            }
                        } else {
                            graphics.setFont(this.fm);
                            this.fmetric = graphics.getFontMetrics(this.fm);
                            graphics.setColor(Color.black);
                            graphics.drawString(line[n], (642 - this.fmetric.stringWidth(line[n])) / 2, 52 + n * 30);
                            graphics.setColor(Color.yellow);
                        }
                        graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 50 + n * 30);
                    }
                    break;
                }
                case 1: {
                    Boulder.line[0] = "Game Over";
                    graphics.setFont(this.fm);
                    this.fmetric = graphics.getFontMetrics(this.fm);
                    graphics.setColor(Color.yellow);
                    for (n = 0; n < 4; ++n) {
                        graphics.setColor(Color.red);
                        graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2 + 2, 200 + n * 30 + 2);
                        graphics.setColor(Color.yellow);
                        graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 200 + n * 30);
                    }
                    break;
                }
                case 2: {
                    Boulder.line[0] = "All Levels Completed!";
                    Boulder.line[1] = "Thanks For Playing!";
                    graphics.setFont(this.fm);
                    this.fmetric = graphics.getFontMetrics(this.fm);
                    graphics.setColor(Color.yellow);
                    for (n = 0; n < 4; ++n) {
                        graphics.setColor(Color.red);
                        graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2 + 2, 200 + n * 30 + 2);
                        graphics.setColor(Color.yellow);
                        graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 200 + n * 30);
                    }
                    break;
                }
                case 3: {
                    mymap.draw(graphics);
                    Boulder.line[0] = "Level " + this.level;
                    Boulder.line[1] = "Get Ready!";
                    graphics.setFont(this.fm);
                    this.fmetric = graphics.getFontMetrics(this.fm);
                    graphics.setColor(Color.yellow);
                    for (n = 0; n < 4; ++n) {
                        graphics.setColor(Color.red);
                        graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2 + 2, 200 + n * 30 + 2);
                        graphics.setColor(Color.yellow);
                        graphics.drawString(line[n], (640 - this.fmetric.stringWidth(line[n])) / 2, 200 + n * 30);
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.move = 6;
                break;
            }
            case 37: {
                this.move = 4;
                break;
            }
            case 38: {
                this.move = 8;
                break;
            }
            case 40: {
                this.move = 2;
                break;
            }
            case 32: {
                this.setstate(this.gamestate);
                break;
            }
            case 80: {
                break;
            }
            case 81: {
                this.gamestate = 1;
                break;
            }
            case 82: {
                mymap.load(this.level);
                this.gamestate = 3;
            }
        }
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.move = 0;
                break;
            }
            case 37: {
                this.move = 0;
                break;
            }
            case 38: {
                this.move = 0;
                break;
            }
            case 40: {
                this.move = 0;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

