/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Deal
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    static final int swidth = 640;
    static final int sheight = 480;
    public static final int fps = 30;
    public static int fpsdelay = 33;
    static final int debug = 0;
    static final String title = "Deal?";
    static final String version = "Version 0.1c (22/12/2020))";
    String[] line = new String[30];
    Redbox[] box = new Redbox[22];
    Redbox mysterybox;
    Zone[] button = new Zone[3];
    int playerbox;
    int offer;
    int highest;
    int dealt;
    int count;
    int cround;
    int gamestate;
    Random rand = new Random();
    int loop = 0;
    final int[] round = new int[]{5, 3, 3, 3, 3, 3, 1, 1};
    final int[] money = new int[]{1, 10, 50, 100, 500, 1000, 5000, 10000, 25000, 50000, 75000, 100000, 300000, 500000, 1000000, 1500000, 2000000, 3500000, 5000000, 7500000, 10000000, 25000000};
    int[] boxmoney = new int[22];
    int[] showmoney = new int[22];
    FontMetrics fmetric;
    final Font fs = new Font("Arial", 1, 16);
    final Font fb = new Font("Arial", 1, 18);
    final Font fm = new Font("Arial", 1, 30);

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Deal() {
        int n;
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        for (n = 0; n < this.button.length; ++n) {
            this.button[n] = new Zone();
        }
        this.button[0].text = "Deal!";
        this.button[1].text = "No Deal!";
        this.button[2].text = "Continue..";
        for (n = 0; n < this.box.length; ++n) {
            this.box[n] = new Redbox();
            this.box[n].no = n + 1;
        }
        for (n = 0; n < 6; ++n) {
            this.box[n].y = 260;
            this.box[n].x = 140 + n * 60;
        }
        for (n = 0; n < 8; ++n) {
            this.box[6 + n].y = 320;
            this.box[6 + n].x = 80 + n * 60;
        }
        for (n = 0; n < 8; ++n) {
            this.box[14 + n].y = 380;
            this.box[14 + n].x = 80 + n * 60;
        }
        this.mysterybox = new Redbox();
        this.mysterybox.open = 1;
        this.mysterybox.value = 0;
        this.mysterybox.no = -1;
        this.mysterybox.x = (640 - 48) / 2;
        this.mysterybox.y = (480 - 48) / 2;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Deal.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Deal());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void startgame() {
        int n;
        this.playerbox = -1;
        this.offer = 0;
        this.dealt = -1;
        this.highest = 0;
        this.cround = 0;
        this.count = 0;
        this.boxmoney = Arrays.copyOf(this.money, this.money.length);
        this.showmoney = Arrays.copyOf(this.money, this.money.length);
        for (n = 0; n < 200; ++n) {
            int n2 = this.rand.nextInt(this.money.length);
            int n3 = this.rand.nextInt(this.money.length);
            int n4 = this.boxmoney[n2];
            this.boxmoney[n2] = this.boxmoney[n3];
            this.boxmoney[n3] = n4;
        }
        for (n = 0; n < this.money.length; ++n) {
            this.box[n].open = 0;
            this.box[n].player = 0;
            this.box[n].value = this.boxmoney[n];
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        graphics.setColor(Color.yellow);
        graphics.drawRect(0, 0, 639, 479);
        if (this.gamestate > 0) {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, 640, 480);
            graphics.setFont(this.fs);
            for (n = 0; n < 11; ++n) {
                if (this.showmoney[n] != 0) {
                    graphics.setColor(Color.blue);
                    graphics.fillRect(0, 86 + n * 20, 100, 15);
                    graphics.setColor(Color.white);
                    if (this.money[n] < 100) {
                        graphics.drawString(Integer.toString(this.money[n]) + "p", 10, 100 + n * 20);
                    } else {
                        graphics.drawString("\u00a3" + this.money[n] / 100, 10, 100 + n * 20);
                    }
                } else {
                    graphics.setColor(Color.gray);
                    graphics.fillRect(0, 86 + n * 20, 100, 15);
                }
                if (this.showmoney[n + 11] != 0) {
                    graphics.setColor(Color.red);
                    graphics.fillRect(540, 86 + n * 20, 100, 15);
                    graphics.setColor(Color.white);
                    if (this.money[n + 11] < 100 && this.showmoney[n + 11] != 0) {
                        graphics.drawString(Integer.toString(this.money[n + 11]) + "p", 550, 100 + n * 20);
                        continue;
                    }
                    graphics.drawString("\u00a3" + this.money[n + 11] / 100, 550, 100 + n * 20);
                    continue;
                }
                graphics.setColor(Color.gray);
                graphics.fillRect(540, 86 + n * 20, 100, 15);
            }
            for (n = 0; n < this.box.length; ++n) {
                this.box[n].draw(graphics);
            }
            graphics.setColor(Color.yellow);
            graphics.setFont(this.fs);
            graphics.drawString("Round : " + (this.cround + 1), 10, 20);
            graphics.drawString("Box " + this.count + " of " + this.round[this.cround], 10, 40);
            if (this.offer < 100) {
                graphics.drawString("Recent Offer: " + this.offer + "p", 300, 20);
            } else {
                graphics.drawString("Recent Offer: \u00a3" + this.offer / 100, 300, 20);
            }
            if (this.highest < 100) {
                graphics.drawString("Highest Offer: " + this.highest + "p", 300, 40);
            } else {
                graphics.drawString("Highest Offer: \u00a3" + this.highest / 100, 300, 40);
            }
            if (this.dealt > -1) {
                if (this.highest < 100) {
                    graphics.drawString("Dealt at " + this.dealt + "p", 10, 60);
                } else {
                    graphics.drawString("Dealt at \u00a3" + this.dealt / 100, 10, 60);
                }
            }
            if (this.playerbox == -1) {
                graphics.setColor(Color.black);
                graphics.fillRect(120, 80, 400, 140);
                graphics.setColor(Color.yellow);
                graphics.drawRect(120, 80, 400, 140);
                graphics.drawString("Choose your box!", 130, 100);
            }
        }
        switch (this.gamestate) {
            case 2: {
                int n2 = 0;
                int n3 = 0;
                int n4 = this.money[21];
                graphics.setColor(Color.black);
                graphics.fillRect(120, 80, 400, 140);
                graphics.setColor(Color.yellow);
                graphics.drawRect(120, 80, 400, 140);
                if (this.dealt == -1) {
                    this.button[0].x = 130;
                    this.button[0].draw(graphics);
                    this.button[1].x = 310;
                    this.button[1].draw(graphics);
                } else {
                    this.button[2].x = 130;
                    this.button[2].draw(graphics);
                }
                this.offer = 0;
                for (n = 0; n < this.showmoney.length; ++n) {
                    n3 += this.showmoney[n];
                    if (this.showmoney[n] <= 0) continue;
                    ++n2;
                    if (this.showmoney[n] >= n4) continue;
                    n4 = this.showmoney[n];
                }
                n3 /= n2;
                n3 -= n4;
                n3 /= 3;
                if ((n3 += n4) > 100000) {
                    do {
                        this.offer += 100000;
                    } while (this.offer < n3);
                } else {
                    this.offer = n3;
                }
                graphics.setColor(Color.yellow);
                if (this.offer < 100) {
                    graphics.drawString("The Banker offers " + this.offer + "p for your box.", 130, 100);
                } else {
                    graphics.drawString("The Banker offers \u00a3" + this.offer / 100 + " for your box.", 130, 100);
                }
                if (this.dealt != -1) {
                    if (this.dealt < this.offer) {
                        graphics.drawString("Could you have dealt too soon perhaps?", 130, 120);
                    }
                    if (this.dealt > this.offer) {
                        graphics.drawString("It looks like you may have dealt the right time..", 130, 120);
                    }
                }
                if (this.offer <= this.highest) break;
                this.highest = this.offer;
                break;
            }
            case 3: {
                int n5 = this.box[this.playerbox].value;
                graphics.setColor(Color.black);
                graphics.fillRect(120, 80, 400, 140);
                graphics.setColor(Color.yellow);
                graphics.drawRect(120, 80, 400, 140);
                this.button[2].x = 130;
                this.button[2].draw(graphics);
                graphics.setColor(Color.yellow);
                if (n5 < 100) {
                    graphics.drawString("Your box contains : " + n5 + "p", 130, 100);
                } else {
                    graphics.drawString("Your box contains : \u00a3" + n5 / 100, 130, 100);
                }
                if (this.dealt != -1) {
                    if (this.dealt < n5) {
                        graphics.drawString("You should not have been so quick to deal...", 130, 120);
                    }
                    if (this.dealt <= n5) break;
                    graphics.drawString("You sold your box for more than it was worth!", 130, 120);
                    break;
                }
                if (n5 == 1) {
                    graphics.drawString("We have a new member of the 1p club!", 130, 120);
                    break;
                }
                if (n5 < this.highest) {
                    graphics.drawString("You should have dealt earlier...", 130, 120);
                }
                if (n5 <= this.highest) break;
                graphics.drawString("You did the right thing by playing on!", 130, 120);
                break;
            }
            case 0: {
                Arrays.fill(this.line, "");
                graphics.setFont(this.fb);
                this.fmetric = graphics.getFontMetrics(this.fb);
                graphics.setColor(Color.black);
                graphics.fillRect(0, 0, 640, 480);
                this.mysterybox.draw(graphics);
                this.line[0] = title;
                this.line[2] = "Choose your box and see if you can";
                this.line[3] = "beat the banker!";
                this.line[18] = "Click to play!!";
                for (n = 0; n < this.line.length; ++n) {
                    if (n == 0 || n == 18) {
                        graphics.setFont(this.fm);
                        this.fmetric = graphics.getFontMetrics(this.fm);
                    } else {
                        graphics.setFont(this.fs);
                        this.fmetric = graphics.getFontMetrics(this.fs);
                    }
                    graphics.setColor(Color.black);
                    graphics.drawString(this.line[n], 2 + (640 - this.fmetric.stringWidth(this.line[n])) / 2, 62 + n * 18);
                    if (n >= 7 && n < 18) {
                        graphics.setColor(Color.white);
                    } else {
                        graphics.setColor(Color.yellow);
                    }
                    graphics.drawString(this.line[n], (640 - this.fmetric.stringWidth(this.line[n])) / 2, 60 + n * 18);
                }
                break;
            }
        }
        graphics.setColor(Color.cyan);
        graphics.drawLine(5, 460, 635, 460);
        graphics.drawString("http://ssjx.co.uk", 498, 475);
        graphics.drawString(version, 2, 475);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.gamestate) {
            case 0: {
                this.gamestate = 1;
                this.startgame();
                this.repaint();
                break;
            }
            case 1: {
                for (int i = 0; i < this.box.length; ++i) {
                    this.box[i].highlight = 0;
                    if (this.box[i].check(n, n2) != 1 || this.box[i].open != 0) continue;
                    if (this.playerbox == -1) {
                        this.playerbox = i;
                        this.box[i].player = 1;
                        continue;
                    }
                    if (i == this.playerbox) continue;
                    this.box[i].open = 1;
                    for (int j = 0; j < this.showmoney.length; ++j) {
                        if (this.box[i].value != this.showmoney[j]) continue;
                        this.showmoney[j] = 0;
                    }
                    ++this.count;
                    if (this.count != this.round[this.cround]) continue;
                    this.gamestate = 2;
                }
                break;
            }
            case 2: {
                if (this.dealt == -1) {
                    if (this.button[0].check(n, n2) == 1) {
                        this.dealt = this.offer;
                        if (this.cround == 5) {
                            this.gamestate = 3;
                        } else {
                            this.gamestate = 1;
                            this.count = 0;
                            ++this.cround;
                        }
                    }
                    if (this.button[1].check(n, n2) == 1) {
                        if (this.cround == 5) {
                            this.gamestate = 3;
                        } else {
                            this.gamestate = 1;
                            this.count = 0;
                            ++this.cround;
                        }
                    }
                } else if (this.button[2].check(n, n2) == 1) {
                    if (this.cround == 5) {
                        this.gamestate = 3;
                    } else {
                        this.gamestate = 1;
                        this.count = 0;
                        ++this.cround;
                    }
                }
                for (int i = 0; i < this.button.length; ++i) {
                    this.button[i].status = 0;
                }
                break;
            }
            case 3: {
                this.gamestate = 0;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.gamestate) {
            case 0: {
                break;
            }
            case 1: {
                for (int i = 0; i < this.box.length; ++i) {
                    this.box[i].highlight = 0;
                    if (this.box[i].check(n, n2) != 1) continue;
                    this.box[i].highlight = 1;
                }
                break;
            }
            case 2: {
                this.button[0].check(n, n2);
                this.button[1].check(n, n2);
                this.button[2].check(n, n2);
                break;
            }
            case 3: {
                this.button[2].check(n, n2);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }
}

