/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class Swan {
    private final int width = 20;
    private final int height = 15;
    private static Image img;
    private static boolean gfxloaded;
    private static Rectangle dest;
    private static Rectangle src;
    private static Random r;
    private static int[] order;
    boolean active;
    int x;
    int y;
    int ox;
    int oy;
    int xdir;
    int ydir;
    int frozen;
    int firedelay;
    int frame;
    private int fc = 0;
    private int alt = 0;

    public Swan() {
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/swans.gif");
                img = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the MAP sprites");
            }
        }
        this.reset();
    }

    public void set(int n, int n2) {
        this.active = true;
        this.frozen = 0;
        this.x = n;
        this.y = n2;
        this.ox = 0;
        this.oy = 0;
        this.xdir = 1;
        if (r.nextInt(10) > 4) {
            this.xdir = -1;
        }
        this.ydir = 0;
        this.frame = 0;
        this.firedelay = 0;
    }

    public void reset() {
        this.active = false;
        this.frozen = 0;
        this.x = 0;
        this.y = 0;
        this.ox = 0;
        this.oy = 0;
        this.xdir = 1;
        this.ydir = 0;
        this.frame = 0;
        this.firedelay = 0;
    }

    public void update(byte[] byArray) {
        if (this.active) {
            if (this.firedelay > 0) {
                --this.firedelay;
            }
            if (this.frozen > 0) {
                --this.frozen;
                return;
            }
            if (this.ox == 0 && this.oy == 0) {
                int n;
                if (this.x == 0 || this.x == 19) {
                    this.xdir *= -1;
                }
                if (byArray[n = this.y * 20 + this.x] == 5 && r.nextInt(10) > 7) {
                    byArray[n] = 3;
                }
                if (byArray[n] == 2) {
                    int n2;
                    boolean bl = false;
                    if (byArray[n + 20] == 1 || byArray[n + 20] == 0) {
                        if (this.ydir == 1) {
                            this.ydir = 0;
                            if (r.nextInt(10) > 4) {
                                Swan.order[0] = 1;
                                Swan.order[1] = 0;
                            }
                            for (n2 = 0; n2 < 2; ++n2) {
                                switch (order[n2]) {
                                    case 0: {
                                        if (byArray[n + 20 + 1] != 1 || byArray[n + 1] != 0) break;
                                        this.xdir = 1;
                                        bl = true;
                                        break;
                                    }
                                    case 1: {
                                        if (byArray[n + 20 - 1] != 1 || byArray[n - 1] != 0) break;
                                        this.xdir = -1;
                                        bl = true;
                                    }
                                }
                                if (bl) break;
                            }
                            if (!bl) {
                                this.ydir = -1;
                            }
                        } else if (r.nextInt(10) > 4) {
                            this.ydir = -1;
                        }
                    }
                    if (byArray[n - 20] == 0) {
                        if (this.ydir == -1) {
                            this.ydir = 0;
                            if (r.nextInt(10) > 4) {
                                Swan.order[0] = 1;
                                Swan.order[1] = 0;
                            }
                            for (n2 = 0; n2 < 2; ++n2) {
                                switch (order[n2]) {
                                    case 0: {
                                        if (byArray[n + 20 + 1] != 1 || byArray[n + 1] != 0) break;
                                        this.xdir = 1;
                                        bl = true;
                                        break;
                                    }
                                    case 1: {
                                        if (byArray[n + 20 - 1] != 1 || byArray[n - 1] != 0) break;
                                        this.xdir = -1;
                                        bl = true;
                                    }
                                }
                                if (bl) break;
                            }
                            if (!bl) {
                                this.ydir = 1;
                            }
                        } else if (r.nextInt(10) > 4) {
                            this.ydir = 1;
                        }
                    }
                } else if (byArray[n + 20 + this.xdir] == 0 || byArray[n + this.xdir] == 1) {
                    this.xdir *= -1;
                }
            }
            if (this.ydir == 0) {
                this.ox += this.xdir;
                if (this.ox == 32 || this.ox == -32) {
                    this.ox = 0;
                    this.x += this.xdir;
                }
            } else {
                this.oy += this.ydir;
                if (this.oy == 32 || this.oy == -32) {
                    this.oy = 0;
                    this.y += this.ydir;
                }
            }
        }
    }

    public void draw(Graphics graphics) {
        if (this.active) {
            int n = 0;
            if (this.frozen > 0) {
                if (this.frozen < 80) {
                    ++this.fc;
                    if (this.fc > 5) {
                        this.fc = 0;
                        this.frame = this.alt = 1 - this.alt;
                    }
                } else {
                    this.fc = 0;
                    this.frame = 1;
                }
            } else {
                this.frame = 0;
                this.alt = 0;
            }
            if (this.ydir == 0) {
                if (this.xdir == 1) {
                    n = (0 + this.frame) * 32;
                }
                if (this.xdir == -1) {
                    n = (2 + this.frame) * 32;
                }
            } else {
                n = (4 + this.frame) * 32;
            }
            Swan.dest.x = this.x * 32 + this.ox;
            Swan.dest.y = this.y * 32 + this.oy;
            Swan.src.x = n;
            graphics.drawImage(img, Swan.dest.x, Swan.dest.y, Swan.dest.x + 32, Swan.dest.y + 32, Swan.src.x, Swan.src.y, Swan.src.x + 32, Swan.src.y + 32, null);
        }
    }

    public boolean hit(Rectangle rectangle) {
        boolean bl = false;
        if (this.active) {
            if (this.frozen > 0) {
                return bl;
            }
            int n = this.x * 32 + this.ox + 6;
            int n2 = this.y * 32 + this.oy;
            Rectangle rectangle2 = new Rectangle(n, n2, 20, 32);
            if (rectangle2.intersects(rectangle) || rectangle.intersects(rectangle2)) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean shot_hit(int n, int n2) {
        if (this.active && this.frozen == 0) {
            int n3 = this.x * 32 + this.ox;
            int n4 = this.y * 32 + this.oy;
            if ((n += 4) >= n3 && n <= n3 + 32 && (n2 += 4) >= n4 && n2 <= n4 + 32) {
                this.frozen = 240;
                return true;
            }
        }
        return false;
    }

    static {
        gfxloaded = false;
        dest = new Rectangle(0, 0, 32, 32);
        src = new Rectangle(0, 0, 32, 32);
        r = new Random();
        order = new int[]{0, 1};
    }
}

