/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

public class Player {
    private final int width = 20;
    private final int height = 15;
    int score = 0;
    int shots = 3;
    int lives;
    private static Image img;
    private static boolean gfxloaded;
    int x;
    int y;
    int ox;
    int oy;
    int fc;
    int frame;
    int xdir;
    int ydir;
    int sprite;
    int jump = 0;
    int facing;
    Rectangle block = new Rectangle(0, 0, 32, 32);
    Rectangle pblock = new Rectangle(0, 0, 24, 32);
    Rectangle eggblock = new Rectangle(0, 0, 32, 15);
    Rectangle dest = new Rectangle(0, 0, 32, 32);
    Rectangle src = new Rectangle(0, 0, 32, 32);

    public Player() {
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/players.gif");
                img = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the MAP sprites");
            }
        }
        this.reset();
    }

    public void set(int n, int n2) {
        this.reset();
        this.x = n;
        this.y = n2;
    }

    public void reset() {
        this.x = 0;
        this.y = 0;
        this.ox = 0;
        this.oy = 0;
        this.fc = 0;
        this.frame = 0;
        this.xdir = 0;
        this.ydir = 0;
        this.sprite = 0;
        this.jump = 0;
        this.facing = -1;
        this.shots = 3;
    }

    private boolean onmap(byte[] byArray, int n, int n2, int n3) {
        int n4 = this.x * 32 + this.ox + n + 4;
        int n5 = this.y * 32 + this.oy + n2;
        this.pblock.x = n4;
        this.pblock.y = n5;
        for (int i = 0; i < 15; ++i) {
            this.block.y = i * 32;
            block5: for (int j = 0; j < 20; ++j) {
                byte by = byArray[i * 20 + j];
                if (by != n3) continue;
                switch (by) {
                    case 3: {
                        this.eggblock.x = j * 32;
                        this.eggblock.y = i * 32 + 17;
                        if (!this.pblock.intersects(this.eggblock) && !this.eggblock.intersects(this.pblock)) continue block5;
                        byArray[i * 20 + j] = 5;
                        return true;
                    }
                    case 4: {
                        this.eggblock.x = j * 32;
                        this.eggblock.y = i * 32 + 17;
                        if (!this.pblock.intersects(this.eggblock) && !this.eggblock.intersects(this.pblock)) continue block5;
                        byArray[i * 20 + j] = 0;
                        return true;
                    }
                    default: {
                        this.block.x = j * 32;
                        if (!this.pblock.intersects(this.block) && !this.block.intersects(this.pblock)) continue block5;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.xdir = n;
        this.ydir = n2;
        if (n != 0) {
            this.facing = n;
        }
        if (this.onmap(byArray, 0, 0, 3)) {
            this.score += 10;
        }
        if (this.onmap(byArray, 0, 0, 4)) {
            this.shots += 3;
            this.score += 5;
        }
        if (this.onmap(byArray, 0, 2, 1) && n2 == -1) {
            this.jump = 20;
        }
        if (this.onmap(byArray, 0, 0, 2)) {
            this.jump = 0;
        }
        if (this.jump > 0) {
            --this.jump;
            if (this.onmap(byArray, 0, -2, 1)) {
                this.jump = 0;
            }
            if (this.jump > 0) {
                this.oy -= 2;
                if (this.oy < 0) {
                    --this.y;
                    this.oy = 30;
                }
            }
        } else if (!this.onmap(byArray, 0, 0, 2)) {
            if (!this.onmap(byArray, 0, 2, 1)) {
                this.oy += 2;
                if (this.oy >= 32) {
                    ++this.y;
                    this.oy = 0;
                }
            }
        } else {
            switch (this.ydir) {
                case 1: {
                    if (!this.onmap(byArray, 0, 2, 1)) {
                        this.oy += 2;
                        if (this.oy == 32) {
                            ++this.y;
                            this.oy = 0;
                        }
                    }
                    ++this.fc;
                    this.sprite = 4;
                    break;
                }
                case -1: {
                    if (!this.onmap(byArray, 0, -2, 1)) {
                        this.oy -= 2;
                        if (this.oy < 0) {
                            --this.y;
                            this.oy = 30;
                        }
                    }
                    ++this.fc;
                    this.sprite = 4;
                }
            }
        }
        switch (this.xdir) {
            case 1: {
                if (this.x >= 19 || this.onmap(byArray, 2, 0, 1)) break;
                this.ox += 2;
                if (this.ox > 30) {
                    ++this.x;
                    this.ox = 0;
                }
                ++this.fc;
                this.sprite = 2;
                break;
            }
            case -1: {
                if (this.x <= -1 || this.onmap(byArray, -2, 0, 1)) break;
                this.ox -= 2;
                if (this.ox < 0) {
                    --this.x;
                    this.ox = 30;
                }
                ++this.fc;
                this.sprite = 0;
            }
        }
        if (this.fc >= 5) {
            this.frame = 1 - this.frame;
            this.fc = 0;
        }
    }

    public void draw(Graphics graphics) {
        this.dest.x = this.x * 32 + this.ox;
        this.dest.y = this.y * 32 + this.oy;
        this.src.x = (this.sprite + this.frame) * 32;
        graphics.drawImage(img, this.dest.x, this.dest.y, this.dest.x + 32, this.dest.y + 32, this.src.x, this.src.y, this.src.x + 32, this.src.y + 32, null);
    }

    public Rectangle player_rect() {
        this.pblock.x = this.x * 32 + this.ox + 4;
        this.pblock.y = this.y * 32 + this.oy;
        return this.pblock;
    }

    public boolean shot_hit(int n, int n2) {
        int n3 = this.x * 32 + this.ox + 8;
        int n4 = this.y * 32 + this.oy;
        return (n += 4) >= n3 && n <= n3 + 16 && (n2 += 4) >= n4 && n2 <= n4 + 32;
    }

    static {
        gfxloaded = false;
    }
}

