/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.InputStream;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

class Map {
    Shotxy[] shot = new Shotxy[50];
    static Random r = new Random();
    public int highscore = 0;
    int width;
    int height;
    int depth;
    int fc;
    int bonus;
    private static Image block;
    private static Image ladder;
    private static Image seed;
    private static Image egg;
    private static Image shot_img;
    private static boolean gfxloaded;
    byte[] map = new byte[300];
    byte[] map_copy = new byte[300];
    Swan[] myswan = new Swan[10];
    Player myplayer = new Player();
    boolean player_hit_by_shot;
    static Rectangle dest;
    static Rectangle src;

    public Map() {
        int n;
        if (!gfxloaded) {
            try {
                URL uRL = this.getClass().getResource("gfx/block.gif");
                block = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/ladder.gif");
                ladder = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/seed.gif");
                seed = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/egg.gif");
                egg = ImageIO.read(uRL);
                uRL = this.getClass().getResource("gfx/shot.gif");
                shot_img = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the MAP sprites");
            }
        }
        for (n = 0; n < this.myswan.length; ++n) {
            this.myswan[n] = new Swan();
        }
        for (n = 0; n < this.shot.length; ++n) {
            this.shot[n] = new Shotxy();
        }
    }

    public boolean load(int n, boolean bl) {
        boolean bl2 = false;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("levels/map" + n + ".bmp");
            byte[] byArray = inputStream.readAllBytes();
            inputStream.close();
            int n2 = byArray[10] + (byArray[11] << 8);
            this.width = byArray[18] + (byArray[19] << 8);
            this.height = byArray[22] + (byArray[23] << 8);
            this.depth = byArray[28] + (byArray[29] << 8);
            if (this.width * this.height <= this.map.length) {
                if (this.depth == 8) {
                    int n3 = 0;
                    for (int i = this.height - 1; i > -1; --i) {
                        for (int j = 0; j < this.width; ++j) {
                            this.map[n3] = byArray[n2 + i * this.width + j];
                            if (this.map[n3] == 5 || this.map[n3] == 6) {
                                int n4 = n3;
                                this.map[n4] = (byte)(this.map[n4] + 10);
                            }
                            this.map_copy[n3] = this.map[n3];
                            ++n3;
                        }
                    }
                    if (bl) {
                        this.mirror();
                    }
                    this.reset();
                    this.bonus = 333;
                    if (n == 1 && !bl) {
                        this.myplayer.score = 0;
                        this.myplayer.lives = 3;
                    }
                    bl2 = true;
                } else {
                    System.out.println("Depth should be 8 not " + this.depth);
                }
            } else {
                System.out.println("Level is too big for map buffer! " + byArray.length + " > " + this.map.length);
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading the map...");
        }
        return bl2;
    }

    public void reset() {
        int n = 0;
        for (byte by : this.map_copy) {
            if (by == 15 || by == 16) {
                this.map[n] = by;
            }
            ++n;
        }
        int n2 = 0;
        this.player_hit_by_shot = false;
        for (n2 = 0; n2 < this.myswan.length; ++n2) {
            this.myswan[n2].reset();
        }
        this.shot_reset();
        n2 = 0;
        for (int i = 0; i < this.height; ++i) {
            block7: for (n = 0; n < this.width; ++n) {
                switch (this.get(n, i)) {
                    case 15: {
                        this.myswan[n2].set(n, i);
                        this.set(n, i, (byte)0);
                        ++n2;
                        continue block7;
                    }
                    case 16: {
                        this.myplayer.set(n, i);
                        this.set(n, i, (byte)0);
                    }
                }
            }
        }
        this.fc = 0;
    }

    public void mirror() {
        int n;
        byte[] byArray = new byte[20];
        for (int i = 0; i < this.height; ++i) {
            for (n = 0; n < this.width; ++n) {
                byArray[n] = this.get(n, i);
            }
            for (n = 0; n < this.width; ++n) {
                this.set(n, i, byArray[this.width - 1 - n]);
            }
        }
        n = 0;
        byte[] byArray2 = this.map;
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            byte by;
            this.map_copy[n] = by = byArray2[i];
            ++n;
        }
    }

    public void draw_only(Graphics graphics) {
        for (int i = 0; i < this.height; ++i) {
            block8: for (int j = 0; j < this.width; ++j) {
                switch (this.get(j, i)) {
                    case 1: {
                        graphics.drawImage(block, j * 32, i * 32, null);
                        continue block8;
                    }
                    case 2: {
                        graphics.drawImage(ladder, j * 32, i * 32, null);
                        continue block8;
                    }
                    case 3: {
                        Map.dest.x = j * 32;
                        Map.dest.y = i * 32;
                        Map.src.x = 0;
                        graphics.drawImage(egg, Map.dest.x, Map.dest.y, Map.dest.x + 32, Map.dest.y + 32, Map.src.x, Map.src.y, Map.src.x + 32, Map.src.y + 32, null);
                        continue block8;
                    }
                    case 4: {
                        graphics.drawImage(seed, j * 32, i * 32, null);
                        continue block8;
                    }
                    case 5: {
                        Map.dest.x = j * 32;
                        Map.dest.y = i * 32;
                        Map.src.x = 32;
                        graphics.drawImage(egg, Map.dest.x, Map.dest.y, Map.dest.x + 32, Map.dest.y + 32, Map.src.x, Map.src.y, Map.src.x + 32, Map.src.y + 32, null);
                    }
                }
            }
        }
        for (int i = 0; i < this.myswan.length; ++i) {
            this.myswan[i].draw(graphics);
        }
        this.myplayer.draw(graphics);
        for (Shotxy shotxy : this.shot) {
            if (shotxy.owner == -1) continue;
            graphics.drawImage(shot_img, shotxy.x, shotxy.y, null);
        }
    }

    public void draw(Graphics graphics) {
        int n;
        for (int i = 0; i < this.height; ++i) {
            block8: for (n = 0; n < this.width; ++n) {
                switch (this.get(n, i)) {
                    case 1: {
                        graphics.drawImage(block, n * 32, i * 32, null);
                        continue block8;
                    }
                    case 2: {
                        graphics.drawImage(ladder, n * 32, i * 32, null);
                        continue block8;
                    }
                    case 3: {
                        Map.dest.x = n * 32;
                        Map.dest.y = i * 32;
                        Map.src.x = 0;
                        graphics.drawImage(egg, Map.dest.x, Map.dest.y, Map.dest.x + 32, Map.dest.y + 32, Map.src.x, Map.src.y, Map.src.x + 32, Map.src.y + 32, null);
                        continue block8;
                    }
                    case 4: {
                        graphics.drawImage(seed, n * 32, i * 32, null);
                        continue block8;
                    }
                    case 5: {
                        Map.dest.x = n * 32;
                        Map.dest.y = i * 32;
                        Map.src.x = 32;
                        graphics.drawImage(egg, Map.dest.x, Map.dest.y, Map.dest.x + 32, Map.dest.y + 32, Map.src.x, Map.src.y, Map.src.x + 32, Map.src.y + 32, null);
                    }
                }
            }
        }
        for (int i = 0; i < this.myswan.length; ++i) {
            this.myswan[i].update(this.map);
            this.myswan[i].draw(graphics);
            if (!this.myswan[i].active) continue;
            for (n = 0; n < this.shot.length; ++n) {
                if (this.shot[n].owner != 0 || !this.myswan[i].shot_hit(this.shot[n].x, this.shot[n].y)) continue;
                this.shot[n].owner = -1;
            }
            if (this.myswan[i].frozen != 0 || this.myswan[i].firedelay != 0 || this.myswan[i].y != this.myplayer.y) continue;
            if (this.myswan[i].x > this.myplayer.x && this.myswan[i].xdir == -1 && r.nextInt(10) > 7) {
                this.shot_add(this.myswan[i].x * 32 + this.myswan[i].ox, this.myswan[i].y * 32 + this.myswan[i].oy, this.myswan[i].xdir, 1);
                this.myswan[i].firedelay = 150;
            }
            if (this.myswan[i].x >= this.myplayer.x || this.myswan[i].xdir != 1 || r.nextInt(10) <= 7) continue;
            this.shot_add(this.myswan[i].x * 32 + this.myswan[i].ox, this.myswan[i].y * 32 + this.myswan[i].oy, this.myswan[i].xdir, 1);
            this.myswan[i].firedelay = 150;
        }
        this.myplayer.draw(graphics);
        for (n = 0; n < this.shot.length; ++n) {
            if (this.shot[n].owner != 1 || !this.myplayer.shot_hit(this.shot[n].x, this.shot[n].y)) continue;
            this.shot[n].owner = -1;
            this.player_hit_by_shot = true;
            return;
        }
        for (Shotxy shotxy : this.shot) {
            if (shotxy.owner == -1) continue;
            graphics.drawImage(shot_img, shotxy.x, shotxy.y, null);
        }
        this.shots_update();
        ++this.fc;
        if (this.fc == 30) {
            this.fc = 0;
            --this.bonus;
        }
    }

    public void move(int n, int n2, boolean bl) {
        this.myplayer.update(this.map, n, n2);
        if (bl && this.myplayer.shots > 0) {
            this.shot_add(this.myplayer.x * 32 + this.myplayer.ox, this.myplayer.y * 32 + this.myplayer.oy, this.myplayer.facing, 0);
            --this.myplayer.shots;
        }
    }

    public int check() {
        boolean bl = false;
        for (int i = 0; i < this.myswan.length; ++i) {
            if (this.myswan[i].hit(this.myplayer.player_rect())) {
                bl = true;
                break;
            }
            if (!this.player_hit_by_shot) continue;
            bl = true;
            break;
        }
        if (this.myplayer.y == 16) {
            bl = true;
        }
        if (bl) {
            --this.myplayer.lives;
            if (this.myplayer.lives > 0) {
                return 1;
            }
            if (this.myplayer.score > this.highscore) {
                this.highscore = this.myplayer.score;
            }
            return 2;
        }
        if (this.bonus <= 0) {
            if (this.myplayer.score > this.highscore) {
                this.highscore = this.myplayer.score;
            }
            return 3;
        }
        return 0;
    }

    public boolean is_highscore() {
        if (this.myplayer.score > this.highscore) {
            this.highscore = this.myplayer.score;
            return true;
        }
        return false;
    }

    byte get(int n, int n2) {
        return this.map[n2 * this.width + n];
    }

    void set(int n, int n2, byte by) {
        this.map[n2 * this.width + n] = by;
    }

    public void set_bonus(int n) {
        this.bonus = n;
    }

    public void cheat() {
        int n = 0;
        for (int i = 0; i < this.map.length; ++i) {
            if (this.map[i] == 3) {
                this.map[i] = 5;
            }
            if (this.map[i] == 5) {
                ++n;
            }
            if (n != 11) continue;
            return;
        }
    }

    public boolean all_eggs() {
        for (byte by : this.map) {
            if (by != 3) continue;
            return false;
        }
        this.myplayer.score += this.bonus;
        return true;
    }

    void shot_reset() {
        for (int i = 0; i < this.shot.length; ++i) {
            this.shot[i].owner = -1;
        }
    }

    int shot_free() {
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].owner != -1) continue;
            return i;
        }
        return -1;
    }

    void shot_add(int n, int n2, int n3, int n4) {
        int n5 = -1;
        n5 = this.shot_free();
        if (n5 >= 0) {
            this.shot[n5].owner = n4;
            this.shot[n5].x = n + 12;
            this.shot[n5].y = n2 + 12;
            this.shot[n5].xdir = n3;
            this.shot[n5].ydir = 0;
        }
    }

    void shots_update() {
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].owner == -1) continue;
            this.shot[i].x = this.shot[i].owner == 0 ? (this.shot[i].x += this.shot[i].xdir * 4) : (this.shot[i].x += this.shot[i].xdir * 2);
            if (this.shot[i].x < 0 || this.shot[i].x > 640) {
                this.shot[i].owner = -1;
            }
            if (this.shot[i].y >= 0 && this.shot[i].y <= 480) continue;
            this.shot[i].owner = -1;
        }
    }

    static {
        gfxloaded = false;
        dest = new Rectangle(0, 0, 32, 32);
        src = new Rectangle(0, 0, 32, 32);
    }
}

