/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Chuckie
extends JPanel
implements KeyListener {
    private static final String title = "Chuckie Egg Future";
    private static final String url = "http://ssjx.co.uk";
    private static final String version = "v0.1 (30/05/20)";
    private static final int swidth = 640;
    private static final int sheight = 480;
    private static final int fps = 60;
    private static int fpsdelay = 16;
    static Map mymap = new Map();
    static Title mytitle = new Title();
    int xd = 0;
    int yd = 0;
    int currentlevel = 1;
    int currentmap = 1;
    GameState state = GameState.TITLE;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean fire = false;
    int firedelay = 0;
    boolean spacedown = false;
    boolean escapedown = false;
    boolean mirror = false;
    FontMetrics fmetric;
    final Font smlFont = new Font("Arial", 0, 14);
    final Font medFont = new Font("Arial", 0, 16);
    final Font bigFont = new Font("Arial", 0, 20);
    final String[] hud_text = new String[]{"Score", "Shots", "Time", "Lives"};
    String[] hud_value = new String[]{"0", "1", "2", "3"};

    public Chuckie() {
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Chuckie.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
        this.state = GameState.TITLE;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Chuckie());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void show_hud(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics.setFont(this.smlFont);
        this.fmetric = graphics.getFontMetrics(this.smlFont);
        graphics.setColor(Color.magenta);
        for (n3 = 0; n3 < 4; ++n3) {
            n2 = this.fmetric.stringWidth(this.hud_text[n3]);
            n = 160 - n2 >> 1;
            graphics.drawString(this.hud_text[n3], n3 * 160 + n, 16);
        }
        graphics.setColor(Color.cyan);
        for (n3 = 0; n3 < 4; ++n3) {
            n2 = this.fmetric.stringWidth(this.hud_value[n3]);
            n = 160 - n2 >> 1;
            graphics.drawString(this.hud_value[n3], n3 * 160 + n, 32);
        }
    }

    public void update_hud() {
        this.hud_value[0] = String.valueOf(Chuckie.mymap.myplayer.score);
        this.hud_value[1] = String.valueOf(Chuckie.mymap.myplayer.shots);
        this.hud_value[2] = String.valueOf(Chuckie.mymap.bonus);
        this.hud_value[3] = String.valueOf(Chuckie.mymap.myplayer.lives);
    }

    public void reset_hud() {
        this.hud_value[0] = "-";
        this.hud_value[1] = "-";
        this.hud_value[2] = "-";
        this.hud_value[3] = "-";
    }

    void draw_bg(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 480);
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.state) {
            case TITLE: {
                this.draw_bg(graphics);
                mytitle.welcome(graphics, Chuckie.mymap.highscore);
                break;
            }
            case READY: {
                this.draw_bg(graphics);
                mymap.draw_only(graphics);
                this.show_hud(graphics);
                mytitle.ready(graphics, this.currentlevel);
                break;
            }
            case PLAY: {
                this.xd = 0;
                this.yd = 0;
                if (this.left) {
                    this.xd = -1;
                }
                if (this.right) {
                    this.xd = 1;
                }
                if (this.up) {
                    this.yd = -1;
                }
                if (this.down) {
                    this.yd = 1;
                }
                mymap.move(this.xd, this.yd, this.fire);
                this.draw_bg(graphics);
                mymap.draw(graphics);
                this.show_hud(graphics);
                this.update_hud();
                int n = mymap.check();
                if (n == 1) {
                    this.state = GameState.READY;
                }
                if (n == 2) {
                    this.state = GameState.FAIL;
                }
                if (n == 3) {
                    this.state = GameState.FAIL;
                }
                if (mymap.all_eggs()) {
                    this.state = GameState.LEVELDONE;
                }
                if (this.firedelay > 0) {
                    --this.firedelay;
                }
                this.fire = false;
                break;
            }
            case FAIL: {
                this.draw_bg(graphics);
                mymap.draw_only(graphics);
                this.show_hud(graphics);
                mytitle.gameover(graphics, this.hud_value[0]);
                break;
            }
            case LEVELDONE: {
                this.draw_bg(graphics);
                mymap.draw_only(graphics);
                this.show_hud(graphics);
                mytitle.leveldone(graphics);
                break;
            }
            case COMPLETED: {
                this.draw_bg(graphics);
                mymap.draw_only(graphics);
                this.show_hud(graphics);
                mytitle.gamedone(graphics, this.hud_value[0]);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.state) {
            case TITLE: {
                if (c != ' ') break;
                this.spacedown = false;
                this.currentlevel = 1;
                this.currentmap = 1;
                this.mirror = false;
                mymap.load(this.currentmap, this.mirror);
                this.reset_hud();
                this.state = GameState.READY;
                break;
            }
            case FAIL: {
                if (c != ' ') break;
                this.state = GameState.TITLE;
                break;
            }
            case READY: {
                if (c != ' ') break;
                mymap.reset();
                this.state = GameState.PLAY;
                this.up = false;
                this.down = false;
                this.left = false;
                this.right = false;
                this.fire = false;
                this.firedelay = 0;
                break;
            }
            case LEVELDONE: {
                if (c != ' ') break;
                if (this.currentlevel < 6) {
                    ++this.currentlevel;
                    ++this.currentmap;
                    if (this.currentmap > 3) {
                        this.currentmap = 1;
                        this.mirror = true;
                    }
                    mymap.load(this.currentmap, this.mirror);
                    this.state = GameState.READY;
                    break;
                }
                mymap.is_highscore();
                this.state = GameState.COMPLETED;
                break;
            }
            case COMPLETED: {
                if (c != ' ') break;
                this.state = GameState.TITLE;
                break;
            }
            case PLAY: {
                if (c == '\u001b') {
                    this.state = GameState.TITLE;
                }
                if (c == 'c') {
                    mymap.cheat();
                }
                if (c != 'q') break;
                mymap.is_highscore();
                this.state = GameState.FAIL;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.state == GameState.PLAY) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = false;
                    break;
                }
                case 40: {
                    this.down = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                    break;
                }
                case 32: {
                    this.fire = false;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.state == GameState.PLAY) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 32: {
                    this.fire = true;
                    this.firedelay = 30;
                }
            }
        }
    }

    public static enum GameState {
        TITLE,
        PLAY,
        FAIL,
        LEVELDONE,
        COMPLETED,
        READY;

    }
}

