/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Centipede
extends JPanel
implements KeyListener {
    private static final String title = "Centipede";
    private static final String url = "http://ssjx.co.uk";
    private static final String version = "v0.1 (28/05/20)";
    private static final int swidth = 480;
    private static final int sheight = 480;
    private static final int fps = 30;
    private static int fpsdelay = 33;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean fire = false;
    int[] grid = new int[900];
    Centxy[] cent = new Centxy[100];
    Playerxy player = new Playerxy();
    Shotxy[] shot = new Shotxy[20];
    int score = 0;
    int hiscore = 10;
    int level = 1;
    int clen = 10;
    String score_str;
    int alt = 0;
    int fc = 0;
    int firecount = 0;
    private FontMetrics fmetric;
    final int[] over_text = new int[]{2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 2, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 2};
    final int[] title_text = new int[]{1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1};
    State gamestate = State.WELCOME;
    static Image mushroom_img;
    static Image cent_img;
    static Image player_img;
    Rectangle dest = new Rectangle(0, 0, 16, 16);
    Rectangle src = new Rectangle(0, 0, 16, 16);
    private final Font smlFont = new Font("Arial", 0, 14);
    private final Font medFont = new Font("Arial", 0, 16);
    private final Font bigFont = new Font("Arial", 0, 20);
    String[] title_line = new String[]{"Use the arrows and space key to", "defeat the centipede!", "", "High Score", "", "", "Recent Score", "", "", "Press Space to start!"};

    public Centipede() {
        int n;
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(480, 480));
        this.addKeyListener(this);
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Centipede.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        thread.start();
        for (n = 0; n < this.cent.length; ++n) {
            this.cent[n] = new Centxy();
        }
        for (n = 0; n < this.shot.length; ++n) {
            this.shot[n] = new Shotxy();
        }
        try {
            URL uRL = Centipede.class.getClassLoader().getResource("mushroom.gif");
            mushroom_img = ImageIO.read(uRL);
            uRL = Centipede.class.getClassLoader().getResource("player.gif");
            player_img = ImageIO.read(uRL);
            uRL = Centipede.class.getClassLoader().getResource("cent.gif");
            cent_img = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the sprites");
        }
        this.setstate(this.gamestate);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Centipede());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void reset() {
        int n;
        for (n = 0; n < this.cent.length; ++n) {
            this.cent[n].a = -1;
        }
        int n2 = 10;
        for (n = 0; n < n2; ++n) {
            this.cent[n].head = false;
            this.cent[n].a = 1;
            this.cent[n].x = -n;
            this.cent[n].y = 1;
            this.cent[n].xdir = 1;
            this.cent[n].ydir = 1;
        }
        this.cent[0].head = true;
        for (n = 0; n < this.shot.length; ++n) {
            this.shot[n].a = 0;
        }
        this.player.x = 15;
        this.player.y = 27;
        this.player.lives = 3;
        for (n = 0; n < this.grid.length; ++n) {
            this.grid[n] = 0;
        }
        this.add_mushrooms(50);
        this.up = false;
        this.down = false;
        this.left = false;
        this.right = false;
        this.fire = false;
        this.firecount = 0;
        this.score = 0;
        this.score_str = String.valueOf(this.score);
    }

    void add_mushrooms(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = (int)Math.floor(Math.random() * 720.0);
            n2 = 60 + n3;
            this.grid[n2] = 4;
        }
    }

    void next_level() {
        int n = 0;
        ++this.level;
        this.score_str = String.valueOf(this.score);
        for (n = 0; n < this.cent.length; ++n) {
            this.cent[n].a = -1;
        }
        if (this.clen + 2 < this.cent.length) {
            this.clen += 2;
        }
        for (n = 0; n < this.clen; ++n) {
            this.cent[n].head = false;
            this.cent[n].a = 1;
            this.cent[n].x = -n;
            this.cent[n].y = 1;
            this.cent[n].xdir = 1;
            this.cent[n].ydir = 1;
        }
        this.cent[0].head = true;
        this.add_mushrooms(5);
    }

    void setstate(State state) {
        switch (state) {
            case WELCOME: {
                fpsdelay = 100;
                if (this.score > this.hiscore) {
                    this.hiscore = this.score;
                }
                this.title_line[4] = String.valueOf(this.hiscore);
                this.title_line[7] = String.valueOf(this.score);
                break;
            }
            case GAME: {
                fpsdelay = 33;
                this.reset();
                break;
            }
            case OVER: {
                fpsdelay = 100;
            }
        }
        this.gamestate = state;
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_bg(graphics);
                this.draw_title(graphics);
                this.draw_footer(graphics);
                break;
            }
            case GAME: {
                this.draw_bg(graphics);
                this.draw_game(graphics);
                if (this.cent_hit() && this.player.inv == 0) {
                    --this.player.lives;
                    if (this.player.lives < 0) {
                        this.setstate(State.OVER);
                    } else {
                        this.player.inv = 30;
                    }
                }
                this.alt = 1 - this.alt;
                ++this.fc;
                if (this.fc <= 1) break;
                this.shot_update();
                if (this.fc < 4) break;
                this.cent_update();
                this.fc = 0;
                break;
            }
            case OVER: {
                this.draw_bg(graphics);
                this.draw_game(graphics);
                this.draw_gameover(graphics);
            }
        }
    }

    void draw_bg(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 480, 480);
    }

    void draw_footer(Graphics graphics) {
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.cyan);
        graphics.drawString(url, 370, 475);
        graphics.drawString(version, 2, 475);
    }

    void draw_title(Graphics graphics) {
        int n;
        int n2 = 0;
        this.src.x = 48;
        this.src.y = 0;
        for (int i = 0; i < 5; ++i) {
            this.dest.y = 48 + i * 12;
            for (n = 0; n < 36; ++n) {
                if (this.title_text[n2] > 0) {
                    this.dest.x = 24 + n * 12;
                    graphics.drawImage(mushroom_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
                }
                ++n2;
            }
        }
        this.src.x = 16;
        this.src.y = 0;
        for (n = 0; n < 36; ++n) {
            this.dest.x = 24 + n * 12;
            this.dest.y = 24;
            graphics.drawImage(cent_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
            this.dest.y = 120;
            graphics.drawImage(cent_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
        }
        int n3 = 172;
        graphics.setFont(this.bigFont);
        this.fmetric = graphics.getFontMetrics(this.bigFont);
        for (n = 0; n < this.title_line.length; ++n) {
            Color color;
            switch (n) {
                case 3: 
                case 6: {
                    color = Color.orange;
                    break;
                }
                case 9: {
                    color = Color.yellow;
                    break;
                }
                default: {
                    color = Color.white;
                }
            }
            if (this.title_line[n].length() > 0) {
                graphics.setColor(color);
                graphics.drawString(this.title_line[n], (480 - this.fmetric.stringWidth(this.title_line[n])) / 2, n3);
            }
            n3 += 24;
        }
    }

    void draw_game(Graphics graphics) {
        int n;
        this.src.y = 0;
        this.src.x = 16;
        for (n = 0; n < this.shot.length; ++n) {
            if (this.shot[n].a != 1) continue;
            this.dest.x = this.shot[n].x * 16;
            this.dest.y = this.shot[n].y * 16;
            graphics.drawImage(player_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
        }
        int n2 = 0;
        int n3 = 0;
        this.src.y = 0;
        for (int i = 0; i < 30; ++i) {
            this.dest.y = i * 16;
            for (n = 0; n < 30; ++n) {
                if (this.grid[n3] > 0) {
                    n2 = this.grid[n3] - 1;
                    this.src.x = n2 * 16;
                    this.dest.x = n * 16;
                    graphics.drawImage(mushroom_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
                }
                ++n3;
            }
        }
        this.src.y = 0;
        for (n = 0; n < this.cent.length; ++n) {
            if (this.cent[n].a == 1 && this.cent[n].x >= 0) {
                this.dest.x = this.cent[n].x * 16;
                this.dest.y = this.cent[n].y * 16;
                if (!this.cent[n].head) {
                    this.src.x = 0;
                    graphics.drawImage(cent_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
                } else {
                    this.src.x = 16;
                    graphics.drawImage(cent_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
                }
            }
            if (this.cent[n].a == -1) break;
        }
        this.src.x = 0;
        this.src.y = 0;
        this.dest.x = this.player.x * 16;
        this.dest.y = this.player.y * 16;
        if (this.player.inv > 0) {
            --this.player.inv;
            if (this.alt == 1) {
                graphics.drawImage(player_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
            }
        } else {
            graphics.drawImage(player_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
        }
        if (this.left && this.gridpos(this.player.x - 1, this.player.y) == 0 && this.player.x > 0) {
            --this.player.x;
        }
        if (this.right && this.player.x + 1 <= 29 && this.gridpos(this.player.x + 1, this.player.y) == 0) {
            ++this.player.x;
        }
        if (this.up && this.gridpos(this.player.x, this.player.y - 1) == 0 && this.player.y > 21) {
            --this.player.y;
        }
        if (this.down && this.player.y + 1 <= 29 && this.gridpos(this.player.x, this.player.y + 1) == 0) {
            ++this.player.y;
        }
        if (this.firecount == 0) {
            if (this.fire) {
                this.shot_add(this.player.x, this.player.y);
                this.firecount = 5;
            }
        } else {
            --this.firecount;
        }
        this.src.x = 0;
        this.src.y = 0;
        this.dest.y = 0;
        this.dest.x = 0;
        for (n = 0; n < this.player.lives; ++n) {
            graphics.drawImage(player_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
            this.dest.x += 16;
        }
        int n4 = 480 - this.fmetric.stringWidth(this.score_str);
        graphics.setColor(Color.yellow);
        graphics.setFont(this.medFont);
        graphics.drawString(this.score_str, n4, 12);
    }

    void draw_gameover(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        this.src.x = n3 * 16;
        this.src.y = 0;
        for (n2 = 0; n2 < 30; ++n2) {
            this.dest.y = n2 * 16;
            for (n = 0; n < 30; ++n) {
                if (this.grid[n4] > 0) {
                    this.dest.x = n * 16;
                    graphics.drawImage(mushroom_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
                }
                ++n4;
            }
        }
        n4 = 0;
        this.src.x = 16;
        this.src.y = 0;
        for (n2 = 0; n2 < 11; ++n2) {
            this.dest.y = 128 + n2 * 16;
            for (n = 0; n < 20; ++n) {
                if (this.over_text[n4] > 0) {
                    this.dest.x = 80 + n * 16;
                    graphics.drawImage(cent_img, this.dest.x, this.dest.y, this.dest.x + 16, this.dest.y + 16, this.src.x, this.src.y, this.src.x + 16, this.src.y + 16, null);
                }
                ++n4;
            }
        }
        if (this.score > this.hiscore) {
            graphics.setFont(this.bigFont);
            this.fmetric = graphics.getFontMetrics(this.bigFont);
            int n5 = 480 - this.fmetric.stringWidth("You have a new high score!") >> 1;
            graphics.drawString("You have a new high score!", n5, 344);
        }
    }

    void draw_welldone(Graphics graphics) {
    }

    void cent_update() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.clen; ++i) {
            n = this.cent[i].y == 1 && this.cent[i].x < 0 ? 0 : this.cent[i].x + this.cent[i].xdir;
            if (n > 29 || n < 0) {
                this.cent[i].xdir *= -1;
                n2 = this.cent[i].y + this.cent[i].ydir;
                if (n2 < 0 || n2 > 29) {
                    this.cent[i].ydir *= -1;
                }
                if (this.cent[i].ydir == -1 && n > 29 && n2 <= 20) {
                    this.cent[i].ydir *= -1;
                }
                this.cent[i].y += this.cent[i].ydir;
                continue;
            }
            if (this.gridpos(this.cent[i].x + this.cent[i].xdir, this.cent[i].y) == 0) {
                this.cent[i].x += this.cent[i].xdir;
                continue;
            }
            this.cent[i].xdir *= -1;
            n2 = this.cent[i].y + this.cent[i].ydir;
            if (n2 < 0 || n2 > 29) {
                this.cent[i].ydir *= -1;
            }
            if (this.cent[i].ydir == -1 && n2 <= 20) {
                this.cent[i].ydir *= -1;
            }
            this.cent[i].y += this.cent[i].ydir;
        }
    }

    int cent_check() {
        int n = 0;
        for (Centxy centxy : this.cent) {
            if (centxy.a != 1) continue;
            ++n;
        }
        return n;
    }

    boolean cent_hit() {
        if (this.player.inv > 0) {
            return false;
        }
        for (int i = 0; i < this.clen; ++i) {
            if (this.cent[i].a != 1 || this.cent[i].x != this.player.x || this.cent[i].y != this.player.y) continue;
            return true;
        }
        return false;
    }

    void cent_head() {
        for (int i = 1; i < this.clen; ++i) {
            if (this.cent[i - 1].a != 0 || this.cent[i].a != 1) continue;
            this.cent[i].head = true;
        }
    }

    void shot_add(int n, int n2) {
        for (int i = 0; i < this.shot.length; ++i) {
            if (this.shot[i].a != 0) continue;
            this.shot[i].a = 1;
            this.shot[i].x = n;
            this.shot[i].y = n2;
            break;
        }
    }

    void shot_update() {
        int n = 0;
        for (int i = 0; i < this.shot.length; ++i) {
            int n2;
            if (this.shot[i].a != 1) continue;
            if (this.shot[i].y < 0) {
                this.shot[i].a = 0;
                continue;
            }
            for (n = 0; n < this.cent.length; ++n) {
                if (this.cent[n].a != 1 || this.cent[n].x != this.shot[i].x || this.cent[n].y != this.shot[i].y) continue;
                this.score += 10;
                this.score_str = String.valueOf(this.score);
                this.shot[i].a = 0;
                this.cent[n].a = 0;
                this.grid_set(this.cent[n].x, this.cent[n].y, 4);
                if (this.cent_check() == 0) {
                    this.next_level();
                }
                this.cent_head();
                break;
            }
            if (this.shot[i].a == 1 && (n2 = this.gridpos(this.shot[i].x, this.shot[i].y)) > 0) {
                this.grid_set(this.shot[i].x, this.shot[i].y, n2 - 1);
                this.shot[i].a = 0;
                if (this.gridpos(this.shot[i].x, this.shot[i].y) == 0) {
                    this.score += 10;
                    this.score_str = String.valueOf(this.score);
                }
            }
            if (this.shot[i].a != 1) continue;
            --this.shot[i].y;
        }
    }

    void grid_set(int n, int n2, int n3) {
        int n4 = n2 * 30 + n;
        this.grid[n4] = n3;
    }

    int gridpos(int n, int n2) {
        int n3 = n2 * 30 + n;
        if (n3 < 0) {
            return 0;
        }
        return this.grid[n3];
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = false;
                    break;
                }
                case 40: {
                    this.down = false;
                    break;
                }
                case 37: {
                    this.left = false;
                    break;
                }
                case 39: {
                    this.right = false;
                    break;
                }
                case 32: {
                    this.fire = false;
                }
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.gamestate == State.GAME) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.up = true;
                    break;
                }
                case 40: {
                    this.down = true;
                    break;
                }
                case 37: {
                    this.left = true;
                    break;
                }
                case 39: {
                    this.right = true;
                    break;
                }
                case 32: {
                    this.fire = true;
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != 'q') break;
                this.setstate(State.OVER);
                break;
            }
            case OVER: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    public static enum State {
        WELCOME,
        GAME,
        OVER;

    }
}

