/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import javax.imageio.ImageIO;

class Explosion {
    private static Image explosion_img;
    private static boolean gfxloaded;
    Xy[] explo = new Xy[20];

    public Explosion() {
        if (!gfxloaded) {
            try {
                URL uRL = Explosion.class.getClassLoader().getResource("gfx/explosion.png");
                explosion_img = ImageIO.read(uRL);
                gfxloaded = true;
            }
            catch (Exception exception) {
                System.out.println("Problem loading the Explosion sprite ");
                System.out.println(exception);
            }
        }
        for (int i = 0; i < this.explo.length; ++i) {
            this.explo[i] = new Xy();
        }
    }

    public void reset() {
        for (int i = 0; i < this.explo.length; ++i) {
            this.explo[i].active = false;
        }
    }

    public void add(int n, int n2) {
        for (int i = 0; i < this.explo.length; ++i) {
            if (this.explo[i].active) continue;
            this.explo[i].active = true;
            this.explo[i].x = n;
            this.explo[i].y = n2;
            this.explo[i].dist = 2;
            break;
        }
    }

    public void draw(Graphics graphics) {
        for (Xy xy : this.explo) {
            if (!xy.active) continue;
            int n = xy.x;
            int n2 = xy.y + xy.dist;
            graphics.drawImage(explosion_img, n, n2, null);
            n2 = xy.y - xy.dist;
            graphics.drawImage(explosion_img, n, n2, null);
            n2 = xy.y;
            n = xy.x + xy.dist;
            graphics.drawImage(explosion_img, n, n2, null);
            n = xy.x - xy.dist;
            graphics.drawImage(explosion_img, n, n2, null);
        }
    }

    public void update() {
        for (int i = 0; i < this.explo.length; ++i) {
            if (!this.explo[i].active) continue;
            this.explo[i].dist += 2;
            if (this.explo[i].dist <= 32) continue;
            this.explo[i].active = false;
        }
    }

    static {
        gfxloaded = false;
    }
}

