/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Cavern
extends JPanel
implements KeyListener {
    private final Font smlFont = new Font("Arial", 0, 16);
    private final Font medFont = new Font("Arial", 0, 18);
    private final Font bigFont = new Font("Arial", 0, 20);
    private FontMetrics fmetric;
    private static final String title = "Cavern Rescue (Java)";
    final String url = "http://ssjx.co.uk";
    final String version = "v0.2 (05/06/21)";
    final int swidth = 640;
    final int sheight = 480;
    private static final int fps = 30;
    private static int fpsdelay = 33;
    final int mapw = 40;
    final int maph = 30;
    boolean up = false;
    boolean down = false;
    boolean left = false;
    boolean right = false;
    boolean fire = false;
    boolean up_key = false;
    boolean down_key = false;
    boolean left_key = false;
    boolean right_key = false;
    boolean space_key = false;
    Map mymap = new Map();
    int[][] grid = new int[40][30];
    boolean[][] visible = new boolean[40][30];
    Xy player = new Xy();
    Xy[] alien = new Xy[10];
    int hostage_total = 0;
    Xy[] hostage = new Xy[5];
    Xy[] pulse = new Xy[3];
    Xy chip = new Xy();
    Explosion exp = new Explosion();
    Teleport tele = new Teleport();
    final String help_txt = "You have 1 movement step remaining";
    int help_count = 0;
    int[] newdir = new int[]{0, 1, 2, 3};
    final int[] over_text = new int[]{2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 2, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 2};
    final int[] title_text = new int[]{1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1};
    final int[] welldone_text = new int[]{1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1};
    State gamestate = State.WELCOME;
    static Image darkwall_img;
    static Image wall_img;
    static Image floor_img;
    static Image grass_img;
    static Image flower_img;
    static Image player_img;
    static Image spider_img;
    static Image hostage_img;
    static Image red_img;
    static Image green_img;
    static Image blue_img;
    static Image chip_img;
    static Image orb_img;
    Point dest = new Point(0, 0);
    Random r = new Random();
    String host_txt = "";
    final String[] title_line = new String[]{"Find and save the five hostages, avoid the aliens!", "", "Each turn you can perform one of two actions, this can be", "either TWO movement steps or ONE pulse.", "", "Controls:", "Arrow Keys - Move", "Space - Pulse Weapon", "", "Pulse wil destroy all surrounding enemies, however", "you only start with enough power for two bursts!", "", "Press Space to start!"};

    public Cavern() {
        Object object;
        int n;
        this.setFocusable(true);
        this.requestFocus();
        this.setPreferredSize(new Dimension(640, 480));
        this.addKeyListener(this);
        for (n = 0; n < this.hostage.length; ++n) {
            this.hostage[n] = new Xy();
        }
        for (n = 0; n < this.pulse.length; ++n) {
            this.pulse[n] = new Xy();
        }
        for (n = 0; n < this.alien.length; ++n) {
            this.alien[n] = new Xy();
            this.alien[n].state = 0;
        }
        try {
            object = Cavern.class.getClassLoader().getResource("gfx/wall.gif");
            wall_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/darkwall.gif");
            darkwall_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/floor.gif");
            floor_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/grass.gif");
            grass_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/flower.gif");
            flower_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/player.gif");
            player_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/spider.gif");
            spider_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/oldman.gif");
            hostage_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/chip.gif");
            chip_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/orb.gif");
            orb_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/red.gif");
            red_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/green.gif");
            green_img = ImageIO.read((URL)object);
            object = Cavern.class.getClassLoader().getResource("gfx/blue.gif");
            blue_img = ImageIO.read((URL)object);
        }
        catch (Exception exception) {
            System.out.println("Problem loading the sprites!");
            System.out.println(exception);
        }
        this.setstate(this.gamestate);
        object = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Cavern.this.repaint();
                    try {
                        Thread.sleep(fpsdelay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        ((Thread)object).start();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame(title);
        jFrame.setResizable(false);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setContentPane(new Cavern());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    void jumble() {
        for (int i = 0; i < 20; ++i) {
            int n = this.r.nextInt(this.newdir.length);
            int n2 = this.r.nextInt(this.newdir.length);
            int n3 = this.newdir[n];
            this.newdir[n] = this.newdir[n2];
            this.newdir[n2] = n3;
        }
    }

    void reset() {
        int n;
        int n2;
        int n3;
        int n4;
        this.host_txt = "5 Hostages Remaining";
        this.up = false;
        this.down = false;
        this.left = false;
        this.right = false;
        this.fire = false;
        this.mymap.create_map();
        for (n4 = 0; n4 < 30; ++n4) {
            for (n3 = 0; n3 < 40; ++n3) {
                this.visible[n3][n4] = false;
                this.grid[n3][n4] = this.mymap.finale[n3][n4];
            }
        }
        n4 = 0;
        do {
            if (this.grid[n3 = this.r.nextInt(40)][n2 = this.r.nextInt(30)] != 2) continue;
            this.alien[n4].state = 1;
            this.alien[n4].x = n3;
            this.alien[n4].y = n2;
            this.alien[n4].xdir = 0;
            this.alien[n4].ydir = 0;
            ++n4;
        } while (n4 < this.alien.length);
        this.player.step = 0;
        this.player.health = 1;
        this.player.shots = 2;
        while (this.grid[n3 = this.r.nextInt(40)][n2 = this.r.nextInt(30)] != 2) {
        }
        this.player.x = n3;
        this.player.y = n2;
        this.make_visible(this.player.x, this.player.y);
        this.hostage_total = this.hostage.length;
        n3 = 0;
        do {
            if (this.grid[n2 = this.r.nextInt(40)][n = this.r.nextInt(30)] != 2) continue;
            this.hostage[n3].a = 1;
            this.hostage[n3].x = n2;
            this.hostage[n3].y = n;
            ++n3;
        } while (n3 < this.hostage.length);
        n3 = 0;
        do {
            if (this.grid[n2 = this.r.nextInt(40)][n = this.r.nextInt(30)] != 2) continue;
            this.pulse[n3].a = 1;
            this.pulse[n3].x = n2;
            this.pulse[n3].y = n;
            ++n3;
        } while (n3 < this.pulse.length);
        while (this.grid[n2 = this.r.nextInt(40)][n = this.r.nextInt(30)] != 2) {
        }
        this.chip.a = 1;
        this.chip.x = n2;
        this.chip.y = n;
        for (n2 = 0; n2 < 30; ++n2) {
            int n5;
            n = this.r.nextInt(40);
            if (this.grid[n][n5 = this.r.nextInt(30)] != 0) continue;
            this.grid[n][n5] = 3;
        }
        this.exp.reset();
        this.tele.reset();
    }

    void setstate(State state) {
        switch (state) {
            case WELCOME: {
                break;
            }
            case GAME: {
                this.reset();
            }
        }
        this.gamestate = state;
    }

    @Override
    public void paint(Graphics graphics) {
        switch (this.gamestate) {
            case WELCOME: {
                this.draw_bg(graphics);
                this.draw_title(graphics);
                this.draw_footer(graphics);
                break;
            }
            case GAME: {
                this.draw_bg(graphics);
                this.draw_game_only(graphics);
                this.update_game();
                if (this.player.health > 0) break;
                this.setstate(State.OVER);
                break;
            }
            case OVER: {
                this.draw_bg(graphics);
                this.draw_game_only(graphics);
                this.draw_gameover(graphics);
                break;
            }
            case COMPLETE: {
                this.draw_bg(graphics);
                this.draw_game_only(graphics);
                this.draw_welldone(graphics);
            }
        }
    }

    void draw_bg(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, 640, 480);
    }

    private void draw_footer(Graphics graphics) {
        graphics.setFont(this.smlFont);
        graphics.setColor(Color.cyan);
        graphics.drawString("http://ssjx.co.uk", 530, 478);
        graphics.drawString("v0.2 (05/06/21)", 2, 478);
    }

    void draw_title(Graphics graphics) {
        int n;
        int n2 = 0;
        for (int i = 0; i < 11; ++i) {
            this.dest.y = 8 + i * 16;
            for (n = 0; n < 29; ++n) {
                if (this.title_text[n2] > 0) {
                    this.dest.x = 88 + n * 16;
                    graphics.drawImage(green_img, this.dest.x, this.dest.y, null);
                }
                ++n2;
            }
        }
        graphics.setFont(this.medFont);
        this.fmetric = graphics.getFontMetrics(this.medFont);
        for (n = 0; n < this.title_line.length; ++n) {
            Color color;
            switch (n) {
                case 0: {
                    color = Color.yellow;
                    break;
                }
                case 5: {
                    color = Color.orange;
                    break;
                }
                case 12: {
                    color = Color.yellow;
                    break;
                }
                default: {
                    color = Color.white;
                }
            }
            int n3 = (640 - this.fmetric.stringWidth(this.title_line[n])) / 2;
            int n4 = 208 + n * 20;
            graphics.setColor(color);
            graphics.drawString(this.title_line[n], n3, n4);
        }
    }

    void draw_game_only(Graphics graphics) {
        int n;
        int n2;
        this.dest.x = 0;
        this.dest.y = 0;
        for (n2 = 0; n2 < 30; ++n2) {
            for (n = 0; n < 40; ++n) {
                if (this.visible[n][n2]) {
                    switch (this.grid[n][n2]) {
                        case 0: {
                            graphics.drawImage(grass_img, this.dest.x, this.dest.y, null);
                            break;
                        }
                        case 2: {
                            graphics.drawImage(floor_img, this.dest.x, this.dest.y, null);
                            break;
                        }
                        case 3: {
                            graphics.drawImage(flower_img, this.dest.x, this.dest.y, null);
                        }
                    }
                }
                this.dest.x += 16;
            }
            this.dest.x = 0;
            this.dest.y += 16;
        }
        this.dest.x = 0;
        this.dest.y = 12;
        for (n2 = 0; n2 < 30; ++n2) {
            for (n = 0; n < 40; ++n) {
                if (this.visible[n][n2]) {
                    switch (this.grid[n][n2]) {
                        case 1: {
                            graphics.drawImage(darkwall_img, this.dest.x, this.dest.y, null);
                        }
                    }
                }
                this.dest.x += 16;
            }
            this.dest.x = 0;
            this.dest.y += 16;
        }
        this.dest.x = 0;
        this.dest.y = 0;
        for (n2 = 0; n2 < 30; ++n2) {
            for (n = 0; n < 40; ++n) {
                if (this.visible[n][n2]) {
                    switch (this.grid[n][n2]) {
                        case 1: {
                            graphics.drawImage(wall_img, this.dest.x, this.dest.y, null);
                        }
                    }
                }
                this.dest.x += 16;
            }
            this.dest.x = 0;
            this.dest.y += 16;
        }
        for (Xy xy : this.hostage) {
            if (xy.a <= 0 || !this.visible[xy.x][xy.y]) continue;
            this.dest.x = xy.x * 16;
            this.dest.y = xy.y * 16;
            graphics.drawImage(hostage_img, this.dest.x, this.dest.y, null);
        }
        for (Xy xy : this.pulse) {
            if (xy.a <= 0 || !this.visible[xy.x][xy.y]) continue;
            this.dest.x = xy.x * 16;
            this.dest.y = xy.y * 16;
            graphics.drawImage(orb_img, this.dest.x, this.dest.y, null);
        }
        if (this.chip.a > 0 && this.visible[this.chip.x][this.chip.y]) {
            this.dest.x = this.chip.x * 16;
            this.dest.y = this.chip.y * 16;
            graphics.drawImage(chip_img, this.dest.x, this.dest.y, null);
        }
        this.dest.x = this.player.x * 16;
        this.dest.y = this.player.y * 16;
        graphics.drawImage(player_img, this.dest.x, this.dest.y, null);
        for (Xy xy : this.alien) {
            if (xy.state <= 0) continue;
            this.dest.x = xy.x * 16;
            this.dest.y = xy.y * 16;
            if (!this.visible[xy.x][xy.y]) continue;
            graphics.drawImage(spider_img, this.dest.x, this.dest.y, null);
        }
        this.exp.draw(graphics);
        this.tele.draw(graphics);
        graphics.setFont(this.medFont);
        graphics.setColor(Color.yellow);
        graphics.drawString(this.host_txt, 2, 16);
        this.dest.y = 0;
        for (n = 0; n < this.player.shots; ++n) {
            this.dest.x = 624 - n * 16;
            graphics.drawImage(blue_img, this.dest.x, this.dest.y, null);
        }
        if (this.help_count > 0) {
            --this.help_count;
            int n3 = (640 - this.fmetric.stringWidth("You have 1 movement step remaining")) / 2;
            graphics.setColor(Color.black);
            graphics.drawString("You have 1 movement step remaining", n3 + 1, 39);
            graphics.setColor(Color.red);
            graphics.drawString("You have 1 movement step remaining", n3, 38);
        }
    }

    void show_map() {
        for (int i = 0; i < 30; ++i) {
            for (int j = 0; j < 40; ++j) {
                this.visible[j][i] = true;
            }
        }
    }

    boolean clear_line(int n, int n2, int n3, int n4) {
        if (n == n3) {
            int n5;
            int n6;
            if (n2 < n4) {
                n6 = n2;
                n5 = n4;
            } else {
                n6 = n4;
                n5 = n2;
            }
            ++n5;
            for (int i = n6; i < n5; ++i) {
                if (this.gridpos(n, i) == 2) continue;
                return false;
            }
            return true;
        }
        if (n2 == n4) {
            int n7;
            int n8;
            if (n < n3) {
                n8 = n;
                n7 = n3;
            } else {
                n8 = n3;
                n7 = n;
            }
            ++n7;
            for (int i = n8; i < n7; ++i) {
                if (this.gridpos(i, n2) == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void update_game() {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < this.hostage.length; ++n4) {
            if (this.hostage[n4].a == 0 || this.hostage[n4].x != this.player.x || this.hostage[n4].y != this.player.y) continue;
            this.hostage[n4].a = 0;
            this.tele.add(this.hostage[n4].x, this.hostage[n4].y);
            --this.hostage_total;
            this.host_txt = this.hostage_total + " Hostages Remaining";
            if (this.hostage_total != 0) continue;
            this.setstate(State.COMPLETE);
        }
        for (n4 = 0; n4 < this.pulse.length; ++n4) {
            if (this.pulse[n4].a == 0 || this.pulse[n4].x != this.player.x || this.pulse[n4].y != this.player.y) continue;
            this.pulse[n4].a = 0;
            ++this.player.shots;
        }
        if (this.chip.a != 0 && this.chip.x == this.player.x && this.chip.y == this.player.y) {
            this.chip.a = 0;
            this.show_map();
        }
        n4 = this.player.step++;
        if (this.left) {
            this.left = false;
            if (this.gridpos(this.player.x - 1, this.player.y) == 2 && this.player.x > 0) {
                --this.player.x;
            }
        }
        if (this.right) {
            this.right = false;
            if (this.gridpos(this.player.x + 1, this.player.y) == 2 && this.player.x + 1 <= 39) {
                ++this.player.x;
                ++this.player.step;
            }
        }
        if (this.up) {
            this.up = false;
            if (this.gridpos(this.player.x, this.player.y - 1) == 2 && this.player.y > 0) {
                --this.player.y;
                ++this.player.step;
            }
        }
        if (this.down) {
            this.down = false;
            if (this.gridpos(this.player.x, this.player.y + 1) == 2 && this.player.y + 1 <= 29) {
                ++this.player.y;
                ++this.player.step;
            }
        }
        if (n4 != this.player.step) {
            this.make_visible(this.player.x, this.player.y);
        }
        for (Xy object : this.alien) {
            if (object.state <= 0 || this.player.x != object.x || this.player.y != object.y) continue;
            --this.player.health;
        }
        for (n3 = 0; n3 < this.alien.length; ++n3) {
            n2 = 0;
            if (this.clear_line(this.player.x, this.player.y, this.alien[n3].x, this.alien[n3].y)) {
                n2 = 1;
            }
            if (n2 != 1) continue;
            this.alien[n3].xdir = 0;
            this.alien[n3].ydir = 0;
            if (this.alien[n3].x > this.player.x && this.gridpos(this.alien[n3].x - 1, this.alien[n3].y) == 2) {
                this.alien[n3].xdir = -1;
            }
            if (this.alien[n3].x < this.player.x && this.gridpos(this.alien[n3].x + 1, this.alien[n3].y) == 2) {
                this.alien[n3].xdir = 1;
            }
            if (this.alien[n3].xdir != 0) continue;
            if (this.alien[n3].y > this.player.y && this.gridpos(this.alien[n3].x, this.alien[n3].y - 1) == 2) {
                this.alien[n3].ydir = -1;
            }
            if (this.alien[n3].y >= this.player.y || this.gridpos(this.alien[n3].x, this.alien[n3].y + 1) != 2) continue;
            this.alien[n3].ydir = 1;
        }
        if (this.player.step >= 2) {
            this.help_count = 0;
            this.player.step = 0;
            block10: for (n3 = 0; n3 < this.alien.length; ++n3) {
                if (this.gridpos(this.alien[n3].x + this.alien[n3].xdir, this.alien[n3].y + this.alien[n3].ydir) == 2) {
                    this.alien[n3].x += this.alien[n3].xdir;
                    this.alien[n3].y += this.alien[n3].ydir;
                } else {
                    this.alien[n3].xdir = 0;
                    this.alien[n3].ydir = 0;
                }
                if (this.alien[n3].xdir != 0 || this.alien[n3].ydir != 0) continue;
                this.jumble();
                n2 = 0;
                n = 0;
                for (int n5 : this.newdir) {
                    switch (n5) {
                        case 0: {
                            n2 = 0;
                            n = -1;
                            break;
                        }
                        case 1: {
                            n2 = 0;
                            n = 1;
                            break;
                        }
                        case 2: {
                            n2 = -1;
                            n = 0;
                            break;
                        }
                        case 3: {
                            n2 = 1;
                            n = 0;
                        }
                    }
                    if (this.gridpos(this.alien[n3].x + n2, this.alien[n3].y + n) != 2) continue;
                    this.alien[n3].xdir = n2;
                    this.alien[n3].ydir = n;
                    continue block10;
                }
            }
            for (Xy xy : this.alien) {
                if (xy.state <= 0 || this.player.x != xy.x || this.player.y != xy.y) continue;
                --this.player.health;
            }
        }
        int n5 = 0;
        if (this.fire) {
            this.fire = false;
            n2 = 0;
            if (this.player.shots > 0) {
                for (n5 = 0; n5 < 3; ++n5) {
                    for (n = 0; n < 3; ++n) {
                        int n6 = this.hit_spider(this.player.x - 1 + n, this.player.y - 1 + n5);
                        if (n6 <= -1) continue;
                        this.exp.add((this.player.x - 1 + n) * 16, (this.player.y - 1 + n5) * 16);
                        this.alien[n6].state = 0;
                        n2 = 1;
                        this.player.step = 2;
                    }
                }
            }
            if (n2 == 1) {
                --this.player.shots;
            }
        }
        this.exp.update();
        this.tele.update();
    }

    int hit_spider(int n, int n2) {
        int n3 = 0;
        for (Xy xy : this.alien) {
            if (xy.state > 0 && xy.x == n && xy.y == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    boolean next_to_player(int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.player.x != n - 1 + j || this.player.y != n2 - 1 + i) continue;
                return true;
            }
        }
        return false;
    }

    void make_visible(int n, int n2) {
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                int n3 = n + j - 3;
                int n4 = n2 + i - 3;
                if (n3 < 0 || n4 < 0 || n3 >= 40 || n4 >= 30) continue;
                this.visible[n3][n4] = true;
            }
        }
    }

    void draw_gameover(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 11; ++n2) {
            this.dest.y = 152 + n2 * 16 + 8;
            for (n = 0; n < 20; ++n) {
                if (this.over_text[n3] > 0) {
                    this.dest.x = 160 + n * 16 + 8;
                    graphics.drawImage(darkwall_img, this.dest.x, this.dest.y, null);
                }
                ++n3;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < 11; ++n2) {
            this.dest.y = 152 + n2 * 16;
            for (n = 0; n < 20; ++n) {
                if (this.over_text[n3] > 0) {
                    this.dest.x = 160 + n * 16;
                    graphics.drawImage(red_img, this.dest.x, this.dest.y, null);
                }
                ++n3;
            }
        }
    }

    void draw_welldone(Graphics graphics) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            this.dest.y = 200 + n2 * 16 + 8;
            for (n = 0; n < 35; ++n) {
                if (this.welldone_text[n3] > 0) {
                    this.dest.x = 40 + n * 16 + 8;
                    graphics.drawImage(darkwall_img, this.dest.x, this.dest.y, null);
                }
                ++n3;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < 5; ++n2) {
            this.dest.y = 200 + n2 * 16;
            for (n = 0; n < 35; ++n) {
                if (this.welldone_text[n3] > 0) {
                    this.dest.x = 40 + n * 16;
                    graphics.drawImage(green_img, this.dest.x, this.dest.y, null);
                }
                ++n3;
            }
        }
    }

    void grid_set(int n, int n2, int n3) {
        this.grid[n][n2] = n3;
    }

    int gridpos(int n, int n2) {
        return this.grid[n][n2];
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38 && this.up_key) {
            this.up = true;
            this.up_key = false;
        }
        if (n == 40 && this.down_key) {
            this.down = true;
            this.down_key = false;
        }
        if (n == 37 && this.left_key) {
            this.left = true;
            this.left_key = false;
        }
        if (n == 39 && this.right_key) {
            this.right = true;
            this.right_key = false;
        }
        if (this.gamestate == State.GAME && n == 32 && this.space_key) {
            if (this.player.step == 0) {
                this.fire = true;
            } else if (this.player.shots > 0) {
                this.help_count = 210;
            }
            this.space_key = false;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            this.up_key = true;
        }
        if (n == 40) {
            this.down_key = true;
        }
        if (n == 37) {
            this.left_key = true;
        }
        if (n == 39) {
            this.right_key = true;
        }
        if (this.gamestate == State.GAME && n == 32) {
            this.space_key = true;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (this.gamestate) {
            case WELCOME: {
                if (c != ' ') break;
                this.setstate(State.GAME);
                break;
            }
            case GAME: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c == 'q') {
                    this.setstate(State.OVER);
                }
                if (c != 'c') break;
                this.show_map();
                break;
            }
            case OVER: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
                break;
            }
            case COMPLETE: {
                if (c == '\u001b') {
                    this.setstate(State.WELCOME);
                }
                if (c != ' ') break;
                this.setstate(State.WELCOME);
            }
        }
    }

    public static enum State {
        WELCOME,
        GAME,
        OVER,
        COMPLETE;

    }
}

