/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import javax.imageio.ImageIO;

public class Player {
    public int x = 0;
    public int y = 0;
    public int task = 0;
    public int xdir = 0;
    public int ydir = 0;
    public int mx = 0;
    public int my = 0;
    public int drop = 0;
    private int frame = 0;
    public int ox = 0;
    public int oy = 0;
    private int sxd = 1;
    private int syd = 0;
    Image[] player_bmp = new Image[8];
    private Rectangle player_rect = new Rectangle(0, 0, 16, 32);
    public boolean gotfish = false;
    private static Rectangle hook_rect = new Rectangle(0, 0, 16, 16);
    Image hook_bmp;
    Image boat_bmp;

    public Player() {
        try {
            URL uRL;
            String[] stringArray = new String[]{"up", "down", "left", "right", "up_1", "down_1", "left_1", "right_1"};
            int n = 0;
            for (String string : stringArray) {
                uRL = Player.class.getClassLoader().getResource("gfx/player/" + string + ".gif");
                this.player_bmp[n] = ImageIO.read(uRL);
                ++n;
            }
            uRL = Player.class.getClassLoader().getResource("gfx/player/boat_r.gif");
            this.boat_bmp = ImageIO.read(uRL);
            uRL = Player.class.getClassLoader().getResource("gfx/fishing/hook.gif");
            this.hook_bmp = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading Player sprite");
            System.out.println(exception);
        }
    }

    public void move(int n, int n2) {
        if (this.xdir == 0 && this.ydir == 0) {
            this.xdir = n;
            this.ydir = n2;
            this.sxd = this.xdir;
            this.syd = this.ydir;
        }
    }

    public void update() {
        this.ox += this.xdir * 4;
        this.oy += this.ydir * 4;
        if (Math.abs(this.ox) == 32 || Math.abs(this.oy) == 32) {
            this.x += this.xdir;
            this.y += this.ydir;
            this.ox = 0;
            this.oy = 0;
            this.xdir = 0;
            this.ydir = 0;
        }
    }

    public int actualx() {
        return this.mx * 20 + this.x;
    }

    public int actualy() {
        return this.my * 13 + this.y;
    }

    public void draw(Graphics graphics) {
        int n = 0;
        int n2 = this.x * 32 + this.ox;
        int n3 = this.y * 32 + this.oy;
        if (this.sxd != 0) {
            this.frame = Math.abs(this.ox) > 16 ? 4 : 0;
            n = this.sxd == 1 ? 3 : 2;
        }
        if (this.syd != 0) {
            this.frame = Math.abs(this.oy) > 16 ? 4 : 0;
            n = this.syd == 1 ? 1 : 0;
        }
        graphics.drawImage(this.player_bmp[n + this.frame], n2, n3, null);
    }

    public void drawboat(Graphics graphics) {
        graphics.drawImage(this.boat_bmp, this.x, 168, null);
        graphics.setColor(Color.black);
        graphics.drawLine(Player.hook_rect.x + 6, 172, Player.hook_rect.x + 6, Player.hook_rect.y);
        Player.hook_rect.x = this.x + 48;
        graphics.drawImage(this.hook_bmp, Player.hook_rect.x, Player.hook_rect.y, null);
    }

    public void updateboat() {
        switch (this.drop) {
            case 0: {
                Player.hook_rect.y = 176;
                break;
            }
            case 1: {
                Player.hook_rect.y += 4;
                if (Player.hook_rect.y < 384) break;
                this.drop = 2;
                break;
            }
            case 2: {
                Player.hook_rect.y -= 4;
                if (Player.hook_rect.y > 176) break;
                Player.hook_rect.y = 176;
                this.drop = 0;
            }
        }
    }

    public Rectangle getBounds() {
        this.player_rect.x = (this.mx * 20 + this.x) * 32 + this.ox + 8;
        this.player_rect.y = (this.my * 13 + this.y) * 32 + this.oy;
        return this.player_rect;
    }

    public Rectangle hookBounds() {
        return hook_rect;
    }
}

