/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;

public class Map {
    private static final int MODE_WELCOME = 0;
    private static final int MODE_RPG = 1;
    private static final int MODE_ROCKFALL = 2;
    private static final int MODE_FISHING = 3;
    private static final int MODE_JELLYFISH = 4;
    private static final int MODE_FOREST = 5;
    private static final int MODE_SHOP = 6;
    private static final int MODE_MOUNTAIN = 7;
    private static final int MODE_COMPLETE = 8;
    private static final int MODE_RUMBLE = 10;
    private static final int MODE_SHAKE = 11;
    private static final int NPC_OLDMAN = 8;
    private static final int NPC_GUARD = 9;
    private static final int NPC_PROF = 10;
    private final int mapw = 64;
    private final int maph = 64;
    private int mapx = 0;
    private int mapy = 0;
    BufferedImage map_town;
    BufferedImage map_mine;
    BufferedImage map_forest;
    BufferedImage map_mountain;
    BufferedImage map_shop;
    BufferedImage mapbmp;
    Image town_grass;
    Image town_path;
    Image town_flower;
    Image town_boulder;
    Image town_tree;
    Image town_water;
    Image town_hole;
    Image town_vfence;
    Image town_house;
    Image town_shop;
    Image town_oldman;
    Image town_guard;
    Image town_boulder2;
    Image town_barrier;
    Image town_hfence;
    Image sign_forest;
    Image sign_fishing;
    Image sign_shop;
    Image mine_earth;
    Image mine_block;
    Image mine_boulder;
    Image mine_diamond;
    Image forest_grass;
    Image forest_grass2;
    Image forest_boulder;
    Image forest_tree;
    Image forest_cherry;
    Image forest_apple;
    Image stone_earth;
    Image mountain_floor;
    Image mountain_block;
    Image mountain_wall;
    Image mountain_tree;
    Image mountain_ladder;
    Image mountain_boulder;
    Image mountain_pillar;
    Image mountain_prof;
    Image mountain_water;
    Image mountain_grass;
    Image shop_block;
    Image shop_infoblock;
    Image shop_milk;
    Image shop_oats;
    Image shop_sweets;
    Image stone_fire;
    Image stone_air;
    Image stone_water;
    Image box_bmp;
    Image black_bmp;
    Image player_bmp;
    Image bg_sky_bmp;
    Image bg_alien_bmp;
    private Image[] sprite = new Image[20];
    public Location[] mylocation = new Location[8];
    private int[][] mapdata = new int[64][64];
    private int[][] mapattr = new int[64][64];
    private Enemy[] town_npc = new Enemy[20];
    public Enemy[] mine_npc = new Enemy[20];
    public Enemy[] forest_npc = new Enemy[20];
    public Enemy[] mountain_npc = new Enemy[20];
    public int effect_timer = 30;
    private int effect_y = 0;
    private int effect_ydir = 2;

    public Map() {
        int n;
        try {
            URL uRL = Map.class.getClassLoader().getResource("gfx/box.gif");
            this.box_bmp = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/backgrounds/sky.gif");
            this.bg_sky_bmp = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/backgrounds/alien.gif");
            this.bg_alien_bmp = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/black32.gif");
            this.black_bmp = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("maps/town.gif");
            this.map_town = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("maps/mine.gif");
            this.map_mine = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("maps/forest.gif");
            this.map_forest = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("maps/mountain.gif");
            this.map_mountain = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("maps/shop.gif");
            this.map_shop = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/grass.gif");
            this.town_grass = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/path.gif");
            this.town_path = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/flower.gif");
            this.town_flower = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/boulder.gif");
            this.town_boulder = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/tree.gif");
            this.town_tree = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/water.gif");
            this.town_water = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/mine_hole.gif");
            this.town_hole = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/fence_vertical.gif");
            this.town_vfence = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/building1.gif");
            this.town_house = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/building2.gif");
            this.town_shop = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/npc/oldman.gif");
            this.town_oldman = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/npc/guard.gif");
            this.town_guard = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/boulder2.gif");
            this.town_boulder2 = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/barrier.gif");
            this.town_barrier = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/fence_horizontal.gif");
            this.town_hfence = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/sign_forest.gif");
            this.sign_forest = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/sign_fishing.gif");
            this.sign_fishing = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/town/sign_shop.gif");
            this.sign_shop = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mine/earth.gif");
            this.mine_earth = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mine/block.gif");
            this.mine_block = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mine/boulder.gif");
            this.mine_boulder = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mine/diamond.gif");
            this.mine_diamond = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/forest/grass.gif");
            this.forest_grass = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/forest/grass2.gif");
            this.forest_grass2 = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/forest/boulder2.gif");
            this.forest_boulder = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/forest/tree.gif");
            this.forest_tree = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/forest/cherry.gif");
            this.forest_cherry = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/forest/red_apple.gif");
            this.forest_apple = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/stones/earth.gif");
            this.stone_earth = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/floor.gif");
            this.mountain_floor = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/block.gif");
            this.mountain_block = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/cavewall.gif");
            this.mountain_wall = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/tree.gif");
            this.mountain_tree = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/ladder.gif");
            this.mountain_ladder = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/boulder2.gif");
            this.mountain_boulder = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/pillar.gif");
            this.mountain_pillar = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/prof.gif");
            this.mountain_prof = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/water2.gif");
            this.mountain_water = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/mountain/grass.gif");
            this.mountain_grass = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/player/right.gif");
            this.player_bmp = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/shop/block.gif");
            this.shop_block = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/shop/infoblock.gif");
            this.shop_infoblock = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/ui/milk.gif");
            this.shop_milk = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/ui/oats.gif");
            this.shop_oats = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/ui/sweets.gif");
            this.shop_sweets = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/stones/fire.gif");
            this.stone_fire = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/stones/air.gif");
            this.stone_air = ImageIO.read(uRL);
            uRL = Map.class.getClassLoader().getResource("gfx/stones/water.gif");
            this.stone_water = ImageIO.read(uRL);
        }
        catch (Exception exception) {
            System.out.println("Problem loading Map sprites");
            System.out.println(exception);
        }
        for (n = 1; n < this.mylocation.length; ++n) {
            if (this.mylocation[n] != null) continue;
            this.mylocation[n] = new Location();
            this.mylocation[n].clear();
        }
        for (n = 0; n < this.town_npc.length; ++n) {
            this.town_npc[n] = new Enemy();
            this.mine_npc[n] = new Enemy();
            this.forest_npc[n] = new Enemy();
            this.mountain_npc[n] = new Enemy();
        }
        this.clear();
    }

    private void clear() {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                this.mapdata[j][i] = 0;
                this.mapattr[j][i] = 0;
            }
        }
    }

    public void mappos(int n, int n2) {
        this.mapx = n * 20;
        this.mapy = n2 * 13;
    }

    public void load(int n) {
        this.clear();
        switch (n) {
            case 1: {
                this.mapbmp = this.map_town;
                this.town_npc[0].count = 0;
                break;
            }
            case 2: {
                this.mapbmp = this.map_mine;
                this.mine_npc[0].count = 0;
                break;
            }
            case 5: {
                this.mapbmp = this.map_forest;
                this.forest_npc[0].count = 0;
                break;
            }
            case 7: {
                this.mapbmp = this.map_mountain;
                this.mountain_npc[0].count = 0;
                break;
            }
            case 6: {
                this.mapbmp = this.map_shop;
            }
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < 64; ++i) {
            block15: for (int j = 0; j < 64; ++j) {
                n2 = this.mapbmp.getRGB(j, i) & 0xFFFFFF;
                switch (n) {
                    case 1: {
                        int n4;
                        int n5;
                        if (n2 == 0xFFFFFF) {
                            this.mapdata[j][i] = 0;
                        }
                        if (n2 == 0) {
                            this.mapdata[j][i] = 1;
                        }
                        if (n2 == 0x84FFFF) {
                            this.mapdata[j][i] = 2;
                        }
                        if (n2 == 0x848484) {
                            this.mapdata[j][i] = 3;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 65280) {
                            this.mapdata[j][i] = 4;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 255) {
                            this.mapdata[j][i] = 5;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xC6C6C6) {
                            this.mapdata[j][i] = 6;
                        }
                        if (n2 == 16745472) {
                            this.mapdata[j][i] = 7;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 32832) {
                            this.mapdata[j][i] = 8;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 32768) {
                            this.mapdata[j][i] = 9;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFFFF80) {
                            this.mapdata[j][i] = 10;
                        }
                        if (n2 == 0xC8C800) {
                            this.mapdata[j][i] = 11;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0x804000) {
                            this.mapdata[j][i] = 12;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0x400080) {
                            this.mapdata[j][i] = 13;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFF80FF) {
                            this.mapdata[j][i] = 1;
                            this.town_npc[n3].set(j, i, 1, n);
                            ++n3;
                            ++this.town_npc[0].count;
                        }
                        if (n2 == 0xFF0000) {
                            this.mapdata[j][i] = 18;
                            for (n5 = 0; n5 < 4; ++n5) {
                                for (n4 = 0; n4 < 4; ++n4) {
                                    this.mapattr[j + n4][i + n5] = 1;
                                }
                            }
                        }
                        if (n2 != 0x840000) continue block15;
                        this.mapdata[j][i] = 19;
                        for (n5 = 0; n5 < 4; ++n5) {
                            for (n4 = 0; n4 < 4; ++n4) {
                                this.mapattr[j + n4][i + n5] = 1;
                            }
                        }
                        continue block15;
                    }
                    case 2: {
                        if (n2 == 0xFFFFFF) {
                            this.mapdata[j][i] = 0;
                        }
                        if (n2 == 16745472) {
                            this.mapdata[j][i] = 1;
                        }
                        if (n2 == 0) {
                            this.mapdata[j][i] = 2;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFF0000) {
                            this.mapdata[j][i] = 3;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFFFF00) {
                            this.mapdata[j][i] = 4;
                        }
                        if (n2 == 0xFF00FF) {
                            this.mapdata[j][i] = 5;
                        }
                        if (n2 != 255) continue block15;
                        this.mapdata[j][i] = 0;
                        this.mine_npc[n3].set(j, i, 0, n);
                        ++n3;
                        ++this.mine_npc[0].count;
                        continue block15;
                    }
                    case 5: {
                        if (n2 == 0xFFFFFF) {
                            this.mapdata[j][i] = 0;
                        }
                        if (n2 == 0xFF00FF) {
                            this.mapdata[j][i] = 1;
                        }
                        if (n2 == 0) {
                            this.mapdata[j][i] = 2;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xCECE00) {
                            this.mapdata[j][i] = 3;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFF0000) {
                            this.mapdata[j][i] = 4;
                        }
                        if (n2 == 65280) {
                            this.mapdata[j][i] = 5;
                        }
                        if (n2 == 255) {
                            this.mapdata[j][i] = 6;
                        }
                        if (n2 == 0xFFFF00) {
                            this.mapdata[j][i] = 0;
                            this.forest_npc[n3].set(j, i, 0, n);
                            ++n3;
                            ++this.forest_npc[0].count;
                        }
                        if (n2 != 0x8000FF) continue block15;
                        this.mapdata[j][i] = 0;
                        this.forest_npc[n3].set(j, i, 0, n);
                        this.forest_npc[n3].red = true;
                        ++n3;
                        ++this.forest_npc[0].count;
                        continue block15;
                    }
                    case 7: {
                        if (n2 == 0) {
                            this.mapdata[j][i] = 1;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 33023) {
                            this.mapdata[j][i] = 2;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFFFF80) {
                            this.mapdata[j][i] = 3;
                        }
                        if (n2 == 255) {
                            this.mapdata[j][i] = 4;
                        }
                        if (n2 == 65535) {
                            this.mapdata[j][i] = 5;
                        }
                        if (n2 == 16448) {
                            this.mapdata[j][i] = 6;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFF8000) {
                            this.mapdata[j][i] = 7;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFFFF00) {
                            this.mapdata[j][i] = 8;
                        }
                        if (n2 == 0x808080) {
                            this.mapdata[j][i] = 9;
                        }
                        if (n2 == 0xFF00FF) {
                            this.mapdata[j][i] = 10;
                        }
                        if (n2 == 16512) {
                            this.mapdata[j][i] = 11;
                        }
                        if (n2 == 0x80FF00) {
                            this.mapdata[j][i] = 12;
                        }
                        if (n2 != 0xFF0000) continue block15;
                        this.mountain_npc[n3].set(j, i, 1, n);
                        ++n3;
                        ++this.mountain_npc[0].count;
                        continue block15;
                    }
                    case 6: {
                        if (n2 == 0) {
                            this.mapdata[j][i] = 1;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFFFF00) {
                            this.mapdata[j][i] = 2;
                            this.mapattr[j][i] = 1;
                        }
                        if (n2 == 0xFF8080) {
                            this.mapdata[j][i] = 3;
                        }
                        if (n2 == 0xFFFF80) {
                            this.mapdata[j][i] = 4;
                        }
                        if (n2 == 0x80FF80) {
                            this.mapdata[j][i] = 5;
                        }
                        if (n2 == 65408) {
                            this.mapdata[j][i] = 6;
                        }
                        if (n2 != 0xFFFFFF) continue block15;
                        this.mapdata[j][i] = 7;
                    }
                }
            }
        }
        if (n == 1) {
            this.mapdata[1][33] = 14;
            this.mapattr[1][33] = 1;
            this.mapdata[58][3] = 15;
            this.mapattr[58][3] = 1;
            this.mapdata[58][17] = 15;
            this.mapattr[58][17] = 1;
            this.mapdata[34][8] = 16;
            this.mapattr[34][8] = 1;
        }
        this.copy(n);
    }

    public void copy(int n) {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                this.mylocation[n].mapdata[j][i] = this.mapdata[j][i];
                this.mylocation[n].mapattr[j][i] = this.mapattr[j][i];
            }
        }
    }

    public void restore(int n) {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                this.mapdata[j][i] = this.mylocation[n].mapdata[j][i];
                this.mapattr[j][i] = this.mylocation[n].mapattr[j][i];
            }
        }
        switch (n) {
            case 1: {
                this.sprite[0] = this.town_grass;
                this.sprite[1] = this.town_path;
                this.sprite[2] = this.town_flower;
                this.sprite[3] = this.town_boulder;
                this.sprite[4] = this.town_tree;
                this.sprite[5] = this.town_water;
                this.sprite[6] = this.town_hole;
                this.sprite[7] = this.town_vfence;
                this.sprite[8] = this.town_oldman;
                this.sprite[9] = this.town_guard;
                this.sprite[10] = this.town_path;
                this.sprite[11] = this.town_boulder2;
                this.sprite[12] = this.town_hfence;
                this.sprite[13] = this.town_barrier;
                this.sprite[14] = this.sign_forest;
                this.sprite[15] = this.sign_fishing;
                this.sprite[16] = this.sign_shop;
                this.sprite[18] = this.town_house;
                this.sprite[19] = this.town_shop;
                break;
            }
            case 2: {
                this.sprite[0] = this.black_bmp;
                this.sprite[1] = this.mine_earth;
                this.sprite[2] = this.mine_block;
                this.sprite[3] = this.mine_boulder;
                this.sprite[4] = this.mine_diamond;
                this.sprite[5] = this.black_bmp;
                break;
            }
            case 5: {
                this.sprite[0] = this.forest_grass;
                this.sprite[1] = this.forest_grass2;
                this.sprite[2] = this.forest_tree;
                this.sprite[3] = this.forest_boulder;
                this.sprite[4] = this.forest_cherry;
                this.sprite[5] = this.forest_apple;
                this.sprite[6] = this.stone_earth;
                break;
            }
            case 7: {
                this.sprite[0] = this.mountain_wall;
                this.sprite[1] = this.mountain_block;
                this.sprite[2] = this.mountain_floor;
                this.sprite[3] = this.mountain_wall;
                this.sprite[4] = this.town_water;
                this.sprite[5] = this.mountain_ladder;
                this.sprite[6] = this.mountain_boulder;
                this.sprite[7] = this.mountain_tree;
                this.sprite[8] = this.town_path;
                this.sprite[9] = this.mountain_pillar;
                this.sprite[10] = this.mountain_prof;
                this.sprite[11] = this.mountain_water;
                this.sprite[12] = this.mountain_grass;
                this.sprite[13] = this.stone_air;
                this.sprite[14] = this.stone_earth;
                this.sprite[15] = this.stone_fire;
                this.sprite[16] = this.stone_water;
                break;
            }
            case 6: {
                this.sprite[0] = this.black_bmp;
                this.sprite[1] = this.shop_block;
                this.sprite[2] = this.shop_infoblock;
                this.sprite[3] = this.shop_milk;
                this.sprite[4] = this.shop_oats;
                this.sprite[5] = this.shop_sweets;
                this.sprite[6] = this.stone_fire;
                this.sprite[7] = this.black_bmp;
            }
        }
    }

    public boolean hitcheck(int n, int n2) {
        return n >= 0 && n2 >= 0 && this.mapattr[this.mapx + n][this.mapy + n2] == 1;
    }

    public int sqr(int n, int n2) {
        return this.mapdata[n][n2];
    }

    public void set(int n, int n2, int n3) {
        this.mapdata[n][n2] = n3;
    }

    public void clr(int n, int n2) {
        this.mapdata[n][n2] = 0;
        this.mapattr[n][n2] = 0;
    }

    public void replace(int n, int n2, int n3) {
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                if (this.mylocation[n].mapdata[j][i] != n2) continue;
                this.mylocation[n].mapdata[j][i] = n3;
                this.mylocation[n].mapattr[j][i] = 0;
            }
        }
    }

    public void update(int n, int n2, int n3) {
        switch (n) {
            case 1: {
                for (int i = 0; i < this.town_npc[0].count; ++i) {
                    this.town_npc[i].move(this.mapdata);
                }
                break;
            }
            case 2: {
                int n4;
                for (n4 = 0; n4 < 64; ++n4) {
                    for (int i = 0; i < 64; ++i) {
                        if (i == n2 && n4 == n3 - 1 || this.mapdata[i][n4] != 3 || this.mapdata[i][n4 + 1] != 0) continue;
                        this.mapdata[i][n4] = 0;
                        this.mapattr[i][n4] = 0;
                        this.mapdata[i][n4 + 1] = 3;
                        this.mapattr[i][n4 + 1] = 1;
                    }
                }
                for (n4 = 0; n4 < this.mine_npc[0].count; ++n4) {
                    this.mine_npc[n4].move(this.mapdata);
                }
                break;
            }
            case 5: {
                for (int i = 0; i < this.forest_npc[0].count; ++i) {
                    if (!this.forest_npc[i].red) {
                        this.forest_npc[i].move(this.mapdata);
                        continue;
                    }
                    if (n2 > 20 && n2 < 40) {
                        if (n3 > 26 && n3 < 39) {
                            this.forest_npc[i].redmove(this.mapdata, n2, n3);
                            continue;
                        }
                        this.forest_npc[i].move(this.mapdata);
                        continue;
                    }
                    this.forest_npc[i].move(this.mapdata);
                }
                break;
            }
            case 7: {
                for (int i = 0; i < this.mountain_npc[0].count; ++i) {
                    this.mountain_npc[i].lr(this.mapdata);
                }
                break;
            }
        }
    }

    public void rumble(Graphics graphics) {
        int n = 0;
        if (this.mapx == 0 && this.mapy == 0) {
            graphics.drawImage(this.bg_alien_bmp, 0, 0, null);
            n = 1;
        }
        if (this.mapx == 40 && this.mapy == 26) {
            graphics.drawImage(this.bg_sky_bmp, 0, 0, null);
            n = 2;
        }
        Point point = new Point(0, 0);
        for (int i = 0; i < 14; ++i) {
            for (int j = 0; j < 20; ++j) {
                int n2 = this.mapdata[this.mapx + j][this.mapy + i];
                if (n2 > 0 && n2 < 18) {
                    if (n2 == 10) {
                        graphics.drawImage(this.sprite[3], point.x, point.y + this.effect_y, null);
                    }
                    if (n2 == 13) {
                        graphics.drawImage(this.sprite[3], point.x, point.y + this.effect_y, null);
                    }
                    if (n2 == 9) {
                        graphics.drawImage(this.sprite[3], point.x, point.y + this.effect_y, null);
                    }
                    if (n2 == 5) {
                        graphics.drawImage(this.sprite[3], point.x, point.y + this.effect_y, null);
                    }
                    graphics.drawImage(this.sprite[n2], point.x, point.y + this.effect_y, null);
                }
                point.x += 32;
            }
            point.x = 0;
            point.y += 32;
        }
        graphics.drawImage(this.player_bmp, 160, 256 + this.effect_y, null);
        this.effect_y += this.effect_ydir;
        if (Math.abs(this.effect_y) == 8) {
            this.effect_ydir *= -1;
        }
        --this.effect_timer;
        if (this.effect_timer == 0) {
            this.effect_y = 0;
            this.effect_ydir = 2;
        }
    }

    public void teleport(Graphics graphics) {
        int n;
        int n2;
        int n3;
        graphics.drawImage(this.bg_sky_bmp, 0, 0, null);
        Point point = new Point(0, 0);
        this.mapx = 40;
        this.mapy = 26;
        for (n3 = 0; n3 < 14; ++n3) {
            for (n2 = 0; n2 < 20; ++n2) {
                n = this.mapdata[this.mapx + n2][this.mapy + n3];
                if (n > 0 && n < 18) {
                    if (n == 10) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    if (n >= 13 && n <= 16) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    if (n == 9) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    if (n == 5) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    graphics.drawImage(this.sprite[n], point.x, point.y, null);
                }
                point.x += 32;
            }
            point.x = 0;
            point.y += 32;
        }
        this.mapx = 0;
        this.mapy = 0;
        point.x = 0;
        point.y = 0;
        for (n3 = 0; n3 < this.effect_y; ++n3) {
            for (n2 = 0; n2 < 20; ++n2) {
                n = this.mapdata[this.mapx + n2][this.mapy + n3];
                if (n > 0 && n < 18) {
                    if (n == 10) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    if (n == 13) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    if (n == 9) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    if (n == 5) {
                        graphics.drawImage(this.sprite[3], point.x, point.y, null);
                    }
                    graphics.drawImage(this.sprite[n], point.x, point.y, null);
                }
                point.x += 32;
            }
            point.x = 0;
            point.y += 32;
        }
        graphics.drawImage(this.player_bmp, 288, 256, null);
        ++this.effect_y;
        if (this.effect_y == 14) {
            this.effect_timer = 0;
            this.effect_y = 0;
            this.effect_ydir = 2;
        }
    }

    public void draw(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4 = 0;
        switch (n) {
            case 7: {
                if (this.mapx == 0 && this.mapy == 0) {
                    graphics.drawImage(this.bg_alien_bmp, 0, 0, null);
                    n4 = 1;
                }
                if (this.mapx == 20 && this.mapy == 39) {
                    graphics.drawImage(this.bg_sky_bmp, 0, 0, null);
                    n4 = 1;
                }
                if (this.mapx != 40 || this.mapy != 26) break;
                graphics.drawImage(this.bg_sky_bmp, 0, 0, null);
                n4 = 2;
                break;
            }
            case 6: {
                graphics.drawImage(this.bg_sky_bmp, 0, 0, null);
                n4 = 2;
            }
        }
        int n5 = 0;
        int n6 = 0;
        for (n3 = 0; n3 < 13; ++n3) {
            for (n2 = 0; n2 < 20; ++n2) {
                int n7;
                if (n4 == 0) {
                    graphics.drawImage(this.sprite[0], n5, n6, null);
                }
                if (n4 == 2 && n3 > 6) {
                    graphics.drawImage(this.sprite[0], n5, n6, null);
                }
                if ((n7 = this.mapdata[this.mapx + n2][this.mapy + n3]) > 0 && n7 < 18) {
                    graphics.drawImage(this.sprite[n7], n5, n6, null);
                }
                n5 += 32;
            }
            n5 = 0;
            n6 += 32;
        }
        switch (n) {
            case 1: {
                n5 = 0;
                n6 = 0;
                for (n3 = 0; n3 < 13; ++n3) {
                    for (n2 = 0; n2 < 20; ++n2) {
                        if (this.mapdata[this.mapx + n2][this.mapy + n3] >= 18) {
                            graphics.drawImage(this.sprite[this.mapdata[this.mapx + n2][this.mapy + n3]], n5, n6, null);
                        }
                        n5 += 32;
                    }
                    n5 = 0;
                    n6 += 32;
                }
                for (n3 = 0; n3 < this.town_npc[0].count; ++n3) {
                    this.town_npc[n3].draw(this.mapx, this.mapy, graphics);
                }
                break;
            }
            case 7: {
                for (n3 = 0; n3 < this.mountain_npc[0].count; ++n3) {
                    this.mountain_npc[n3].draw(this.mapx, this.mapy, graphics);
                }
                break;
            }
            case 5: {
                for (n3 = 0; n3 < this.forest_npc[0].count; ++n3) {
                    this.forest_npc[n3].draw(this.mapx, this.mapy, graphics);
                }
                break;
            }
            case 2: {
                for (n3 = 0; n3 < this.mine_npc[0].count; ++n3) {
                    this.mine_npc[n3].draw(this.mapx, this.mapy, graphics);
                }
                break;
            }
        }
    }
}

