/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.ImageIO;

public class Inventory {
    private static final int swidth = 640;
    private static final int sheight = 480;
    private static final int limit = 16;
    private String[] item = new String[16];
    private int[] qty = new int[16];
    private String[] tmp_item = new String[16];
    private int[] tmp_qty = new int[16];
    private final Font medFont = new Font("Arial", 1, 16);
    Image[] sprite = new Image[13];

    public Inventory() {
        try {
            String[] stringArray = new String[]{"ui/box", "ui/apple", "ui/cherry", "ui/diamond", "ui/fish", "ui/milk", "ui/oats", "ui/strawberry", "ui/sweets", "stones/earth", "stones/fire", "stones/air", "stones/water"};
            int n = 0;
            for (String string : stringArray) {
                URL uRL = Inventory.class.getClassLoader().getResource("gfx/" + string + ".gif");
                this.sprite[n] = ImageIO.read(uRL);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Problem loading Inventory sprite");
            System.out.println(exception);
        }
        this.clear();
    }

    public void clear() {
        Arrays.fill(this.item, "");
        Arrays.fill(this.qty, 0);
    }

    public void copy() {
        this.tmp_item = Arrays.copyOf(this.item, this.item.length);
        this.tmp_qty = Arrays.copyOf(this.qty, this.qty.length);
    }

    public void restore() {
        this.item = Arrays.copyOf(this.tmp_item, this.tmp_item.length);
        this.qty = Arrays.copyOf(this.tmp_qty, this.tmp_qty.length);
    }

    public void add(String string) {
        int n;
        for (n = 0; n < this.item.length; ++n) {
            if (!this.item[n].equals(string)) continue;
            int n2 = n;
            this.qty[n2] = this.qty[n2] + 1;
            return;
        }
        for (n = 0; n < this.item.length; ++n) {
            if (this.qty[n] != 0) continue;
            this.item[n] = string;
            this.qty[n] = 1;
            break;
        }
    }

    public void remove(String string, int n) {
        for (int i = 0; i < this.item.length; ++i) {
            if (!this.item[i].equals(string)) continue;
            int n2 = i;
            this.qty[n2] = this.qty[n2] - n;
            if (this.qty[i] != 0) break;
            this.item[i] = "";
            break;
        }
    }

    public int count(String string) {
        for (int i = 0; i < this.item.length; ++i) {
            if (!this.item[i].equals(string)) continue;
            return this.qty[i];
        }
        return 0;
    }

    public void draw(Graphics graphics) {
        int n = 0;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 432, 639, 48);
        int n2 = 4;
        int n3 = 0;
        for (String string : this.item) {
            n = 0;
            if (string.equals("Apple")) {
                n = 1;
            }
            if (string.equals("Cherry")) {
                n = 2;
            }
            if (string.equals("Diamond")) {
                n = 3;
            }
            if (string.equals("Fish")) {
                n = 4;
            }
            if (string.equals("Milk")) {
                n = 5;
            }
            if (string.equals("Oats")) {
                n = 6;
            }
            if (string.equals("Strawberry")) {
                n = 7;
            }
            if (string.equals("Sweets")) {
                n = 8;
            }
            if (string.equals("Earth Stone")) {
                n = 9;
            }
            if (string.equals("Fire Stone")) {
                n = 10;
            }
            if (string.equals("Air Stone")) {
                n = 11;
            }
            if (string.equals("Water Stone")) {
                n = 12;
            }
            if (n > 0) {
                graphics.drawImage(this.sprite[n], n2, 440, null);
                graphics.drawImage(this.sprite[0], n2, 440, null);
                if (this.qty[n3] > 0) {
                    graphics.setFont(this.medFont);
                    graphics.setColor(Color.black);
                    graphics.drawString(String.valueOf(this.qty[n3]), n2 + 16 - 1, 471);
                    graphics.setColor(Color.white);
                    graphics.drawString(String.valueOf(this.qty[n3]), n2 + 16, 472);
                }
            } else {
                graphics.drawImage(this.sprite[0], n2, 440, null);
            }
            n2 += 40;
            ++n3;
        }
    }
}

