/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;

public class Enemy {
    private static final int MODE_WELCOME = 0;
    private static final int MODE_RPG = 1;
    private static final int MODE_ROCKFALL = 2;
    private static final int MODE_FISHING = 3;
    private static final int MODE_JELLYFISH = 4;
    private static final int MODE_FOREST = 5;
    private static final int MODE_SHOP = 6;
    private static final int MODE_MOUNTAIN = 7;
    private static final int MODE_COMPLETE = 8;
    private static final int MODE_WAIT = 9;
    private static final int MODE_RUMBLE = 10;
    private static final int MODE_SHAKE = 11;
    private static Random rand = new Random();
    public int count = 0;
    public int x = 0;
    public int y = 0;
    public int ox = 0;
    public int oy = 0;
    public boolean red = false;
    private int state = 0;
    private int xdir = 0;
    private int ydir = 0;
    private int path = 0;
    private int frame = 0;
    private int startx = 0;
    private int starty = 0;
    private int[] order = new int[]{0, 1, 2, 3};
    private static Image[] sprite = new Image[14];
    private static Image box_bmp;
    private static boolean gfxloaded;
    private Rectangle rect = new Rectangle(0, 0, 28, 32);

    public Enemy() {
        if (!gfxloaded) {
            gfxloaded = true;
            int n = 0;
            try {
                URL uRL;
                String[] stringArray;
                for (String string : stringArray = new String[]{"forest/ghost", "forest/ghost2", "mountain/spider", "mountain/spider2", "mine/spike", "", "town/npc/up", "town/npc/up_1", "town/npc/down", "town/npc/down_1", "town/npc/left", "town/npc/left_1", "town/npc/right", "town/npc/right_1"}) {
                    if (!string.equals("")) {
                        uRL = Enemy.class.getClassLoader().getResource("gfx/" + string + ".gif");
                        Enemy.sprite[n] = ImageIO.read(uRL);
                    }
                    ++n;
                }
                uRL = Enemy.class.getClassLoader().getResource("gfx/box.gif");
                box_bmp = ImageIO.read(uRL);
            }
            catch (Exception exception) {
                System.out.println("Problem loading Enemy sprite " + n);
                System.out.println(exception);
            }
        }
    }

    private void jumble() {
        for (int i = 0; i < 10; ++i) {
            int n = rand.nextInt(this.order.length);
            int n2 = rand.nextInt(this.order.length);
            int n3 = this.order[n];
            this.order[n] = this.order[n2];
            this.order[n2] = n3;
        }
    }

    public void set(int n, int n2, int n3, int n4) {
        this.startx = n;
        this.starty = n2;
        this.reset();
        this.path = n3;
        this.state = n4;
        this.red = false;
    }

    public void reset() {
        this.x = this.startx;
        this.y = this.starty;
        this.ox = 0;
        this.oy = 0;
        this.xdir = 1;
        this.ydir = 0;
        this.red = false;
    }

    public void move(int[][] nArray) {
        if (Math.abs(this.ox) == 32 || Math.abs(this.oy) == 32) {
            this.x += this.xdir;
            this.y += this.ydir;
            this.ox = 0;
            this.oy = 0;
        }
        if (this.ox == 0 && this.oy == 0 && nArray[this.x + this.xdir][this.y + this.ydir] != this.path) {
            this.jumble();
            boolean bl = false;
            for (int n : this.order) {
                switch (n) {
                    case 0: {
                        if (nArray[this.x + 1][this.y + 0] != this.path) break;
                        this.xdir = 1;
                        this.ydir = 0;
                        bl = true;
                        break;
                    }
                    case 1: {
                        if (nArray[this.x - 1][this.y + 0] != this.path) break;
                        this.xdir = -1;
                        this.ydir = 0;
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (nArray[this.x + 0][this.y + 1] != this.path) break;
                        this.xdir = 0;
                        this.ydir = 1;
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (nArray[this.x + 0][this.y - 1] != this.path) break;
                        this.xdir = 0;
                        this.ydir = -1;
                        bl = true;
                    }
                }
                if (bl) break;
            }
        }
        this.ox += this.xdir * 2;
        this.oy += this.ydir * 2;
    }

    public void redmove(int[][] nArray, int n, int n2) {
        if (Math.abs(this.ox) == 32 || Math.abs(this.oy) == 32) {
            this.x += this.xdir;
            this.y += this.ydir;
            this.ox = 0;
            this.oy = 0;
        }
        if (this.ox == 0 && this.oy == 0) {
            this.ydir = 0;
            this.xdir = 0;
            int n3 = this.x;
            int n4 = this.y;
            this.jumble();
            for (int n5 : this.order) {
                boolean bl = false;
                switch (n5) {
                    case 0: {
                        if (n3 >= n || nArray[this.x + 1][this.y + 0] != this.path) break;
                        this.xdir = 1;
                        this.ydir = 0;
                        bl = true;
                        break;
                    }
                    case 1: {
                        if (n3 <= n || nArray[this.x - 1][this.y + 0] != this.path) break;
                        this.xdir = -1;
                        this.ydir = 0;
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (n4 >= n2 || nArray[this.x + 0][this.y + 1] != this.path) break;
                        this.xdir = 0;
                        this.ydir = 1;
                        bl = true;
                        break;
                    }
                    case 3: {
                        if (n4 <= n2 || nArray[this.x + 0][this.y - 1] != this.path) break;
                        this.xdir = 0;
                        this.ydir = -1;
                        bl = true;
                    }
                }
                if (bl) break;
            }
        }
        this.ox += this.xdir * 2;
        this.oy += this.ydir * 2;
    }

    public void lr(int[][] nArray) {
        if (Math.abs(this.ox) == 32) {
            this.x += this.xdir;
            this.ox = 0;
        }
        if (this.ox == 0 && (nArray[this.x + this.xdir][this.y] == this.path || nArray[this.x + this.xdir][this.y + 1] == 3 || nArray[this.x + this.xdir][this.y] == 6 || nArray[this.x + this.xdir][this.y] == 12)) {
            this.xdir *= -1;
        }
        this.ox += this.xdir * 2;
    }

    public void draw(int n, int n2, Graphics graphics) {
        if (this.y - n2 < 13) {
            int n3 = 0;
            int n4 = (this.x - n) * 32 + this.ox;
            int n5 = (this.y - n2) * 32 + this.oy;
            switch (this.state) {
                case 1: {
                    if (this.ydir == 0 && ((n3 = Math.abs(this.ox)) == 0 || n3 == 8 || n3 == 16 || n3 == 24)) {
                        this.frame = 1 - this.frame;
                    }
                    if (this.xdir == 0 && ((n3 = Math.abs(this.oy)) == 0 || n3 == 8 || n3 == 16 || n3 == 24)) {
                        this.frame = 1 - this.frame;
                    }
                    if (this.ydir == -1) {
                        graphics.drawImage(sprite[6 + this.frame], n4, n5, null);
                    }
                    if (this.ydir == 1) {
                        graphics.drawImage(sprite[8 + this.frame], n4, n5, null);
                    }
                    if (this.xdir == -1) {
                        graphics.drawImage(sprite[10 + this.frame], n4, n5, null);
                    }
                    if (this.xdir != 1) break;
                    graphics.drawImage(sprite[12 + this.frame], n4, n5, null);
                    break;
                }
                case 7: {
                    n3 = Math.abs(this.ox);
                    if (n3 == 0 || n3 == 8 || n3 == 16 || n3 == 24) {
                        this.frame = 1 - this.frame;
                    }
                    graphics.drawImage(sprite[2 + this.frame], n4, n5, null);
                    break;
                }
                case 5: {
                    if (!this.red) {
                        graphics.drawImage(sprite[0], n4, n5, null);
                        break;
                    }
                    graphics.drawImage(sprite[1], n4, n5, null);
                    break;
                }
                case 2: {
                    graphics.drawImage(sprite[4], n4, n5, null);
                }
            }
        }
    }

    public Rectangle getBounds() {
        this.rect.x = this.x * 32 + this.ox + 2;
        this.rect.y = this.y * 32 + this.oy;
        return this.rect;
    }

    static {
        gfxloaded = false;
    }
}

